package ipsk.persistence;


import java.beans.PropertyDescriptor;

import ipsk.webapps.PermissionDeniedException;

import javax.servlet.http.HttpServletRequest;


/**
 * Persistence security manager.
 * This manager denies everything, so it must be overriden to allow functionality.
 * @author klausj
 *
 */
public class SecurityManager {
	
	public void checkMergePermission(HttpServletRequest req, Object o) throws PermissionDeniedException {
		if (getMergePermission(req, o,null)) {
			return;
		} else {
			throw new PermissionDeniedException();
		}
	}
	
	public boolean getMergePermission(HttpServletRequest req, Object o,PropertyDescriptor propertyDescriptor){
		return false;
	}
	
	public void checkPersistPermission(HttpServletRequest req, Object o)
			throws PermissionDeniedException {
		if (getPersistPermission(req, o)) {
			return;
		} else {
			throw new PermissionDeniedException();
		}
	}
	
	public boolean getPersistPermission(HttpServletRequest req, Object o){
		return false;
	}

	public void checkReadPermission(HttpServletRequest req, Object o) throws PermissionDeniedException {
		if (getReadPermission(req, o)) {
			return;
		} else {
			throw new PermissionDeniedException();
		}
	}
	
	public boolean getReadPermission(HttpServletRequest req, Object o){
		return false;
	}

	public void checkRemovePermission(HttpServletRequest req, Object o) throws PermissionDeniedException {
		if (getRemovePermission(req, o)) {
			return;
		} else {
			throw new PermissionDeniedException();
		}
	}
	
	public boolean getRemovePermission(HttpServletRequest req, Object o){
		return false;
	}

	public void checkMergePermission(HttpServletRequest req, Object o, PropertyDescriptor propertyDescriptor) throws PermissionDeniedException {
		if (getMergePermission(req, o,propertyDescriptor)) {
			return;
		} else {
			throw new PermissionDeniedException();
		}
	}

}
