package ipsk.jsp.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

public class ParamTag extends TagSupport{

	private String name;
	private String value;
	private ParamConsumer paramConsumer;
	
	public void setParent(Tag parent){
		super.setParent(parent);
		if(parent instanceof ParamConsumer){
			paramConsumer=(ParamConsumer)parent;
		}
	}

	
	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public String getValue() {
		return value;
	}


	public void setValue(String value) {
		this.value = value;
	}
	
	public int doEndTag() throws JspException {
		if(paramConsumer!=null && name!=null) {
			paramConsumer.applyParam(name, value);
		}
		return EVAL_PAGE;
	}


}
