package ipsk.jsp.taglib.beans.table;

import ipsk.jsp.BeanTableController;
import ipsk.jsp.BeanTableModel;
import ipsk.jsp.Controller;
import ipsk.jsp.taglib.ControllerProvider;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanControllerProvider;
import ipsk.webapps.ControllerException;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.Tag;

public class ItemsPositionTag extends ExtBodyTagSupport {
	private BeanTableController controller;

	private BeanTableModel beanTableModel;

	public void setParent(Tag parent) {
		if (parent instanceof ControllerProvider) {
			Controller scontroller = ((ControllerProvider) parent).getController();
			if(scontroller instanceof BeanTableController){
				controller = (BeanTableController)scontroller;
			}
			

		}
	}
	
	public int doStartTag() throws JspException {
		if(controller != null){
			try {
				beanTableModel = controller.getBeanTableModel((HttpServletRequest)pageContext.getRequest());
			} catch (ControllerException e) {
				e.printStackTrace();
				throw new JspException(e);
			}
		}
		return EVAL_BODY_INCLUDE;
	}
	
	public int doEndTag() throws JspException {

		Integer itemCount = beanTableModel.getItemCount();
		Integer firstItem = beanTableModel.getFirstItem();
		Integer lastItem = beanTableModel.getLastItem();
		JspWriter ow = pageContext.getOut();

		try {
		
			ow.println("<p>"
					+ LocaleSupport.getLocalizedMessage(pageContext,
							"items.position", new Object[] { firstItem + 1,
									lastItem + 1, itemCount }, RES_BUNDLE_NAME)
					+ "</p>");

		} catch (IOException ioe) {
			throw new JspException("Error: IOException while writing to client");
		}

		return EVAL_PAGE;
	}

}
