package ipsk.persistence;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

import ipsk.math.bool.BoolExpr;
import ipsk.sql.GroupByClause;
import ipsk.sql.JoinClause;
import ipsk.sql.OrderBy;
import ipsk.sql.OrderByClause;


public class ParameterizedQuery<T> {
	public static final String JPQL_SELECT_EXPRESSION="o";
	//protected String name;
	
	public static class FromDeclaration{
		private String type;
		private String identifier;
		public FromDeclaration(String type,String identifier){
			this.type=type;
			this.identifier=identifier;
		}
		public String getType() {
			return type;
		}
		public String getIdentifier() {
			return identifier;
		}
		
		public String toString(){
			return new String(type+" "+identifier);
		}	
	}
	protected Class<T> queryType;
	protected boolean selectDistinct=false;
	protected JoinClause joinClause;
	public JoinClause getJoinClause() {
		return joinClause;
	}

	public void setJoinClause(JoinClause joinClause) {
		this.joinClause = joinClause;
	}

	protected String whereClause;
	protected QueryParam[] queryParams;
	protected BoolExpr additionalCondition;
	protected GroupByClause groupBy;
	protected OrderByClause orders;
	protected String qlQueryTypeName;
	protected FromDeclaration[] additionalFromDeclarations=null;
	
	
	public ParameterizedQuery(Class<T> queryType){
		super();
		this.queryType=queryType;
		String queryTypeName=queryType.getName();
		qlQueryTypeName = queryTypeName.substring(queryTypeName
			.lastIndexOf(".") + 1);
	
	}
	
	public Query createQuery(EntityManager em){
		TypedQuery<T> tq=createTypedQuery(em);
		return tq;
	}
	
	public TypedQuery<T> createTypedQuery(EntityManager em){
		StringBuffer queryStrBuf=new StringBuffer();
		queryStrBuf.append("SELECT ");
		if(selectDistinct){
			queryStrBuf.append("DISTINCT ");
		}
		queryStrBuf.append(JPQL_SELECT_EXPRESSION);
		queryStrBuf.append(" FROM ");
		queryStrBuf.append(qlQueryTypeName);
		queryStrBuf.append(" ");
		queryStrBuf.append(JPQL_SELECT_EXPRESSION);
		if(additionalFromDeclarations!=null){
			for(FromDeclaration addFromDecl:additionalFromDeclarations){
				queryStrBuf.append(",");
				queryStrBuf.append(addFromDecl);
			}
		}
		if(joinClause!=null) {
			queryStrBuf.append(" ");
			queryStrBuf.append(joinClause.toJPQLString());
		}
		if(whereClause!=null || additionalCondition !=null){
			queryStrBuf.append(" WHERE (");
		}
		
		if(whereClause!=null){
			queryStrBuf.append("(");
			queryStrBuf.append(whereClause);
			queryStrBuf.append(")");
		}
		
		if(whereClause!=null && additionalCondition !=null){
			queryStrBuf.append(" AND ");
		}
		PersistenceBoolExpr persBoolExpr=null;
		if(additionalCondition!=null){
		PersistenceBoolExprConverter condConverter=new PersistenceBoolExprConverter(additionalCondition,JPQL_SELECT_EXPRESSION);
		persBoolExpr=condConverter.createQueryData(em);
		queryStrBuf.append("( ");
		queryStrBuf.append(persBoolExpr.getConditionalExpression());
		queryStrBuf.append(" )");
		}
		if(whereClause!=null || additionalCondition !=null){
			queryStrBuf.append(")");
		}
//		if(orders!=null && orders.length >0){
//			queryStrBuf.append(" ORDER BY ");
//			for(int i=0;i<orders.length;i++){
//				queryStrBuf.append(orders[i].toJPQLString(JPQL_SELECT_EXPRESSION));
//				if(i+1<orders.length){
//					queryStrBuf.append(", ");
//				}
//			}
//		}
		
		if(groupBy!=null) {
			queryStrBuf.append(groupBy.toJPQLString(JPQL_SELECT_EXPRESSION));
		}
		if(orders!=null){
			queryStrBuf.append(orders.toJPQLString(JPQL_SELECT_EXPRESSION));
		}
		String qStr=queryStrBuf.toString();
		//Query q=em.createQuery(qStr);
		TypedQuery<T> q=em.createQuery(qStr,queryType);
		if(queryParams!=null){
			for(QueryParam qp:queryParams){
				q.setParameter(qp.getName(), qp.getParam());
			}
		}
		if(persBoolExpr!=null){
		Object[] additionalConditionParms=persBoolExpr.getQueryVars();
		if(additionalConditionParms!=null){
			for(int i=0;i<additionalConditionParms.length;i++){
				q.setParameter(PersistenceBoolExprConverter.JPQL_PARAM_NAME_PREFIX+"_"+(i+1), additionalConditionParms[i]);
			}
		}
		}
		
		return q;
	}
	


	


	public GroupByClause getGroupBy() {
		return groupBy;
	}

	public void setGroupBy(GroupByClause groupBy) {
		this.groupBy = groupBy;
	}

	public OrderByClause getOrderByClause() {
		return orders;
	}



	public void setOrderByClause(OrderByClause orders) {
		this.orders = orders;
	}

	public BoolExpr getAdditionalCondition() {
		return additionalCondition;
	}

	public void setAdditionalCondition(BoolExpr additionalCondition) {
		this.additionalCondition = additionalCondition;
	}

	public QueryParam[] getQueryParams() {
		return queryParams;
	}

	public void setQueryParams(QueryParam[] queryParams) {
		this.queryParams = queryParams;
	}

	public String getWhereClause() {
		return whereClause;
	}

	public void setWhereClause(String whereClause) {
		this.whereClause = whereClause;
	}

	public FromDeclaration[] getAdditionalFromDeclarations() {
		return additionalFromDeclarations;
	}

	public void setAdditionalFromDeclarations(FromDeclaration[] fromDeclarations) {
		this.additionalFromDeclarations = fromDeclarations;
	}

	public void appendOrderByClause(OrderByClause orderByClause) {
		if(this.orders!=null && orderByClause!=null){
			OrderBy[] orderBys = orders.getOrder();
			OrderBy[] appOrderBys=orderByClause.getOrder();
			if(orderBys!=null && appOrderBys!=null){
				int newArrSize=orderBys.length+appOrderBys.length;
				OrderBy[] newArr=new OrderBy[newArrSize];
				for(int i=0;i<orderBys.length;i++){
					newArr[i]=orderBys[i];
				}
				for(int i=0;i<appOrderBys.length;i++){
					newArr[i+orderBys.length]=appOrderBys[i];
				}
				this.orders.setOrder(newArr);
			}
		}else{
			setOrderByClause(orderByClause);
		}
	}

	public boolean isSelectDistinct() {
		return selectDistinct;
	}

	public void setSelectDistinct(boolean selectDistinct) {
		this.selectDistinct = selectDistinct;
	}
	
}
