package ipsk.persistence;

import java.util.ArrayList;
import java.util.Locale;

import javax.persistence.EntityManager;

import ipsk.math.bool.BoolExpr;
import ipsk.math.bool.ExtBoolExpr;

/**
 * Creates conditional expression from boolean expression.
 * 
 * @author klausj
 * 
 */

public class PersistenceBoolExprConverter {

	public final static String JPQL_PARAM_NAME_PREFIX="persistenceboolexprconverter";
	private BoolExpr boolExpr;
	private String jpqlSelectExpression=null;
	

	public PersistenceBoolExprConverter(String jpqlSelectExpression) {
		this.jpqlSelectExpression=jpqlSelectExpression;
	}

	public PersistenceBoolExprConverter(BoolExpr boolExpr,String jpqlSelectExpression) {
		this(jpqlSelectExpression);
		this.boolExpr = boolExpr;
	}

	public PersistenceBoolExpr createQueryData() {
		return createQueryData(null,boolExpr,0);
	}
	public PersistenceBoolExpr createQueryData(int paramCountOffset) {
		return createQueryData(null,boolExpr,paramCountOffset);
	}
	public PersistenceBoolExpr createQueryData(EntityManager em) {
		return createQueryData(em,boolExpr,0);
	}
	public PersistenceBoolExpr createQueryData(EntityManager em,int paramCountOffset) {
		return createQueryData(em,boolExpr,paramCountOffset);
	}
	public PersistenceBoolExpr createQueryData(EntityManager em,BoolExpr e,int paramCountOffset) {
		return createQueryData(em,e,new ArrayList<Object>(),paramCountOffset);
	}
	
	private String escapeSQLLikeChars(Object param) {
		String paramStr=param.toString();
		String escParamStr=paramStr.replace("%","\\%").replace("_", "\\_");
		return escParamStr;
	}
	
	private PersistenceBoolExpr createQueryData(EntityManager em,BoolExpr e,ArrayList<Object> vars,int paramCountOffset) {

		String pqlWhere = "";
		String jpqlSelect="";
		Object operand0 = e.getOperand0();
		boolean caseInSensitive=false;
		if(e instanceof ExtBoolExpr){
			ExtBoolExpr ee=(ExtBoolExpr)e;
			if(ee.isCaseInSensitive()){
				caseInSensitive=true;
			}
		}
		if (operand0 != null) {
			if (operand0 instanceof BoolExpr) {
				PersistenceBoolExpr tPqd = createQueryData(em,(BoolExpr) operand0,vars,paramCountOffset);
				pqlWhere = pqlWhere.concat("( "
						+ tPqd.getConditionalExpression() + " )");
			} else if (operand0 instanceof String) {
				jpqlSelect=new String(jpqlSelectExpression+"."+(String) operand0);
				if(caseInSensitive){
					jpqlSelect="LOWER("+jpqlSelect+")";
				}

			}
			Object operator = e.getOperator();
			if (operator == null) {
				pqlWhere = "";
			} else {
				Object operand1=e.getOperand1();
				Object param=null;
				if( operand1 instanceof PersistenceObjectIdentifier){
					PersistenceObjectIdentifier poi=(PersistenceObjectIdentifier)operand1;
					param=em.find(poi.getTargetClass(), poi.getIdObject());
				}else{
					param=operand1;
				}
				String paramName=null;
				if(param!=null){
					if(param instanceof String && caseInSensitive){
				
					// problem with some locales see JSE API docs of java.lang.String.toLowerCase()
					// we cannot use the locale of the user because JPA will use the SQL-DB LOWER() function 
					// for the query results
					param=((String)param).toLowerCase(Locale.ENGLISH);
					}
					
				}
				boolean valueSet = false;
				
				if (operator.equals(ExtBoolExpr.STARTS_WITH)) {
					vars.add(escapeSQLLikeChars(param) + "%");
					paramName=JPQL_PARAM_NAME_PREFIX+"_"+(vars.size()+paramCountOffset);
					pqlWhere = pqlWhere.concat(jpqlSelect+" LIKE :"+paramName+" ");			
					valueSet = true;
				} else if (operator.equals(ExtBoolExpr.ENDS_WITH)) {
					vars.add("%" + escapeSQLLikeChars(param));
					paramName=JPQL_PARAM_NAME_PREFIX+"_"+(vars.size()+paramCountOffset);
					pqlWhere = pqlWhere.concat(jpqlSelect+" LIKE :"+paramName+" ");			
					valueSet = true;
				} else if (operator.equals(ExtBoolExpr.CONTAINS)) {
					vars.add("%" + escapeSQLLikeChars(param) + "%");
					paramName=JPQL_PARAM_NAME_PREFIX+"_"+(vars.size()+paramCountOffset);
					pqlWhere = pqlWhere.concat(jpqlSelect+" LIKE :"+paramName+" ");
					valueSet = true;
				} else if (operator.equals(ExtBoolExpr.MEMBER)) {
					vars.add(param);
					paramName=JPQL_PARAM_NAME_PREFIX+"_"+(vars.size()+paramCountOffset);
					pqlWhere = pqlWhere.concat(" :"+paramName+" MEMBER OF "+jpqlSelect);
					valueSet = true;
				}  else if (operator.equals(ExtBoolExpr.EQUALS)) {
					vars.add(param);
					paramName=JPQL_PARAM_NAME_PREFIX+"_"+(vars.size()+paramCountOffset);
					pqlWhere = pqlWhere.concat(" "+jpqlSelect+" = :"+paramName);
					valueSet = true;
				} else if (operator.equals(ExtBoolExpr.NOT_MEMBER)) {
					vars.add(param);
					paramName=JPQL_PARAM_NAME_PREFIX+"_"+(vars.size()+paramCountOffset);
					pqlWhere = pqlWhere.concat(" :"+paramName+" NOT MEMBER OF "+jpqlSelect);
					valueSet = true;
				}  else if (operator.equals(ExtBoolExpr.EQUALS_NOT)) {
					vars.add(param);
					paramName=JPQL_PARAM_NAME_PREFIX+"_"+(vars.size()+paramCountOffset);
					pqlWhere = pqlWhere.concat(" ("+jpqlSelect+" IS NULL) OR ("+jpqlSelect+" <> :"+paramName+")");
					valueSet = true;
				}  else if (operator.equals(ExtBoolExpr.BOUND)) {
					pqlWhere = pqlWhere.concat(" ("+jpqlSelect+" IS NOT NULL) ");
					valueSet = true;
				}  else if (operator.equals(ExtBoolExpr.NOT_BOUND)) {
					pqlWhere = pqlWhere.concat(" ("+jpqlSelect+" IS NULL) ");
					valueSet = true;
				}else {
					pqlWhere = pqlWhere.concat(jpqlSelect+" " + operator + " ");
				}

				if (param instanceof BoolExpr) {
					PersistenceBoolExpr tPqd = createQueryData(em,((BoolExpr) param),vars,paramCountOffset);
					pqlWhere = pqlWhere.concat("( "
							+ tPqd.getConditionalExpression() + " )");
					//vars.addAll(Arrays.asList(tPqd.getQueryVars()));
				} else {
					if (!valueSet) {
						vars.add(param);
						paramName=JPQL_PARAM_NAME_PREFIX+"_"+(vars.size()+paramCountOffset);
						pqlWhere = pqlWhere.concat(" :"+paramName+" ");
						
					}

				}
			}
		}
		return new PersistenceBoolExpr(pqlWhere, vars.toArray());
	}

	public String getJpqlSelectExpression() {
		return jpqlSelectExpression;
	}

	public void setJpqlSelectExpression(String jpaSelectExpression) {
		this.jpqlSelectExpression = jpaSelectExpression;
	}
	
	
	public static void main(String[] args){
		String t="J\u00e4nsch";
		System.out.println(t.toUpperCase());
		System.out.println(t.toUpperCase(Locale.ENGLISH));
		
	}

}
