/*
 * Created on Oct 11, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package ipsk.webapps.session;

import java.util.Comparator;
import java.util.Locale;
import java.util.Vector;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

/**
 * Traces user session information.
 * @author klausj
 *
 */
public class SessionObserver implements HttpSessionListener{

    private static SessionObserver instance=null;
    private   Vector<HttpSession> boundedSessions;
    
    /**
     * 
     */
    public  SessionObserver() {
        super();
        instance=this;
        boundedSessions=new Vector<HttpSession>();
       
    }
    
    public synchronized static SessionObserver getSessionObserver(){
        if (instance==null)new SessionObserver();
        return instance;
    }

  
    
    public HttpSession[] getBoundedSessions(){
        return (HttpSession[])(getSessionObserver().boundedSessions.toArray(new HttpSession[boundedSessions.size()]));
    }
    
    public HttpSession[] getBoundedSessionsOrderedByLastAccessed(){
    	@SuppressWarnings("unchecked")
		Vector<HttpSession> bSesssClone=(Vector<HttpSession>)(getSessionObserver().boundedSessions.clone());
    				
    	bSesssClone.sort(new Comparator<HttpSession>() {
			@Override
			public int compare(HttpSession o1, HttpSession o2) {
				long at1=o1.getLastAccessedTime();
				long at2=o2.getLastAccessedTime();
				return (int)(at2-at1);
			}
    		
		});
    	
    	return bSesssClone.toArray(new HttpSession[bSesssClone.size()]);   
    }

    public void sessionCreated(HttpSessionEvent arg0) {
       getSessionObserver();
        HttpSession session=arg0.getSession();
        Locale locale=null;
        if(session.getAttribute("locale")==null){  
            String localeStr=session.getServletContext().getInitParameter("locale");       
            if (localeStr==null){
            	locale=Locale.getDefault();      	
            }else{
            	locale=new Locale(localeStr);    	
            }     
            session.setAttribute("locale",locale);
    	}
        if(!boundedSessions.contains(session)){
        	boundedSessions.add(session);
        }
    }

    public void sessionDestroyed(HttpSessionEvent arg0) {
        getSessionObserver();
        HttpSession session=arg0.getSession();
        
        boundedSessions.remove(session);
        try{
        	session.setAttribute("locale",null);
        }catch(IllegalStateException ise){
        	// OK
        }
    }
}
