package ipsk.webapps.security;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class AccountRequest {

//	public static enum Type {RESET_PASSWORD,NEW_ACCOUNT};
	private UUID uuid;
	
	private String login;
	private String email;
	

	private Date requestDate;
	private Date validUntil;
//	private Type type;
	private Map<String,String[]> parameterMap;
	
	

	public Map<String, String[]> getParameterMap() {
		return parameterMap;
	}

//	public Type getType() {
//		return type;
//	}
//
//	public void setType(Type type) {
//		this.type = type;
//	}
	public AccountRequest(UUID uuid,String login,String email, Date requestDate,Date validUntil){
		this(uuid,login,email,requestDate,validUntil,null);
	}
	public AccountRequest(UUID uuid,String login,String email,Date requestDate,Date validUntil,Map<String,String[]> parameterMap){
		super();
//		this.type=type;
		this.uuid=uuid;
		this.login=login;
		this.email=email;
		this.requestDate=requestDate;
		this.validUntil=validUntil;
		this.parameterMap=parameterMap;
	}
	
	public int hashCode(){
		return login.hashCode() * uuid.hashCode();
	}
	
	public boolean equals(Object o){
		if(o != null && o instanceof AccountRequest){
			AccountRequest prr=(AccountRequest)o;
			return(prr.getLogin().equals(login) && 
			   prr.getUuid().equals(uuid));
		}
		return false;
	}
	
	public UUID getUuid() {
		return uuid;
	}
	public String getLogin() {
		return login;
	}
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}
	public Date getRequestDate() {
		return requestDate;
	}
	public Date getValidUntil() {
		return validUntil;
	}
	
	public boolean isValid(){
		Date now=new Date();
		return now.before(validUntil);
	}
	
}
