package ipsk.jsp.taglib;

import ips.beans.ExtBeanInfo;
import ipsk.beans.validation.ValidationResult;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;
import ipsk.webapps.NoSuchObjectException;
import ipsk.webapps.ObjectAlreadyExistsException;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.ProcessResult;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;

public class ControllerInvokeTag extends BeanTableControllerTag {

	private Object param;
	private String method;
	private String var;
	


	public int doStartTag() throws JspException {
		ServletRequest sreq = pageContext.getRequest();
		ExtBeanInfo beanInfo = controller.getBeanInfo();
		int jspReturn=EVAL_BODY_INCLUDE;
		if (controller != null && sreq instanceof HttpServletRequest) {

			HttpServletRequest req = (HttpServletRequest) sreq;
			
			try {
				
				if(method!=null){
					ArrayList<Object> paramList=new ArrayList<Object>();
					ArrayList<Class> paramClassList=new ArrayList<Class>();
					paramList.add(req);
					paramClassList.add(HttpServletRequest.class);
					if(param!=null){
						paramList.add(param);
						paramClassList.add(param.getClass());
					}
					try {
						Method procMethod=controller.getClass().getMethod(method,paramClassList.toArray(new Class[0]));
						Object value=procMethod.invoke(controller,paramList.toArray(new Object[0]));
						ProcessResult processResult=controller.getProcessResult();
						
						if (var != null) {
							// variable is set - means custom body content to evaluate
							pageContext.setAttribute(var, value,
									PageContext.REQUEST_SCOPE);
							
						}
					} catch (SecurityException e) {
						e.printStackTrace();
						controller.rollback();
						controller.close();
						throw new ControllerException("Could not access method: "+method,e);
					} catch (NoSuchMethodException e) {
						e.printStackTrace();
						controller.rollback();
						controller.close();
						throw new ControllerException("No such method: "+method,e);
					} catch (IllegalArgumentException e) {
						e.printStackTrace();
						controller.rollback();
						controller.close();
						throw new ControllerException(e);
					} catch (IllegalAccessException e) {
						e.printStackTrace();
						controller.rollback();
						controller.close();
						throw new ControllerException(e);
					} catch (InvocationTargetException e) {
						e.printStackTrace();
						e.getTargetException().printStackTrace();
						controller.rollback();
						controller.close();
						throw new ControllerException(e);
					}
				}
			} catch (ControllerException e) {
				controller.rollback();
				controller.close();

				if (e instanceof PermissionDeniedException) {
					// w.println("<p>" + getLocalizedMessage("error.occurred")+ "
					// permission denied !</p>");
					throw new JspException(
							getLocalizedMessage("object.permission.denied"), e);
				} else if (e instanceof ObjectAlreadyExistsException) {

					ObjectAlreadyExistsException oaee = (ObjectAlreadyExistsException) e;
					Object oId = oaee.getObjectId();
					String oIdStr = "()";
					if (oId != null)
						oIdStr = oId.toString();
					String resBundleName = beanInfo.getResourceBundleName();
					String classResKey = beanInfo.getClassResourceKey();
					String classDescr = "Object";
					if (resBundleName != null && classResKey != null) {
						classDescr = LocaleSupport.getLocalizedMessage(
								pageContext, classResKey, resBundleName);
					}

					String errMsg = LocaleSupport.getLocalizedMessage(
							pageContext, "object.already_exists", new Object[] {
									classDescr, oIdStr }, "ipsk.jsp.Messages");
					// w.println(errMsg);
					throw new JspException(errMsg, e);

				} else if (e instanceof NoSuchObjectException) {
					NoSuchObjectException nsoe = (NoSuchObjectException) e;
					Object oId = nsoe.getObjectId();
					String oIdStr = "()";
					if (oId != null)
						oIdStr = oId.toString();
					String resBundleName = beanInfo.getResourceBundleName();
					String classResKey = beanInfo.getClassResourceKey();
					String classDescr = "Object";
					if (resBundleName != null && classResKey != null) {
						classDescr = LocaleSupport.getLocalizedMessage(
								pageContext, classResKey, resBundleName);
					}

					String errMsg = LocaleSupport.getLocalizedMessage(
							pageContext, "object.no_such", new Object[] {
									classDescr, oIdStr }, "ipsk.jsp.Messages");
					// w.println(errMsg);
					throw new JspException(errMsg, e);

				} else {
					e.printStackTrace();

					// w.println("<p>" + getLocalizedMessage("error.occurred")
					// + "<br>" + e.getMessage()+"</p>");
					throw new JspException(e);

				}
				// return SKIP_BODY;
			}
			
		}
		return EVAL_BODY_INCLUDE;
	}

	public int doEndTag() throws JspException {
		controller.close();
		return EVAL_PAGE;
	}

	
	
	public Object getParam() {
		return param;
	}

	public void setParam(Object param) {
		this.param = param;
	}

	public String getMethod() {
		return method;
	}

	public void setMethod(String processMethod) {
		this.method = processMethod;
	}

	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;
	}

	

}
