package ipsk.jsp.taglib.beans.edit;

import ipsk.jsp.taglib.beans.BeanProviderTag;
import ipsk.jsp.taglib.beans.BeanPropertyIterator.Iteration;
import ipsk.webapps.BasicPersistenceBeanController;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class BeanEditTag extends BeanProviderTag {

	private String action;
	private String actionCommand;
	private String tableClass;
	private String tableClassAttr="";
	private boolean disabled;
	private boolean hasBody=false;
	private boolean tableEndPrinted=false;
	
	public int doStartTag() throws JspException {
		super.doStartTag();
		if(displayedProps!=null && beanInfo.isIdGenerated() && actionCommand.equals(BasicPersistenceBeanController.CMD_ADD)){
			// if this is a new request and the ID is generated by the database remove the ID property
			// from displayed property list
			displayedProps.remove(beanInfo.getIdPropertyDescriptor().getName());
			// get current property again
			currentProperty=null;
			validationMessage=null;
			if (displayedProps.size() > 0) {
				propertyPosition = 0;
				currentProperty = displayedProps.get(propertyPosition);
			}
		}
		
		JspWriter w = pageContext.getOut();
		String hrefAction;
		if(action!=null){
			hrefAction=action;
		}else{
		HttpServletRequest req=(HttpServletRequest)pageContext.getRequest();
		hrefAction=req.getRequestURL().toString();
		}
		tableEndPrinted=false;
		try {
			w.println("<table"+tableClassAttr+">");
		} catch (IOException e) {
			throw new JspException(e);
		}
		hasBody=false;
		return EVAL_BODY_INCLUDE;
	}
	public int doAfterBody() throws JspException {
		hasBody=true;
		return printProperties();
	}
	
	private void printTableEnd() throws JspException {
		if(!tableEndPrinted){
			JspWriter w = pageContext.getOut();
			try {
				w.println("</table>");
			} catch (IOException e) {
				e.printStackTrace();
				throw new JspException(e);
				
			}
			tableEndPrinted=true;
		}
	}
	
	protected void iterationChanged() throws JspException {
		Iteration it=getIteration();
		if(Iteration.HIDDEN.equals(it)){
			printTableEnd();
		}
	}
	
	public int printProperties() throws JspException {
		//JspWriter w=pageContext.getOut();
		Iteration it=getIteration();
		if(Iteration.TABLE.equals(it)){
		if (currentProperty !=null && !currentPropertyDone){
		
			BeanPropertyTag bpt=new BeanPropertyTag();
			try {
				bpt.setPageContext(pageContext);
				bpt.setParent(this);
				bpt.getBeanProperty().setContext(this);
				bpt.setDisabled(disabled);
				bpt.printTag();
			} catch (Exception e) {
				e.printStackTrace();
				throw new JspException(e);
			}
			setCurrentPropertyDone(true);
		}
		}else if(Iteration.HIDDEN.equals(it)){
			printTableEnd();
		}
		return super.doAfterBody();
	}

	public int doEndTag() throws JspException {
		if(!hasBody){
			int res;
			do{
				res=printProperties();
			}while(res==EVAL_BODY_AGAIN);
		}
//		JspWriter w = pageContext.getOut();
//		try {
//			w.println("</table>");
//		} catch (IOException e) {
//			throw new JspException(e);
//		}
		return EVAL_PAGE;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getActionCommand() {
		return actionCommand;
	}

	public void setActionCommand(String actionCommand) {
		this.actionCommand = actionCommand;
	}

	public String getBeanIdPropertyVar() {
		return beanIdPropertyVar;
	}

	public void setBeanIdPropertyVar(String beanIdPropertyVar) {
		this.beanIdPropertyVar = beanIdPropertyVar;
	}

	public String getTableClass() {
		return tableClass;
	}

	public void setTableClass(String tableClass) {
		this.tableClass = tableClass;
		tableClassAttr=" class=\""+tableClass+"\"";
	}
	public boolean isDisabled() {
		return disabled;
	}
	public void setDisabled(boolean disabled) {
		this.disabled = disabled;
	}


}
