//    IPS Java Utils
//    (c) Copyright 2009-2010
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.


package ips.beans;

import ipsk.beans.ExtPropertyDescriptor;
import ipsk.persistence.PersistenceObjectIdentifier;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;


public interface ExtBeanInfo extends ipsk.beans.ExtBeanInfo{

	/**
	 * Returns the property descriptor with the @javax.persistence.Id annotation.
	 * @return the property descriptor with the @javax.persistence.Id annotation
	 */
	public PropertyDescriptor getIdPropertyDescriptor();
	
	/**
	 * Returns true if the ID value is generated by the database.
	 * @return true if Id is generated
	 */
	public boolean isIdGenerated();
	
	/**
	 * Returns true if the ID is an embedded ID.
	 * @return true if ID is embedded
	 */
	public boolean isIdEmbedded();
	
	/**
	 * Get bean info embedded ID type.
	 * @return arry of property descriptors of 
	 */
	public ExtBeanInfo getEmbeddedIdBeanInfo();
	
	
	/**
	 * Get ID value.
	 * @param bean the bean instance
	 * @return the ID value or null if the bean has no annotated id method
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 */
	public Object getIdValue(Object bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;
	/**
	 * Get ID value.
	 * @param bean the bean instance
	 * @return the persistence object identifier which identifies the object in the persistence unit
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 */
	public PersistenceObjectIdentifier getPersistenceObjectIdentifier(Object bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;
	
	/**
	 * Creates an Id object for the bean by the given string id representation.
	 * @param idStr
	 * @return id object with correct type
	 * @throws SecurityException
	 * @throws NoSuchMethodException
	 * @throws IllegalArgumentException
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 */
	public Object createIdValueByString(String idStr) throws SecurityException,
	NoSuchMethodException, IllegalArgumentException,
	InstantiationException, IllegalAccessException,
	InvocationTargetException;

	/**
	 * Gets properties which are persisted by JPA.
	 * Returns all properties except the ones which have a \@javax.persistence.Transient annotation.
	 * This will only work correctly if JPA with annotations is used.
	 * @return persistence properties
	 */
	public PropertyDescriptor[] getPersistencePropertyDescriptors();
	
	public List<ExtPropertyDescriptor> getExtPersistencePropertyDescriptors();
	
	/**
	 * Returns persistence property names. 
	 * @return set of persistence property names
	 */
	public Set<String> getPersistencePropertyNames();
	
	/**
	 * Gets property which is persisted by JPA by name.
	 * @return persistence property
	 */
	public PropertyDescriptor getPersistencePropertyDescriptor(String name);
	
	/**
	 * If true objects of this class are immutable if they are referenced from other objects.
	 * @return true if objects of this class should not be updated if referenced from other objects.
	 */
	public Set<PropertyDescriptor> getObjectImmutablePropertyDescriptors();
	
	
	public List<String> getHiddenProperties();
	
//	/**
//	 * Returns property names which should be considered to determine if an object is immutable. 
//	 * @return set of property names which should be considered to determine if an object is immutable. 
//	 */
//	public Set<String> getImmutableReferenceProperties();
}
