package ips.beans;

import ipsk.beans.BeanModel;
import ipsk.beans.DateConversionException;
import ipsk.beans.MapConverter;
import ipsk.beans.MapConverterException;
import ipsk.beans.NumberConversionException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.TimeConversionException;
import ipsk.beans.validation.EMail;
import ipsk.beans.validation.ValidationResult;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.lang.reflect.NativeTypeWrapper;
import ipsk.persistence.SecurityManager;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.PermissionDeniedException;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Query;
import javax.persistence.ValidationMode;
import javax.servlet.http.HttpServletRequest;

/**
 * Extends MapConverter to apply "deep" properties in the bean (or PJO)
 * hierarchy.
 * 
 * @author klausj
 * 
 */

public class PersistenceMapConverter<T> extends MapConverter {
	private boolean DEBUG = false;

	private class PropertyApplyResult{
		private PropertyValidationResult validationResult;
		private Object propertyValue;
		
		
		public PropertyApplyResult(Object value,PropertyValidationResult pvr){
			this.propertyValue=value;
			this.validationResult=pvr;
		}
		public Object getPropertyValue() {
			return propertyValue;
		}
		public void setPropertyValue(Object propertyValue) {
			this.propertyValue = propertyValue;
		}
		public PropertyValidationResult getValidationResult() {
			return validationResult;
		}
		public void setValidationResult(PropertyValidationResult validationResult) {
			this.validationResult = validationResult;
		}
		
	}
	
	protected PropertyApplyResult applyProperty(PropertyDescriptor pd, Map<String,String[]> properties,
			Object bean)throws MapConverterException {
		
		PropertyValidationResult pvr=null;
		Object o=null;
		String propertyName = pd.getName();
		String[] propertyParams=null;
//		String propertyParameter=null;
		if (properties.containsKey(propertyName)) {
			propertyParams=properties.get(propertyName);
//			 propertyParameter=propertyParams[0];
		}
		
		try{
			o = super.getValue(pd, properties);
			// Get annotation hints
			Method readMethod=pd.getReadMethod();
			EMail emailAnno=readMethod.getAnnotation(EMail.class);
			if(emailAnno!=null && o instanceof String){
				String emailAddressList=(String)o;
				InternetAddress[] testIas=InternetAddress.parse(emailAddressList);
				for(InternetAddress testIa:testIas){
					testIa.validate();
				}
			}
		} catch (DateConversionException e) {
			pvr=new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
			pvr.setValidationException(e);
			pvr.setFailedProperties(e.getFailedProperties());
			pvr.setValidationMessage(new LocalizableMessage(ExtBodyTagSupport.RES_BUNDLE_NAME,"validation.field.wrong_date_format"));
		}catch (TimeConversionException e) {
			
			pvr=new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
			pvr.setValidationException(e);
			pvr.setFailedProperties(e.getFailedProperties());
			pvr.setValidationMessage(new LocalizableMessage(ExtBodyTagSupport.RES_BUNDLE_NAME,"validation.field.wrong_time_format"));
			
		}catch (NumberConversionException e) {
			
			pvr=new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
			pvr.setValidationException(e);
			pvr.setFailedProperties(e.getFailedProperties());
			pvr.setValidationMessage(new LocalizableMessage(ExtBodyTagSupport.RES_BUNDLE_NAME,"validation.field.wrong_number_format"));
		
		}catch (AddressException e) {
			pvr=new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
			pvr.setValidationException(e);
			HashMap<String, String[]> failedPrMap = new HashMap<String, String[]>();
			failedPrMap.put(propertyName, propertyParams);
			pvr.setFailedProperties(failedPrMap);
			pvr.setValidationMessage(new LocalizableMessage(ExtBodyTagSupport.RES_BUNDLE_NAME,"validation.field.wrong_email_format"));
		}catch (IllegalArgumentException e) {
			e.printStackTrace();
			throw new MapConverterException(e);
		} 
	
		
		return new PropertyApplyResult(o,pvr);
		
	}
	protected PropertyApplyResult applyProperty(PropertyDescriptor pd, Map<String,String[]> properties,
			Object bean, EntityManager em, boolean persist,HttpServletRequest req,SecurityManager securityManager)
			throws MapConverterException, PermissionDeniedException {
		
		PropertyValidationResult pvr=null;
		Object o=null;
//		String propertyName = pd.getName();
//		String propertyParameter=null;
//		if (properties.containsKey(propertyName)) {
//			 propertyParameter= ((String[]) properties.get(propertyName))[0];
//		}
		try{
			o = super.getValue(pd, properties);
			if (o == null || o.equals(NULL_VALUE_AS_DEF)){
				o=applyRelationshipProperty(pd, properties,bean, em, persist,req,securityManager);
			}
		} catch (DateConversionException e) {
			pvr=new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
			pvr.setValidationException(e);
			pvr.setFailedProperties(e.getFailedProperties());
			pvr.setValidationMessage(new LocalizableMessage(ExtBodyTagSupport.RES_BUNDLE_NAME,"validation.field.wrong_date_format"));
		}catch (TimeConversionException e) {
			
			pvr=new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
			pvr.setValidationException(e);
			pvr.setFailedProperties(e.getFailedProperties());
			pvr.setValidationMessage(new LocalizableMessage(ExtBodyTagSupport.RES_BUNDLE_NAME,"validation.field.wrong_time_format"));
			
		}catch (NumberConversionException e) {
			
			pvr=new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
			pvr.setValidationException(e);
			pvr.setFailedProperties(e.getFailedProperties());
			pvr.setValidationMessage(new LocalizableMessage(ExtBodyTagSupport.RES_BUNDLE_NAME,"validation.field.wrong_number_format"));
		
		}catch (IllegalArgumentException e) {
			e.printStackTrace();
			throw new MapConverterException(e);
		}
	
		
		return new PropertyApplyResult(o,pvr);
		
	}
	
	protected Object getValue(PropertyDescriptor pd, Map<String, String[]> properties,
			Object bean, EntityManager em, boolean persist,HttpServletRequest req,SecurityManager securityManager)
			throws MapConverterException, PermissionDeniedException {
		Object o = super.getValue(pd, properties);
		if (o != null && ! o.equals(NULL_VALUE_AS_DEF))
			return o;
		return  applyRelationshipProperty(pd, properties,bean, em, persist,req,securityManager);
	}
	
//	@SuppressWarnings("unchecked")
//	protected Object getValue(PropertyDescriptor pd, Map properties,
//			Object bean, EntityManager em, boolean persist,HttpServletRequest req,SecurityManager securityManager)
//			throws MapConverterException, PermissionDeniedException {
//		Object o = super.getValue(pd, properties);
//		if (o != null && ! o.equals(NULL_VALUE_AS_DEF))
//			return o;
//		return  applyRelationshipProperty(pd, properties,bean, em, persist,req,securityManager);
//	}
		
	@SuppressWarnings("unchecked")
	protected Object applyRelationshipProperty(PropertyDescriptor pd, Map<String,String[]> properties,
			Object bean, EntityManager em, boolean persist,HttpServletRequest req,SecurityManager securityManager)
	throws MapConverterException, PermissionDeniedException {	
		Object o=null;
		Class<?> beanClass=bean.getClass();
		try{
		ExtBeanInfo extBeanInfo = PersistenceIntrospector
				.getPersistenceBeanInfo(beanClass,true);
		String propertyName = pd.getName();
		Set<Entry<String,String[]>> entries = properties.entrySet();
		Iterator<Entry<String, String[]>> ei = entries.iterator();
		while (ei.hasNext()) {
			Map.Entry<String,String[]> entry = ei.next();
			String key = (String) entry.getKey();
			Object value = entry.getValue();

			// look for e.g. "deep" property organisations.person_id
			int dotIndex = key.indexOf('.');
			String keyName = null;
			String deepProperty = null;
			if (dotIndex > 0) {
				keyName = key.substring(0, dotIndex);
				deepProperty = key.substring(dotIndex + 1);
				if (!keyName.equals(propertyName)) {
					continue;
				}
				Class<?> propertyType = pd.getPropertyType();
			
				// check for parameterized Collection
				Method readMethod = pd.getReadMethod();
				boolean embeddedid = (extBeanInfo.isIdEmbedded() && pd
						.equals(extBeanInfo.getIdPropertyDescriptor()));
				Type rt = readMethod.getGenericReturnType();
				boolean isCollection = Collection.class
						.isAssignableFrom(propertyType);
				// boolean
				// isCollection=rt.getClass().isAssignableFrom(Collection.class);
				boolean paramterized = (rt instanceof ParameterizedType);
				if (embeddedid) {
					Object embIdObj = readMethod.invoke(bean, new Object[0]);
					if (embIdObj == null) {
						// construct embedded id object
						embIdObj = propertyType.newInstance();
					}
					// construct "toplevel" property map
					Map<String, String[]> embProps = new HashMap<String, String[]>();
					Set<Map.Entry<String, String[]>> entries2 = properties.entrySet();
//					Iterator ei2 = entries2.iterator();
//					while (ei2.hasNext()) {
//						Map.Entry entry2 = (Map.Entry) ei2.next();
					for(Map.Entry<String, String[]> entry2:entries2){
						String key2 = entry2.getKey();
						// Object value2 = entry2.getValue();

						int dotIndex2 = key2.indexOf('.');
						String keyName2 = null;
						String deepProperty2 = null;
						if (dotIndex2 > 0) {
							keyName2 = key2.substring(0, dotIndex2);
							deepProperty2 = key2.substring(dotIndex2 + 1);
							if (!keyName2.equals(propertyName)) {
								continue;
							}
							embProps.put(deepProperty2, entry2.getValue());
						}
					}

					// apply map
					MapConverter embMc = new MapConverter();
					embMc.setBeanProperties(embIdObj, embProps);
					return embIdObj;

				} else if (isCollection && paramterized) {

					ParameterizedType prt = (ParameterizedType) rt;
					ExtBeanInfo deepClassInfo = null;
					Class<?> collClass = null;
					PropertyDescriptor[] deepPds = null;
					PropertyDescriptor relatedIdPd = null;
					Object[] relatedIdObjects = null;
					Object[] relatedObjects = null;
					Type[] pts = prt.getActualTypeArguments();
					if (pts.length == 1) {
						collClass = (Class<?>) pts[0];
						// String collClassName = collClass.getName();
						deepClassInfo = PersistenceIntrospector
								.getPersistenceBeanInfo(collClass,true);
						deepPds = deepClassInfo
								.getPersistencePropertyDescriptors();
						relatedIdPd = deepClassInfo.getIdPropertyDescriptor();
						if (!relatedIdPd.getName().equals(deepProperty)) {
							throw new MapConverterException("Property "
									+ deepProperty
									+ " of related type does not match "
									+ relatedIdPd.getName());
						}
						Class<?> idClass = relatedIdPd.getPropertyType();
						Class<?> idwClass = NativeTypeWrapper
								.getWrapperClass(idClass);
						Constructor<?> idCstr = idwClass
								.getConstructor(new Class[] { String.class });
						String[] idStrVals = (String[]) value;
						relatedIdObjects = new Object[idStrVals.length];
						
						relatedObjects = new Object[idStrVals.length];
						for (int i = 0; i < idStrVals.length; i++) {
							relatedIdObjects[i] = idCstr
									.newInstance(new Object[] { idStrVals[i] });
							
							relatedObjects[i] = em.find(collClass,
									relatedIdObjects[i]);
							securityManager.checkReadPermission(req, relatedObjects[i]);
						}

					} else {
						throw new MapConverterException(
								"Property "
										+ pd.getName()
										+ " has ambigious (more than one) type arguments.");
					}
					String mappedBy = null;
					ManyToMany mmA = readMethod
							.getAnnotation(javax.persistence.ManyToMany.class);
					OneToMany omA = readMethod
							.getAnnotation(javax.persistence.OneToMany.class);
					
					if (mmA != null) {
						mappedBy = mmA.mappedBy();
						if (mappedBy == null || mappedBy.equals("")) {
							// owning side
							PropertyDescriptor relatedPropertyPd = null;
							for (PropertyDescriptor relPd : deepPds) {
								Method relRm=relPd.getReadMethod();
								ManyToMany relMmA = relRm.getAnnotation(javax.persistence.ManyToMany.class);
								if(relMmA!=null){
									String relMappedBy=relMmA.mappedBy();
									if(relMappedBy!=null && relMappedBy.equals(propertyName)){
										relatedPropertyPd = relPd;
										break;
									}
								}
							
							}
							if(relatedPropertyPd==null){
								throw new MapConverterException("Related many to many property for "+bean.getClass().getName()+"."+propertyName+" in class "+deepClassInfo.getBeanDescriptor().getBeanClass().getName()+" not found !");
							}
							Method relReadMethod=relatedPropertyPd.getReadMethod();
							
							Collection<Object> coll = (Collection<Object>) readMethod.invoke(
									bean, new Object[0]);
							for (Object ro : relatedObjects) {
								// TODO order change is not reflected
								if(coll instanceof List){
									if(!coll.contains(ro)){
										coll.add(ro);
									}
								}else{
								coll.add(ro);
								}
								if(persist){
								Collection<Object> relColl = (Collection<Object>) relReadMethod.invoke(
										ro, new Object[0]);
								securityManager.checkMergePermission(req, ro,relatedPropertyPd);
								relColl.add(bean);
								em.merge(ro);
								}
							}
							
							
							

						} else {
							// not owning side
							Collection<Object> coll = (Collection<Object>) readMethod.invoke(
									bean, new Object[0]);
							for (Object ro : relatedObjects) {
								coll.add(ro);
								if(persist){
								PropertyDescriptor relatedPropertyPd = null;
								
								for (PropertyDescriptor deepPd : deepPds) {
									if (deepPd.getName().equals(mappedBy)) {
										relatedPropertyPd = deepPd;
										break;
									}
								}
								if (relatedPropertyPd == null) {
									throw new MapConverterException(
											"Cannot find mappedby property "
													+ mappedBy);
								}
								Collection<Object> relColl = (Collection<Object>) relatedPropertyPd
										.getReadMethod().invoke(ro,
												new Object[0]);
								securityManager.checkMergePermission(req, ro,relatedPropertyPd);
								relColl.add(bean);
								em.merge(ro);
								}
							}
						}
					} else if (omA != null) {
						mappedBy = omA.mappedBy();
						if (mappedBy == null || mappedBy.equals("")) {
							throw new MapConverterException(
									"Missing mappedby annotation for property "
											+ pd.getName());
						}
						Collection<Object> coll = (Collection<Object>) readMethod.invoke(bean,
								new Object[0]);
						for (Object ro : relatedObjects) {
							coll.add(ro);
							if(persist){
							PropertyDescriptor relatedPropertyPd = null;
							for (PropertyDescriptor deepPd : deepPds) {
								if (deepPd.getName().equals(mappedBy)) {
									relatedPropertyPd = deepPd;
									break;
								}
							}
							if (relatedPropertyPd == null) {
								throw new MapConverterException(
										"Cannot find mappedby property "
												+ mappedBy);
							}
							relatedPropertyPd.getWriteMethod().invoke(ro,
									new Object[] { bean });
							securityManager.checkMergePermission(req, ro);
							em.merge(ro);
							}
						}

					} else {
						throw new MapConverterException(
								"Expected OneToMany or ManyTOMany annotation for property "
										+ pd.getName());

					}

				} else {
					Object res = null;
					String[] values=(String[])value;
					if(values.length>1){
						throw new MapConverterException("More than one query parameter for many to one relationship.");
					}
					String didStr = values[0];
//					 empty string  is interpreted as null value
					if (!didStr.equals("")) {
						
						String propertyTypeName = propertyType.getName();
						if (!BasicPersistenceBeanController.USE_FULL_QUALIFIED_CLASSNAMES_IN_QUERY) {
							propertyTypeName = propertyTypeName
									.substring(propertyTypeName
											.lastIndexOf(".") + 1);
						}

						ExtBeanInfo deepClassInfo = PersistenceIntrospector
								.getPersistenceBeanInfo(propertyType,true);
						PropertyDescriptor relatedIdPd = deepClassInfo
								.getIdPropertyDescriptor();
						if (!relatedIdPd.getName().equals(deepProperty)) {
							throw new MapConverterException("Property "
									+ deepProperty + " is not the ID property.");
						}
						ManyToOne manyToOneAnno = readMethod
								.getAnnotation(ManyToOne.class);
						OneToOne oneToOneAnno = readMethod
						.getAnnotation(javax.persistence.OneToOne.class);

							Object idObj = null;
							Class<?> idClass = relatedIdPd.getPropertyType();
							Class<?> idwClass = NativeTypeWrapper
									.getWrapperClass(idClass);

							Constructor<?> idCstr = idwClass
									.getConstructor(new Class[] { String.class });
							idObj = idCstr.newInstance(new Object[] { didStr });
							res = em.find(propertyType, idObj);
							//securityManager.checkReadPermission(req,res);
							if (persist && manyToOneAnno != null) {
								// not owning side
//								PropertyDescriptor relPropertyPd = null;
								PropertyDescriptor[] relPPds = deepClassInfo
										.getPersistencePropertyDescriptors();
								for (PropertyDescriptor relPpd : relPPds) {
									Method relRm = relPpd.getReadMethod();
									OneToMany oneToManyAnno = relRm
											.getAnnotation(OneToMany.class);
									if (oneToManyAnno != null) {
										String mappedby = oneToManyAnno
												.mappedBy();
										// Check mappedby and property type !!
										Type relRt = relRm.getGenericReturnType();
										if(relRt instanceof ParameterizedType){
											ParameterizedType prelRt=(ParameterizedType)relRt;
											Type[] relAtas=prelRt.getActualTypeArguments();
											if(relAtas!=null && relAtas.length==1){
												Type relAta=relAtas[0];
												Class<?> relAClass=null;
												if(relAta instanceof Class){
													relAClass=(Class<?>)relAta;
												}
										
										if (mappedby != null && mappedby.equals(propertyName) 
											&& relAClass!=null && relAClass.isAssignableFrom(beanClass)
										   ) {
											securityManager.checkMergePermission(req,res,relPpd);
											Collection<Object> relColl = (Collection<Object>) relRm
													.invoke(res, new Object[0]);
											relColl.add(bean);
											break;
										}
											}
										}
										// what to check ??
										// securityManager.checkMegePermission(req,?);
									}
								}

							} else if (persist && oneToOneAnno != null) {
								// TODO OneToOne is not tested yet !!
								PropertyDescriptor[] relPPds = deepClassInfo
										.getPersistencePropertyDescriptors();
								String mappedBy = oneToOneAnno.mappedBy();
								if (mappedBy != null && !mappedBy.equals("")) {
									// not owning
									for (PropertyDescriptor relPpd : relPPds) {
										if (relPpd.getName().equals(mappedBy)) {
											Method relWm = relPpd
													.getWriteMethod();
											relWm.invoke(res,
													new Object[] { bean });
											break;
										}
										// what to check ??
										// securityManager.checkMegePermission(req,?);
									}
								} else {
									// owning

									for (PropertyDescriptor relPpd : relPPds) {
										Method relRm = relPpd.getReadMethod();
										OneToOne relOneToOneAnno = relRm
												.getAnnotation(OneToOne.class);
										if (relOneToOneAnno != null) {
											String mappedby = relOneToOneAnno
													.mappedBy();
											if (mappedby != null
													&& mappedby
															.equals(propertyName)) {
												Method relWm = relPpd
														.getWriteMethod();
												relWm.invoke(res,
														new Object[] { bean });
												break;
											}
											// what to check ??
											// securityManager.checkMegePermission(req,?);
										}
									}

								}
							}
						}
						return res;
					}
				}

			}
		} catch (NoSuchMethodException e) {

		} catch (IntrospectionException e) {
			e.printStackTrace();
			throw new MapConverterException(e);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
			throw new MapConverterException(e);
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			throw new MapConverterException(e);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
			throw new MapConverterException(e);
		} catch (InstantiationException e) {
			e.printStackTrace();
			throw new MapConverterException(e);
		}

		return o;
	}
	
	/**
	 * Applies not updatable properties to bean and creates BeanModel.
	 * @param bean
	 * @param properties
	 * @param beanModel bean model
	 * @return true if pre persisting is required 
	 * @throws MapConverterException
	 */
	public boolean createPrepersistBeanModel(Object bean, Map<String,String[]> properties,BeanModel<T> beanModel) throws MapConverterException {
//		@SuppressWarnings("unchecked")
		//BeanModel<Object> beanModel=new BeanModel<Object>(bean);
		
		boolean prePersistRequired=false;
		ExtBeanInfo beanInfo;
		try {
			beanInfo = PersistenceIntrospector.getPersistenceBeanInfo(bean.getClass(),true);
		} catch (IntrospectionException e1) {
			throw new MapConverterException(e1);
		}

		PropertyDescriptor[] beanProperties = beanInfo.getPersistencePropertyDescriptors();
		for (int i = 0; i < beanProperties.length; i++) {
			PropertyDescriptor propertyDescriptor = beanProperties[i];
			//Class type = propertyDescriptor.getPropertyType();
			Method readMethod=propertyDescriptor.getReadMethod();
			Column columnAnno=readMethod.getAnnotation(Column.class);
			boolean updatable=true;
			if(columnAnno!=null){
				updatable=columnAnno.updatable();
			}
			boolean nullable=true;
			if(columnAnno!=null){
				nullable=columnAnno.nullable();
			}
			if(!updatable || !nullable){
				Method writeMethod = propertyDescriptor.getWriteMethod();

				try {
					PropertyApplyResult par = applyProperty(propertyDescriptor, properties, bean);
					PropertyValidationResult pvr=par.getValidationResult();
					if (pvr==null || pvr.isValid() ){
						Object val=par.getPropertyValue();
						if (val != null) {
							if (val.equals(NULL_VALUE) ||val.equals(NULL_VALUE_AS_DEF)) {
								writeMethod.invoke(bean, new Object[] { null });
							} else {
								writeMethod.invoke(bean, new Object[] { val });
							}
						}
					}else{
						ValidationResult vr=beanModel.getValidationResult();
						if(vr==null){
							vr=new ValidationResult(ValidationResult.Type.ERRORS);
							beanModel.setValidationResult(vr);
						}
						vr.putPropertyValidationResult(propertyDescriptor.getName(), pvr);
					}
				}catch (IllegalArgumentException e) {
					throw new MapConverterException(e);
				} catch (IllegalAccessException e) {
					throw new MapConverterException(e);
				} catch (InvocationTargetException e) {
					throw new MapConverterException(e);
				}
				prePersistRequired=true;
			}
		}
		if (DEBUG)
			System.out.println("Applied not updatable properties.");
		return prePersistRequired;
	}
	
	
	public BeanModel<Object> createBeanModel(Object bean, Map<String,String[]> properties,EntityManager em, boolean persist,HttpServletRequest req,SecurityManager securityManager) throws MapConverterException {
//		@SuppressWarnings("unchecked")
		BeanModel<Object> beanModel=new BeanModel<Object>(bean);
		applyToBeanModel(beanModel, properties, em, persist, req, securityManager);
		return beanModel;
	}
	
	public void applyToBeanModel(BeanModel<?> beanModel, Map<String,String[]> properties,EntityManager em, boolean persist,HttpServletRequest req,SecurityManager securityManager) throws MapConverterException {
//		@SuppressWarnings("unchecked")
		
		Object bean=beanModel.getBean();
		ExtBeanInfo beanInfo;
		try {
			beanInfo = PersistenceIntrospector.getPersistenceBeanInfo(bean.getClass(),true);
		} catch (IntrospectionException e1) {
			throw new MapConverterException(e1);
		}

		PropertyDescriptor[] beanProperties = beanInfo.getPersistencePropertyDescriptors();
		for (int i = 0; i < beanProperties.length; i++) {
			PropertyDescriptor propertyDescriptor = beanProperties[i];
			//Class type = propertyDescriptor.getPropertyType();
			Method writeMethod = propertyDescriptor.getWriteMethod();

			try {
				PropertyApplyResult par = applyProperty(propertyDescriptor, properties, bean, em,
						persist,req,securityManager);
				PropertyValidationResult pvr=par.getValidationResult();
				if (pvr==null || pvr.isValid() ){
					Object val=par.getPropertyValue();
					if (val != null) {
						if (val.equals(NULL_VALUE) ||val.equals(NULL_VALUE_AS_DEF)) {
							writeMethod.invoke(bean, new Object[] { null });
						} else {
							writeMethod.invoke(bean, new Object[] { val });
						}
					}
				}else{
					ValidationResult vr=beanModel.getValidationResult();
					if(vr==null){
						vr=new ValidationResult(ValidationResult.Type.ERRORS);
						beanModel.setValidationResult(vr);
					}else{
						vr.setType(ValidationResult.Type.ERRORS);
					}
					vr.putPropertyValidationResult(propertyDescriptor.getName(), pvr);
				}
			} catch (PermissionDeniedException e) {
				throw new MapConverterException(e);
			}catch (IllegalArgumentException e) {
				throw new MapConverterException(e);
			} catch (IllegalAccessException e) {
				throw new MapConverterException(e);
			} catch (InvocationTargetException e) {
				throw new MapConverterException(e);
			}
		}
		if (DEBUG)
			System.out.println("Converting finished");
		return;
	}

	public Object setBeanProperties(Object bean, Map<String,String[]> properties,
			EntityManager em, boolean persist,HttpServletRequest req,SecurityManager securityManager) throws MapConverterException {

		ExtBeanInfo beanInfo;
		try {
			beanInfo = PersistenceIntrospector.getPersistenceBeanInfo(bean.getClass(),true);
		} catch (IntrospectionException e1) {
			throw new MapConverterException(e1);
		}

		PropertyDescriptor[] beanProperties = beanInfo.getPersistencePropertyDescriptors();
		for (int i = 0; i < beanProperties.length; i++) {
			PropertyDescriptor propertyDescriptor = beanProperties[i];
			//Class type = propertyDescriptor.getPropertyType();
			Method writeMethod = propertyDescriptor.getWriteMethod();

			try {
				Object val = getValue(propertyDescriptor, properties, bean, em,
						persist,req,securityManager);
				if (val != null) {
					if (val.equals(NULL_VALUE) ||val.equals(NULL_VALUE_AS_DEF)) {
						writeMethod.invoke(bean, new Object[] { null });
					} else {
						writeMethod.invoke(bean, new Object[] { val });
					}
				}
			} catch (PermissionDeniedException e) {
				throw new MapConverterException(e);
			}catch (IllegalArgumentException e) {
				throw new MapConverterException(e);
			} catch (IllegalAccessException e) {
				throw new MapConverterException(e);
			} catch (InvocationTargetException e) {
				throw new MapConverterException(e);
			}
		}
		if (DEBUG)
			System.out.println("Converting finished");
		return bean;
	}

}
