package ipsk.jsp;


import ips.beans.BeanInfoProvider;
import ips.beans.ExtBeanInfo;
import ipsk.beans.BeanModel;
import ipsk.beans.form.FormConfiguration;

import ipsk.math.bool.ExtBoolExpr;
import ipsk.persistence.EntityManagerProvider;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.sql.OrderByClause;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;

import java.beans.PropertyDescriptor;
import java.util.List;

import javax.persistence.CascadeType;
import ipsk.persistence.SecurityManager;

import javax.servlet.http.HttpServletRequest;

public interface BeanTableController extends PersistenceJSPController,BeanInfoProvider,EntityManagerProvider{

	//public void processRequest(HttpServletRequest req) throws ControllerException;
	public void processNamedQuery(HttpServletRequest request,String namedQuery, Object[] objects) throws ControllerException;
	public String getNamedQuery();
	public ExtBoolExpr getBoolCondition();
	public OrderByClause getOrderByClause();
	public List<String> getDisplayColumns();
	public PersistenceObjectIdentifier getRelatedObjectIdentifier();
	
	//public ExtBeanInfo getBeanInfo();
	public Object getId();
	public boolean isIdGenerated();
	public Object getItem() throws ControllerException;
	public boolean hasRelationShips(Object bean) throws ControllerException;
	public boolean hasRelationShips(Object bean,CascadeType ignoreRemoveCascadedWith) throws ControllerException;
	public boolean hasRelationShips(Object bean,PropertyDescriptor propertyDescriptor) throws ControllerException;
	
	public boolean modifyable(Object bean) throws ControllerException;
	public boolean removable(Object bean) throws ControllerException;
	//public List getItems();
	//public int getItemCount();
	public int getFirstItem();
	//public int getLastItem();
	public int getBatchSize();
	public BeanTableModel<?> getBeanTableModel(HttpServletRequest request) throws ControllerException;
	public void setAdditionalColumns(String[] additionalColsArr);
	public void setDisplayColumns(List<String> displayColumnNames);
	
	public void setBatchSize(int batchSize);
	
	public BeanModel getBeanModel();
	
	public ProcessResult getProcessResult();
	public FormConfiguration getFormConfiguration();
	public boolean itemSelectable(Object item);
	

}
