package ipsk.jsp;


import ipsk.webapps.BasicPersistenceBeanController;

import java.util.HashMap;
import java.util.Map;

public class BeanTableSelectionModel<E> {

	
	
	
	protected String action;
	
	protected boolean selectionMode;
	protected boolean selectionMultiMode;
	
	protected Object[] selectedIds;
	
	/**
	 * The class of the bean for which the bean requests a selection.
	 */
	protected String selectTargetClass;
	/**
	 * The property name of the bean for which the bean requests a selection.
	 */
	protected String selectTargetProperty;
	/**
	 * The ID property name of the bean for which the bean requests a selection.
	 */
	protected String selectTargetIdProperty;
	/**
	 * The ID value of the bean for which the bean requests a selection.
	 */
	protected String selectTargetId;
	

	public boolean isSelectionMode() {
		return selectionMode;
	}

	public void setSelectionMode(boolean selectionMode) {
		this.selectionMode = selectionMode;
	}

	public void setSelectTargetClass(String selectTargetClass) {
		this.selectTargetClass=selectTargetClass;
	}
	public String getSelectTargetClass(){
		return selectTargetClass;
	}
	public String getSelectTargetProperty() {
		return selectTargetProperty;
	}

	public void setSelectTargetProperty(String selectTargetProperty) {
		this.selectTargetProperty = selectTargetProperty;
	}

	public String getSelectTargetId() {
		return selectTargetId;
	}

	public void setSelectTargetId(String selectTargetId) {
		this.selectTargetId = selectTargetId;
	}

	public String getSelectTargetIdProperty() {
		return selectTargetIdProperty;
	}

	public void setSelectTargetIdProperty(String selectTargetIdProperty) {
		this.selectTargetIdProperty = selectTargetIdProperty;
	}

	public Object[] getSelectedIds() {
		return selectedIds;
	}

	public void setSelectedIds(Object[] selectedIds) {
		this.selectedIds = selectedIds;
	}

	public String getAction() {
		
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public boolean isSelectionMultiMode() {
		return selectionMultiMode;
	}

	public void setSelectionMultiMode(boolean selectionMultiMode) {
		this.selectionMultiMode = selectionMultiMode;
	}
	
	
	public Map toQueryMap(){
		Map<String, String[]> qMap=new HashMap<String, String[]>();
		qMap.put(BasicPersistenceBeanController.KEY_ACTION,new String[]{action});
		//qMap.put(BasicController., value)
		return qMap;
	}

	



}
