package ipsk.jsp.fmt;

import java.util.Locale;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;

public class LocaleSupport extends javax.servlet.jsp.jstl.fmt.LocaleSupport{

	public static Locale getLocale(ServletRequest req) {
		Locale loc= null;
		if(req instanceof HttpServletRequest){
//			// user preference setting in this session
			HttpSession sess=((HttpServletRequest)req).getSession(false);
			if (sess!=null) {
				loc= getLocaleFromObject(Config.get(sess,javax.servlet.jsp.jstl.core.Config.FMT_LOCALE));
			}
		}
		
//		// user preference setting in this request
		if (loc==null){
			loc= getLocaleFromObject(Config.get(req,javax.servlet.jsp.jstl.core.Config.FMT_LOCALE));
		}
		if(loc==null){
			// requested locale
			loc=req.getLocale();
		}
		if(loc==null){
			loc=req.getLocale();
		}
		
		return loc;
	}
	
	
	

	public static Locale getLocale(PageContext pageContext) {
		//Object locCont=pageContext.findAttribute("javax.servlet.jsp.jstl.fmt.localizationContext");
		
		// user preference setting in this session
		Locale loc=getLocaleFromObject(Config.find(pageContext,
				javax.servlet.jsp.jstl.core.Config.FMT_LOCALE));
		if(loc==null){
			// requested locale
			loc=pageContext.getRequest().getLocale();
		}
		if (loc==null){
			// default server locale
			loc=Locale.getDefault();
		}
		return loc;
	}

	private static Locale getLocaleFromObject(Object localeObject) {
		if (localeObject instanceof Locale) {
			return (Locale) localeObject;
		} else if (localeObject instanceof String) {

			return parse((String)localeObject);

		} else {
			return null;
		}
	}

	public static Locale parse(String localeStr) {
		Locale locale = null;
		String language;
		String country = null;
		int sep = localeStr.indexOf("_");
		if (sep == -1) {
			// e.g. locale: en
			language = localeStr;
		} else {
			// e.g locale: en_GB
			language = localeStr.substring(0, sep);
			country = localeStr.substring(sep + 1);
		}

		// String lastUrl=request.getParameter("url");
		if (country == null) {
			locale = new Locale(language);
		} else {
			locale = new Locale(language, country);
		}
		return locale;
	}

}
