package ipsk.jsp.taglib;

import ips.beans.BeanInfoProvider;
import ips.beans.ExtBeanInfo;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.Controller;
import ipsk.jsp.taglib.beans.BeanControllerProvider;
import ipsk.webapps.BasicPersistenceBeanController;




public class BeanTableControllerTag extends ExtBodyTagSupport implements BeanInfoProvider,ControllerProvider{
	protected  BeanTableController controller;

	protected int batchSize=BasicPersistenceBeanController.DEFAULT_BATCHSIZE;
	public BeanTableController getController() {
		return controller;
	}

	public void setController(BeanTableController beanTableController) {
		this.controller = beanTableController;
		setBatchSize(batchSize);
	}

	public ExtBeanInfo getBeanInfo() {
		
		return controller.getBeanInfo();
		
	}

	public int getBatchSize() {
		return batchSize;
	}

	public void setBatchSize(int batchSize) {
		this.batchSize = batchSize;
		if(controller!=null){
			this.controller.setBatchSize(batchSize);
		}
	}
}
