package ipsk.jsp.taglib;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.PersistenceException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;

import ips.beans.BeanInfoProvider;
import ips.beans.ExtBeanInfo;
import ipsk.jsp.BeanTableController;
import ipsk.webapps.ControllerException;
import ipsk.webapps.NoSuchObjectException;
import ipsk.webapps.ObjectAlreadyExistsException;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.ProcessResult;

public class ControllerProcessTag extends ControllerProviderTag {

	private String namedQuery=null;
	private Object param;
	private String processMethod;
	private String filterMethod;
	

	private String var;
	private boolean checkSecureRequestToken=false;
//	private FormConfiguration formConfiguration;
//	
//	public FormConfiguration getFormConfiguration() {
//		return formConfiguration;
//	}
//
//	public void setFormConfiguration(FormConfiguration formConfiguration) {
//		this.formConfiguration = formConfiguration;
//	}

	public boolean getCheckSecureRequestToken() {
		return checkSecureRequestToken;
	}

	public void setCheckSecureRequestToken(boolean checkSecureToken) {
		this.checkSecureRequestToken = checkSecureToken;
	}

	public String getNamedQuery() {
		return namedQuery;
	}

	public void setNamedQuery(String namedQuery) {
		this.namedQuery = namedQuery;
	}



	public int doStartTag() throws JspException {
		ServletRequest sreq = pageContext.getRequest();
		ServletContext servletContext=pageContext.getServletContext();
		ExtBeanInfo beanInfo = null;
		if(controller instanceof BeanInfoProvider){
			beanInfo=((BeanInfoProvider)controller).getBeanInfo();
		}
		
		if (controller != null && sreq instanceof HttpServletRequest) {

			HttpServletRequest req = (HttpServletRequest) sreq;
			
			try {
				controller.setServletContext(servletContext);
//				controller.setFormConfiguration(formConfiguration);
				controller.setCheckSecureRequestToken(checkSecureRequestToken);
				if(filterMethod!=null && ! filterMethod.isBlank()) {
					try {
						Method fMethod=controller.getClass().getMethod(filterMethod, List.class);
						controller.setFilterMethod(fMethod);
					} catch (NoSuchMethodException | SecurityException e) {
						e.printStackTrace();
						throw new ControllerException("Filter method "+filterMethod+ " not found!", e);
					}
				}
				
				if(pctrl!=null) {
					pctrl.open();
				}
				if(processMethod!=null){
					ArrayList<Object> paramList=new ArrayList<Object>();
					ArrayList<Class<?>> paramClassList=new ArrayList<Class<?>>();
					paramList.add(req);
					paramClassList.add(HttpServletRequest.class);
					if(param!=null){
						paramList.add(param);
						paramClassList.add(param.getClass());
					}
					try {
						Method procMethod=controller.getClass().getMethod(processMethod,paramClassList.toArray(new Class[0]));
						Object value=procMethod.invoke(controller,paramList.toArray(new Object[0]));
						
						if (var != null) {
							// variable is set: custom body content to evaluate
							pageContext.setAttribute(var, value,
									PageContext.REQUEST_SCOPE);
							
						}
					} catch (SecurityException e) {
						e.printStackTrace();
						if(pctrl!=null) {
							pctrl.rollback();
							pctrl.close();
						}
						throw new ControllerException("Could not access method: "+processMethod,e);
					} catch (NoSuchMethodException e) {
						e.printStackTrace();
						if(pctrl!=null) {
							pctrl.rollback();
							pctrl.close();
						}
						throw new ControllerException("No such method: "+processMethod,e);
					} catch (IllegalArgumentException e) {
						e.printStackTrace();
						if(pctrl!=null) {
							pctrl.rollback();
							pctrl.close();
						}
						throw new ControllerException(e);
					} catch (IllegalAccessException e) {
						e.printStackTrace();
						if(pctrl!=null) {
							pctrl.rollback();
							pctrl.close();
						}
						throw new ControllerException(e);
					} catch (InvocationTargetException e) {
						e.printStackTrace();
						e.getTargetException().printStackTrace();
						if(pctrl!=null) {
							pctrl.rollback();
							pctrl.close();
						}
						throw new ControllerException(e);
					}
				}else if(namedQuery!=null){
					if(controller instanceof BeanTableController){
					((BeanTableController)controller).processNamedQuery(req,namedQuery,new Object[]{param});
					}
				}else{
					controller.processRequest(req);
				}
				if(pctrl!=null) {
					pctrl.commit();
				}
				if(controller instanceof BeanTableController){
					ProcessResult pr=((BeanTableController)controller).getProcessResult();
					if(pr!=null){
						ProcessResult.Type prT=pr.getType();
					}
				}
				// commit changes 
				// the entity manager of the controller
				
				//ValidationResult vr=controller.getValidationResult();
				
			} catch (ControllerException e) {
				if(pctrl!=null) {
					pctrl.rollback();
					pctrl.close();
				}

				if (e instanceof PermissionDeniedException) {
					// w.println("<p>" + getLocalizedMessage("error.occurred")+ "
					// permission denied !</p>");
					throw new JspException(
							getLocalizedMessage("object.permission.denied"), e);
				} else if (e instanceof ObjectAlreadyExistsException) {

					ObjectAlreadyExistsException oaee = (ObjectAlreadyExistsException) e;
					Object oId = oaee.getObjectId();
					String oIdStr = "()";
					if (oId != null)
						oIdStr = oId.toString();
					String resBundleName = null;
					String classResKey=null;
					if(beanInfo!=null){
						resBundleName = beanInfo.getResourceBundleName();
						classResKey = beanInfo.getClassResourceKey();
					}
					String classDescr = "Object";
					
					if (resBundleName != null && classResKey != null) {
						classDescr = LocaleSupport.getLocalizedMessage(
								pageContext, classResKey, resBundleName);
					}

					String errMsg = LocaleSupport.getLocalizedMessage(
							pageContext, "object.already_exists", new Object[] {
									classDescr, oIdStr }, "ipsk.jsp.Messages");
					// w.println(errMsg);
					throw new JspException(errMsg, e);

				} else if (e instanceof NoSuchObjectException) {
					NoSuchObjectException nsoe = (NoSuchObjectException) e;
					Object oId = nsoe.getObjectId();
					String oIdStr = "()";
					if (oId != null)
						oIdStr = oId.toString();
					String resBundleName = null;
					String classResKey=null;
					if(beanInfo!=null){
						resBundleName = beanInfo.getResourceBundleName();
						classResKey = beanInfo.getClassResourceKey();
					}
					String classDescr = "Object";
					if (resBundleName != null && classResKey != null) {
						classDescr = LocaleSupport.getLocalizedMessage(
								pageContext, classResKey, resBundleName);
					}

					String errMsg = LocaleSupport.getLocalizedMessage(
							pageContext, "object.no_such", new Object[] {
									classDescr, oIdStr }, "ipsk.jsp.Messages");
					// w.println(errMsg);
					throw new JspException(errMsg, e);

				} else {
					e.printStackTrace();

					// w.println("<p>" + getLocalizedMessage("error.occurred")
					// + "<br>" + e.getMessage()+"</p>");
					throw new JspException(e);

				}
				// return SKIP_BODY;
			}catch(PersistenceException pe){
				if(pctrl!=null) {
					pctrl.rollback();
					pctrl.close();
				}
				pe.printStackTrace();
				throw new JspException(pe);
			}
			
		}
		return EVAL_BODY_INCLUDE;
	}

	public int doEndTag() throws JspException {
		if(pctrl!=null) {
			pctrl.close();
		}
		return EVAL_PAGE;
	}

	
	
	public Object getParam() {
		return param;
	}

	public void setParam(Object param) {
		this.param = param;
	}

	public String getProcessMethod() {
		return processMethod;
	}

	public void setProcessMethod(String processMethod) {
		this.processMethod = processMethod;
	}
	
	public String getFilterMethod() {
		return filterMethod;
	}

	public void setFilterMethod(String filterMethod) {
		this.filterMethod = filterMethod;
	}

	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;
	}

	

}
