package ipsk.jsp.taglib;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class FileInfoTag extends ExtBodyTagSupport {

	private File[] files;
	
	public int doStartTag() throws JspException{
		
		JspWriter out=pageContext.getOut();
		
		try {
			if(files!=null && files.length>0){
			out.print("<table>");
			
				for(File f:files){
				out.print("<tr><td>"+f.getAbsoluteFile()+"</td><td>"+new Date(f.lastModified())+"</td></tr>");
				}
			}else{
				out.print("<p>");
				out.print(getLocalizedMessage("files.no_files"));
			}
		} catch (IOException e) {
			
			e.printStackTrace();
			throw new JspException(e);
		}
	
	
		return SKIP_BODY;
	}
	
	public int doEndTag() throws JspException{
		
		JspWriter out=pageContext.getOut();
		
		try {
		if(files!=null && files.length>0){
			out.println("</table>");
		}else{
			out.print("</p>");
		}
		} catch (IOException e) {
			
			e.printStackTrace();
			throw new JspException(e);
		}
		
		
		return EVAL_PAGE;
	}
	
	public File[] getFiles() {
		return files;
	}
	public void setFiles(File[] files) {
		this.files = files;
	}
	
	
	
	
}
