package ipsk.jsp.taglib;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class SystemInfoTag extends BodyTagSupport {

	private String tableClass;

	private String tableClassStr = "";

	public String getTableClass() {
		return tableClass;
	}

	public void setTableClass(String tableClass) {
		this.tableClass = tableClass;
		tableClassStr = " class=\"" + tableClass + "\"";
	}

	public int doStartTag() throws JspException {

		JspWriter ow = pageContext.getOut();
		ServletRequest req=pageContext.getRequest();
		Locale loc=null;
		if(req!=null) {
			loc=req.getLocale();
		}
		NumberFormat nf;
		if(loc==null) {
			nf=NumberFormat.getNumberInstance();
		}else {
			nf=NumberFormat.getNumberInstance(loc);
		}
		
		long totMem=Runtime.getRuntime().totalMemory();
		long maxMem=Runtime.getRuntime().maxMemory();
		long freeMem=Runtime.getRuntime().freeMemory();
		
		String totMemFmtStr=nf.format(totMem);
		String maxMemFmtStr=nf.format(maxMem);
		String freeMemFmtStr=nf.format(freeMem);
		
		try {
			ow.println("<table" + tableClassStr + ">");

			ow.println("<tr><td>Operating system name</td><td>"
					+ System.getProperty("os.name") + "</td></tr>");
			ow.println("<tr><td>Operating system architecture</td><td>"
					+ System.getProperty("os.arch") + "</td></tr>");
			ow.println("<tr><td>Operating system version</td><td>"
					+ System.getProperty("os.version") + "</td></tr>");
			ow.println("<tr><td>JVM implementation vendor</td><td>"
					+ System.getProperty("java.vm.vendor") + "</td></tr>");
			ow.println("<tr><td>JVM implementation name</td><td>"
					+ System.getProperty("java.vm.name") + "</td></tr>");
			ow.println("<tr><td>JVM implementation version</td><td>"
					+ System.getProperty("java.vm.version") + "</td></tr>");
			ow
					.println("<tr><td>Processors</td><td align=\"right\">"
							+ Runtime.getRuntime().availableProcessors()
							+ "</td></tr>");
			ow.println("<tr><td>Total memory</td><td align=\"right\">"
					+ totMemFmtStr + "</td></tr>");
			ow.println("<tr><td>Max memory</td><td align=\"right\">"
					+ maxMemFmtStr + "</td></tr>");
			ow.println("<tr><td>Free memory</td><td align=\"right\">"
					+ freeMemFmtStr + "</td></tr>");
		} catch (IOException e) {
			e.printStackTrace();
			throw new JspException(e);

		}
		return SKIP_BODY;
	}

	public int doEndTag() throws JspException {
		JspWriter ow = pageContext.getOut();
		try {
			ow.println("</table>");
		} catch (IOException e) {
			e.printStackTrace();
			throw new JspException(e);

		}
		return EVAL_PAGE;
	}

}
