package ipsk.jsp.taglib.beans;

import ips.beans.ExtBeanInfo;
import ipsk.beans.BeanModel;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.form.FormConfiguration;
import ipsk.beans.form.PropertyConfiguration;
import ipsk.beans.validation.Input;
import ipsk.beans.validation.ValidationResult;
import ipsk.util.LocalizableMessage;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.TooltipResourceKey;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;

public class BeanProperty {

	protected BeanModel<?> beanModel = null;

	protected Object value = null;

	protected String var = null;

	protected String name;

	protected String bundle;

	protected String key;

	private Method readmethod;

	private ResourceKey resourceKey;
	
	private TooltipResourceKey tooltipResourceKey;

	private String resourceBundleName;

	protected PropertyDescriptor propertyDescriptor;

	protected BeanProvider beanProvider;
	
	protected boolean readOnly=false;
	protected boolean required=false;
	
	public boolean isRequired() {
		return required;
	}
	public PropertyConfiguration getConfiguration() {
		return configuration;
	}
	protected String action=null;
	
	protected boolean valid=true;
	
	private PropertyConfiguration configuration;

	public BeanProperty() {
		this(null,null,null);
	}
	public BeanProperty(String name) {
		this(name,null,null);
	}

	public BeanProperty(String name, String bundle, String key) {
		super();
		this.name = name;
		this.bundle = bundle;
		this.key = key;
	}

	public BeanProperty(PropertyDescriptor pd) {
		super();
		this.propertyDescriptor = pd;
		name = propertyDescriptor.getName();
		bundle = null;
		key = null;
	}

	public void setContext(BeanPropertyIterator beanProvider)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		this.beanProvider = beanProvider;
		ExtBeanInfo beanInfo=beanProvider.getBeanInfo();
		if(name==null)name=beanProvider.getCurrentProperty();
		beanModel = beanProvider.getBeanModel();
		
		// Get form configuration for this property
		configuration=null;
		FormConfiguration formConfiguration=beanProvider.getFormConfiguration();
		if(formConfiguration!=null){
			//required=formConfiguration.isDefaultRequired();
			required=false;
			List<PropertyConfiguration> propCfgs=formConfiguration.getPropertyConfigurations();
			for(PropertyConfiguration pCfg:propCfgs){
				if(name.equals(pCfg.getPropertyDescriptor().getName())){
					required=pCfg.isRequired();
					configuration=pCfg;
					break;
				}
			}
		}
		boolean match=false;
		PropertyDescriptor pd = null;
		String propertyName=name;
		int sepIndex=name.indexOf(".");
		if(sepIndex!=-1){
			propertyName=name.substring(sepIndex+1);
		}
		// check additional props first
		String[] addProps=beanProvider.getAdditionalPropertyNames();
		if(addProps!=null){
			for(String addProp:addProps){
				if(propertyName.equals(addProp)){
					match=true;
					setPropertyDescriptor(null);
				}
			}
		}
		if(!match){
			pd=beanInfo.getPersistencePropertyDescriptor(propertyName);
			if(pd!=null){
				setPropertyDescriptor(pd);
				if(beanInfo.isIdGenerated() && beanInfo.getIdPropertyDescriptor().equals(pd)){
					setReadOnly(true);
				}
				match=true;
				readmethod = pd.getReadMethod();
				resourceKey = readmethod.getAnnotation(ResourceKey.class);
				tooltipResourceKey=readmethod.getAnnotation(TooltipResourceKey.class);
			}
		}
		if(!match) {
			PropertyDescriptor[] pojoPds=beanInfo.getPropertyDescriptors();
			for(PropertyDescriptor pojoPd:pojoPds) {
				String pojoPdNm=pojoPd.getName();
				if(propertyName.equals(pojoPdNm)) {
					pd=pojoPd;
					setPropertyDescriptor(pd);
					match=true;
					readmethod = pd.getReadMethod();
					resourceKey = readmethod.getAnnotation(ResourceKey.class);
					tooltipResourceKey=readmethod.getAnnotation(TooltipResourceKey.class);
					break;
				}
			}
		}

		if(!match){
			throw new IllegalArgumentException("Unknown bean property: "+propertyName);
		}
		resourceBundleName = beanInfo.getResourceBundleName();
		if(readmethod!=null){
			ResourceBundleName resBundleAnno=readmethod.getAnnotation(ResourceBundleName.class);
			if(resBundleAnno!=null){
				// property has a different resource bundle
				resourceBundleName=resBundleAnno.value();
			}

			Input inputA=readmethod.getAnnotation(Input.class);
			if(inputA!=null){
				required=required || inputA.required();
			}
		}
		Object bean=null;
		if(beanModel !=null){
			bean=beanModel.getBean();
		}
		if(bean==null){
			setValue(null);
		}else if (readmethod!=null){
			Object value = readmethod.invoke(bean, new Object[0]);
			setValue(value);
		}
		if (var != null) {
			beanProvider.getPageContext().setAttribute(var, value,
					PageContext.REQUEST_SCOPE);
		}

	}

	public String getBundle() {
		return bundle;
	}

	public void setBundle(String bundle) {
		this.bundle = bundle;
	}

	public String getName() {
		return name;
	}

	public PropertyDescriptor getPropertyDescriptor() {
		return propertyDescriptor;
	}

	public void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
		this.propertyDescriptor = propertyDescriptor;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	

	public Object getValue() {
		return value;
	}

	
	public void setValue(Object value) {
		this.value = value;
	}

	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;

	}

	public String getDescriptor() {
		String descr = null;
		if (resourceBundleName != null && resourceKey != null
				&& beanProvider != null) {
			descr = LocaleSupport.getLocalizedMessage(beanProvider
					.getPageContext(), resourceKey.value(), resourceBundleName);
		} else {
			descr = propertyDescriptor.getShortDescription();
		}

		return descr;
	}
	
	/**
	 * Returns localized tooltip text of property.
	 * @return localized tooltip text or null if not available
	 */
	public String localizedTooltipText() {
		String ttt = null;
		if (resourceBundleName != null && tooltipResourceKey != null
				&& beanProvider != null) {
			ttt = LocaleSupport.getLocalizedMessage(beanProvider
					.getPageContext(), tooltipResourceKey.value(), resourceBundleName);
		} 
		return ttt;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	public boolean isReadOnly() {
		return readOnly;
	}
	public void setReadOnly(boolean readOnly) {
		this.readOnly = readOnly;
	}
	public String getAction() {
		return action;
	}
	public void setAction(String action) {
		this.action = action;
	}
	public boolean isValid() {
		return valid;
	}
	public void setValid(boolean valid) {
		this.valid = valid;
	}

	public BeanModel getBeanModel() {
		return beanModel;
	}
	public void setBeanModel(BeanModel beanModel) {
		this.beanModel = beanModel;
	}
	
	public PropertyValidationResult getValidationResult(){
		if(beanModel!=null){
			ValidationResult vr=beanModel.getValidationResult();
			if(vr!=null){
				return vr.getPropertyValidationResult(name);
			}
		}
	
			return null;
		
	}
	public BeanProvider getBeanProvider() {
		return beanProvider;
	}

}
