package ipsk.jsp.taglib.beans;

import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanPropertyIterator.Iteration;
import ipsk.text.html.HTMLTextEncoder;

import java.lang.reflect.InvocationTargetException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class BeanPropertyTag extends ExtBodyTagSupport implements BeanPropertyProvider{

	protected BeanProperty beanProperty = null;

	protected BeanPropertyIterator beanProvider;
	
	protected boolean disabled=false;

	public BeanProvider getBeanProvider() {
		return beanProvider;
	}

	public void setPageContext(PageContext pc) {
		super.setPageContext(pc);
		beanProperty=new BeanProperty();
	}
	
	public void setParent(Tag parent){
		super.setParent(parent);
		// Find enclosing bean provider
		Tag bpParent=parent;
		
		while(bpParent!=null && !(bpParent instanceof BeanPropertyIterator)){
			bpParent=bpParent.getParent();
		}
		if(bpParent !=null && bpParent instanceof BeanPropertyIterator){
			beanProvider=(BeanPropertyIterator)bpParent;
		}
		
	}

	public int doStartTag() throws JspException {
		//Tag p = getParent();
		
		//beanProvider = (BeanProvider) p;
		Iteration it=beanProvider.getIteration();
		
		String currProp = beanProvider.getCurrentProperty();
		if (currProp == null || currProp.equals(beanProperty.getName())) {
			try {
				beanProperty.setContext(beanProvider);
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			//if (beanProperty.getVar() != null) {
				return EVAL_BODY_INCLUDE;
			//} else {
			//	return SKIP_BODY;
			//}
		} else {
			return SKIP_BODY;
		}
	}

	public int doEndTag() throws JspException {
		return EVAL_PAGE;
	}

	public String getBundle() {
		return beanProperty.getBundle();
	}

	public String getKey() {
		return beanProperty.getKey();
	}

	public String getName() {
		return beanProperty.getName();
	}

	public void setBundle(String bundle) {
		beanProperty.setBundle(bundle);
		this.bundle = bundle;
	}

	public void setKey(String key) {
		this.key = key;
		beanProperty.setKey(key);
	}

	public void setName(String name) {
		beanProperty.setName(name);
	}

	public String getVar() {
		return beanProperty.getVar();
	}

	public void setVar(String var) {
		beanProperty.setVar(var);
	}

	public String getAction(){
		return beanProperty.getAction();
	}
	
	public void setAction(String action){
		beanProperty.setAction(action);
	}
	
	public BeanProperty getBeanProperty() {
		return beanProperty;
	}

	public boolean isDisabled() {
		return disabled;
	}

	public void setDisabled(boolean disabled) {
		this.disabled = disabled;
	}
	
	public String descriptorHtmlTitelTooltipAttribute() {
		return BeanPropertyTagUtils.descriptorHtmlTitelTooltipAttribute(beanProperty);
	}

	public String descriptorHtml() {
		return BeanPropertyTagUtils.descriptorHtml(beanProperty);
	}
	
}
