package ipsk.jsp.taglib.beans;

import ipsk.text.html.HTMLTextEncoder;

public class BeanPropertyTagUtils {

	public static String descriptorHtml(BeanProperty beanProperty) {
		String descrHtml=HTMLTextEncoder.encode(beanProperty.getDescriptor());
		return descrHtml;
	}
	
	public static String descriptorHtmlTitelTooltipAttribute(BeanProperty beanProperty) {
		String tooltipText=beanProperty.localizedTooltipText();
		String descrTitleHtml="";
		if(tooltipText!=null) {
			String htmlTooltiptext=HTMLTextEncoder.encode(tooltipText);
			descrTitleHtml=" title=\""+htmlTooltiptext+"\"";
		}
		return descrTitleHtml;
	}
	
}
