package ipsk.jsp.taglib.beans;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.lang.reflect.NativeTypeWrapper;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.util.EnumResourceKeys;
import ipsk.util.MemberResourceKey;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Native;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;

public class BeanPropertyValueText {

	private ExtBeanInfo beanInfo;
	public final static String DEF_COLL_SEP_STRING=",";
	public final static String RESOURCE_KEY_TRUE="yes";
	public final static String RESOURCE_KEY_FALSE="no";
	
	private PageContext pageContext;
	private Locale locale;

	private int dateStyle = DateFormat.MEDIUM;

	private int timeStyle = DateFormat.MEDIUM;
	
	private int maxListLength=0;
	
	private String listSeparatorString=DEF_COLL_SEP_STRING;
	
	public BeanPropertyValueText(ExtBeanInfo beanInfo, PageContext pageContext) {
		this.beanInfo = beanInfo;
		this.pageContext = pageContext;
		locale = ipsk.jsp.fmt.LocaleSupport.getLocale(pageContext);
		if (locale == null) {
			locale = Locale.getDefault();
		}
	}
	public BeanPropertyValueText(ExtBeanInfo beanInfo, PageContext pageContext,int maxNumberOfDisplayCollMembers) {
		this.beanInfo = beanInfo;
		this.pageContext = pageContext;
		this.maxListLength=maxNumberOfDisplayCollMembers;
		locale = ipsk.jsp.fmt.LocaleSupport.getLocale(pageContext);
		if (locale == null) {
			locale = Locale.getDefault();
		}
	}
	
	/**
	 * Returns true if a value is considered empty.
	 * An empty value is null or an empty collection. All other values considered as non empty (including empty strings and zero numbers). 
	 * @param pd property descriptor associated with the value
	 * @param value the value
	 * @return true if considered as empty value
	 */
	public boolean isEmpty(PropertyDescriptor pd, Object value) {

		// empty if...
		// value is null ...
		if(value==null)return true;
		if (pd != null) {
			
			Class<?> propType = pd.getPropertyType();
			//if(propType.isAssignableFrom(Collection.class)) {
			if (Collection.class.isAssignableFrom(propType) && value instanceof Collection) {
				Collection<?> coll=(Collection<?>)value;
				int elementCount = 0;
				if(coll!=null) {
					elementCount = coll.size();
					// ...or empty collection
					return (elementCount==0);
				}
			} 
		}
		return false;
	}
	
	public String getValueTextRepresentation(PropertyDescriptor pd, Object value) {

		String valStr = "";
		if(value==null)return valStr;
		if (pd != null) {
			//String p = pd.getName();
			Class<?> propType = pd.getPropertyType();
			Temporal dateTemporal = pd.getReadMethod().getAnnotation(
					Temporal.class);
			if(value instanceof PersistenceObjectIdentifier){
				return ((PersistenceObjectIdentifier)value).getIdObject().toString();
			}else if (Collection.class.isAssignableFrom(propType)) {
				Collection<?> coll=(Collection<?>)value;
				int elementCount = 0;
				if (value != null) {
					elementCount = coll.size();
				}
				if(elementCount!=0 && elementCount<=maxListLength){
					Iterator<?> it=coll.iterator();
					StringBuffer sb=new StringBuffer();
					while (it.hasNext()){
						sb.append(it.next().toString());
						if(it.hasNext())sb.append(listSeparatorString);
					}
					return sb.toString();
				}else{
					return ("#" + elementCount);
				}

			} else if (propType.equals(boolean.class) || propType.equals(Boolean.class)) {
				if (value.equals(true)) {
					return LocaleSupport
							.getLocalizedMessage(pageContext, RESOURCE_KEY_TRUE,"ipsk.jsp.Messages");
				}
				if (value.equals(false)) {
					return LocaleSupport.getLocalizedMessage(pageContext, RESOURCE_KEY_FALSE,"ipsk.jsp.Messages");
				}
			} else if (propType.isEnum()) {
				Enum<?> enumVal = (Enum<?>) value;
				String enumMemberName = enumVal.name();
				String message = enumVal.toString();
				
				EnumResourceKeys reskeysAnno = (EnumResourceKeys) propType
						.getAnnotation(EnumResourceKeys.class);
				if (reskeysAnno != null) {
					for (MemberResourceKey memberResKeyAnno : reskeysAnno
							.memberResourceKeys()) {
						if (memberResKeyAnno.name().equals(enumMemberName)) {
							String resourceKey = memberResKeyAnno.key();
							if (resourceKey != null) {
								message = LocaleSupport.getLocalizedMessage(
										pageContext, resourceKey, beanInfo
												.getResourceBundleName());
							}
							break;
						}
					}
					
				}
				return message;
			} else if(NativeTypeWrapper.isPrimitiveNumber(propType) || Number.class.isAssignableFrom(propType)){
				// do not format ID's
				PropertyDescriptor idPd=beanInfo.getIdPropertyDescriptor();
				if(idPd != null && idPd.equals(pd)){
					return value.toString();
				}else{
					// localized formatting 
					NumberFormat nf=NumberFormat.getInstance(locale);
					return nf.format(value);
				}
			}else if (Date.class.isAssignableFrom(propType)) {
				// if a date is requested
				if (value != null) {
					Date date = (Date) value;

					// Locale locale = (Locale) (pageContext.getSession()
					// .getAttribute("javax.servlet.jsp.jstl.fmt.locale"));
					
					
					DateFormat dateFormat = null;
					// do not print time values if only a date is requested
					if (dateTemporal != null
							&& (dateTemporal.value().equals(TemporalType.DATE))) {

						dateFormat = DateFormat.getDateInstance(dateStyle,
								locale);
					} else {
						dateFormat = DateFormat.getDateTimeInstance(dateStyle,
								timeStyle, locale);
					}

					valStr = dateFormat.format(date);
				}
			} else {
				if (value != null) {
					String valueStr = value.toString();
					if(valueStr!=null){
						valStr=valueStr;
					}
				}
			}
		}
		return valStr;
	}
	
	/**
	 * Returns true if the property type is a collection.
	 * @param pd property descriptor to retrieve the value
	 * @return true if the property type is a collection
	 */
	public boolean isCollection(PropertyDescriptor pd) {
		Class<?> propType = pd.getPropertyType();
		return (Collection.class.isAssignableFrom(propType));
	}
	
	/**
	 * Returns true if a value is considered empty.
	 * An empty value is null or an empty collection. All other values considered as non empty (including empty strings and zero numbers). 
	 * @param bean the bean which contains the property 
	 * @param pd property descriptor to retrieve the value
	 * @return true if the value is considered empty
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 */
	public boolean isEmpty(Object bean, PropertyDescriptor pd)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		Method rm = pd.getReadMethod();
		Object value = rm.invoke(bean, new Object[0]);
		return isEmpty(pd, value);

	}

	public String getValueTextRepresentation(Object bean, PropertyDescriptor pd)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		Method rm = pd.getReadMethod();
		Object value = rm.invoke(bean, new Object[0]);
		return getValueTextRepresentation(pd, value);

	}

}
