package ipsk.jsp.taglib.beans;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.net.EditableURI;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.webapps.BasicPersistenceBeanController;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;

import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;

public class RelationshipURL {

	private BeanProperty beanProperty=null;
	private Object bean=null;
	
	public RelationshipURL(BeanProperty beanProperty) {
		super();
		this.beanProperty=beanProperty;
	}
	
	public RelationshipURL(Object bean) {
		super();
		this.bean=bean;
	}
	
	public EditableURI getEditableURI(String action)
	throws RelationshipException {
		
		EditableURI uri = null;
		if (action == null) {
			throw new NullPointerException("No action base URL given!");
		}
		try {
			if(bean!=null){
				// bean self view
				ExtBeanInfo relBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(this.bean.getClass(),true);
				PersistenceObjectIdentifier selfPoi = relBeanInfo
				.getPersistenceObjectIdentifier(bean);
				if (selfPoi != null) {
					uri = new EditableURI(action);
					uri.appendQueryMap(selfPoi.toQueryMap());
					uri.appendQuery(BasicPersistenceBeanController.KEY_CMD,
							BasicPersistenceBeanController.CMD_VIEW);
				}

			}else{
				// related property view
				PropertyDescriptor pd = beanProperty.getPropertyDescriptor();
				Class propType = pd.getPropertyType();
				Object bean = beanProperty.getBeanModel().getBean();
				ExtBeanInfo beanInfo=beanProperty.getBeanProvider().getBeanInfo();


				Method rm = pd.getReadMethod();
				Object relValue = rm.invoke(bean, new Object[0]);
				if (relValue != null) {
					String mappedBy = null;

					if (Collection.class.isAssignableFrom(propType)) {
						// Assuming ManyToMany or OneToMany

						//if (((Collection) relValue).size() > 0) {
						uri = new EditableURI(action);
						uri.appendQuery(BasicPersistenceBeanController.KEY_CMD,
								BasicPersistenceBeanController.CMD_LIST_RELATED);
						ManyToMany manyToManyAnno = rm
						.getAnnotation(ManyToMany.class);
						if (manyToManyAnno != null) {
							mappedBy = manyToManyAnno.mappedBy();
						} else {
							OneToMany oneToManyAnno = rm
							.getAnnotation(OneToMany.class);
							if (oneToManyAnno != null) {
								mappedBy = oneToManyAnno.mappedBy();
							}
						}
						if (mappedBy != null && !mappedBy.equals("")) {
							uri.appendQuery(BasicPersistenceBeanController.KEY_MAPPEDBY,
									mappedBy);
						} else {
							uri.appendQuery(
									BasicPersistenceBeanController.KEY_RELATED_PROPERTY, pd
									.getName());
						}
						PersistenceObjectIdentifier poi = beanInfo
						.getPersistenceObjectIdentifier(bean);
						uri.appendQueryMap(poi.toQueryMap());
						//}
					} else {
						// Assuming ManyToOne or OneToOne
						// identify target object by ID directly

						ExtBeanInfo relBeanInfo = PersistenceIntrospector
						.getPersistenceBeanInfo(propType,true);
						PersistenceObjectIdentifier relPoi = relBeanInfo
						.getPersistenceObjectIdentifier(relValue);
						if (relPoi != null) {
							uri = new EditableURI(action);
							uri.appendQueryMap(relPoi.toQueryMap());
							uri.appendQuery(BasicPersistenceBeanController.KEY_CMD,
									BasicPersistenceBeanController.CMD_VIEW);
						}
					}
				}
			}
		} catch (Exception e) {
			throw new RelationshipException(e);
		}
		return uri;
	}
}
