package ipsk.jsp.taglib.beans.edit;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverter;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.Unit;
import ipsk.beans.form.FormConfiguration;
import ipsk.jsp.fmt.LocaleSupport;
import ipsk.jsp.taglib.beans.BeanPropertyIterator;
import ipsk.jsp.taglib.beans.BeanPropertyTagUtils;
import ipsk.jsp.taglib.beans.BeanPropertyIterator.Iteration;
import ipsk.jsp.taglib.beans.BeanProvider;
import ipsk.jsp.taglib.beans.BeanProviderAdapter;
import ipsk.lang.reflect.NativeTypeWrapper;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.util.EnumResourceKeys;
import ipsk.util.LocalizableMessage;
import ipsk.util.MemberResourceKey;
import ipsk.util.annotations.TextAreaView;
import ipsk.webapps.BasicPersistenceBeanController;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

import javax.persistence.Column;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public class BeanPropertyTag extends ipsk.jsp.taglib.beans.BeanPropertyTag {

	private static final int TEXTAREA_DEF_COLS = 20;
	private static final int TEXTAREA_DEF_ROWS = 3;
	
	public static enum EditorType {DEFAULT,WEIGHT_I18N};
//	private String actions=null;
//	private HashSet<String> actionsSet=new HashSet<String>();
	private boolean hasBody=false;
	private String actionForNew=null;
	private boolean hidden=false;
	
	private String defaultOptionResourceKey;
	private String defaultOptionResourceBundle;


	private String value;
	
	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public boolean isHidden() {
		return hidden;
	}

	public void setHidden(boolean hidden) {
		this.hidden = hidden;
	}

	public String getActionForNew() {
		return actionForNew;
	}

	public void setActionForNew(String actionForNew) {
		this.actionForNew = actionForNew;
	}
	
	protected int maxListLength=0;
	
	public int getMaxListLength() {
		return maxListLength;
	}

	public void setMaxListLength(int maxListLength) {
		this.maxListLength = maxListLength;
	}

	private String editUnit;
	private String editor;
	
	public String getEditor() {
		return editor;
	}

	public void setEditor(String editor) {
		this.editor = editor;
	}

	public String getEditUnit() {
		return editUnit;
	}

	public void setEditUnit(String editUnit) {
		this.editUnit = editUnit;
	}
	
	public String getDefaultOptionResourceKey() {
		return defaultOptionResourceKey;
	}

	public void setDefaultOptionResourceKey(String defaultOptionResourceKey) {
		this.defaultOptionResourceKey = defaultOptionResourceKey;
	}
	
	public String getDefaultOptionResourceBundle() {
		return defaultOptionResourceBundle;
	}

	public void setDefaultOptionResourceBundle(String defaultOptionResourceBundle) {
		this.defaultOptionResourceBundle = defaultOptionResourceBundle;
	}
	
	private boolean hideIfEmpty=false;
	public boolean getHideIfEmpty() {
		return hideIfEmpty;
	}

	public void setHideIfEmpty(boolean hideIfEmpty) {
		this.hideIfEmpty = hideIfEmpty;
	}


	public void printTag() throws JspException {
		printTag(beanProvider);
	}

	public void printTag(BeanProvider beanProvider) throws JspException {
		JspWriter ow = pageContext.getOut();
		try {
			Locale locale=LocaleSupport.getLocale(pageContext);
			//We need the display language for the session locale not for the default locale:
			String displayLanguage=locale.getDisplayLanguage(locale);


			boolean imperialUnits=locale.equals(new Locale("en","GB"));

			//FormConfiguration formConfig=beanProvider.getFormConfiguration();

			String p = beanProperty.getName();
			ExtBeanInfo beanInfo = beanProvider.getBeanInfo();
			PropertyDescriptor pd = beanProperty.getPropertyDescriptor();
			Method rm = pd.getReadMethod();
			boolean inserting=BasicPersistenceBeanController.CMD_ADD.equals(beanProvider.getActionCommand());
			boolean updating=BasicPersistenceBeanController.CMD_STORE.equals(beanProvider.getActionCommand());

			boolean insertable=true;
			boolean updateable=true;
			Integer maxStringLength=null;
			Column colAnno=rm.getAnnotation(Column.class);
			if(colAnno!=null){
				insertable=colAnno.insertable();
				updateable=colAnno.updatable();
				maxStringLength=colAnno.length();
			}
			boolean isRequired=beanProperty.isRequired();
			Object propValue = beanProperty.getValue();
			boolean propValueEmpty=propValue==null;
			if(propValue!=null && propValue instanceof String) {
				String propValStr=(String) propValue;
				propValueEmpty=propValueEmpty|| propValStr.isEmpty();
			}
			if(!(hideIfEmpty && propValueEmpty)) {
				boolean isId = (pd != null && pd.equals(beanInfo
						.getIdPropertyDescriptor()));

				boolean readonly = (beanProperty.isReadOnly() || isDisabled() || (isId && updating) || (updating && !updateable) || (inserting && ! insertable));
				if (isId && beanInfo.isIdEmbedded()) {
					ExtBeanInfo embIdInfo = beanInfo.getEmbeddedIdBeanInfo();
					for (PropertyDescriptor emPd : embIdInfo
							.getPropertyDescriptors()) {
						if (!emPd.getPropertyType().equals(Class.class)) {
							BeanPropertyTag embpt = new BeanPropertyTag();

							embpt.setParent(this);
							embpt.setPageContext(pageContext);
							BeanProviderAdapter bpa = new BeanProviderAdapter(
									pageContext, new BeanModel<Object>(propValue), beanProvider
									.getActionCommand(), pd.getName() + "."
											+ emPd.getName(),Iteration.TABLE, embIdInfo);
							embpt.getBeanProperty().setContext(bpa);
							embpt.getBeanProperty().setReadOnly(readonly);
							embpt.printTag(bpa);
						}
					}

				} else {
					String valStr = "";
					String readOnlyStr = "";

					if (readonly) {
						readOnlyStr = " readonly";
					}
					PropertyValidationResult pvr=beanProperty.getValidationResult();
					String validatedParameterValue=null;
					if(pvr!=null){
						Map<String,String[]> validatedMap=pvr.getFailedProperties();
						if(validatedMap!=null){
							String[] validatedValues=validatedMap.get(beanProperty.getName());
							if(validatedValues!=null && validatedValues.length>=1){
								validatedParameterValue=validatedValues[0];
							}
						} 
					}
					Class<?> propType = pd.getPropertyType();
					Temporal dateTemporal = pd.getReadMethod().getAnnotation(
							Temporal.class);
					boolean unitConversion=false;
					String displayUnit=null;
					String propUnit=null;
					Object propUnitObj=pd.getValue(Unit.class.getName());
					if(propUnitObj instanceof String){
						propUnit=(String)propUnitObj;
						displayUnit=propUnit;
					}
					if(editUnit!=null){
						displayUnit=editUnit;
						// convert units if edit unit not equal unit of property
						// example: DB uses SI unit m (meter), edit unit is cm (height of a person is usually measured in cm)
						unitConversion=(propUnit!=null && ! propUnit.equals(editUnit));
					}
					String requiredSymbol="";
					if(isRequired){
						requiredSymbol=" *";
					}
					String titleHtmlTooltipAttributeStr=BeanPropertyTagUtils.descriptorHtmlTitelTooltipAttribute(beanProperty);
					String descrHtml=BeanPropertyTagUtils.descriptorHtml(beanProperty);
					ow.print("<tr><td"+titleHtmlTooltipAttributeStr+">" + descrHtml + requiredSymbol+"</td>");
					if (Collection.class.isAssignableFrom(propType)) {
						int elementCount = 0;
						Collection<?> collVal=null;
						ow.print("<td>");
						if (propValue != null) {
							collVal=(Collection<?>) propValue;
							elementCount = collVal.size();
							// forward preset values from new requests
							Type rt = rm.getGenericReturnType();
							boolean paramterized = (rt instanceof ParameterizedType);
							if (elementCount > 0
									&& paramterized
									&& BasicPersistenceBeanController.CMD_ADD.equals(beanProvider.getActionCommand())) {
								//String prtName = rt.toString();
								ParameterizedType prt = (ParameterizedType) rt;

								Type[] pts = prt.getActualTypeArguments();
								if (pts.length == 1) {
									Class<?> collClass = (Class<?>) pts[0];

									if(collClass.isEnum()){

										Collection<?> valueAsColl = (Collection<?>) propValue;
										for (Object so : valueAsColl) {

											ow
											.println("<input type=\"hidden\" name=\""
													+ p
													+ "\" value=\""
													+ so.toString() + "\"/>");
										}
									}else{
										ExtBeanInfo pbi = PersistenceIntrospector
												.getPersistenceBeanInfo(collClass,true);
										PropertyDescriptor idDescr = pbi
												.getIdPropertyDescriptor();
										if (idDescr != null) {
											String idPropName = idDescr.getName();
											Collection<?> valueAsColl = (Collection<?>) propValue;
											Method deepIdReadMethod = idDescr
													.getReadMethod();
											for (Object so : valueAsColl) {
												Object deepIdvalue = deepIdReadMethod
														.invoke(so, new Object[0]);
												ow
												.println("<input type=\"hidden\" name=\""
														+ p
														+ "."
														+ idPropName
														+ "\" value=\""
														+ deepIdvalue + "\"/>");
											}

										}
									}
								}
							}
						}
						String href=getAction();
						String hrefForNew=getActionForNew();

						if(href!=null && ! href.equals("")){
							BeanShowRelatedTag bsht=new BeanShowRelatedTag();
							bsht.setPageContext(pageContext);
							bsht.setParent(this);
							bsht.setHref(href);
							bsht.setMaxListLength(maxListLength);
							bsht.doStartTag();
							bsht.doEndTag();
						}else{
							// TODO duplicate code in BeanPropertyValueText 

							if(elementCount>0 && elementCount<=maxListLength && collVal!=null) {
								Iterator<?> it=collVal.iterator();
								StringBuffer sb=new StringBuffer();
								while (it.hasNext()){
									sb.append(it.next().toString());
									if(it.hasNext())sb.append(',');
								}
								ow.print(sb.toString());
							}else {
								ow.print("#" + elementCount);
							}
						}

						if(href!=null && ! href.equals("")){
							ow.print(" ");
							BeanSelectRelatedTag bst=new BeanSelectRelatedTag();
							bst.setPageContext(pageContext);
							bst.setParent(this);
							bst.setHref(href);
							bst.setHrefForNew(hrefForNew);
							bst.doStartTag();
							bst.doEndTag();
						}

						ow.print("</td>");
					} else if (propType.equals(Boolean.TYPE)) {

						ow.println("<td><select"+(readonly?" disabled":"")+" name=\"" + p + "\">");
						String selectedStr = "";
						if (propValue!=null && propValue.equals(true))
							selectedStr = " selected ";
						ow.println("<option value=\"true\"" + selectedStr + ">"
								+ getLocalizedMessage("yes") + "</option>");
						selectedStr = "";
						if (propValue !=null && propValue.equals(false))
							selectedStr = " selected ";
						ow.println("<option value=\"false\"" + selectedStr + ">"
								+ getLocalizedMessage("no") + "</option>");
						ow.println("</select></td>");
					} else if (propType.equals(Boolean.class)) {

						ow.println("<td><select"+(readonly?" disabled":"")+" name=\"" + p + "\">");
						String selectedStr = "";
						if (propValue==null){
							selectedStr = " selected ";
						}

						String defaultOptionStr= "-- "+getLocalizedMessage("select") +" --";

						if(defaultOptionResourceKey!=null) {
							if(defaultOptionResourceBundle!=null) {
								defaultOptionStr=getLocalizedMessage(defaultOptionResourceKey, defaultOptionResourceBundle);
							}else {
								defaultOptionStr=getLocalizedMessage(defaultOptionResourceKey);
							}
						}

						ow.println("<option value=\"\"" + selectedStr + ">" + defaultOptionStr + "</option>");

						if (propValue!=null && propValue.equals(true)){
							selectedStr = " selected ";
						}else{
							selectedStr = "";
						}
						ow.println("<option value=\"true\"" + selectedStr + ">"
								+ getLocalizedMessage("yes") + "</option>");

						if (propValue !=null && propValue.equals(false)){
							selectedStr = " selected ";
						}else{
							selectedStr = "";
						}
						ow.println("<option value=\"false\"" + selectedStr + ">"
								+ getLocalizedMessage("no") + "</option>");
						ow.println("</select></td>");
					} else if (propType.isEnum()) {
						ow.println("<td><select"+(readonly?" disabled":"")+" name=\"" + p + "\">");
						String selectedStr = "";
						if(!isRequired) {
							if(propValue==null) {
								selectedStr = " selected ";
							}
							String defaultOptionStr= "-- "+getLocalizedMessage("select") +" --";

							if(defaultOptionResourceKey!=null) {
								if(defaultOptionResourceBundle!=null) {
									defaultOptionStr=getLocalizedMessage(defaultOptionResourceKey, defaultOptionResourceBundle);
								}
							}

							ow.println("<option value=\"\"" + selectedStr + ">"
									+ defaultOptionStr + "</option>");
						}
						for(Object o:propType.getEnumConstants()){
							Enum<?> enumPt=(Enum<?>)o;
							String enumMemberName=enumPt.name();
							String message=enumPt.toString();

							EnumResourceKeys reskeysAnno = (EnumResourceKeys) propType
									.getAnnotation(EnumResourceKeys.class);
							if (reskeysAnno != null) {
								for (MemberResourceKey memberResKeyAnno : reskeysAnno
										.memberResourceKeys()) {
									if (memberResKeyAnno.name().equals(
											enumMemberName)) {
										String resourceKey = memberResKeyAnno.key();
										if (resourceKey != null) {
											message = getLocalizedMessage(
													resourceKey,
													beanInfo
													.getResourceBundleName());
										}
										break;
									}
								}

							}

							selectedStr = "";

							if (propValue!=null && propValue.equals(o))
								selectedStr = " selected ";
							//						ow.println("<option value=\"true\"" + selectedStr + ">"
							//								+ getLocalizedMessage("yes") + "</option>");
							ow.println("<option value=\""+enumMemberName+"\"" + selectedStr + ">"
									+ message + "</option>");


						}

						ow.println("</select></td>");
						//				}
						//				else if(Number.class.isAssignableFrom(propType)){
						//					if(EditorType.WEIGHT_I18N.equals(editor) && imperialUnits){
						//						// TODO
						//					}else{
						//					String displayEditVal="";
						//					if("cm".equalsIgnoreCase(editUnit)){
						//						
						//						String editVal=pageContext.getRequest().getParameter(MapConverter.LEN_CM_KEY);
						//						if(editVal!=null){
						//							displayEditVal=editVal;
						//						}
						//						ow.print("<td><input name=\""+p+ "."+MapConverter.LEN_CM_KEY+"\" value=\""
						//								+ displayEditVal+ "\""
						//								+ readOnlyStr+ "/>");
						//						if(editUnit!=null){
						//							ow.print(" "+editUnit);
						//						}
						//						
						//					}
						//					}


					}else if (Date.class.isAssignableFrom(propType)) {

						// && (dateTemporal.value().equals(TemporalType.DATE)
						// (dateTemporal.value().equals(TemporalType.DATE)
						// (dateTemporal.value().equals(TemporalType.DATE))) {
						// if a date is requested
						Calendar cal = Calendar.getInstance();
						if (propValue != null) {
							cal.setTime((Date) propValue);
						} else {
							cal.setTime(new Date());
						}
						Integer valDay = new Integer(cal.get(Calendar.DAY_OF_MONTH));
						Integer valMonth = new Integer(cal.get(Calendar.MONTH) + 1);
						Integer valYear = new Integer(cal.get(Calendar.YEAR));
						Integer valHour = new Integer(cal.get(Calendar.HOUR_OF_DAY));
						Integer valMinute = new Integer(cal.get(Calendar.MINUTE));
						Integer valSecond = new Integer(cal.get(Calendar.SECOND));
						Integer valMilliSecond = new Integer(cal
								.get(Calendar.MILLISECOND));
						// Locale locale = (Locale) (pageContext.getSession()
						// .getAttribute("javax.servlet.jsp.jstl.fmt.locale"));
						//					Locale locale = LocaleSupport.getLocale(pageContext);
						// TODO more languages
						String dateSep = "/";
						String dateFormatStr="DD/MM/YYYY";
						String timeFormatStr="HH:MM:SS:mmm";
						if (locale != null
								&& locale.getLanguage().equals(
										new Locale("de", "", "").getLanguage())) {
							// german
							dateSep = ".";
							dateFormatStr="TT.MM.JJJJ";
						}
						ow
						.print("<td><input name=\""
								+ p
								+ "."
								+ MapConverter.DATE_DAY_KEY
								+ "\" type=\"text\" size=\"2\" maxlength=\"2\" value=\""
								+ valDay
								+ "\""
								+ readOnlyStr
								+ "/>"
								+ dateSep
								+ "<input name=\""
								+ p
								+ "."
								+ MapConverter.DATE_MONTH_KEY
								+ "\" type=\"text\" size=\"2\" maxlength=\"2\" value=\""
								+ valMonth
								+ "\""
								+ readOnlyStr
								+ "/>"
								+ dateSep
								+ "<input name=\""
								+ p
								+ "."
								+ MapConverter.DATE_YEAR_KEY
								+ "\" type=\"text\" size=\"4\" maxlength=\"4\" value=\""
								+ valYear + "\"" + readOnlyStr + "/>("+dateFormatStr+")");

						// do not print time values if only a date is requested
						if (dateTemporal == null
								|| (!dateTemporal.value().equals(TemporalType.DATE))) {
							ow
							.print("<br><input name=\""
									+ p
									+ "."
									+ MapConverter.DATE_HOUR_OF_DAY_KEY
									+ "\" type=\"text\" size=\"2\" maxlength=\"2\" value=\""
									+ valHour
									+ "\""
									+ readOnlyStr
									+ "/>:<input name=\""
									+ p
									+ "."
									+ MapConverter.DATE_MINUTE_KEY
									+ "\" type=\"text\" size=\"2\" maxlength=\"2\" value=\""
									+ valMinute
									+ "\""
									+ readOnlyStr
									+ "/>:<input name=\""
									+ p
									+ "."
									+ MapConverter.DATE_SECOND_KEY
									+ "\" type=\"text\" size=\"2\" maxlength=\"2\" value=\""
									+ valSecond
									+ "\""
									+ readOnlyStr
									+ "/>.<input name=\""
									+ p
									+ "."
									+ MapConverter.DATE_MILLISECOND_KEY
									+ "\" type=\"text\" size=\"3\" maxlength=\"3\" value=\""
									+ valMilliSecond + "\"" + readOnlyStr
									+ "/>("+timeFormatStr+")");
						}
						ow.print("</td>");
					} else if (propType.equals(String.class)) {
						ow.println("<td>");

						TextAreaView textAreaViewAnno=rm.getAnnotation(TextAreaView.class);
						if(textAreaViewAnno!=null){
							String colsStr="";
							int cols=textAreaViewAnno.cols();
							if(cols==-1){
								cols=TEXTAREA_DEF_COLS;
							}
							colsStr=" cols=\""+cols+"\" ";

							String rowsStr="";
							int rows=textAreaViewAnno.rows();
							if(rows==-1){
								rows=TEXTAREA_DEF_ROWS;
							}
							rowsStr=" rows=\""+rows+"\" ";

							ow.print("<textarea name=\"" + p + "\""+rowsStr+colsStr+ readOnlyStr + ">");
							if(validatedParameterValue!=null){
								ow.print(HTMLTextEncoder.encode(validatedParameterValue,false));
							}else{
								if(propValue !=null){
									ow.print(HTMLTextEncoder.encode(propValue.toString(),false));
								}else if(value!=null) {
									ow.print(HTMLTextEncoder.encode(value,true));
								}
							}
							ow.print("</textarea>");
						}else{
							if (validatedParameterValue != null) {
								valStr = " value=\""
										+ HTMLTextEncoder
										.encode(validatedParameterValue)
										+ "\"";
							} else {

								if (propValue != null) {
									valStr = " value=\""
											+ HTMLTextEncoder.encode(propValue
													.toString()) + "\"";
								}else if(value!=null) {
									valStr = " value=\""
											+ HTMLTextEncoder.encode(value) + "\"";
								}
							}
							String maxLengthAttr="";
							if(maxStringLength!=null){
								maxLengthAttr=" maxLength=\""+maxStringLength+"\" ";
							}
							ow.println("<input name=\"" + p + "\"" + maxLengthAttr + valStr
									+ readOnlyStr + ">");
						}
						ow.println("</td>");
					}else if (propType.isPrimitive()
							|| NativeTypeWrapper.isNativeWrapperClass(propType)) {


						if (validatedParameterValue != null) {
							valStr = " value=\""
									+ HTMLTextEncoder
									.encode(validatedParameterValue) + "\"";
						} else {
							if (propValue != null) {
								valStr = " value=\""
										+ HTMLTextEncoder.encode(propValue.toString())
										+ "\"";
							}else if(value!=null) {
								valStr = " value=\""
										+ HTMLTextEncoder.encode(value) + "\"";
							}
						}

						ow.println("<td>");



						if(Number.class.isAssignableFrom(propType) && unitConversion){
							//						if(EditorType.WEIGHT_I18N.equals(editor) && imperialUnits){
							//							// TODO
							//						}else{
							String displayEditVal="";
							String editVal=null;
							if("cm".equalsIgnoreCase(editUnit)){
								if(inserting){
									String paramKey=pd.getName()+"."+MapConverter.LEN_CM_KEY;
									editVal=pageContext.getRequest().getParameter(paramKey);
								}else{
									// convert bean value
									if(propValue!=null){
										double valAsDouble=((Number)propValue).doubleValue();
										editVal=Double.valueOf(valAsDouble*100).toString();
									}
								}
								if(editVal!=null){
									displayEditVal=editVal;
								}
								ow.print("<input name=\""+p+ "."+MapConverter.LEN_CM_KEY+"\" value=\""
										+ displayEditVal+ "\""
										+ readOnlyStr+ "/>");


							}
							// TODO other units
							//						}
						}else{
							ow.println("<input name=\"" + p + "\"" + valStr
									+ readOnlyStr + ">");

						}
						if(displayUnit!=null){
							ow.print(" "+displayUnit);
						}
						ow.println("</td>");
					} else {
						// other classes

						ow.print("<td>");
						if (propValue != null) {

							// forward preset values from new requests
							//Type rt = rm.getGenericReturnType();
							if (BasicPersistenceBeanController.CMD_ADD.equals(beanProvider.getActionCommand())) {
								ExtBeanInfo pbi = PersistenceIntrospector
										.getPersistenceBeanInfo(propType,true);
								PropertyDescriptor idDescr = pbi
										.getIdPropertyDescriptor();
								if (idDescr != null) {
									String idPropName = idDescr.getName();

									Method deepIdReadMethod = idDescr
											.getReadMethod();

									Object deepIdvalue = deepIdReadMethod.invoke(
											propValue, new Object[0]);
									ow.println("<input type=\"hidden\" name=\"" + p
											+ "." + idPropName + "\" value=\""
											+ deepIdvalue + "\"/>");

								}
							}
						}
						if(propValue!=null){
							String propValueStr=propValue.toString();
							String htmlEncPropValueStr=HTMLTextEncoder.encode(propValueStr);
							ow.print(htmlEncPropValueStr);
						}

						String href=getAction();
						String hrefForNew=getActionForNew();
						if(href!=null && ! href.equals("")){
							ow.print(" ");
							BeanSelectRelatedTag bst=new BeanSelectRelatedTag();
							bst.setPageContext(pageContext);
							bst.setParent(this);
							bst.setHref(href);
							bst.setHrefForNew(hrefForNew);
							bst.doStartTag();
							bst.doEndTag();
						}
						ow.print("</td>");
					}

					if(pvr != null){
						LocalizableMessage msg=pvr.getValidationMessage();
						if(msg!=null){
							ow.print("<td class=\"error\">"+HTMLTextEncoder.encode(getLocalizedMessage(msg))+"</td>");
						}else{
							ow.print("<td class=\"error\">"+HTMLTextEncoder.encode(getLocalizedMessage("validation.field.invalid"))+"</td>");
						}
					}

					ow.print("</tr>");
				}
			}
		} catch (Exception e) {
			String msg="Could not print bean property !";
			servletContext.log(msg+":"+e.getMessage());
			throw new JspException(msg, e);
		}
	}

	
	private boolean matchesIteration(){
		
		Iteration it=beanProvider.getIteration();
		return ((hidden && Iteration.HIDDEN.equals(it) || !hidden && Iteration.TABLE.equals(it)));
		
	}
	
	public int doStartTag() throws JspException {

		Tag p = getParent();
		beanProvider = (BeanPropertyIterator) p;
		ExtBeanInfo beanInfo = beanProvider.getBeanInfo();
		String currProp = beanProvider.getCurrentProperty();
		
		if (currProp == null || !currProp.equals(beanProperty.getName())) {
			return SKIP_BODY;
		}
//		Iteration it=beanProvider.getIteration();
//		if((Iteration.TABLE.equals(it) && hidden) || (Iteration.HIDDEN.equals(it) && !hidden)){
//			return SKIP_BODY;
//		}
		
		if(!matchesIteration()){
			return SKIP_BODY;
		}

		int retVal = super.doStartTag();
		PropertyDescriptor idPd=beanInfo.getIdPropertyDescriptor();
		if (idPd!=null && idPd.getName().equals(currProp)) {
			beanProperty.setReadOnly(true);
		}
//		if (beanProperty.getVar() == null) {
//			printTag();
//		}
//		beanProvider.setCurrentPropertyDone(true);
		hasBody=false;
		return retVal;
	}
	
	public int doAfterBody() throws JspException {
		hasBody=true;
		return super.doAfterBody();
	}
	
	public int doEndTag() throws JspException {
		String currProp = beanProvider.getCurrentProperty();
		if (currProp != null && !currProp.equals(beanProperty.getName())) {
			return EVAL_PAGE;
		}
		
		if (!hasBody && matchesIteration()) {
			printTag();
		}
		beanProvider.setCurrentPropertyDone(true);
		return EVAL_PAGE;
	}

//	public String getActions() {
//		return actions;
//	}
//
//	public void setActions(String actions) {
//		this.actions = actions;
//		StringTokenizer st=new StringTokenizer(actions,",");
//		while(st.hasMoreTokens()){
//			actionsSet.add(st.nextToken().trim());
//		}
//	}

}
