package ipsk.jsp.taglib.beans.edit;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverter;
import ipsk.jsp.fmt.LocaleSupport;
import ipsk.jsp.taglib.beans.BeanProvider;
import ipsk.jsp.taglib.beans.BeanProviderAdapter;
import ipsk.lang.reflect.NativeTypeWrapper;
import ipsk.net.EditableURI;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.webapps.BasicPersistenceBeanController;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public abstract class BeanRelatedTag extends ipsk.jsp.taglib.beans.BeanPropertyTag {

	protected String href;
	//private String selProp;
	protected boolean readonly=false;
	protected boolean hasBody=false;
	
	protected  String command=null;
	protected String anchorResourceKey;
	
	protected Collection<?> collVal=null;
	protected Integer elementCount=null;
	protected boolean actionDisabled=false;
	private int maxListLength=0;
	
	public int getMaxListLength() {
		return maxListLength;
	}


	public void setMaxListLength(int maxListLength) {
		this.maxListLength = maxListLength;
	}


	public void setParent(Tag parent){
		super.setParent(parent);
		// Find enclosing bean property tag
		Tag bpParent=parent;
		
		while(bpParent!=null && !(bpParent instanceof ipsk.jsp.taglib.beans.BeanPropertyTag)){
			bpParent=bpParent.getParent();
		}
		if(bpParent !=null && bpParent instanceof ipsk.jsp.taglib.beans.BeanPropertyTag){
			beanProperty=((ipsk.jsp.taglib.beans.BeanPropertyTag)bpParent).getBeanProperty();
		}
		
	}
	
	
	public void printTag() throws JspException {
		printTag(beanProvider);
	}

	public void printTag(BeanProvider beanProvider) throws JspException {
		JspWriter ow = pageContext.getOut();
		try {
			//String params = new String();
			EditableURI relatedUri=new EditableURI(href);
			String p = beanProperty.getName();
			ExtBeanInfo beanInfo = beanProvider.getBeanInfo();
			PropertyDescriptor pd = beanProperty.getPropertyDescriptor();
			Method rm = pd.getReadMethod();
			Object value = beanProperty.getValue();
			PropertyDescriptor idPd=beanInfo.getIdPropertyDescriptor();
			boolean isId = (pd != null && pd.equals(idPd));

			readonly = (beanProperty.isReadOnly() || isId);
			if (!readonly) {
				// Get relative URL of this page
				//String uri=null;
				ServletRequest sr=pageContext.getRequest();
				if(sr instanceof HttpServletRequest){
					HttpServletRequest httpSr=(HttpServletRequest)sr;
					//String contextPath=httpSr.getContextPath();
					//String backURI=httpSr.getRequestURI();
					String backURI=httpSr.getServletPath();
//					// cut context path
//					if(backURI.startsWith(contextPath)){
//						backURI=backURI.substring(contextPath.length());
//					}else{
//						// Hmm...
//					}
					// Add back link URI
					relatedUri.appendQuery(BasicPersistenceBeanController.KEY_ACTION, backURI);	
				}
				String mappedBy=null;
				ManyToMany manyToManyAnno=rm.getAnnotation(ManyToMany.class);
				if(manyToManyAnno!=null){
					mappedBy=manyToManyAnno.mappedBy();
				}else{
					OneToMany oneToManyAnno=rm.getAnnotation(OneToMany.class);
					if(oneToManyAnno!=null){
						mappedBy=oneToManyAnno.mappedBy();
					}
				}
				if(mappedBy!=null &&  ! mappedBy.equals("")){
					relatedUri.appendQuery(BasicPersistenceBeanController.KEY_MAPPEDBY,mappedBy);
				}
				relatedUri.appendQuery(BasicPersistenceBeanController.KEY_RELATED_PROPERTY,p);
				
				
				Class persClass=beanInfo.getBeanDescriptor().getBeanClass();
				BeanModel beanModel=beanProvider.getBeanModel();
				Object b=beanModel.getBean();
				Object idObject=beanInfo.getIdValue(b);
				//Object idObject=beanInfo.getIdValue(beanProvider.getBeanModel().getBean());
				PersistenceObjectIdentifier poi=new PersistenceObjectIdentifier(persClass,idObject);
				relatedUri.appendQueryMap(poi.toQueryMap());
				//relatedUri.appendQuery(BasicController.KEY_RELATED_ID,idObject.toString());
				Class propType = pd.getPropertyType();

				if (Collection.class.isAssignableFrom(propType)) {
					relatedUri.appendQuery(BasicPersistenceBeanController.KEY_CMD,command);
					
					int elementCount = 0;
					// ow.print("<a >");
					if (value != null) {
						collVal=(Collection<?>)value;
						elementCount = collVal.size();
						this.elementCount=elementCount;
						// forward preset values from new requests
						Type rt = rm.getGenericReturnType();
						boolean paramterized = (rt instanceof ParameterizedType);
						if (elementCount > 0 && paramterized) {
							// String prtName = rt.toString();
							ParameterizedType prt = (ParameterizedType) rt;

							Type[] pts = prt.getActualTypeArguments();
							if (pts.length == 1) {
								Class<?> collClass = (Class<?>) pts[0];
								// String collClassName = collClass.getName();

								ExtBeanInfo pbi = PersistenceIntrospector
										.getPersistenceBeanInfo(collClass,true);
								PropertyDescriptor idDescr = pbi
										.getIdPropertyDescriptor();
								if (idDescr != null) {
									String idPropName = idDescr.getName();
									
									Method deepIdReadMethod = idDescr
											.getReadMethod();
									for (Object so : collVal) {
										Object deepIdvalue = deepIdReadMethod
												.invoke(so, new Object[0]);
//										if (params.length() > 0
//												&& !params.endsWith("&"))
//											params = params.concat("&");
//										params = params
//												.concat(BasicController.KEY_SELECTED_ID
//														+ "=" + deepIdvalue);
									}

								}
							}
						}
					}
					// ow.print("#" + elementCount + "</td>");

				} else {
					// class , no collection -> OneToMany
					relatedUri.appendQuery(BasicPersistenceBeanController.KEY_CMD,command);
					if (value != null) {
						
						ExtBeanInfo relatedBi = PersistenceIntrospector
								.getPersistenceBeanInfo(propType,true);
						PropertyDescriptor relatedIdPd = relatedBi
								.getIdPropertyDescriptor();
						if (relatedIdPd != null) {
							String relatedIdPropName = relatedIdPd.getName();

							Method relatedIdReadMethod = relatedIdPd.getReadMethod();

							Object relatedIdvalue = relatedIdReadMethod.invoke(value,
									new Object[0]);


							relatedUri.appendQuery(BasicPersistenceBeanController.KEY_SELECTED_ID,relatedIdvalue);

						}
					}
				}
				
				
				actionDisabled=(BasicPersistenceBeanController.CMD_SELECT_TO_REMOVE.equals(command) || BasicPersistenceBeanController.CMD_SELECT_TO_DELETE.equals(command) )
						&& elementCount!=null 
						&& elementCount==0;
				if(!actionDisabled) {
					ow.print("<a href=\""+encodeURL(relatedUri.getUri())+"\">");
				}
			}
		} catch (Exception e) {
			throw new JspException("Could not print bean property !", e);
		}
	}

	public int doStartTag() throws JspException {

		Tag p = getParent();
		actionDisabled=false;
		elementCount=null;
		//beanProvider = (BeanProvider) p;
		
		ExtBeanInfo beanInfo = beanProvider.getBeanInfo();
		String currProp = beanProvider.getCurrentProperty();
		if (currProp != null && !currProp.equals(beanProperty.getName())) {
			return SKIP_BODY;
		}else{

		//int retVal = super.doStartTag();
		
		
			try {
				beanProperty.setContext(beanProvider);
			} catch (Exception e) {
				e.printStackTrace();
				throw new JspException("Error setting bean context !", e);
			} 

			
		if (beanInfo.getIdPropertyDescriptor().getName().equals(currProp)) {
			beanProperty.setReadOnly(true);
		}
		if (!beanProperty.isReadOnly()) {
			printTag();
		}
		// print body of the tag (not empty, if the user wants customized link)
		// reset flag to detect later if a body was evaluated
		hasBody=false;
		return EVAL_BODY_INCLUDE;
		}
	}
	
	public int doAfterBody() {
		// body is not empty and now evaluated
		// we do not need to print default link
		hasBody = true;
		return EVAL_PAGE;
	}

	public int doEndTag() throws JspException {
		JspWriter ow = pageContext.getOut();
		try {
			if (!hasBody) {
				// no custom body for the link - print default link
				if(anchorResourceKey==null){
					// No given text - print default number of elements
					
					if(elementCount!=null){

						if(elementCount>0 && elementCount<=maxListLength && collVal!=null) {
							Iterator<?> it=collVal.iterator();
							StringBuffer sb=new StringBuffer();
							while (it.hasNext()){
								sb.append(it.next().toString());
								if(it.hasNext())sb.append(',');
							}
							ow.print(sb.toString());
						}else {
							ow.print("#" + elementCount);
						}
					}

				}else{
					ow.print("[" + getLocalizedMessage(anchorResourceKey) + "]");
				}
			}
			if (!readonly && !actionDisabled) {
				ow.println("</a>");
			}
		} catch (Exception e) {
			throw new JspException("Could not print bean property !", e);
		}
		return EVAL_PAGE;
	}

	public String getHref() {
		return href;
	}

	public void setHref(String href) {
		this.href = href;
	}


//	public String getSelProp() {
//		return selProp;
//	}
//
//
//	public void setSelProp(String selProp) {
//		this.selProp = selProp;
//	}

}
