package ipsk.jsp.taglib.beans.edit;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.beans.MapConverter;
import ipsk.jsp.fmt.LocaleSupport;
import ipsk.jsp.taglib.beans.BeanProvider;
import ipsk.jsp.taglib.beans.BeanProviderAdapter;
import ipsk.lang.reflect.NativeTypeWrapper;
import ipsk.net.EditableURI;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.webapps.BasicPersistenceBeanController;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;

import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Enumerated;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public class BeanSelectRelatedTag extends ipsk.jsp.taglib.beans.BeanPropertyTag {

	protected String href;
	protected String hrefForNew=null;
	public String getHrefForNew() {
		return hrefForNew;
	}


	public void setHrefForNew(String hrefForNew) {
		this.hrefForNew = hrefForNew;
	}

	//private String selProp;
	protected boolean readonly=false;
	//protected boolean hasBody=false;
	
	//protected  String command=null;
	//protected String anchorResourceKey;
	
	public void setParent(Tag parent){
		super.setParent(parent);
		// Find enclosing bean property tag
		Tag bpParent=parent;
		
		while(bpParent!=null && !(bpParent instanceof ipsk.jsp.taglib.beans.BeanPropertyTag)){
			bpParent=bpParent.getParent();
		}
		if(bpParent !=null && bpParent instanceof ipsk.jsp.taglib.beans.BeanPropertyTag){
			beanProperty=((ipsk.jsp.taglib.beans.BeanPropertyTag)bpParent).getBeanProperty();
		}
		
	}
	
	
	public void printTag() throws JspException {
		printTag(beanProvider);
	}

	public void printTag(BeanProvider beanProvider) throws JspException {
		JspWriter ow = pageContext.getOut();
		try {
			
			EditableURI addNewRelatedUri=null;

			String hrefNew=getHrefForNew();
			if(hrefNew!=null){
				addNewRelatedUri=new EditableURI(hrefNew);
			}
			
			EditableURI addOrSetRelatedUri=new EditableURI(href);
			EditableURI removeOrResetReatedUri=new EditableURI(href);
			String addOrSetResourceKey=null;
			String removeOrResetResourceKey="remove";
			
			String p = beanProperty.getName();
			ExtBeanInfo beanInfo = beanProvider.getBeanInfo();
			PropertyDescriptor pd = beanProperty.getPropertyDescriptor();
			Method rm = pd.getReadMethod();
		
			Object value = beanProperty.getValue();
			PropertyDescriptor idPd=beanInfo.getIdPropertyDescriptor();
			boolean isId = (pd != null && pd.equals(idPd));

			readonly = (beanProperty.isReadOnly() || isId);
			if (!readonly) {
				// Get relative URL of this page
				//String uri=null;
				ServletRequest sr=pageContext.getRequest();
				if(sr instanceof HttpServletRequest){
					//String backURI=((HttpServletRequest)sr).getRequestURI();
					String backURI=((HttpServletRequest)sr).getServletPath();
					// Add back link URI
					if(addNewRelatedUri!=null){
						addNewRelatedUri.appendQuery(BasicPersistenceBeanController.KEY_ACTION, backURI);
					}
					addOrSetRelatedUri.appendQuery(BasicPersistenceBeanController.KEY_ACTION, backURI);
					removeOrResetReatedUri.appendQuery(BasicPersistenceBeanController.KEY_ACTION, backURI);	
				}
				
				boolean isEnum=false;
				
				String mappedBy=null;
				CascadeType[] cascadeTypes=null;
				boolean orphanRemoval=false;
				
				ManyToMany manyToManyAnno=rm.getAnnotation(ManyToMany.class);
				
				if(manyToManyAnno!=null){
					mappedBy=manyToManyAnno.mappedBy();
					cascadeTypes=manyToManyAnno.cascade();
					
				}else{
					OneToMany oneToManyAnno=rm.getAnnotation(OneToMany.class);
					OneToOne oneToOneAnno=rm.getAnnotation(OneToOne.class);
					if(oneToManyAnno!=null){
						mappedBy=oneToManyAnno.mappedBy();
						cascadeTypes=oneToManyAnno.cascade();
						orphanRemoval=oneToManyAnno.orphanRemoval();
					}else if(oneToOneAnno!=null){
						mappedBy=oneToOneAnno.mappedBy();
						cascadeTypes=oneToOneAnno.cascade();
						orphanRemoval=oneToOneAnno.orphanRemoval();
					}else{
						Enumerated enumerated=rm.getAnnotation(Enumerated.class);
						ElementCollection elementCollection=rm.getAnnotation(ElementCollection.class);
						if(enumerated!=null){
							isEnum=true;
						}
						if(elementCollection!=null){
							
						}
					}
				}
				if(mappedBy!=null &&  ! mappedBy.equals("")){
					if(addNewRelatedUri!=null){
						addNewRelatedUri.appendQuery(BasicPersistenceBeanController.KEY_MAPPEDBY,mappedBy);
					}
					addOrSetRelatedUri.appendQuery(BasicPersistenceBeanController.KEY_MAPPEDBY,mappedBy);
					removeOrResetReatedUri.appendQuery(BasicPersistenceBeanController.KEY_MAPPEDBY,mappedBy);
				}
				
				if(addNewRelatedUri!=null){
					addNewRelatedUri.appendQuery(BasicPersistenceBeanController.KEY_RELATED_PROPERTY,p);
				}
				addOrSetRelatedUri.appendQuery(BasicPersistenceBeanController.KEY_RELATED_PROPERTY,p);
				removeOrResetReatedUri.appendQuery(BasicPersistenceBeanController.KEY_RELATED_PROPERTY,p);
				//relatedUri.appendQuery(BasicController.KEY_RELATED_PROPERTY,idPd.getName());
				Class<?> persClass=beanProvider.getBeanInfo().getBeanDescriptor().getBeanClass();
				Object idObject=beanProvider.getBeanInfo().getIdValue(beanProvider.getBeanModel().getBean());
				if(idObject!=null) {
					PersistenceObjectIdentifier poi=new PersistenceObjectIdentifier(persClass,idObject);
					if(addNewRelatedUri!=null){
						addNewRelatedUri.appendQueryMap(poi.toQueryMap());
					}
					addOrSetRelatedUri.appendQueryMap(poi.toQueryMap());
					removeOrResetReatedUri.appendQueryMap(poi.toQueryMap());
				}
				//relatedUri.appendQuery(BasicController.KEY_RELATED_ID,idObject.toString());
				Class<?> propType = pd.getPropertyType();
				
//				EditableURI removeOrResetReatedUri=(EditableURI)addOrSetRelatedUri.clone();
				int elementCount = 0;
				if (Collection.class.isAssignableFrom(propType)) {
					//if(cascadeRemove){
					if(orphanRemoval){
						// If orphans are removed it is not possible that unbound items exist.
						// Therefore this not an list selection, but a creation of a new object
						// This should maybe better be done by a different tag.
					}
					if(addNewRelatedUri!=null){
						addNewRelatedUri.appendQuery(BasicPersistenceBeanController.KEY_CMD,BasicPersistenceBeanController.CMD_NEW_TO_ADD);
					}
					addOrSetRelatedUri.appendQuery(BasicPersistenceBeanController.KEY_CMD,BasicPersistenceBeanController.CMD_SELECT_TO_ADD);
			
					
					addOrSetResourceKey="add";
					removeOrResetReatedUri.appendQuery(BasicPersistenceBeanController.KEY_CMD, BasicPersistenceBeanController.CMD_SELECT_TO_REMOVE);
					
					
					// ow.print("<a >");
					if (value != null) {
						elementCount = ((Collection<?>) value).size();
						// forward preset values from new requests
						Type rt = rm.getGenericReturnType();
						boolean paramterized = (rt instanceof ParameterizedType);
						if (elementCount > 0 && paramterized) {
							// String prtName = rt.toString();
							ParameterizedType prt = (ParameterizedType) rt;

							Type[] pts = prt.getActualTypeArguments();
							if (pts.length == 1) {
								Class<?> collClass = (Class<?>) pts[0];
								
								if(isEnum){

								}else{
									ExtBeanInfo pbi = PersistenceIntrospector
											.getPersistenceBeanInfo(collClass,true);
									PropertyDescriptor idDescr = pbi
											.getIdPropertyDescriptor();
									if (idDescr != null) {
										String idPropName = idDescr.getName();
										Collection<?> valueAsColl = (Collection<?>) value;
										Method deepIdReadMethod = idDescr
												.getReadMethod();
										for (Object so : valueAsColl) {
											Object deepIdvalue = deepIdReadMethod
													.invoke(so, new Object[0]);

										}

									}
								}
							}
						}
					}
					// ow.print("#" + elementCount + "</td>");

				} else {
					// class , no collection -> ManyToOne or OneToOne
					
					addOrSetRelatedUri.appendQuery(BasicPersistenceBeanController.KEY_CMD,BasicPersistenceBeanController.CMD_SELECT_TO_SET);
					addOrSetResourceKey="select";
					removeOrResetReatedUri.appendQuery(BasicPersistenceBeanController.KEY_CMD,BasicPersistenceBeanController.CMD_SELECT_TO_RESET);
					
					if (value != null) {
						elementCount=1;
						ExtBeanInfo relatedBi = PersistenceIntrospector
								.getPersistenceBeanInfo(propType,true);
						PropertyDescriptor relatedIdPd = relatedBi
								.getIdPropertyDescriptor();
						if (relatedIdPd != null) {
							String relatedIdPropName = relatedIdPd.getName();

							Method relatedIdReadMethod = relatedIdPd.getReadMethod();

							Object relatedIdvalue = relatedIdReadMethod.invoke(value,
									new Object[0]);


							addOrSetRelatedUri.appendQuery(BasicPersistenceBeanController.KEY_SELECTED_ID,relatedIdvalue);

						}
					}
				}
				if (!readonly) {
					if(addNewRelatedUri!=null){
						ow.print("<a href=\""+encodeURL(addNewRelatedUri.getUri())+"\">[" + HTMLTextEncoder.encode(getLocalizedMessage("add.new")) + "]</a>");
					}
					if(!orphanRemoval){
						ow.print("<a href=\""+encodeURL(addOrSetRelatedUri.getUri())+"\">[" + HTMLTextEncoder.encode(getLocalizedMessage(addOrSetResourceKey)) + "]</a>");
					}
					if(elementCount>0){
						ow.print("<a href=\""+encodeURL(removeOrResetReatedUri.getUri())+"\">[" + HTMLTextEncoder.encode(getLocalizedMessage(removeOrResetResourceKey)) + "]</a>");
					}
				}
			}
		} catch (Exception e) {
			throw new JspException("Could not print bean property !", e);
		}
	}

	public int doStartTag() throws JspException {

		Tag p = getParent();
		//beanProvider = (BeanProvider) p;
		
		ExtBeanInfo beanInfo = beanProvider.getBeanInfo();
		String currProp = beanProvider.getCurrentProperty();
		if (currProp != null && !currProp.equals(beanProperty.getName())) {
			return SKIP_BODY;
		}else{

			try {
				beanProperty.setContext(beanProvider);
			} catch (Exception e) {
				e.printStackTrace();
				throw new JspException("Error setting bean context !", e);
			} 

			
		if (beanInfo.getIdPropertyDescriptor().getName().equals(currProp)) {
			beanProperty.setReadOnly(true);
		}
		if (!beanProperty.isReadOnly()) {
			printTag();
		}
		return SKIP_BODY;
		}
	}
	

	public int doEndTag() throws JspException {
		JspWriter ow = pageContext.getOut();
		return EVAL_PAGE;
	}

	public String getHref() {
		return href;
	}

	public void setHref(String href) {
		this.href = href;
	}


}
