package ipsk.jsp.taglib.beans.table;

import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanProperty;
import ipsk.jsp.taglib.beans.BeanPropertyProvider;
import ipsk.jsp.taglib.beans.table.BeanTableTag.RowStatus;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class BeanTableColTag extends ExtBodyTagSupport implements BeanPropertyProvider {

	//private BeanTableCol tableCol;

	private BeanTableTag beanTableParentTag;

	//private boolean isGenerated = false;;

	//private Object value;

	private String name;

	private String bundle;

	public String getBundle() {
		return bundle;
	}

	public void setBundle(String bundle) {
		this.bundle = bundle;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	private String key;

	private String href;

	private String queryName;

	private String var;

	private String hrefVar;
	
	private String valueCssClass=null;
	
	public String getValueCssClass() {
		return valueCssClass;
	}

	public void setValueCssClass(String valueCssClass) {
		this.valueCssClass = valueCssClass;
	}

	protected int maxTextLength=-1;
	
	public int getMaxTextLength() {
		return maxTextLength;
	}

	public void setMaxTextLength(int maxTextLength) {
		this.maxTextLength = maxTextLength;
	}

	protected int maxListLength=0;
	
	private BeanProperty beanProperty;
	
	

	public BeanTableColTag() {
		super();

	}

//	public BeanTableColTag(PropertyDescriptor pd) {
//		super();
//		beanProperty = new BeanProperty(pd);
//	}

	public void setParent(Tag parent) {
		super.setParent(parent);
		if (parent instanceof BeanTableTag) {
			beanTableParentTag = (BeanTableTag) parent;
		}
	}

//	public String getBundle() {
//		return bundle;
//	}
//
//	public void setBundle(String bundle) {
//		this.bundle = bundle;
//	}

//	public String getHeaderKey() {
//		return headerKey;
//	}
//
//	public void setHeaderKey(String headerKey) {
//		this.headerKey = headerKey;
//	}

	public int doStartTag() throws JspException {
		if(beanTableParentTag==null){
			throw new JspException("Table column tag must be inside table tag body.");
		}
		BeanTableCol tableCol=beanTableParentTag.getColumn(name);
		RowStatus rowStatus = beanTableParentTag.getRowStatus();
		String currProp = beanTableParentTag.getCurrentProperty();
		if (rowStatus == BeanTableTag.RowStatus.TAGS) {
			
			if(bundle!=null){
				tableCol.setBundle(bundle);
			}
			if(key!=null){
				tableCol.setKey(key);
			}
			if(tableCol instanceof BeanPropertyTableCol){
				BeanPropertyTableCol bptc=(BeanPropertyTableCol)tableCol;
				bptc.setVar(var);
				bptc.setQueryName(queryName);
				bptc.setHref(href);
				bptc.setMaxListLength(maxListLength);
				bptc.setValueCssClass(valueCssClass);
				bptc.setMaxTextLength(maxTextLength);
				beanProperty=bptc.getBeanProperty();
				
			}else{
				// assuming additional non bean property based column
			
			}
		} else if (rowStatus == BeanTableTag.RowStatus.DATA) {
			if (currProp != null && currProp.equals(name)) {
				if(tableCol==null){
					return EVAL_BODY_INCLUDE;
				}else{
					if(tableCol instanceof BeanPropertyTableCol){
						BeanPropertyTableCol bptc=(BeanPropertyTableCol)tableCol;
						String var=bptc.getVar();
						if(var!=null){
							//				 variable is set - means custom body content to evaluate
							//				PropertyDescriptor pd = beanTableParentTag.getBeanProperty(name)
							//						.getPropertyDescriptor();

							PropertyDescriptor pd=bptc.getBeanProperty().getPropertyDescriptor();
							Object item = beanTableParentTag.getItem();
							Method rm = pd.getReadMethod();
							Object value = null;
							try {
								value = rm.invoke(item, new Object[0]);
							} catch (Exception e) {
								throw new JspException(e);
							}
							pageContext.setAttribute(var, value,
									PageContext.REQUEST_SCOPE);

							if(hrefVar!=null){
								String hrefValue=null;
								try {
									hrefValue=bptc.getEncodedHrefUri(item);
								} catch (Exception e) {
									throw new JspException(e);
								} 
								pageContext.setAttribute(hrefVar, hrefValue,
										PageContext.REQUEST_SCOPE);
							}
							return EVAL_BODY_INCLUDE;
						}
					}else{
						// additional custom column tag
						return EVAL_BODY_INCLUDE;
					}
				}
			}

		}
		return SKIP_BODY;
	}

//	public void printTag() throws JspException {
//
//		BeanTableModel beanTableModel = beanTableParentTag.getBeanTableModel();
//		ExtBeanInfo beanInfo = beanTableParentTag.getBeanInfo();
//		
//		PropertyDescriptor pd = getBeanProperty().getPropertyDescriptor();
//		Class propType = pd.getPropertyType();
//		Object item = beanTableParentTag.getItem();
//		
//		if (var == null) {
//			JspWriter ow = pageContext.getOut();
//			try {
//				ow.print("<td>");
//
//				if (href != null) {
//
//					EditableURI uri = new EditableURI(href);
//					//Object idVal = beanInfo.getIdValue(item);
//					PersistenceObjectIdentifier poi=null;
//					try {
//					poi=beanInfo.getPersistenceObjectIdentifier(item);
//				} catch (Exception e) {
//					throw new JspException(
//							"Could not read id (primary key): ", e);
//				}
//					Object idVal =poi.getIdObject();
//					PropertyDescriptor idPropertyDescriptor = beanInfo.getIdPropertyDescriptor();
//
//					if (queryName != null) {
//						uri.appendQuery(BasicController.KEY_CMD,
//								BasicController.CMD_NAMED_QUERY);
//						uri.appendQuery(BasicController.KEY_QUERY_NAME,
//								queryName);
////						uri.appendQuery(
////								BasicController.KEY_QUERY_PARAM_CLASSNAME,
////								beanTableModel.getExtBeanInfo()
////										.getBeanDescriptor().getBeanClass()
////										.getName());
//						uri.appendQueryMap(poi.toQueryMap());
////						uri.appendQuery(BasicController.KEY_ID, idVal
////								.toString());
//					} else {
//						if (pd.equals(idPropertyDescriptor)) {
//							// The Id property, means the link points to a JSP
//							// page using the same entity class
//							uri.appendQuery(BasicController.KEY_CMD,
//									BasicController.CMD_VIEW);
//							uri.appendQuery(idPropertyDescriptor.getName(),
//									idVal);
//						} else {
//							String mappedBy = null;
//							if (Collection.class.isAssignableFrom(propType)) {
//
//								// Assuming ManyToMany or OneToMany
//								uri.appendQuery(BasicController.KEY_CMD,
//										BasicController.CMD_LIST_RELATED);
//								Method rm = pd.getReadMethod();
//
//								ManyToMany manyToManyAnno = rm
//										.getAnnotation(ManyToMany.class);
//								if (manyToManyAnno != null) {
//									mappedBy = manyToManyAnno.mappedBy();
//								} else {
//									OneToMany oneToManyAnno = rm
//											.getAnnotation(OneToMany.class);
//									if (oneToManyAnno != null) {
//										mappedBy = oneToManyAnno.mappedBy();
//									}
//								}
//
//							} else {
//								// Assuming ManyToOne or OneToOne
//								uri.appendQuery(BasicController.KEY_CMD,
//										BasicController.CMD_VIEW);
//
//							}
//							uri.appendQueryMap(poi.toQueryMap());
//							if (mappedBy != null && !mappedBy.equals("")) {
//								uri.appendQuery(BasicController.KEY_MAPPEDBY,
//										mappedBy);
//							} else {
//								uri.appendQuery(
//										BasicController.KEY_RELATED_PROPERTY,
//										pd.getName());
//							}
//						}
//
//					}
//					ow.println("<a href=\"" + uri + "\">");
//				}
//
//				BeanPropertyValueText bpvt = new BeanPropertyValueText(
//						beanInfo, pageContext);
//				String valStr = null;
//				try {
//					valStr = bpvt.getValueTextRepresentation(item, pd);
//				} catch (Exception e) {
//					throw new JspException(
//							"Could not create bean value string representation: "
//									+ e);
//				}
//				
//				ow.print(HTMLTextEncoder.encode(valStr));
//		
//				if (href != null) {
//					ow.print("</a>");
//				}
//				ow.print("</td>");
//			
//			} catch (IOException ioe) {
//				throw new JspException(
//						"Error: IOException while writing to client");
//			}
//		}
//	}

	public int doEndTag() throws JspException {

		return EVAL_PAGE;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
		BeanTableCol tableCol=beanTableParentTag.getColumn(name);
		if(tableCol instanceof BeanPropertyTableCol){
			BeanPropertyTableCol bptc=(BeanPropertyTableCol)tableCol;
//			bptc.setVar(var);
//			bptc.setQueryName(queryName);
//			bptc.setHref(href);
			beanProperty=bptc.getBeanProperty();
			
		}
	}

	public String getHref() {
		return href;
	}

	public void setHref(String href) {
		this.href = href;
	}


	public int getMaxListLength() {
		return maxListLength;
	}



	public void setMaxListLength(int maxListLength) {
		this.maxListLength = maxListLength;
	}
	
	public String getQueryName() {
		return queryName;
	}

	public void setQueryName(String namedQuery) {
		this.queryName = namedQuery;
		
	}

	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;
	}

	public BeanProperty getBeanProperty() {
		
		return beanProperty;
	}

	public String getHrefVar() {
		return hrefVar;
	}

	public void setHrefVar(String hrefVar) {
		this.hrefVar = hrefVar;
	}

//	public BeanProperty getBeanProperty() {
//		return beanProperty;
//	}
//
//	public void setBeanProperty(BeanProperty beanProperty) {
//		this.beanProperty = beanProperty;
//	}

//	public boolean isGenerated() {
//		return isGenerated;
//	}
//
//	public void setGenerated(boolean isGenerated) {
//		this.isGenerated = isGenerated;
//	}

}
