package ipsk.jsp.taglib.beans.table;

import ips.beans.ExtBeanInfo;
import ipsk.beans.PropertyNameOrder;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.Controller;
import ipsk.jsp.taglib.ControllerProvider;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanControllerProvider;
import ipsk.jsp.taglib.beans.BeanPropertyValueText;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.net.BoolExprQueryParser;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.webapps.BasicPersistenceBeanController;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.Tag;

// TODO change operator and value input depending on property type, WSP-0016
public class DynamicBoolExprTag extends ExtBodyTagSupport {

//	public class DisplayedProperty{
//		private String name;
//		public String getName() {
//			return name;
//		}
//		public Class<?> getType() {
//			return type;
//		}
//		private Class<?> type;
//		/**
//		 * @param name
//		 * @param type
//		 */
//		public DisplayedProperty(String name, Class<?> type) {
//			super();
//			this.name = name;
//			this.type = type;
//		}
//		
//		
//	}
	
	private ArrayList<PropertyDescriptor> displayedProps;

	private String CSSclass = null;

	private BeanTableController controller;

	private ExtBeanInfo beanInfo;

	private int ci = 0;

	private int ei = 0;

	// private PropertyDescriptor[] bePds = null;

	// private BeanTableModel beanTableModel;
	public void setParent(Tag parent) {
		if (parent instanceof ControllerProvider) {
			Controller scontroller = ((ControllerProvider) parent).getController();
			if(scontroller instanceof BeanTableController){
				controller=(BeanTableController)scontroller;
			}
			// beanTableModel=controller.getBeanTableModel();
			beanInfo = controller.getBeanInfo();
			PropertyDescriptor[] pds = beanInfo
			.getPersistencePropertyDescriptors();
			displayedProps = new ArrayList<PropertyDescriptor>();
			ArrayList<String> displayablePropNames=new ArrayList<String>();
			for (PropertyDescriptor pd : pds) {
				Class<?> type = pd.getPropertyType();
				// String typeName = type.getCanonicalName();

				if (type.isPrimitive() || type.equals(java.lang.Boolean.class)
						|| type.isEnum()
						|| java.lang.Number.class.isAssignableFrom(type)
						|| type.equals(java.lang.String.class)
						|| type.equals(java.util.Date.class)) {
					//displayedProps.add(pd);
					displayablePropNames.add(pd.getName());
				}
			}
			PropertyNameOrder pnOrder=new PropertyNameOrder(displayablePropNames.toArray(new String[0]));

			pnOrder.applyPreferredOrder(beanInfo.getPreferredDisplayOrder());
			String[] orderedPropNames=pnOrder.getOrder();
			for(String pName:orderedPropNames){
				for (PropertyDescriptor pd : pds) {
					if(pName.equals(pd.getName())){
						displayedProps.add(pd);
					}
				}
			}
		}

	}

	public int doStartTag() throws JspException {
		// super.doStartTag();
		if (controller.getNamedQuery() != null) return SKIP_BODY;
		HttpServletRequest req = (HttpServletRequest) (pageContext.getRequest());
		//String contextPath = req.getContextPath();
		String servletPath = req.getServletPath();
		String encodedPath=encodeURL(servletPath);
		JspWriter ow = pageContext.getOut();
		try {
			ow
					.println("<form method=\"POST\" action=\""
							+ HTMLTextEncoder.encode(encodedPath)
							+ "\" accept-charset=\"UTF-8\" enctype=\"application/x-www-form-urlencoded;charset=utf-8\">");
			ow.println("<fieldset>");
			ow.println("<legend>"+HTMLTextEncoder.encode(getLocalizedMessage("conditions"))+"</legend>");
		} catch (IOException ioe) {
			throw new JspException("Error: IOException while writing conditition query");
		}

		return EVAL_BODY_INCLUDE;
	}

	private void printColumnSelectOption(JspWriter ow, PropertyDescriptor pd,
			boolean selected) throws IOException {
		String selectAttr = "";
		if (selected) {
			selectAttr = " selected ";
		}
		String pDescr = pd.getShortDescription();
		String resKey = (String) pd.getValue("ipsk.util.ResourceKey");
		if (resKey != null) {
			pDescr = LocaleSupport.getLocalizedMessage(pageContext, resKey,
					controller.getBeanInfo().getResourceBundleName());
		}
		ow.println("<option value=\"" + pd.getName() + "\"" + selectAttr + ">"
				+ HTMLTextEncoder.encode(pDescr) + "</option>");
	}

	private void printOperatorSelectOption(JspWriter ow, Object exprOp,
			boolean selected) throws IOException {
		String selectAttr = "";
		if (selected) {
			selectAttr = " selected ";
		}
		String queryOp = BoolExprQueryParser.getQueryOperator(exprOp);

		String localizedExprOp = "";
		if (exprOp instanceof String) {
			localizedExprOp = (String)exprOp;
		}
		if (exprOp.equals(ExtBoolExpr.STARTS_WITH)) {
			localizedExprOp = getLocalizedMessage("starts_with");
		} else if (exprOp.equals(ExtBoolExpr.ENDS_WITH)) {
			localizedExprOp = getLocalizedMessage("ends_with");
		} else if (exprOp.equals(ExtBoolExpr.CONTAINS)) {
			localizedExprOp = getLocalizedMessage("contains");
		}else if (exprOp.equals(ExtBoolExpr.EQUALS)) {
			localizedExprOp = getLocalizedMessage("id.equals");
		}else if (exprOp.equals(ExtBoolExpr.BOUND)) {
			localizedExprOp = getLocalizedMessage("is.bound");
		}else if (exprOp.equals(ExtBoolExpr.MEMBER)) {
			localizedExprOp = getLocalizedMessage("id.has_member");
		}else if (exprOp.equals(ExtBoolExpr.EQUALS_NOT)) {
			localizedExprOp = getLocalizedMessage("id.equals_not");
		}else if (exprOp.equals(ExtBoolExpr.NOT_MEMBER)) {
			localizedExprOp = getLocalizedMessage("id.has_not_member");
		}else if (exprOp.equals(ExtBoolExpr.NOT_BOUND)) {
			localizedExprOp = getLocalizedMessage("is.not_bound");
		}
		ow.println("<option value=\"" + queryOp + "\"" + selectAttr + ">"
				+ HTMLTextEncoder.encode(localizedExprOp) + "</option>");
	}

	public void printBoolExpression(ExtBoolExpr be, int ei, JspWriter ow)
			throws IOException {
		PropertyDescriptor[] ppds = beanInfo
		.getPersistencePropertyDescriptors();
		String op0 = (String) be.getOperand0();

		Object opStr = be.getOperator();
		ow.println("<fieldset>");
		ow.println("<legend>"+HTMLTextEncoder.encode(getLocalizedMessage("condition"))+"</legend>");
		ow.println("<select name=\"_ec" + ei + "\">");

		if (op0 == null) {
			ow.println("<option value=\"\" selected >-- "
					+ HTMLTextEncoder.encode(getLocalizedMessage("field.select")) + " --</option>");
		} else {
			ow.println("<option value=\"\">"+HTMLTextEncoder.encode("-- " + getLocalizedMessage("reset")
					+ " --")+"</option>");
		}
		if (be.isObjectRelationShip()) {
			// relationship properties are not in displayedProperties
			
			for (PropertyDescriptor pd : ppds) {
				if (pd.getName().equals(op0)) {
					// displayedProps.add(pd);
					printColumnSelectOption(ow, pd, true);
				}
			}
		} else {
			for (PropertyDescriptor pd : displayedProps) {
				boolean selected = (op0 != null && op0.equals(pd.getName()));
				printColumnSelectOption(ow, pd, selected);
			}
		}
		ow.println("</select>");

		ow.println("<select name=\"_eo" + ei + "\">");
		String[] exprOps = ExtBoolExpr.getExprOperators();
		if (opStr == null) {
			ow.println("<option value=\"\" selected >"+HTMLTextEncoder.encode("-- "
					+ LocaleSupport.getLocalizedMessage(pageContext,
							"operator.select", RES_BUNDLE_NAME)
					+ " --")+"</option>");
		} else {
			ow.println("<option value=\"\">"+HTMLTextEncoder.encode("-- "
					+ LocaleSupport.getLocalizedMessage(pageContext, "reset",
							RES_BUNDLE_NAME) + " --")+"</option>");
		}
		if (be.isObjectRelationShip()) {
			printOperatorSelectOption(ow, opStr, true);

		} else {
			String[] exprOpsNoRelationship=ExtBoolExpr.getExprOperatorsWithoutRelationshipOperators();
			for (String exprOp : exprOpsNoRelationship) {
				boolean selected = (opStr != null && opStr.equals(exprOp));
				printOperatorSelectOption(ow, exprOp, selected);
			}
		}
		ow.println("</select>");
		
		String op1Str="";
		if(!be.unaryOperator()){
			Object op1 = be.getOperand1();

			BeanPropertyValueText bpvt = new BeanPropertyValueText(beanInfo,
					pageContext);
			// op1Str=op1.toString();
			PropertyDescriptor opPd = null;
			for (PropertyDescriptor pd : ppds) {
				if (op0 != null && op0.equals(pd.getName())) {
					opPd = pd;
					break;
				}
			}
			op1Str = bpvt.getValueTextRepresentation(opPd, op1);
		}
		String readOnlyStr="";
		if(be.unaryOperator() || be.isObjectRelationShip()){
			readOnlyStr=" readonly ";
		}
		ow.println("<input name=\"_ev" + ei + "\" type=\"text\" value=\""
				+ HTMLTextEncoder.encode(op1Str) + "\""+readOnlyStr+" />");
		
		// TODO disabled caseinsensitive checkbox
		// problems with SQL lower() function with our PostgreSQL DB !
		// see myPostgres.txt
		String caseInSensitiveSelStr="";
		if(be.isCaseInSensitive())caseInSensitiveSelStr=" checked ";
		ow.println("<span style=\"white-space: nowrap\">"+LocaleSupport.getLocalizedMessage(pageContext,"case_insensitive", RES_BUNDLE_NAME)+"</span><input type=\"checkbox\" name=\"_eci" + ei + "\" value=\"insensitive\""+caseInSensitiveSelStr+">");

//		ow.println("<br>");
		ow.println("</fieldset>");

	}

	public void resolveBoolExpr(ExtBoolExpr ebe, JspWriter out)
			throws IOException {
		if (ebe == null)
			return;
		if (ebe.getOperator() == null || ebe.isExpression()) {
			// dummy expression or real expression set

			printBoolExpression(ebe, ei, out);
			ei++;
		} else {

			String condstr = ("<input type=\"hidden\" name=\"_c" + ci + "\" value=\"");
			ci++;
			ExtBoolExpr op0 = (ExtBoolExpr) ebe.getOperand0();

			if (op0.getOperator() == null || op0.isExpression()) {
				condstr = condstr.concat("e" + ei);
			} else {
				condstr = condstr.concat("c" + ci);
			}
			resolveBoolExpr(op0, out);
			String opr = (String) ebe.getOperator();

			condstr = condstr.concat("_" + opr + "_");

			ExtBoolExpr op1 = (ExtBoolExpr) ebe.getOperand1();
			if (op1.getOperator() == null || op1.isExpression()) {
				condstr = condstr.concat("e" + ei);
			} else {
				condstr = condstr.concat("c" + ci);
			}
			resolveBoolExpr(op1, out);
			condstr = condstr.concat("\">");
			out.println(condstr);
		}

	}

	public int doEndTag() throws JspException {

		if (controller.getNamedQuery() == null) {
			JspWriter ow = pageContext.getOut();
			ExtBoolExpr boolCondition = controller.getBoolCondition();

			// String cssClassAttr = "";
			// if (CSSclass != null)
			// cssClassAttr = " class=\"" + CSSclass + "\"";

			// HttpServletRequest req = (HttpServletRequest) (pageContext
			// .getRequest());
			// String contextPath = req.getContextPath();
			// String servletPath = req.getServletPath();

			try {
				// String op1Str = "";
				// String opStr = null;
				// Object op0 = null;

				ExtBoolExpr dispBe = null;
				if (boolCondition == null) {
					dispBe = new ExtBoolExpr();
				} else {
					dispBe = boolCondition.addEmptyExpression();
				}
				ci = 0;
				ei = 0;
				resolveBoolExpr(dispBe, ow);

				// if (boolCondition != null) {
				// op0 = boolCondition.getOperand0();
				// Object op = boolCondition.getOperator();
				// PropertyDescriptor opPd = null;
				// for (PropertyDescriptor pd : displayedProps) {
				// if (op0 != null && op0.equals(pd.getName())) {
				// opPd = pd;
				// break;
				// }
				// }
				// Object op1 = boolCondition.getOperand1();
				// opStr = BoolExprQueryParser.getQueryOperator(op);
				// BeanPropertyValueText bpvt = new BeanPropertyValueText(
				// beanInfo, pageContext);
				// // op1Str=op1.toString();
				// op1Str = bpvt.getValueTextRepresentation(opPd, op1);
				// }
				//
				// ow.println("<select name=\"_ec0\">");
				// if (op0 == null) {
				// ow
				// .println("<option value=\"\" selected >-- Select field
				// --</option>");
				// } else {
				// ow.println("<option value=\"\">-- Reset --</option>");
				// }
				// for (PropertyDescriptor pd : displayedProps) {
				// String selected = "";
				// if (op0 != null && op0.equals(pd.getName()))
				// selected = " selected ";
				// String pDescr = pd.getShortDescription();
				// String resKey = (String) pd
				// .getValue("ipsk.util.ResourceKey");
				// if (resKey != null) {
				// pDescr = LocaleSupport.getLocalizedMessage(pageContext,
				// resKey, controller.getBeanInfo()
				// .getResourceBundleName());
				// }
				// ow.println("<option value=\"" + pd.getName() + "\""
				// + selected + ">" + pDescr + "</option>");
				//
				// }
				// ow.println("</select>");
				// ow.println("<select name=\"_eo0\">");
				// String[] exprOps = ExtBoolExpr.getExprOperators();
				// if (opStr == null) {
				// ow
				// .println("<option value=\"\" selected >-- Select operator
				// --</option>");
				// } else {
				// ow.println("<option value=\"\">-- Reset --</option>");
				// }
				// for (String exprOp : exprOps) {
				// String queryOp = BoolExprQueryParser
				// .getQueryOperator(exprOp);
				// String selected = "";
				// if (opStr != null && opStr.equals(queryOp))
				// selected = " selected ";
				// ow.println("<option value=\"" + queryOp + "\"" + selected
				// + ">" + exprOp + "</option>");
				// }
				// ow.println("</select>");
				// ow.println("<input name=\"_ev0\" type=\"text\" value=\""
				// + op1Str + "\" />");
				// Locale locale = (Locale) (pageContext.getSession()
				// .getAttribute("javax.servlet.jsp.jstl.fmt.locale"));
				Locale locale = ipsk.jsp.fmt.LocaleSupport
						.getLocale(pageContext);
				ow.println("<input type=\"hidden\" name=\""
						+ BasicPersistenceBeanController.KEY_LOCALE + "\" value=\"" + locale
						+ "\" />");
				ow.println("<input type=\"hidden\" name=\""
						+ BasicPersistenceBeanController.KEY_CMD + "\" value=\""
						+ BasicPersistenceBeanController.CMD_LIST_APPLY_COND + "\" />");
				ow.println("<input type=\"submit\" name=\"_submit\" value=\""
						+ getLocalizedMessage("condition.apply") + "\" />");
				ow.println("</fieldset>");
				ow.println("</form>");
				// ow.println("<form method=\"POST\" action=\""+action+"\">");
				// ow.println("<input name=\"_ev0\" type=\"text\"
				// value=\""+op1Str+"\" />");
				//			
				// ow.println("<input type=\"hidden\" name=\"cmd\"
				// value=\"cond_reset\" />");
				// ow.println("</form>");
			} catch (IOException ioe) {
				throw new JspException(
						"Error: IOException while writing condition query end tag");
			} catch (CloneNotSupportedException e) {
				throw new JspException(
						"Error: Could not clone boolean expression object.");
			}

		}
		return EVAL_PAGE;
	}

	public String getCSSclass() {
		return CSSclass;
	}

	public void setCSSclass(String sclass) {
		CSSclass = sclass;
	}

}
