package ipsk.jsp.taglib.beans.table;

import ipsk.jsp.BeanTableController;
import ipsk.jsp.BeanTableModel;
import ipsk.jsp.Controller;
import ipsk.jsp.taglib.ControllerProvider;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanControllerProvider;
import ipsk.net.EditableURI;
import ipsk.net.EditableURL;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.Tag;

public class PageNaviTag extends ExtBodyTagSupport {

	private BeanTableController controller;

	private BeanTableModel beanTableModel;

	public void setParent(Tag parent) {
		if (parent instanceof ControllerProvider) {
			Controller scontroller = ((ControllerProvider) parent).getController();
			if(scontroller instanceof BeanTableController){
				controller=(BeanTableController)scontroller;
			}
		}
	}

	public int doStartTag() throws JspException {
		if(controller != null){
			try {
				beanTableModel = controller.getBeanTableModel((HttpServletRequest)pageContext.getRequest());
			} catch (ControllerException e) {
				e.printStackTrace();
				throw new JspException(e);
			}
		}
		return EVAL_BODY_INCLUDE;
	}

	public int doEndTag() throws JspException {

		int itemCount = beanTableModel.getItemCount();
		// int pageCount=beanTableModel.getPageCount();
		boolean firstEnable = (beanTableModel.getFirstItem() != 0);
		boolean prevEnable = (beanTableModel.getFirstItem() > 0);
		boolean nextEnable = (beanTableModel.getLastItem() < itemCount - 1);
		boolean lastEnable = (beanTableModel.getLastItem() < itemCount - 1);

		HttpServletRequest req = (HttpServletRequest) (pageContext.getRequest());
		//String contextPath = req.getContextPath();
		String servletPath = req.getServletPath();
		String encodedPath=encodeURL(servletPath);
		
		JspWriter ow = pageContext.getOut();
		if (firstEnable || nextEnable || prevEnable || lastEnable) {
			try {
				if (firstEnable) {
					EditableURI href=new EditableURI(encodedPath);
					href.appendQuery(BasicPersistenceBeanController.KEY_CMD,BasicPersistenceBeanController.CMD_LIST_FIRST);
					ow.print("<a href=\"" +href.getHTMLEncodedUri()+ "\">");
				}
				ow.print("["
						+ LocaleSupport.getLocalizedMessage(pageContext,
								"page.first", RES_BUNDLE_NAME) + "]");
				if (firstEnable) {
					ow.print("</a>");
				}

				if (nextEnable) {
					EditableURI href=new EditableURI(encodedPath);
					href.appendQuery(BasicPersistenceBeanController.KEY_CMD,BasicPersistenceBeanController.CMD_LIST_NEXT);
					ow.print("<a href=\"" + href.getHTMLEncodedUri() + "\">");
				}

				ow.print("["
						+ LocaleSupport.getLocalizedMessage(pageContext,
								"page.next", RES_BUNDLE_NAME) + "]");
				if (nextEnable) {
					ow.print("</a>");
				}

				if (prevEnable) {
					EditableURI href=new EditableURI(encodedPath);
					href.appendQuery(BasicPersistenceBeanController.KEY_CMD,BasicPersistenceBeanController.CMD_LIST_PREVIOUS);
					ow.print("<a href=\"" + href.getHTMLEncodedUri() + "\">");
				}

				ow.print("["
						+ LocaleSupport.getLocalizedMessage(pageContext,
								"page.previous", RES_BUNDLE_NAME) + "]");
				if (prevEnable) {
					ow.print("</a>");
				}
				if (lastEnable) {
					EditableURI href=new EditableURI(encodedPath);
					href.appendQuery(BasicPersistenceBeanController.KEY_CMD,BasicPersistenceBeanController.CMD_LIST_LAST);
					ow.print("<a href=\"" +href.getHTMLEncodedUri() + "\">");
				}

				ow.print("["
						+ LocaleSupport.getLocalizedMessage(pageContext,
								"page.last", RES_BUNDLE_NAME) + "]");
				if (lastEnable) {
					ow.print("</a>");
				}
				ow.print(" "
						+ LocaleSupport.getLocalizedMessage(pageContext,
								"page", RES_BUNDLE_NAME));

			} catch (IOException ioe) {
				throw new JspException(
						"Error: IOException while writing to client");
			}
		}

		return EVAL_PAGE;
	}

}
