package ipsk.jsp.taglib.beans.view;

import ipsk.jsp.taglib.beans.BeanPropertyIterator;
import ipsk.jsp.taglib.beans.BeanPropertyIterator.Iteration;
import ipsk.jsp.taglib.beans.BeanPropertyValueText;
import ipsk.jsp.taglib.beans.RelationshipURL;
import ipsk.net.EditableURI;
import ipsk.text.html.HTMLTextEncoder;

import java.beans.PropertyDescriptor;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public class BeanPropertyTag extends ipsk.jsp.taglib.beans.BeanPropertyTag {


	protected Boolean defaultHideIfEmpty=null;
	protected Boolean hideIfEmpty=null;
	public Boolean getHideIfEmpty() {
		return hideIfEmpty;
	}

	public void setHideIfEmpty(Boolean hideIfEmpty) {
		this.hideIfEmpty = hideIfEmpty;
	}
	
	protected Boolean cssWarnOnNonEmptyColl;

	public Boolean getCssWarnOnNonEmptyColl() {
		return cssWarnOnNonEmptyColl;
	}

	public void setCssWarnOnNonEmptyColl(Boolean cssWarnOnNonEmptyColl) {
		this.cssWarnOnNonEmptyColl = cssWarnOnNonEmptyColl;
	}

	protected int maxListLength=0;
	
	public int getMaxListLength() {
		return maxListLength;
	}

	public void setMaxListLength(int maxListLength) {
		this.maxListLength = maxListLength;
	}

	public void printTag() throws JspException {
		JspWriter w = pageContext.getOut();
		try {
			if (beanProperty.getVar() == null) {
				PropertyDescriptor pd = beanProperty.getPropertyDescriptor();
				Object bean = beanProperty.getBeanModel().getBean();
				BeanPropertyValueText beanValueTxt = new BeanPropertyValueText(
						beanProvider.getBeanInfo(), pageContext,maxListLength);
				
				Tag p = getParent();
				if(p instanceof BeanViewTag) {
					defaultHideIfEmpty=((BeanViewTag)p).getDefaultHideIfEmpty();
				}else {
					defaultHideIfEmpty=null;
				}
				boolean effHideIfEmpty=false;
				if(hideIfEmpty==null) {
					if(defaultHideIfEmpty!=null) {
						effHideIfEmpty=defaultHideIfEmpty;
					}
				}else {
					effHideIfEmpty=hideIfEmpty;
				}
				boolean isColl=beanValueTxt.isCollection(pd);
				boolean empty=beanValueTxt.isEmpty(bean, pd);
				if(!(effHideIfEmpty && empty)) {
					// print property
					EditableURI uri = null;
					String action=getAction();
					if (action != null) {
						RelationshipURL relURL=new RelationshipURL(beanProperty);
						uri=relURL.getEditableURI(encodeURL(action));
					}
					String descrHtml=descriptorHtml();
					String titleHtmlTooltipAttributeStr=descriptorHtmlTitelTooltipAttribute();
					
					String valueHtmlAttributeSet="";
					if(Boolean.TRUE.equals(cssWarnOnNonEmptyColl) && isColl && !empty) {
						valueHtmlAttributeSet=" class=\"warn\"";
					}
					String textRepresentation = beanValueTxt
							.getValueTextRepresentation(bean, pd);
					String htmlRepresentation=HTMLTextEncoder.encode(textRepresentation);
					String descrTdHtml="<td"+titleHtmlTooltipAttributeStr+">"+ descrHtml + "</td>";
					String valueHtml;
					if (uri != null) {
						String encodedURL=HTMLTextEncoder.encode(uri.getUri());
						valueHtml="<a href=\""+ encodedURL + "\">"+ htmlRepresentation+ "</a>";
					} else {
						valueHtml= htmlRepresentation;
					}
					String valueTdHtml="<td"+valueHtmlAttributeSet+">" + valueHtml + "</td>";
					String propertyTrHtml="<tr>"+descrTdHtml+valueTdHtml+"</tr>";
					
					w.println(propertyTrHtml);
					
				}
			}
		} catch (Exception e) {
			throw new JspException("Could not print bean property !", e);
		}
	}

	public int doStartTag() throws JspException {
		Tag p = getParent();	
		beanProvider = (BeanPropertyIterator) p;
		Iteration it=beanProvider.getIteration();
		String currProp = beanProvider.getCurrentProperty();
		if (currProp != null && !currProp.equals(beanProperty.getName())) {
			return SKIP_BODY;
		}
		int retVal=SKIP_BODY;
		if(Iteration.TABLE.equals(it)){
			retVal = super.doStartTag();
			printTag();
		}
		beanProvider.setCurrentPropertyDone(true);
		return retVal;
	}

	public int doEndTag() throws JspException {
		return EVAL_PAGE;
	}

}
