package ipsk.jsp.taglib.utils;

import ipsk.jsp.fmt.LocaleSupport;
import ipsk.text.StringTokenizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class LanguageChooserTag extends BodyTagSupport {

	public class LanguageOption implements Comparable<LanguageOption>{
		/**
		 * @param value
		 * @param displayName
		 */
		public LanguageOption(String value, String displayName,boolean disabled) {
			super();
			this.value = value;
			this.displayName = displayName;
			this.disabled=disabled;
		}
		private String value;
//		public String getValue() {
//			return value;
//		}
//		public String getDisplayName() {
//			return displayName;
//		}
		private String displayName;
		
		private boolean disabled;
		
		@Override
		public int compareTo(LanguageOption o) {
			return displayName.compareTo(o.displayName);
		}
		
		public boolean equals(Object o) {
			if(o instanceof LanguageOption) {
				LanguageOption other=(LanguageOption)o;
				return other.value.equals(value);
			}
			return  false;
		}
		
		public int hashCode() {
			return value.hashCode();
		}
	
	}
	
	
	
	public LanguageChooserTag(){
		super();
		Locale[] localeArray=Locale.getAvailableLocales();
		localeList=Arrays.asList(localeArray);
	}
	
	private String languages;
	private String excludeLanguages;
	private String disabledLanguages;

	private String name;
	private String value=null;

	private boolean localize=true;
	private boolean nullable=false;
	public boolean isNullable() {
		return nullable;
	}

	public void setNullable(boolean nullable) {
		this.nullable = nullable;
	}

	private String standard;
	
	public String getStandard() {
		return standard;
	}

	public void setStandard(String standard) {
		this.standard = standard;
	}

	public boolean isLocalize() {
		return localize;
	}

	public void setLocalize(boolean localize) {
		this.localize = localize;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getLanguages() {
		return languages;
	}

	public void setLanguages(String locales) {
		this.languages = locales;
		if(locales!=null){
			localeList=new ArrayList<Locale>();
			String[] localesStrArr=StringTokenizer.split(locales,',', true);
			for(String locStr:localesStrArr){
				Locale l=LocaleSupport.parse(locStr.trim());
				localeList.add(l);
			}
		}
	}
	
	public String getExcludeLanguages() {
		return excludeLanguages;
	}

	public void setExcludeLanguages(String excludeLanguages) {
		this.excludeLanguages = excludeLanguages;
		
		if(this.excludeLanguages!=null) {
			localeList=new ArrayList<Locale>();
			String[] excludeStrArr=StringTokenizer.split(this.excludeLanguages,',', true);
			Locale[] localeArray=Locale.getAvailableLocales();
			boolean include;
			for(Locale al:localeArray) {
				include=true;
				for(String exclStr:excludeStrArr){
					//Locale l=LocaleSupport.parse(exclStr.trim());
					String l3=exclStr.trim();
					String al3=al.getISO3Language();
					if(al3.equals(l3)) {
						include=false;
					}
				}
				if(include) {
					localeList.add(al);
				}
			}
		}
	}
	
	public String getDisabledLanguages() {
		return disabledLanguages;
	}

	public void setDisabledLanguages(String disabledLanguages) {
		this.disabledLanguages = disabledLanguages;
		disabledLanguageCodes.clear();
		if(this.disabledLanguages!=null) {
			String[] disabledStrArr=StringTokenizer.split(this.disabledLanguages,',', true);
			for(String disabledStr:disabledStrArr) {
				disabledLanguageCodes.add(disabledStr);
			}
		}
	}

	private List<Locale> localeList=null;
	private Set<String> disabledLanguageCodes=new HashSet<>();

	public int doStartTag() throws JspException {
		
		List<Locale> locList=localeList;
		if(locList==null){
			locList=Arrays.asList(Locale.getAvailableLocales());
		}
		
		JspWriter ow = pageContext.getOut();
		Locale currLocale=LocaleSupport.getLocale(pageContext);
		String currLocaleLanCode;
		if(standard==null || "ISO-639-1".equalsIgnoreCase(standard.trim())){
			currLocaleLanCode=currLocale.getLanguage();
		}else if("ISO-639-3".equalsIgnoreCase(standard.trim())){
			currLocaleLanCode=currLocale.getISO3Language();
		}else{
			throw new JspException("Unknown language standard \""+standard+"\". Possible values are ISO-639-1 and ISO-639-3 (default)");
		}
		try {
			ow.println("<select name=\""+name+"\">");
			SortedSet<LanguageOption> langValueSet=new TreeSet<LanguageOption>();
			boolean languageSelected=false;
			for(Locale l:locList){
				String optionLangValue;
				
				if(standard==null || "ISO-639-1".equalsIgnoreCase(standard.trim())){
					optionLangValue=l.getLanguage();
				}else if("ISO-639-3".equalsIgnoreCase(standard.trim())){
					optionLangValue=l.getISO3Language();
				}else{
					throw new JspException("Unknown language standard \""+standard+"\". Possible values are ISO-639-1 and ISO-639-3 (default)");
				}
				Locale displayLocale;
				if(localize){
					displayLocale=currLocale;
				}else{
					displayLocale=l;
				}
				String displaystring=l.getDisplayLanguage(displayLocale);
				if(optionLangValue!=null && !"".equals(optionLangValue)) {
					boolean disabled=disabledLanguageCodes.contains(optionLangValue);
					LanguageOption lOpt=new LanguageOption(optionLangValue,displaystring,disabled);
					if(!langValueSet.contains(lOpt)) {
						langValueSet.add(lOpt);
					}
				}
				
			}
			
			
			if(nullable){
				String selectedAttrStr="";
				if(value==null || "".equals(value)){
					// value not set
					selectedAttrStr=" selected=\"selected\"";
				}
				String selLngStr=LocaleSupport.getLocalizedMessage(pageContext,"language.select","ipsk.jsp.Messages");
				ow.print("<option"+selectedAttrStr+" value=\"\">-- "+selLngStr+" --</option>");
			}

			for(LanguageOption lo:langValueSet) {
				boolean selected=false;

				if(value!=null && !value.equals("")){
					if(value.equalsIgnoreCase(lo.value)){
						selected=true;
					}
				}else if(!nullable){
					// value not set, not  nullable, we just set the current locale
					if(currLocaleLanCode.equals(lo.value)){
						selected=true;
					}
				}
				String selectedAttrStr="";
				String disabledStr="";
				if(!lo.disabled && selected){
					languageSelected=true;
					selectedAttrStr=" selected=\"selected\"";
				}
				if(lo.disabled) {
					disabledStr=" disabled=\"true\"";
				}

				ow.print("<option"+selectedAttrStr+disabledStr+" value=\""+lo.value+"\">");
				ow.print(lo.displayName);
				ow.println("</option>");
			}
			
		} catch (IOException e) {
			e.printStackTrace();
			throw new JspException(e);

		}
		return SKIP_BODY;
	}

	public int doEndTag() throws JspException {
		JspWriter ow = pageContext.getOut();
		try {
			ow.println("</select>");
		} catch (IOException e) {
			e.printStackTrace();
			throw new JspException(e);

		}
		return EVAL_PAGE;
	}

}
