package ipsk.net;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryCollectionParser {

	public final static String NAME_INDEX_SEPARATOR="_"; 
	private String paramBaseName;
	private String paramListPatternString;
	private String paramMapPatternString;
	private Pattern paramListPattern;
	private Pattern paramMapPattern;
	
	public QueryCollectionParser(String paramBaseName) {
		super();
		this.paramBaseName=paramBaseName;
		paramListPatternString=paramBaseName+NAME_INDEX_SEPARATOR+"(?<index>\\d+)";
		paramListPattern = Pattern.compile(paramListPatternString);
		paramMapPatternString=paramBaseName+NAME_INDEX_SEPARATOR+"(?<index>\\w+)";
		paramMapPattern=Pattern.compile(paramMapPatternString);
	}
	
	public Map<Integer,String[]> parseListMultiple(Map<String,String[]> paramMap) throws ParserException{
		
		Map<Integer,String[]> listMap=new HashMap<>();
		for(String pn:paramMap.keySet()) {
			Matcher m = paramListPattern.matcher(pn);
			if(m.matches()) {
				String indexGroup=m.group("index");
				try {
					int paramIndex=Integer.parseInt(indexGroup);
					listMap.put(paramIndex, paramMap.get(pn));
				}catch(NumberFormatException nfe) {
					throw new ParserException(nfe);
				}
			
			}
		}
	
		return listMap;
	}
	
	
	public Map<Integer,String> parseList(Map<String,String[]> paramMap) throws ParserException{
		
		Map<Integer,String> listMap=new HashMap<>();
		for(String pn:paramMap.keySet()) {
			Matcher m = paramListPattern.matcher(pn);
			if(m.matches()) {
				String indexGroup=m.group("index");
				try{
					int paramIndex=Integer.parseInt(indexGroup);
					//System.out.println(pn+" matches, indexGroup: "+indexGroup+", paramIndex: "+paramIndex);
					String paramValue=null;
					String[] paramValues=paramMap.get(pn);
					if(paramValues!=null) {
						int prmValsLen=paramValues.length;
						if(prmValsLen==1) {
							paramValue=paramValues[0];
						}else if(prmValsLen>1) {
							throw new ParserException("Multiple values for parameter "+paramBaseName+ " with index "+paramIndex);
						}
					}
					listMap.put(paramIndex, paramValue);
				}catch(NumberFormatException nfe) {
					throw new ParserException(nfe);
				}
			}
		}
	
		return listMap;
	}
	
	public Map<String,String> parseMap(Map<String,String[]> paramMap) throws ParserException{
		
		Map<String,String> map=new HashMap<>();
		for(String pn:paramMap.keySet()) {
			Matcher m = paramMapPattern.matcher(pn);
			if(m.matches()) {
				String paramKey=m.group("index");
				try{
					
					//System.out.println(pn+" matches, indexGroup: "+indexGroup+", paramIndex: "+paramIndex);
					String paramValue=null;
					String[] paramValues=paramMap.get(pn);
					if(paramValues!=null) {
						int prmValsLen=paramValues.length;
						if(prmValsLen==1) {
							paramValue=paramValues[0];
						}else if(prmValsLen>1) {
							throw new ParserException("Multiple values for parameter "+paramBaseName+ " with key "+paramKey);
						}
					}
					map.put(paramKey, paramValue);
				}catch(NumberFormatException nfe) {
					throw new ParserException(nfe);
				}
			}
		}
	
		return map;
	}
	

	public static void main(String[] args) {
		Map<String,String[]> testMap=new HashMap<>();
		testMap.put("_pg_switch_00000567", new String [] {"Bla"}); // Match, index 567
		testMap.put("_pg_switch_2", new String [] {"Foo"}); // Match, index 2
		testMap.put("_other", new String [] {"Other"}); // Does not match, ignored
		testMap.put("_pg_switch_2ab", new String [] {"Foo"}); // Does not match, ignored
		
		QueryCollectionParser qap=new QueryCollectionParser("_pg_switch");
		Map<Integer, String> lst;
		try {
			lst = qap.parseList(testMap);
			System.out.println("list size: "+lst.size()+" "+lst.get(567)+" "+lst.get(2));
		} catch (ParserException e) {
			e.printStackTrace();
		}
		
	}

}
