/*
 * Date  : 12.02.2004
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */

package ipsk.net.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;



/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
public class PutServlet extends HttpServlet {

	private final static boolean DEBUG = false;
	protected final static int DEFAULT_BUFSIZE=2048; 

	protected int bufSize = DEFAULT_BUFSIZE;
	protected byte[] buf = new byte[bufSize];
	protected InputStream is;
	protected OutputStream os;
	protected FileOutputStream fos;
	protected FileInputStream fis;

	protected synchronized void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException {

		String relServletPath = req.getServletPath();
		ServletContext sc = getServletContext();
		if (DEBUG)
			log("ServletPath: " + relServletPath);
		if (DEBUG)
			log("Authentication: " + req.getAuthType());
		if (DEBUG)
			log("User: " + req.getRemoteUser());
		String recsDir = sc.getInitParameter("recsDir");
			if (DEBUG)log("recsDir: " + recsDir);
		Enumeration params = sc.getInitParameterNames();
		if (DEBUG)
			log("Params: " + params);
		String rPath = new String(recsDir + File.separator + relServletPath);
		File f = new File(rPath);

		File pd = f.getParentFile();
		if(DEBUG)log("Parent dir: "+pd.getPath());
		if (DEBUG)
			log("Saving:" + rPath);
		try {
			if (DEBUG)log("Path:" + f.getCanonicalPath());
		} catch (IOException e) {
			log("Cannot get canonical path.",e);
			throw e;
		}
		boolean created = false;
		if (!pd.exists()) {
			if (DEBUG)
				log("Creating dir ...");
			created = pd.mkdirs();
		}
			if (created)log("Directory "+pd.getName()+" for user '"+req.getRemoteUser()+"' created.");
		is = req.getInputStream();
		fos = new FileOutputStream(f);
		int read = 0;
		try {
			do {
				read = is.read(buf, 0, bufSize);
				if (read > 0)
					fos.write(buf, 0, read);
			} while (read >= 0);
			log("File '"+f.getAbsolutePath()+"' written for user '"+ req.getRemoteUser()+"' written.");
		} catch (IOException e) {
			throw e;
		} finally {
			if (fos != null)
				fos.close();
		}

	}

	protected synchronized void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
		ServletContext sc = getServletContext();
		//int response;
		String relServletPath = req.getServletPath();
		String recsDir = sc.getInitParameter("recsDir");
		String rPath = new String(recsDir + File.separator + relServletPath);
		if (DEBUG)
			log("Get request: " + rPath);
		File f = new File(rPath);
		try {
			os = res.getOutputStream();
			fis = new FileInputStream(f);
			// TODO parse audiofile
			//res.setContentType("audio/wav");
			if (DEBUG)
				log("File opened.");
			int read = 0;
			do {
				read = fis.read(buf, 0, bufSize);
				if (read > 0) {
					try {
						os.write(buf, 0, read);
					} catch (IOException e) {
						if (DEBUG)
							log("Outstream closed !!", e);
					}
				}
			} while (read >= 0);
		} catch(FileNotFoundException fnfe){
			res.sendError(HttpServletResponse.SC_NOT_FOUND);	
		} catch(IOException e) {
			throw e;
		} finally {
			if (fis!=null)fis.close();
		}
	}
	
}
