/*
 * CVS   : $Id: ZipUploadServlet.java,v 1.1 2006/08/07 15:53:00 klausj Exp $
 * Date  : Feb 10, 2005
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */

package ipsk.net.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @version $Id: ZipUploadServlet.java,v 1.1 2006/08/07 15:53:00 klausj Exp $
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
public class ZipUploadServlet extends PutServlet {
	private final static boolean DEBUG = true;
	protected synchronized void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException {

		String relServletPath = req.getServletPath();
		ServletContext sc = getServletContext();
		if (DEBUG)
			log("ServletPath: " + relServletPath);
		if (DEBUG)
			log("Authentication: " + req.getAuthType());
		if (DEBUG)
			log("User: " + req.getRemoteUser());
		String recsDir = sc.getInitParameter("recsDir");
		if (DEBUG)
			log("recsDir: " + recsDir);
		Enumeration params = sc.getInitParameterNames();
		if (DEBUG)
			log("Params: " + params);

		is = req.getInputStream();
		ZipInputStream zipInputStream = new ZipInputStream(is);
		ZipEntry entry = null;
		while ((entry = zipInputStream.getNextEntry()) != null) {

			String entryName = entry.getName();
			log("Got new ZIP entry: " + entryName);
			StringTokenizer st = new StringTokenizer(entryName, " ");
			st.nextToken();
			String path = st.nextToken();
			String rPath = new String(recsDir + File.separator + path);
			File f = new File(rPath);

			File pd = f.getParentFile();
			if (DEBUG)
				log("Saving:" + rPath);
			try {
				if (DEBUG)
					log("Path:" + f.getCanonicalPath());
			} catch (IOException e) {
				log("Cannot get canonical path.", e);
				throw e;
			}
			boolean created = false;
			if (!pd.exists()) {
				if (DEBUG)
					log("Creating dir ...");
				created = pd.mkdirs();
			}
			if (created)
				log("Directory " + pd.getName() + " created.");

			fos = new FileOutputStream(f);
			int read = 0;
			try {
				do {
					read = zipInputStream.read(buf, 0, bufSize);
					if (read > 0)
						fos.write(buf, 0, read);
				} while (read >= 0);
				log("File '" + f.getAbsolutePath() + "' written.");
			} catch (IOException e) {
				throw e;
			} finally {
				zipInputStream.closeEntry();
				if (DEBUG)
					log("Closed entry.");
				if (fos != null)
					fos.close();
			}
		}
	}

}
