package ipsk.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

import ipsk.webapps.EntityManagerFactoryInitializer;

public class EntityManagerProviderImpl implements EntityManagerProvider{

	public class EntityManagerThreadLocal extends ThreadLocal<EntityManager> {
		protected synchronized EntityManager initialValue() {
			EntityManager em=null;
			EntityManagerFactory emf=EntityManagerFactoryInitializer.getEntityManagerFactory();
			if(emf!=null) {
				em=emf.createEntityManager();
			}
			return em;
		}
	}

	private EntityManagerThreadLocal emtl;


	public EntityManagerProviderImpl() {
		emtl=new EntityManagerThreadLocal();
	}
	
	public EntityManager getThreadEntityManager() {
		if (emtl == null) {
			emtl=new EntityManagerThreadLocal();
		}
		return emtl.get();
	}
	
	public void removeEntityManagerThreadLocal() {
		if(emtl!=null) {
			emtl.remove();
		}
	}
	
	public EntityManager getEntityManager() {
		return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
	}

}
