package ipsk.persistence;

import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;
import ipsk.util.LocalizableMessage;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;

public abstract class EntityManagerWorker extends ProgressWorker{
	
	private EntityManagerFactory entityManagerFactory;
	protected volatile EntityManager entityManager;
	

	//protected SecurityManager securityManager=new SecurityManager();


	
	/**
	 * Create worker in JPA context.
	 * This constructor should be used if the worker runs its own thread.
	 */
	public EntityManagerWorker(EntityManagerFactory entityManagerFactory) {
		super();
		this.entityManagerFactory=entityManagerFactory;
	}
	/**
	 * Create worker in JPA context.
	 * This constructor should be used if the worker runs in an already existing thread by direct call of doWork().
	 */
	public EntityManagerWorker(EntityManager entityManager) {
		super();
		this.entityManager=entityManager;
	}
	
	
	
	public void run(){
		progressStatus.running();
		if(entityManagerFactory!=null){
			entityManager=entityManagerFactory.createEntityManager();
		}
		
		EntityTransaction tx=entityManager.getTransaction();
		if(tx!=null && ! tx.isActive()){
		tx.begin();
		}
		try {
			doWork();
			synchronized(progressStatus){
				if(progressStatus.hasCancelRequest()){
					rollback(entityManager);
				}else{
					try {
						commit(entityManager);
					} catch (WorkerException e) {
						rollback(entityManager);
						progressStatus.error(new LocalizableMessage(e.getMessage()));
					}
				}
			}
		} catch (WorkerException e) {
			rollback(entityManager);
			progressStatus.error(new LocalizableMessage(e.getMessage()));
			
		}finally{
			try {
				closeEntityManager(entityManager);
				
			} catch (WorkerException e) {
				e.printStackTrace();
				progressStatus.error(new LocalizableMessage(e.getMessage()));
			}
			synchronized(progressStatus){
				if(progressStatus.hasCancelRequest()){
					progressStatus.canceled();
				}else if (! progressStatus.isError()){
					progressStatus.done();
				}
			}
			fireProgressEvent();
		}
	
	}

	private void commit(EntityManager em) throws WorkerException{

		if (em != null && em.isOpen()) {
			EntityTransaction tx = null;
			try {
				tx = em.getTransaction();
				if (tx!=null && tx.isActive()) {
					tx.commit();
				}
			} catch (PersistenceException e) {
				e.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();
				throw new WorkerException(e);
			} catch (IllegalStateException ise) {
				ise.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();
				throw new WorkerException(ise);
			} catch (Exception e) {
				e.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();
				throw new WorkerException(e);
			} 
		}
	}
	

	
	private void closeEntityManager(EntityManager em) throws WorkerException  {

		// for open JPA it is required to   
		try {
			commit(em);
		} catch (WorkerException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (em != null && em.isOpen()) {
			em.close();
		}
		
	}
	
	private void rollback(EntityManager em){
		if (em != null) {
			EntityTransaction tx = null;
				tx = em.getTransaction();
				if (tx!=null && tx.isActive()) {
					tx.rollback();
				}
		}
	}
	public EntityManager getEntityManager() {
		return entityManager;
	}
	public void setEntityManager(EntityManager entityManager) {
		this.entityManager = entityManager;
	}
		
}
