package ipsk.persistence.text;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.jsp.fmt.LocaleSupport;
import ipsk.jsp.taglib.beans.BeanPropertyValueText;
import ipsk.lang.reflect.NativeTypeWrapper;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.text.ParserException;
import ipsk.util.EnumResourceKeys;
import ipsk.util.MemberResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.webapps.ControllerException;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.persistence.Temporal;
import javax.persistence.TemporalType;





public class StringObjectConverter extends ipsk.text.StringObjectConverter {
	public static Object stringToObject(String strValue, PropertyDescriptor pd,Locale locale) throws ParserException {
		return stringToObject(strValue, pd,locale,false,false);
	}
	
	public static Object stringToObject(String strValue, PropertyDescriptor pd,Locale locale,boolean enumKey,boolean caseInsensitive) throws ParserException {
		
		Class<?> propertyType=pd.getPropertyType();
		ResourceBundle rb=ResourceBundle.getBundle("ipsk.jsp.Messages", locale);
		Method readMethod=pd.getReadMethod();
		
		if(Collection.class.isAssignableFrom(propertyType)){
			Type rt = readMethod.getGenericReturnType();
			if (rt instanceof ParameterizedType) {
				ParameterizedType prt = (ParameterizedType) rt;
				Type[] pts = prt.getActualTypeArguments();
				if (pts.length == 1) {
					// we expect exactly one parameterized type argument 
					Class relatedReturnType=(Class) pts[0];
					Object idObj =null;
					ExtBeanInfo relatedBeanInfo=null;
					try {
						relatedBeanInfo = PersistenceIntrospector
						.getPersistenceBeanInfo(relatedReturnType,true);
						// create the primary key ID object of the related object
						idObj = relatedBeanInfo.createIdValueByString(strValue);
						
					} catch (Exception e) {
						throw new ParserException(e);
					}
					return new PersistenceObjectIdentifier(relatedReturnType,idObj);
				}else{
					throw new ParserException("Parameterized type "+prt+" has more than one type arguemnts\nCannot get bean info of property return type.");
				}
			}else{
				throw new ParserException("Property "+pd.getName()+" is not prameterized.\nCannot create Id object for unknown type!");
			}
			
		}else if(NativeTypeWrapper.isPrimitiveNumber(propertyType) || Number.class.isAssignableFrom(propertyType)){
			// byte,short,int,float,double (primitive types) or Byte,Short,Integer,Float,Double (object) numbers
			NumberFormat nf=NumberFormat.getNumberInstance(locale);
			Number n;
			try {
				n=nf.parse(strValue);
			} catch (ParseException e) {
				e.printStackTrace();
				throw new ParserException(e);
			}
			if(propertyType.equals(Byte.TYPE) || propertyType.equals(Byte.class)){
				return new Byte(n.byteValue());
			}else if(propertyType.equals(Short.TYPE) || propertyType.equals(Short.class)){
				return new Short(n.shortValue());
			}else if(propertyType.equals(Integer.TYPE) || propertyType.equals(Integer.class)){
				return new Integer(n.intValue());
			}else if(propertyType.equals(Long.TYPE) || propertyType.equals(Long.class)){
				return new Long(n.longValue());
			}else if(propertyType.equals(Float.TYPE) || propertyType.equals(Float.class)){
				return new Float(n.floatValue());
			}else if(propertyType.equals(Double.TYPE) || propertyType.equals(Double.class)){
				return new Double(n.doubleValue());
			}else{
				return null;
			}
			
		}else if(Date.class.isAssignableFrom(propertyType)){
		
			try {
			Method rm=pd.getReadMethod();
			Temporal dateType=rm.getAnnotation(Temporal.class);
			if(dateType != null && dateType.value().equals(TemporalType.DATE)){
				//This is a date instance
				return DateFormat.getDateInstance(DateFormat.DEFAULT,locale).parse(strValue);
			}else if (dateType != null && dateType.value().equals(TemporalType.TIME)){
				// This is a time instance
				// Try Long first
				try {
					long timeMillis=Long.parseLong(strValue);
					Date dt=new Date(timeMillis);
					return dt;
				}catch(NumberFormatException nfe) {
					return DateFormat.getTimeInstance(DateFormat.DEFAULT,locale).parse(strValue);
				}
			}else{
				// date time
				// This is a time instance
				// Try Long first
				try {
					long timeMillis=Long.parseLong(strValue);
					Date dt=new Date(timeMillis);
					return dt;
				}catch(NumberFormatException nfe) {
					return DateFormat.getDateTimeInstance(DateFormat.DEFAULT,DateFormat.DEFAULT,locale).parse(strValue);
				}
			}
			} catch (ParseException e) {
				throw new ParserException(e);
			}
			
		}else if(propertyType.equals(Boolean.TYPE) || propertyType.equals(Boolean.class)){
			// try to match localized boolean values e.g. 'Yes' or 'No'
			if(strValue.equals(rb.getString(BeanPropertyValueText.RESOURCE_KEY_TRUE))){
				return new Boolean(true);
			}else if(strValue.equals(rb.getString(BeanPropertyValueText.RESOURCE_KEY_TRUE))){
				return new Boolean(false);
			}else return new Boolean(strValue);
			
		}else if(propertyType.isEnum()){
			
			if(enumKey) {
				Enum<?> enumType=Enum.valueOf((Class) propertyType,strValue);
				return enumType;
			}else {
			
//			Class<T extends Enum<T>> enumPropertyType=(Class<? extends Enum<?>>) propertyType;
			// check resource keys annotation
			EnumResourceKeys enumresKeysAnno=(EnumResourceKeys) propertyType.getAnnotation(EnumResourceKeys.class);
			if(enumresKeysAnno!=null){
				// each enumeration member has an associated resource key
				// and each resource key points to a localized string
				
				// get the resource bundle name of the bean class
//				@SuppressWarnings("unchecked")
				Class<?> beanClass= readMethod.getDeclaringClass();
				ResourceBundleName resBundleAnno=(ResourceBundleName) beanClass.getAnnotation(ResourceBundleName.class);
				ResourceBundle beanRb=null;
				if(resBundleAnno!=null){
					String resBundleName=resBundleAnno.value();
					beanRb=ResourceBundle.getBundle(resBundleName,locale);
				}else{
					// default 
					beanRb=rb;
				}
				
				MemberResourceKey[] memberResKeyAnnos=enumresKeysAnno.memberResourceKeys();
				for(MemberResourceKey mrkAnno:memberResKeyAnnos){
					// compare each localized presentation with the given string value
					String enumMemberResKey=mrkAnno.key();
					String localizedEnumMemberPresentation=beanRb.getString(enumMemberResKey);
					if(localizedEnumMemberPresentation!=null){
						if((caseInsensitive && localizedEnumMemberPresentation.equalsIgnoreCase(strValue))
								|| (!caseInsensitive && localizedEnumMemberPresentation.equals(strValue))){
					
						// match!
						String enumName=mrkAnno.name();
						@SuppressWarnings("unchecked")
						Enum<?> enumType=Enum.valueOf((Class)propertyType,enumName);
						return enumType;
						}
					}
				}
				// not found
				return null;
			}else{
				@SuppressWarnings("unchecked")
				Enum<?> enumType=Enum.valueOf((Class)propertyType,strValue);
				return enumType;
			}
			}
		}else if(propertyType.isPrimitive() || propertyType.equals(String.class) || propertyType.equals(Character.class)){
			// char,Character and String types
			return stringToObject(strValue, propertyType);
		}else{
			// a custom class whose objects are identified by an ID object
			
					Object idObj =null;
					ExtBeanInfo relatedBeanInfo=null;
					try {
						relatedBeanInfo = PersistenceIntrospector
						.getPersistenceBeanInfo(propertyType,true);
						// create the primary key ID object of the related object
						idObj = relatedBeanInfo.createIdValueByString(strValue);
						
					} catch (Exception e) {
						throw new ParserException(e);
					}
					return new PersistenceObjectIdentifier(propertyType,idObj);
				
			
		}
	
	}
	
}
