package ipsk.webapps;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NoResultException;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.persistence.internal.codegen.ReflectiveAttributeDefinition;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ips.beans.PersistenceMapConverter;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverter;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.form.FormConfiguration;
import ipsk.beans.form.PropertyConfiguration;
import ipsk.beans.validation.BeanValidator;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.BeanTableModel;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.net.BoolExprQueryParser;
import ipsk.net.OrderByQueryParser;
import ipsk.persistence.EntityManagerProviderImpl;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.PersistenceBoolExpr;
import ipsk.persistence.PersistenceBoolExprConverter;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.SecurityManager;
import ipsk.sql.OrderByClause;
import ipsk.text.ParserException;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.SelectMode.ActionType;

public abstract class BasicEnumBeanController<T extends Enum<T>> extends EntityManagerProviderImpl implements BeanTableController,BeanValidator {

	public static class Mode{}
	public static class ListMode extends Mode{
		private SelectMode selectMode=null;
		
		public SelectMode getSelectMode() {
			return selectMode;
		}
		public void setSelectMode(SelectMode selectMode) {
			this.selectMode = selectMode;
		}
		
	}
	public static class SingleMode extends Mode{}
	public static class EditMode extends SingleMode{}
	public static class ViewMode extends SingleMode{}
	

	
	public final static int DEFAULT_BATCHSIZE = 20;
	public final static int MAX_BATCHSIZE = 1000;

	// Toplink Essentials JPA implementation does not work with
	// full classified class names in JPA queries e.g.
	// SELECT o FROM ipsk.speechdb.Person AS o; -> syntax error
	// SELECT o FROM Person AS o; -> OK
	// it is the JPA specification, not a Toplink bug  
	public final static boolean USE_FULL_QUALIFIED_CLASSNAMES_IN_QUERY = false;

	// key for command
	public final static String KEY_CMD = "_cmd";
	
	public final static String KEY_MODEL_REQUEST="_model_req";

	// key for action reference
	public final static String KEY_ACTION = "_action";
	
	public final static String KEY_QUERY_NAME="name";

	//public final static String KEY_RELATED_ID = "_related_id";

	// key for JPA mappedby attribute
	public final static String KEY_MAPPEDBY = "_related_mappedby";

	public final static String KEY_RELATED_PROPERTY = "_related_prop";

	// the property
	public final static String KEY_SELECTED_PROPERTY = "_sel_prop";

	public final static String KEY_SELECTED_ID = "_sel_id";

	//public final static String KEY_SELECT_TARGET_CLASS = "_sel_trg_class";

	public final static String KEY_SELECT_TARGET_PROPERTY = "_sel_trg_prop";

	public final static String KEY_SELECT_TARGET_ID_PROPERTY = "_sel_trg_id_prop";

	public final static String KEY_SELECT_TARGET_ID = "_sel_trg_id";
	
	public final static String KEY_PREFIX_DELETE_RELATED="_delete_rel";
	
	public final static String KEY_PREFIX_DEFAULT_DESELECT="_default_deselect";

	// list command
	public final static String CMD_LIST = "list";

	public final static String CMD_LIST_RELATED = "list_related";
	public final static String CMD_SELECT_TO_ADD = "select_to_add";
	public final static String CMD_SELECT_TO_REMOVE = "select_to_remove";
	public static final String CMD_SELECT_TO_SET = "select_to_set";
	public static final String CMD_SELECT_TO_RESET = "select_to_reset";
	
	
	public static final String CMD_LIST_CHANGE_SELECTION = "list_change_sel";
	public static final String CMD_CANCEL_LIST_CHANGE_SELECTION = "list_change_sel";

	public static final String CMD_CORRECT="correct";

	public static final String CMD_LIST_SELECT_ITEM = "list_select_item";

	public static final String CMD_LIST_SELECT_MULTI = "list_select_multi";

	public static final String CMD_VIEW = "view";
	public static final String CMD_VIEW_TO_DELETE = "view_to_delete";

	public static final String CMD_CANCEL = "cancel";
	

	public static final String KEY_LOCALE = "_locale";
	
	public static final String KEY_ROWS = "rows";

	public static final String VAL_SELECT_ADD = "select_add";
	public static final String VAL_SELECT_REMOVE = "select_remove";

	public static final String JPQL_PARAM_NAME_PREFIX="basiccontroller_where_param";

	
	public String[] SUBMIT_CMDS = new String[] { CMD_CANCEL};

	protected Class<T> queryType;

	protected String queryTypeName;

	protected String jsfIdentifier;

	protected int batchSize = DEFAULT_BATCHSIZE;

	protected int firstItem = 0;

	private boolean queryMembers=false;

	private String[] additionalColumns;
	public String[] getAdditionalColumns() {
		return additionalColumns;
	}

	public void setAdditionalColumns(String[] additionalColumns) {
		this.additionalColumns = additionalColumns;
	}

	private List<String> displayColumns;

	private ExtBeanInfo beanInfo = null;

	private Object id;

	private boolean idGenerated = false;

	protected BeanTableModel<T> beanTableModel;
	private PersistenceObjectIdentifier relatedObjectIdentifier;
	private Mode mode=null;

	private boolean actionCanceled;

	private Object selectedItemId;
	private Set<Object> selectedItemIds;
	
	protected HttpServletRequest currentRequest;
	public void setCurrentRequest(HttpServletRequest currentRequest) {
		this.currentRequest = currentRequest;
	}

	protected ServletContext servletContext;

	public ServletContext getServletContext() {
		return servletContext;
	}

	public void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	protected SecurityManager securityManager=new SecurityManager();
	protected boolean dropInSecureItems=false;

	//private ValidationResult validationResult;
	
	protected BeanModel<T> beanModel=null;
	protected ProcessResult processResult;
	protected T[] enumValues;
	protected String relatedPropertyName;
	
	protected boolean checkSecureRequestToken=false;
	
	public void setCheckSecureRequestToken(boolean checkSecureRequestToken) {
		this.checkSecureRequestToken = checkSecureRequestToken;
	}
	
	public FormConfiguration getFormConfiguration() {
		return null;
	}

	public static String RESOURCE_BUNDLE_NAME="ipsk.jsp.Messages";
	
	private static LocalizableMessage VALIDATION_MSG_FIELD_REQUIRED=new LocalizableMessage(RESOURCE_BUNDLE_NAME,"validation.field.required");

	// private LocalizableMessage errorMessage = null;
	public BasicEnumBeanController(Class<T> queryType) {
		this(queryType, queryType.getName());
	}

	public BasicEnumBeanController( Class<T> queryType,
			String jsfIdentifier) {
		this.queryType = queryType;
		queryTypeName = queryType.getName();
		
		
		try {
			beanInfo=PersistenceIntrospector.getExtendedBeanInfo(queryType, true, false);
			// TODO Do we need the bean info fo enums ??
			Method vm=queryType.getMethod("values");
			Object valArrObj=vm.invoke(null);
			if(valArrObj instanceof Object[]){
				this.enumValues=(T[]) valArrObj;
			}
		} catch (IntrospectionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();

		for (PropertyDescriptor pd : pds) {

			// Class type = pd.getPropertyType();
			Method rm = pd.getReadMethod();
			if (rm.getAnnotation(javax.persistence.GeneratedValue.class) != null) {
				setIdGenerated(true);
			}
		}
		this.jsfIdentifier = jsfIdentifier;

	}
	
	
	public void open(){
		EntityManager em= getThreadEntityManager();
		EntityTransaction tx=em.getTransaction();
		if(tx!=null && ! tx.isActive()){
		tx.begin();
		}
	}

	public ExtBeanInfo getBeanInfo() {
		try {
			return PersistenceIntrospector.getPersistenceBeanInfo(queryType);
		} catch (IntrospectionException e1) {
			return null;
		}
	}

	public EntityManager getEntityManager() {
		//return emf.createEntityManager();
		return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
	}

	public PropertyDescriptor[] getBeanProperties() {
		BeanInfo beanInfo;
		try {
			beanInfo = Introspector.getBeanInfo(queryType);
		} catch (IntrospectionException e1) {
			return null;
		}
		PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();

		return pds;
	}
	



	
	public T getById(Object id) {
		EntityManager em = getThreadEntityManager();
		T o = em.find(queryType, id);
		return o;
	}

	public boolean hasRelationShips(Object bean) throws ControllerException{
		return false;
	}

	public boolean hasRelationShips(Object bean,PropertyDescriptor propertyDescriptor) throws ControllerException{
		return false;
	}
	
	public boolean hasRelationShips(Object bean,CascadeType ignoreRemoveCascadedWith) throws ControllerException{
		return false;
	}
	
	public boolean isObjectImmutable(Object bean) throws ControllerException{
		
		return true;
	}
	
	public boolean isObjectRemovable(Object bean) throws ControllerException{
		
		return false;
	}
	
	public boolean modifyable(Object bean) {
		return false;
	}
	
	public boolean removable(Object bean) {
		return false;
	}
	
	public boolean itemSelectable(Object item) {
		return true;
	}
	
	/**
	 * Removes object by ID.
	 * Throws controller exception if object has relationships (SQL foreign constraints) or remove not permitted by security manager.
	 * @param req HTTP servlet request
	 * @param id object ID
	 * @return the object
	 * @throws ControllerException
	 */
	public Object removeById(HttpServletRequest req,Object id) throws ControllerException {
		return removeById(req,id, false);
	}
	/**
	 * Removes object by ID.
	 * If removeRelationShips parameter is set the method tries to remove the relationships (not the related objects; no cascade remove) first.
	 * When the object is decoupled it will be removed.
	 * Throws controller exception if object has relationships (SQL foreign constraints) or remove not permitted by security manager.
	 * @param req HTTP servlet request
	 * @param id object ID
	 * @param removeRelationShips if true remove the relationships first
	 * @return the object
	 * @throws ControllerException
	 */
	public Object removeById(HttpServletRequest req,Object id,boolean removeRelationShips) throws ControllerException {
		return removeById(req,beanInfo,id,removeRelationShips);
	}
	
	public Object removeById(HttpServletRequest req,ExtBeanInfo typeInfo,Object id,boolean removeRelationShips) throws ControllerException {
		
		EntityManager em = getThreadEntityManager();
		try {
			Object o = em.find(typeInfo.getBeanDescriptor().getBeanClass(), id);
			if(o==null){
				throw new NoSuchObjectException(id);
			}
			securityManager.checkRemovePermission(req,o);
			if (removeRelationShips) {
				PropertyDescriptor[] ppds = typeInfo
						.getPersistencePropertyDescriptors();
				for (PropertyDescriptor ppd : ppds) {
					Method rm = ppd.getReadMethod();
					OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
					// ManyToOne manyToOne=rm.getAnnotation(ManyToOne.class);
					ManyToMany manyToManyAnno = rm
							.getAnnotation(ManyToMany.class);
					OneToOne oneToOneAnnotation=rm.getAnnotation(OneToOne.class);
					boolean cascadeRemove=false;
					if (oneToManyAnno != null) {
						CascadeType[] cascadeTypes=oneToManyAnno.cascade();
						for(CascadeType ct:cascadeTypes){
							if(ct.equals(CascadeType.ALL) || ct.equals(CascadeType.REMOVE)){
								cascadeRemove=true;
								break;
							}
						}
						if(cascadeRemove)continue;
						PropertyDescriptor relatedPropertyDescriptor = null;
						String mappedby = oneToManyAnno.mappedBy();
						if (mappedby == null || mappedby.equals("")) {
							// simply continue, will throw an error on remove
							// later
							continue;
						}
						Type rt = rm.getGenericReturnType();
						if (rt instanceof ParameterizedType) {
							ParameterizedType prt = (ParameterizedType) rt;
							Type[] pts = prt.getActualTypeArguments();
							if (pts.length == 1) {
								// we expect exactly one parameterized type
								// argument
								Class<?> relatedReturnType = (Class<?>) pts[0];
								ExtBeanInfo relatedbeanInfo = null;
									relatedbeanInfo = PersistenceIntrospector
											.getPersistenceBeanInfo(relatedReturnType);
								PropertyDescriptor[] relPpds = relatedbeanInfo
										.getPersistencePropertyDescriptors();
								for (PropertyDescriptor relPpd : relPpds) {
									if (relPpd.getName().equals(mappedby)) {
										relatedPropertyDescriptor = relPpd;
									}
								}

							} else {
								continue;
							}
						} else {
							continue;
						}
						Collection<?> values;
							values = (Collection<?>)rm.invoke(o, new Object[0]);
						Method relWriteMethod=relatedPropertyDescriptor.getWriteMethod();
						for(Object relObj:values){
							relWriteMethod.invoke(relObj, new Object[]{null});
							securityManager.checkMergePermission(req, relObj);
							em.merge(relObj);
						}
						values.clear();
					}else if(manyToManyAnno != null){
						CascadeType[] cascadeTypes=manyToManyAnno.cascade();
						for(CascadeType ct:cascadeTypes){
							if(ct.equals(CascadeType.ALL) || ct.equals(CascadeType.REMOVE)){
								cascadeRemove=true;
								break;
							}
						}
						if(cascadeRemove)continue;
						PropertyDescriptor relatedPropertyDescriptor = null;
						String mappedby = manyToManyAnno.mappedBy();
						if (mappedby == null || mappedby.equals("")) {
							// Owning side, nothing to do
							continue;
						}
						Type rt = rm.getGenericReturnType();
						if (rt instanceof ParameterizedType) {
							ParameterizedType prt = (ParameterizedType) rt;
							Type[] pts = prt.getActualTypeArguments();
							if (pts.length == 1) {
								// we expect exactly one parameterized type
								// argument
								Class<?> relatedReturnType = (Class<?>) pts[0];
								ExtBeanInfo relatedbeanInfo = null;
									relatedbeanInfo = PersistenceIntrospector
											.getPersistenceBeanInfo(relatedReturnType);
								PropertyDescriptor[] relPpds = relatedbeanInfo
										.getPersistencePropertyDescriptors();
								for (PropertyDescriptor relPpd : relPpds) {
									if (relPpd.getName().equals(mappedby)) {
										relatedPropertyDescriptor = relPpd;
									}
								}

							} else {
								continue;
							}
						} else {
							continue;
						}
						Collection<?> values;
							values = (Collection<?>)rm.invoke(o, new Object[0]);
						Method relReadMethod=relatedPropertyDescriptor.getReadMethod();
						for(Object relObj:values){
							Collection<?> relCollValues=(Collection<?>)relReadMethod.invoke(relObj, new Object[0]);
							securityManager.checkMergePermission(req,relObj);
							relCollValues.remove(o);
							em.merge(relObj);
						}
						values.clear();
					}else if(oneToOneAnnotation!=null){
						CascadeType[] cascadeTypes = oneToOneAnnotation
								.cascade();
						for (CascadeType ct : cascadeTypes) {
							if (ct.equals(CascadeType.ALL)
									|| ct.equals(CascadeType.REMOVE)) {
								cascadeRemove = true;
								break;
							}
						}
						if (cascadeRemove)
							continue;
						Class<?> returnType = rm.getReturnType();
						Object relObj = rm.invoke(o, new Object[0]);
						if (relObj == null) {
							// no relationship set
							continue;
						}

						ExtBeanInfo relBeanInfo = PersistenceIntrospector
								.getPersistenceBeanInfo(returnType);
						PropertyDescriptor[] relPPds = relBeanInfo
								.getPersistencePropertyDescriptors();
						String mappedBy = oneToOneAnnotation.mappedBy();
						if (mappedBy != null && !mappedBy.equals("")) {
							// not owning
							for (PropertyDescriptor relPpd : relPPds) {
								if (relPpd.getName().equals(mappedBy)) {
									Method relWm = relPpd.getWriteMethod();
									securityManager.checkMergePermission(req,
											relObj);
									relWm.invoke(relObj, new Object[] { null });

									em.merge(relObj);
									break;
								}
							}
						} else {
							// owning

							for (PropertyDescriptor relPpd : relPPds) {
								Method relRm = relPpd.getReadMethod();
								OneToOne relOneToOneAnno = relRm
										.getAnnotation(OneToOne.class);
								if (relOneToOneAnno != null) {
									String mappedby = relOneToOneAnno
											.mappedBy();
									if (mappedby != null
											&& mappedby.equals(ppd.getName())) {
										Method relWm = relPpd.getWriteMethod();
										securityManager.checkMergePermission(
												req, relObj);
										relWm.invoke(relObj,
												new Object[] { null });
										break;
									}

								}
							}

				}
						
					}
				}
			}
			em.remove(o);
			return o;
		//	beanModel=new BeanModel(o);
		//	processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
			throw new ControllerException(e);
		} catch (IntrospectionException e) {
			e.printStackTrace();
			throw new ControllerException(e);
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			throw new ControllerException(e);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
			throw new ControllerException(e);
		} 
	}
	
//	 To be overriden by custom controllers
	//protected abstract void checkReadPermission(HttpServletRequest req, Object o) throws PermissionDeniedException;
	//protected abstract void checkPersistPermission(HttpServletRequest req, Object o) throws PermissionDeniedException;
	//protected abstract void checkMergePermission(HttpServletRequest req, Object o) throws PermissionDeniedException;
	//protected abstract void checkRemovePermission(HttpServletRequest req, Object o) throws PermissionDeniedException;

	
	public BeanTableModel<?> getBeanTableModel(HttpServletRequest request) throws ControllerException {
		if(beanTableModel==null)createBeanTableModel(request);
		return beanTableModel;
	}

	public BeanTableModel<?> getBeanTableModel(){
		return beanTableModel;
	}
	public int getFirstItem() {
		return firstItem;
	}


	public int getBatchSize() {
		return batchSize;
	}

	public void processNamedQuery(HttpServletRequest req,String namedQuery, Object[] params) throws ControllerException {
		currentRequest=req;
		clear();
		processListRequest(req);
	}

	
	public void createBeanTableModel(HttpServletRequest request) throws ControllerException {
		createBeanTableModel(request.getParameter(KEY_CMD),request);
	}

	public void createBeanTableModel(String cmd,HttpServletRequest request) throws ControllerException {
		
		createBeanTableModel(cmd, new BeanTableModel<T>(),request);
	}

	public void selectItem(HttpServletRequest request) throws ControllerException{
		HashMap<String,String[]> pMap=(HashMap<String, String[]>) request.getParameterMap();
		setSelectedItemId(request, createIdObject(pMap));
	}
	
	
	public void changeSelectedItemIds(HttpServletRequest request) throws ControllerException{

		Map<String,String[]> pMap=request.getParameterMap();
		setSelectedItemId(request, createIdObject(pMap));
	}
	
	public void createEmptyBeanTableModel(HttpServletRequest request){
		beanTableModel=new BeanTableModel<T>();
		beanTableModel.setBatchSize(batchSize);
		beanTableModel.setExtBeanInfo(beanInfo);
		beanTableModel.setItems(new ArrayList<T>());
		beanTableModel.setItemCount(0);
	}

	@SuppressWarnings("unchecked")
	public void createBeanTableModel(String command, BeanTableModel<T> btm,
			HttpServletRequest request) throws ControllerException {

		btm.setBatchSize(batchSize);
		btm.setExtBeanInfo(beanInfo);

		if (CMD_LIST_RELATED.equals(command)) {
			mode=new ListMode();
			processRelationShip(request.getParameterMap());
			command=CMD_LIST; // TODO necessary to change command here ?
		}else if (CMD_SELECT_TO_RESET.equals(command)) {
			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
			ListMode lm=new ListMode();
			lm.setSelectMode(new SelectMode(SelectMode.ActionType.RESET,request.getParameter(KEY_ACTION),selectTargetProperty));
			mode=lm;
			processRelationShip(request.getParameterMap());
			//createBeanTableModel(command,btm,request);
		}
		if (mode != null && mode instanceof ListMode) {
			btm.setSelectMode(((ListMode) mode).getSelectMode());
		}
		EntityManager em = getThreadEntityManager();
		
		PersistenceObjectIdentifier poi=getRelatedObjectIdentifier();
		
		Class<?> targetClass=poi.getTargetClass();
		List<T> resultList=new ArrayList<T>();
		int itemCount=resultList.size();
		try {
			ExtBeanInfo targetBi=PersistenceIntrospector.getExtendedBeanInfo(targetClass);
			PropertyDescriptor relPd=targetBi.getPersistencePropertyDescriptor(relatedPropertyName);
			Object targetObj=em.find(targetClass,poi.getIdObject());
			Method rm=relPd.getReadMethod();
			Object resObj=rm.invoke(targetObj);
			
			if(!queryMembers){
				resultList.addAll(Arrays.asList(this.enumValues));
			}
			if(resObj instanceof Collection<?>){
				Collection<T> resCol=(Collection<T>)resObj;
				for(T enumVal:this.enumValues){
					if(!resCol.contains(enumVal)){
						if(queryMembers){
							resultList.add(enumVal);
						}else{
							resultList.remove(enumVal);
						}
					}
				}
			
			}
			itemCount=resultList.size();
		} catch (IntrospectionException e1) {
			
			e1.printStackTrace();
			throw new ControllerException(e1);
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		
		if (CMD_LIST_SELECT_ITEM.equals(command)
				|| CMD_LIST_SELECT_MULTI.equals(command)) {

			selectItem(request);
		} 
		
		if (firstItem > itemCount - 1) {
			firstItem = 0;
		}
		
		List<T> safeItems=new ArrayList<T>();
		for (T o : resultList) {
			if(securityManager!=null){
				if(!dropInSecureItems){
					securityManager.checkReadPermission(request, o);
				}else{
					if(securityManager.getReadPermission(request, o)){
						safeItems.add(o);
					}	
				}
			}
			setPropertiesAfterQuery(request, em, o);
		}
		
		
		if(dropInSecureItems){
			itemCount=safeItems.size();
			btm.setItems(safeItems);
		}else{
			btm.setItems(resultList);
		}
		
		btm.setItemCount(itemCount);
		btm.setFirstItem(firstItem);
		btm.setLastItem(firstItem + batchSize >= itemCount ? itemCount - 1
				: firstItem + batchSize - 1);
		
		
		if (selectedItemId != null) {
			btm.setSelectedRowsIds(new Object[] { selectedItemId });
		}
		// btm.setBeanClass(queryType);
		btm.setExtBeanInfo(getBeanInfo());
		beanTableModel = btm;
	}

	protected void setPropertiesAfterSelect(HttpServletRequest request, Object selObject) {
		// Does nothing
		// To be overridden by controller subclasses
	}
	
	protected void setPropertiesAfterSelect(HttpServletRequest request, Set<Object> selObjects) {
		// Does nothing
		// To be overridden by controller subclasses
	}

	
	public void createBeanModel(HttpServletRequest request) throws ControllerException{	
		Map<String,String[]> map = request.getParameterMap();
		Object idObj = createIdObject(map);
		EntityManager em = getThreadEntityManager();
		
		T editItem;
		try {
			
			editItem = em.find(queryType, idObj);
			if(editItem==null){
				throw new NoSuchObjectException(idObj);
			}
			PersistenceMapConverter mapConverter = new PersistenceMapConverter();
			try {
				mapConverter.setBeanProperties(editItem, map, em, false,request,securityManager);
				securityManager.checkReadPermission(request, editItem);
				beanModel=new BeanModel<T>(editItem);
			} catch (MapConverterException e) {
				e.printStackTrace();
				throw new ControllerException(
						"Could not apply property values.", e);
			}
		} catch (PersistenceException e) {
			e.printStackTrace();
			close();
			throw e;
		}
	}
	
	
	public T getItem() throws ControllerException {

		
		if(beanModel!=null){
			return beanModel.getBean();
		}else{
			return null;
		}

	}

	
	
	public List<String> getDisplayColumns() {
		return displayColumns;
	}

	protected void setPropertiesOnNew(Object bean) {
		// Does nothing
		// To be overwritten by special controllers
	}

	protected void setPropertiesOnCreate(HttpServletRequest request,EntityManager em,Object bean) {
		// Does nothing
		// To be overwritten by special controllers
	}
	
	protected void setPropertiesAfterQuery(HttpServletRequest request,EntityManager em,Object o) {
		// Does nothing
		// To be overwritten by special controllers
	}
	

	public ValidationResult validate(Object o,ValidationResult validationResult) throws ValidationException{
		FormConfiguration formConfiguration=getFormConfiguration();
		ValidationResult vr=validationResult;
		boolean defaultRequired=false;
		if(vr==null){
		vr=new ValidationResult();
		}
		if (queryType.isAssignableFrom(o.getClass())){
			
			
//			if(formConfiguration!=null){
//				boolean formRequired=formConfiguration.isDefaultRequired();
//				boolean formShow=formConfiguration.isDefaultShow();
//				defaultRequired=formRequired&&formShow;
//			}
			PropertyDescriptor[] pPds=beanInfo.getPersistencePropertyDescriptors();
			for (PropertyDescriptor pd:pPds){
				String pdName=pd.getName();
				PropertyValidationResult prVr=vr.getPropertyValidationResult(pdName);
				// Ignore already existing errors
				if(prVr==null || prVr.isValid()){
					boolean required=defaultRequired;
					if(formConfiguration!=null){
						List<PropertyConfiguration> propCfgs=formConfiguration.getPropertyConfigurations();
						for(PropertyConfiguration pCfg:propCfgs){
							if(pd.equals(pCfg.getPropertyDescriptor())){
								required=pCfg.isRequired()&&pCfg.isShow();
								break;
							}
						}
					}
					Method rm=pd.getReadMethod();
					Object val;
					try {
						val = rm.invoke(o, new Object[]{});
					} catch (Exception e) {
						e.printStackTrace();
						throw new ValidationException(e);
					}
					Column colAnno=pd.getReadMethod().getAnnotation(Column.class);

					if(colAnno!=null){
						// check nullable
						if(! colAnno.nullable() && val==null){
							vr.setType(ValidationResult.Type.ERRORS);
							LocalizableMessage msg=new LocalizableMessage(beanInfo.getResourceBundleName(),"validation.field.must_be_set");
							vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR,msg));
						}

						if(required){
							if(val==null || pd.getPropertyType().equals(String.class) && "".equals(val)){
								vr.setType(ValidationResult.Type.ERRORS);
								vr.putPropertyValidationResult(pd.getName(),new PropertyValidationResult(PropertyValidationResult.Type.ERROR,VALIDATION_MSG_FIELD_REQUIRED));

							}

						}
						// check length of string
						if(pd.getPropertyType().equals(String.class)){
							if(val!=null && ((String)val).length() > colAnno.length()){
								vr.setType(ValidationResult.Type.ERRORS);
								LocalizableMessage msg=new LocalizableMessage(beanInfo.getResourceBundleName(),"validation.field.too_long");
								vr.putPropertyValidationResult(pd.getName(),new PropertyValidationResult(PropertyValidationResult.Type.ERROR,msg));
							}
						}
					}
				}
			}
		}else{
			throw new ValidationException("Object has not type of controller !");
		}
		
		return vr;
	}
	
	
	protected void apply(HttpServletRequest request, String command)
			throws ControllerException {
		Map<String,String[]> map = request.getParameterMap();
		BeanModel<?> newBeanModel=null;
		T newItem= null;
		try {
			newItem = queryType.newInstance();
		} catch (InstantiationException e1) {

			e1.printStackTrace();
			throw new ControllerException(e1);
		} catch (IllegalAccessException e1) {
			e1.printStackTrace();
			throw new ControllerException(e1);
		}
		
		EntityManager em = getThreadEntityManager();
		//securityManager.checkPersistPermission(request, newItem);
//		boolean idGenerated=beanInfo.isIdGenerated();
		// pre persist the item
//		if(idGenerated){
//			em.persist(newItem);
//		}
			setPropertiesOnCreate(request,em,newItem);
			PersistenceMapConverter mapConverter = new PersistenceMapConverter();
			try {
				//mapConverter.setBeanProperties(newItem, map, em, true,request,securityManager);
				newBeanModel=mapConverter.createBeanModel(newItem, map, em, false, request, securityManager);
			} catch (MapConverterException e) {
				e.printStackTrace();
				//if(idGenerated)em.remove(newItem);
				rollback();
				Throwable cause=e.getCause();
				if(cause instanceof ControllerException){
					throw (ControllerException)cause;
				}
				throw new ControllerException("Could not apply properties.", e);
			}
			ExtBeanInfo bInfo = getBeanInfo();
			if (bInfo.getIdPropertyDescriptor() != null && !isIdGenerated()) {
				// check if id already exists
				Object idO;
				try {
					idO = bInfo.getIdValue(newItem);
				} catch (Exception e) {
					
					e.printStackTrace();
					em.remove(newItem);
					throw new ControllerException(e);
				}
				Object exO = em.find(bInfo.getBeanDescriptor().getBeanClass(),
						idO);
				if (exO != null) {
					throw new ObjectAlreadyExistsException(idO);
				}
			}
		
			ValidationResult validationResult=null;
			try {
				validationResult=validate(newBeanModel.getBean(),newBeanModel.getValidationResult());
			} catch (ValidationException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			}
			processResult=new ProcessResult(validationResult);
//			if (validationResult.isValid()) {
//			securityManager.checkMergePermission(request, newItem);
//			if(idGenerated){
//				em.merge(newItem);
//			}else{
//				em.persist(newItem);
//			}
//			em.flush();
//		}else{
//			
////			 rollback does not remove the new item !!! TopLink Bug ?
//			//em.remove(newItem);
//			rollback();
//
//			
//		}
			
			beanModel=new BeanModel<T>(newItem,validationResult);
			
		//mode=new ListMode();
		//item=o;
		//createViewModel(request);
		//createBeanTableModel(command,request);
	}
	
	
	
	private void processRelationShip(Map<String, String[]> queryMap)
			throws ControllerException {
//		ExtBoolExpr relatedCondition = null;

		// String qc=null;
		PersistenceObjectIdentifier poi;
		try {
			poi = PersistenceObjectIdentifier.parseQueryMap(queryMap);
		} catch (ParserException e1) {

			e1.printStackTrace();
			throw new ControllerException(
					"Could not parse object identifier from query map.", e1);
		} catch (IntrospectionException e1) {
			e1.printStackTrace();
			throw new ControllerException("Could not introspect class.", e1);
		}
		PropertyDescriptor[] ppds = beanInfo
				.getPersistencePropertyDescriptors();

		// String idStr = queryMap.get(KEY_RELATED_ID)[0];
		String propertyName = null;
		relatedPropertyName = null;
		String[] mappedByArr = queryMap.get(KEY_MAPPEDBY);
		
		if (mappedByArr != null) {
			// ManyToOne
			propertyName = mappedByArr[0];
			for (PropertyDescriptor pd : ppds) {
				if (pd.getName().equals(propertyName)) {
					break;
				}
			}
		} else {
			// OneToMany,ManyToMany,OneToOne
			String[] relatedPropArr=queryMap.get(KEY_RELATED_PROPERTY);
			if(relatedPropArr==null || relatedPropArr.length!=1){
				throw new ControllerException("Related property name missing in query (parameter '"+KEY_RELATED_PROPERTY+"'");
			}
			relatedPropertyName = relatedPropArr[0];
			
		}

		if(mode !=null && mode instanceof ListMode){
			SelectMode selectMode=((ListMode) mode).getSelectMode();
			SelectMode.ActionType actionType = null;
			if(selectMode!=null){
				actionType=selectMode.getActionType();
			}
			// Enum is always a collection
//			if (Collection.class.isAssignableFrom(relatedType)) {
//				// we need the parameterized type argument e.g. Person
//				// for method: Set<Person> getPersons()
//				Type rt = readMethod.getGenericReturnType();
//				if (rt instanceof ParameterizedType) {
//					ParameterizedType prt = (ParameterizedType) rt;
//					Type[] pts = prt.getActualTypeArguments();
//					if (pts.length != 1) {
//						throw new ControllerException(
//								"Parameterized type "
//										+ prt
//										+ " has not exactly one type argument\nCannot get bean info of property return type.");
//					}
//				} else {
//					throw new ControllerException(
//							"Property "
//									+ relatedPropertyName
//									+ " is not prameterized.\nCannot create Id object for unknown type!");
//				}

				if(actionType==null){
//					relatedCondition = new ExtBoolExpr();
//					relatedCondition.setOperator(ExtBoolExpr.NOT_MEMBER);
					queryMembers=false;
				}else if (actionType.equals(ActionType.ADD)) {

//					relatedCondition = new ExtBoolExpr();
//					relatedCondition.setOperator(ExtBoolExpr.MEMBER);
					queryMembers=true;
				} else if (actionType.equals(ActionType.REMOVE)) {
//					relatedCondition = new ExtBoolExpr();
//					relatedCondition.setOperator(ExtBoolExpr.NOT_MEMBER);
					queryMembers=false;
				} else if (actionType.equals(ActionType.SET)) {
					// do not set a condition
				}else if (actionType.equals(ActionType.RESET)) {
//					relatedCondition = new ExtBoolExpr();
//					relatedCondition.setOperator(ExtBoolExpr.NOT_MEMBER);
					queryMembers=false;
				} 

//			} else {
//				// related type is the return type of the getter method
//				// e.g. Person getPerson()
//				//relatedReturnType = relatedPropertyDescriptor.getPropertyType();
//				if (actionType==null || actionType.equals(ActionType.REMOVE)) {
//					relatedCondition = new ExtBoolExpr();
//					relatedCondition.setOperator(ExtBoolExpr.EQUALS);
//				}else if (actionType.equals(ActionType.ADD)) {
//					relatedCondition = new ExtBoolExpr();
//					//relatedCondition.setOperator(ExtBoolExpr.EQUALS_NOT);
//					// we need IS NULL here !!
//					relatedCondition.setOperator(ExtBoolExpr.NOT_BOUND);
//				}  
//
//			}		
			
		}
		setRelatedObjectIdentifier(poi);
	}


	
	
	public void processListRequest(HttpServletRequest req) throws ControllerException{
		currentRequest=req;
		clear();
		if(!(mode instanceof ListMode)){
			mode=new ListMode();
		}
		createBeanTableModel(req.getParameter(KEY_CMD),req);
	}
	
//	public void processListRequest(String command) throws ControllerException{
//		mode=new ListMode();
//		createBeanTableModel(command);
//	}
	
	public String processCommand(HttpServletRequest request,String[] possibleSubmitCommands){
		String command = request.getParameter(KEY_CMD);
		
		// find submit commands
		for (String possibleSubmitCmd :possibleSubmitCommands) {
			if (request.getParameter("_" + possibleSubmitCmd) != null) {
				command = possibleSubmitCmd;
				break;
			}
		}
		return command;
	}
	public String processCommand(HttpServletRequest request){
		return processCommand(request,SUBMIT_CMDS);
	}
	/**
	 * Compatibility method implementation only.
	 * @throws ControllerException 
	 */
	public ProcessResult process(HttpServletRequest request,HttpServletResponse response,Servlet servlet) throws ControllerException{
		processRequest(request);
		return getProcessResult();
	}
	/**
	 * Compatibility method implementation only.
	 * @throws ControllerException 
	 */
	public ProcessResult process(HttpServletRequest request,HttpServletResponse response) throws ControllerException{
		processRequest(request);
		return getProcessResult();
	}
	
	@SuppressWarnings("unchecked")
	public void processRequest(HttpServletRequest request)
			throws ControllerException {
		currentRequest=request;
		clear();
		if (request.getCharacterEncoding() == null) {
			try {
				request.setCharacterEncoding("UTF-8");
			} catch (UnsupportedEncodingException e) {
				throw new ControllerException(e);
			}
		}
		Map<String,String[]> queryMap=request.getParameterMap();
		String command=processCommand(request);
		if(command!=null && command.equals(CMD_CANCEL)){
			beanModel=new BeanModel<T>((T)null,new ValidationResult(ValidationResult.Type.CANCELLED));
			processResult=new ProcessResult(ProcessResult.Type.CANCELLED);
			actionCanceled=true;
			return;
		}
		
		
		// set default command
		// and translate cancel commands
		if (command == null || command.equals(CMD_CANCEL))command = CMD_LIST;
		
	
		if (CMD_LIST_RELATED.equals(command)) {
//			setNamedQuery(null, null);
//			setBoolCondition(null);
			mode=new ListMode();
			processRelationShip(queryMap);
			createBeanTableModel(CMD_LIST,request);
		}else if (command.equals(CMD_SELECT_TO_ADD)) {
//			setNamedQuery(null, null);
//			setBoolCondition(null);
			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
			ListMode lm=new ListMode();
			lm.setSelectMode(new SelectMode(SelectMode.ActionType.ADD,request.getParameter(KEY_ACTION),selectTargetProperty));
			mode=lm;
			BeanTableModel<T> btm = new BeanTableModel<T>();
			processRelationShip(queryMap);
			
			createBeanTableModel(command,btm,request);
		}else if (command.equals(CMD_SELECT_TO_REMOVE)) {
//			setNamedQuery(null, null);
//			setBoolCondition(null);
			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
			ListMode lm=new ListMode();
			lm.setSelectMode(new SelectMode(SelectMode.ActionType.REMOVE,request.getParameter(KEY_ACTION),selectTargetProperty));
			mode=lm;
			BeanTableModel<T> btm = new BeanTableModel<T>();
			processRelationShip(queryMap);
			
			createBeanTableModel(command,btm,request);
		}else if (command.equals(CMD_SELECT_TO_SET)) {
//			setNamedQuery(null, null);
//			setBoolCondition(null);
			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
			ListMode lm=new ListMode();
			lm.setSelectMode(new SelectMode(SelectMode.ActionType.SET,request.getParameter(KEY_ACTION),selectTargetProperty));
			mode=lm;
			BeanTableModel<T> btm = new BeanTableModel<T>();
			processRelationShip(queryMap);
			createBeanTableModel(command,btm,request);
		}else if (command.equals(CMD_SELECT_TO_RESET)) {
//			setNamedQuery(null, null);
//			setBoolCondition(null);
//			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
//			ListMode lm=new ListMode();
//			lm.setSelectMode(new SelectMode(SelectMode.ActionType.RESET,request.getParameter(KEY_ACTION),selectTargetProperty));
//			mode=lm;
			BeanTableModel<T> btm = new BeanTableModel<T>();
			createBeanTableModel(command,btm,request);
		}else if (command.equals(CMD_LIST)) {
			mode=new ListMode();
			processListRequest(request);
		}else if (command.startsWith(CMD_LIST)) {
			processListRequest(request);
	
		} else if (command.equals(CMD_CORRECT) || command.equals(CMD_VIEW)) {

			createBeanModel(request);
			
			if(command.equals(command.equals(CMD_CORRECT))){
				mode=new EditMode();
			}else{
				mode=new ViewMode();
			}
		}
	}

	protected Object createIdObject(Map<String,String[]> map) throws ControllerException {
		Object idObj = null;
		if (beanInfo.isIdEmbedded()) {
			
			// embedded (compound) ID's are coded either with
			// keys for each attribute of the ID or as
			// as single string id (required for relationship operations
			// otherwise the query map gets topo complicated)
			
			PropertyDescriptor idPd = beanInfo.getIdPropertyDescriptor();
			// construct embedded id object

			try {
				idObj = idPd.getPropertyType().newInstance();
			} catch (Exception e) {

				e.printStackTrace();
				throw new ControllerException(e);
			}

			// construct "toplevel" property map
			// with key for each attribute of the compound key

			HashMap<String,String[]> embProps = new HashMap<String, String[]>();
			Set<Map.Entry<String,String[]>> entries2 = map.entrySet();
//			Iterator ei2 = entries2.iterator();
//			while (ei2.hasNext()) {
			for(Map.Entry<String,String[]> entry2:entries2){
//				Map.Entry<String,String[]> entry2 = ei2.next();
				String key2 =entry2.getKey();
				// Object value2 = entry2.getValue();

				int dotIndex2 = key2.indexOf('.');
				String keyName2 = null;
				String deepProperty2 = null;
				if (dotIndex2 > 0) {
					keyName2 = key2.substring(0, dotIndex2);
					deepProperty2 = key2.substring(dotIndex2 + 1);
					if (!keyName2.equals(idPd.getName())) {
						continue;
					}
					embProps.put(deepProperty2, entry2.getValue());
				}
			}
			
			if(embProps.size()>0){
			// apply map
			MapConverter embMc = new MapConverter();
			try {
				embMc.setBeanProperties(idObj, embProps);
				return idObj;
			} catch (MapConverterException e) {

				e.printStackTrace();
				throw new ControllerException(e);
			}
			}else{
				// TODO chack this code!
				// fall back to single String constructor below
				
			}
		} 
			String[] idStrs = map.get(beanInfo
					.getIdPropertyDescriptor().getName());
			if (idStrs != null && idStrs.length == 1 && idStrs[0] != null) {
				String idStr = idStrs[0];
				try {
					idObj = beanInfo.createIdValueByString(idStr);
					if (idObj == null)
						throw new ControllerException(
								"Could not get item with id=" + idStr);
					setId(idObj);
				} catch (Exception e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}
			} else {
				// try object identifier
				try {
					PersistenceObjectIdentifier poi = PersistenceObjectIdentifier.parseQueryMap(map);
					if(poi!=null){
						idObj=poi.getIdObject();
					}
				} catch (Exception e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}

			}
		
		return idObj;
	}
	
	
	public void rollback(){
		EntityManager em = getThreadEntityManager();
		if (em != null) {
			EntityTransaction tx = null;
				tx = em.getTransaction();
				if (tx!=null && tx.isActive()) {
					tx.rollback();
				}
		}
	}
	
	public void commit() throws ControllerException{
		EntityManager em = getThreadEntityManager();
		if (em != null) {
			EntityTransaction tx = null;
			try {
				tx = em.getTransaction();
				if (tx!=null && tx.isActive()) {
					tx.commit();
				}
			} catch (PersistenceException e) {
				e.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();

//				setBoolCondition(null);
				throw new ControllerException(e);
			} catch (IllegalStateException ise) {
				ise.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();

//				setBoolCondition(null);
				throw new ControllerException(ise);
			} catch (Exception e) {
				e.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();
				throw new ControllerException(e);
			} 
		}
	}
	
	protected void clear(){
		processResult=null;
		beanModel=null;
		beanTableModel=null;
		//validationResult=null;
		actionCanceled=false;
		
	}
	
	public synchronized void close()  {

		EntityManager em = getThreadEntityManager();
		
		// for open JPA it is required to   
		try {
			commit();
		} catch (ControllerException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (em != null) {
			em.close();
		}
		
		removeEntityManagerThreadLocal();
	}

	public ExtBoolExpr getBoolCondition() {
		return null;
	}

	public OrderByClause getOrderByClause() {
		return null;
	}

	public String getNamedQuery() {
		return null;
	}


	public void setDisplayColumns(List<String> displayColumns) {
		this.displayColumns = displayColumns;
	}

	public boolean isIdGenerated() {
		return idGenerated;
	}

	public void setIdGenerated(boolean idGenerated) {
		this.idGenerated = idGenerated;
	}

	public Object getId() {
		return id;
	}

	public void setId(Object id) {
		this.id = id;
	}

	public String getKEY_SELECT_TARGET_PROPERTY() {
		return KEY_SELECT_TARGET_PROPERTY;
	}

	public String getKEY_SELECT_TARGET_ID() {
		return KEY_SELECT_TARGET_ID;
	}

	public String getKEY_SELECT_TARGET_ID_PROPERTY() {
		return KEY_SELECT_TARGET_ID_PROPERTY;
	}

	public String getKEY_SELECTED_ID() {
		return KEY_SELECTED_ID;
	}

	public String getKEY_ACTION() {
		return KEY_ACTION;
	}

	public void setBatchSize(int batchSize) {
		this.batchSize = batchSize;
	}
	
	public PersistenceObjectIdentifier getRelatedObjectIdentifier() {
		return relatedObjectIdentifier;
	}

	public void setRelatedObjectIdentifier(
			PersistenceObjectIdentifier relatedObjectIdentifier) {
		this.relatedObjectIdentifier = relatedObjectIdentifier;
	}

	public Object getSelectedItemId() {
		return selectedItemId;
	}
	
	public Object getSelectedItem() {
		if(selectedItemId==null)return null;
		EntityManager em=getThreadEntityManager();
		Object ret=em.find(queryType, selectedItemId);
		return ret;
	}

	public void setSelectedItemId(HttpServletRequest request,Object selectedItemId) {
		this.selectedItemId = selectedItemId;
		setPropertiesAfterSelect(request, selectedItemId);
	}

	public void setSelectedItemIds(HttpServletRequest request,Set<Object> selectedItemIds) {
		this.selectedItemIds = selectedItemIds;
		setPropertiesAfterSelect(request, selectedItemIds);
	}

	public Set<Object> getSelectedItemIds() {
		return selectedItemIds;
	}

	public boolean isActionCanceled() {
		return actionCanceled;
	}

	public BeanModel<T> getBeanModel() {
		return beanModel;
	}

	public ProcessResult getProcessResult() {
		return processResult;
	}

	public static String getKEY_PREFIX_DELETE_RELATED() {
		return KEY_PREFIX_DELETE_RELATED;
	}

	public SecurityManager getSecurityManager() {
		return securityManager;
	}

	public void setSecurityManager(SecurityManager securityManager) {
		this.securityManager = securityManager;
	}

	public boolean isDropInSecureItems() {
		return dropInSecureItems;
	}

	public void setDropInSecureItems(boolean dropInSecureItems) {
		this.dropInSecureItems = dropInSecureItems;
	}

}
