package ipsk.webapps;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NoResultException;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ips.beans.PersistenceMapConverter;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverter;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.form.FormConfiguration;
import ipsk.beans.form.PropertyConfiguration;
import ipsk.beans.validation.BeanValidator;
import ipsk.beans.validation.Input;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.BeanTableModel;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.net.BoolExprQueryParser;
import ipsk.net.OrderByQueryParser;
import ipsk.persistence.Delegate;
import ipsk.persistence.EntityManagerProviderImpl;
import ipsk.persistence.ImmutibilityProvider;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.PersistenceBoolExpr;
import ipsk.persistence.PersistenceBoolExprConverter;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.SecurityManager;
import ipsk.sql.OrderByClause;
import ipsk.text.ParserException;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.SelectMode.ActionType;

public abstract class BasicPersistenceBeanController<T> extends EntityManagerProviderImpl implements BeanTableController,BeanValidator {

	public static class Mode{}
	public static class ListMode extends Mode{
		private SelectMode selectMode=null;
		
		public SelectMode getSelectMode() {
			return selectMode;
		}
		public void setSelectMode(SelectMode selectMode) {
			this.selectMode = selectMode;
		}
		
	}
	public static class SingleMode extends Mode{}
	public static class EditMode extends SingleMode{}
	public static class ViewMode extends SingleMode{}
	
	
	
//	public static class QueryResult{
//		private List resultList=null;
//		private Object singleResult=null;
//		
//		public QueryResult(Object singleResult){
//			this.singleResult=singleResult;
//		}
//		public QueryResult(List resultList){
//			this.resultList=resultList;
//		}
//		
//		public int getItemCount(){
//			if(singleResult!=null)return 1;
//			if(resultList==null)return 0;
//			return resultList.size();
//		}
//		public List getResultList() {
//			return resultList;
//		}
//		public Object getSingleResult() {
//			return singleResult;
//		}
//		
//	}
	
	public final static int DEFAULT_BATCHSIZE = 20;
	public final static int MAX_BATCHSIZE = 1000;

	// Toplink Essentials JPA implementation does not work with
	// full classified class names in JPA queries e.g.
	// SELECT o FROM ipsk.speechdb.Person AS o; -> syntax error
	// SELECT o FROM Person AS o; -> OK
	// it is the JPA specification, not a Toplink bug  
	public final static boolean USE_FULL_QUALIFIED_CLASSNAMES_IN_QUERY = false;

	// key for command
	public final static String KEY_CMD = "_cmd";
	
	public final static String KEY_MODEL_REQUEST="_model_req";

	// key for action reference
	public final static String KEY_ACTION = "_action";
	
	public final static String KEY_QUERY_NAME="name";

	//public final static String KEY_RELATED_ID = "_related_id";

	// key for JPA mappedby attribute
	public final static String KEY_MAPPEDBY = "_related_mappedby";

	public final static String KEY_RELATED_PROPERTY = "_related_prop";

	// the property
	public final static String KEY_SELECTED_PROPERTY = "_sel_prop";

	public final static String KEY_SELECTED_ID = "_sel_id";

	//public final static String KEY_SELECT_TARGET_CLASS = "_sel_trg_class";

	public final static String KEY_SELECT_TARGET_PROPERTY = "_sel_trg_prop";

	public final static String KEY_SELECT_TARGET_ID_PROPERTY = "_sel_trg_id_prop";

	public final static String KEY_SELECT_TARGET_ID = "_sel_trg_id";
	
	public final static String KEY_PREFIX_DELETE_RELATED="_delete_rel";
	
	public final static String KEY_PREFIX_DEFAULT_DESELECT="_default_deselect";
	
	
	// list command
	public final static String CMD_LIST = "list";

	public final static String CMD_LIST_RELATED = "list_related";
	public final static String CMD_SELECT_TO_ADD = "select_to_add";
	public final static String CMD_SELECT_TO_REMOVE = "select_to_remove";
	public final static String CMD_SELECT_TO_DELETE = "select_to_delete";
	public static final String CMD_SELECT_TO_SET = "select_to_set";
	public static final String CMD_SELECT_TO_RESET = "select_to_reset";
	
	public final static String CMD_LIST_ALL = "list_all";

	public final static String CMD_LIST_FIRST = "list_first";

	public final static String CMD_LIST_PREVIOUS = "list_previous";

	public final static String CMD_LIST_NEXT = "list_next";

	public final static String CMD_LIST_LAST = "list_last";
	
	public static final String CMD_LIST_NUM_ROWS_PAGE = "list_num_rows_page";
	
	public static final String CMD_LIST_ADD_COL = "list_add_col";

	public static final String CMD_LIST_REMOVE_COL = "list_remove_col";

	public static final String CMD_LIST_COLS_RESET = "list_cols_reset";

	public static final String CMD_LIST_APPLY_COND = "list_apply_cond";

	public static final String CMD_LIST_ORDER_BY = "list_order_by";
	
	public static final String CMD_LIST_CHANGE_SELECTION = "list_change_sel";
	public static final String CMD_CANCEL_LIST_CHANGE_SELECTION = "list_change_sel";

	public static final String CMD_NAMED_QUERY = "named_query";

	public static final String CMD_NAMED_QUERY_SINGLE = "named_query_single";


	// create new object
	public static final String CMD_NEW = "new";
	public static final String CMD_NEW_TO_ADD = "new_to_add";
	// apply properties to object
	public static final String CMD_APPLY = "apply";
	// apply properties to existing object
	public static final String CMD_MERGE = "merge";
	// add (persist) to database
	public static final String CMD_ADD = "add";
	//public static final String CMD_CONFIRMED_ADD = "add_confirmed";
	public static final String CMD_ADD_ADD = "add_add";
	public static final String CMD_STORE = "store";
	
	public static final String CMD_STORE_ADD_RELATED = "store_add_related";
	public static final String CMD_STORE_REMOVE_RELATED = "store_remove_related";
	public static final String CMD_STORE_DELETE_RELATED = "store_delete_related";
	public static final String CMD_STORE_SET_RELATED = "store_set_related";
	public static final String CMD_STORE_RESET_RELATED = "store_reset_related";
	
	public static final String CMD_EXPORT = "export";
	
	/**
	 * Removes object. 
	 */
	public static final String CMD_REMOVE = "remove";
	/**
	 * Removes relationships to other objects, then removes object.
	 */
	public static final String CMD_DELETE = "delete";

	public static final String CMD_EDIT = "edit";
	public static final String CMD_EDIT_OR_NEW = "edit_or_new";
	public static final String CMD_CORRECT="correct";

	public static final String CMD_LIST_SELECT_ITEM = "list_select_item";

	public static final String CMD_LIST_SELECT_MULTI = "list_select_multi";

	public static final String CMD_VIEW = "view";
	public static final String CMD_VIEW_TO_DELETE = "view_to_delete";

	public static final String CMD_CANCEL = "cancel";
	public static final String CMD_CANCEL_STORE_RELATED = "cancel_store_related";
	
	//public static final String MODEL_LIST="list";
	//public static final String MODEL_SINGLE="single";

	public static final String KEY_LOCALE = "_locale";
	
	public static final String KEY_ROWS = "rows";

	public static final String VAL_SELECT_ADD = "select_add";
	public static final String VAL_SELECT_REMOVE = "select_remove";

	//public static final String KEY_SELECT_CMD = "select_cmd";

	public static final String JPQL_PARAM_NAME_PREFIX="basiccontroller_where_param";

	
	public String[] SUBMIT_CMDS = new String[] { CMD_CANCEL, CMD_APPLY, CMD_MERGE,CMD_EDIT,CMD_EDIT_OR_NEW, CMD_ADD,
			CMD_STORE,CMD_STORE_ADD_RELATED,CMD_STORE_REMOVE_RELATED,CMD_STORE_DELETE_RELATED,CMD_STORE_SET_RELATED,CMD_STORE_RESET_RELATED,CMD_CANCEL_STORE_RELATED, CMD_EXPORT, CMD_REMOVE,CMD_DELETE };


	protected Class<T> queryType;

	protected String queryTypeName;

	protected String jsfIdentifier;

	protected int batchSize = DEFAULT_BATCHSIZE;

	protected int firstItem = 0;

	private String namedQuery = null;
	private Query query;
	private ParameterizedQuery parameterizedQuery = null;

	//private RelatedQuery relatedQuery=null;
	private ExtBoolExpr boolCondition;

	private OrderByClause orderByClause;

	//private Object namedQueryParam;

	private Object[] namedQueryParams = null;

	//private String namedQueryParamClassName;

	private PersistenceObjectIdentifier namedQueryParam;
	
	private String[] additionalColumns;
	public String[] getAdditionalColumns() {
		return additionalColumns;
	}

	public void setAdditionalColumns(String[] additionalColumns) {
		this.additionalColumns = additionalColumns;
	}

	private List<String> displayColumns;

	protected ExtBeanInfo beanInfo = null;

	// private PropertyDescriptor idPropertyDescriptor = null;

	protected Object id;

	//private Object item = null;

	private boolean idGenerated = false;

	protected BeanTableModel<T> beanTableModel;
	private PersistenceObjectIdentifier relatedObjectIdentifier;
	private PropertyDescriptor relatedPropertyDescriptor; 
	private String qlQeryTypeName;
	//private Object selectedItem;
	private Mode mode=null;

	private boolean actionCanceled;

	private Object selectedItemId;
	private Set<Object> selectedItemIds;
	
	protected HttpServletRequest currentRequest;
	public void setCurrentRequest(HttpServletRequest currentRequest) {
		this.currentRequest = currentRequest;
	}

	protected ServletContext servletContext;

	public ServletContext getServletContext() {
		return servletContext;
	}

	public void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
	}
	
	protected Method filterMethod;
	public void setFilterMethod(Method filterMethod) {
		this.filterMethod=filterMethod;
	}

	protected SecurityManager securityManager=new SecurityManager();
	protected boolean dropInSecureItems=false;

	//private ValidationResult validationResult;
	
	protected BeanModel<T> beanModel=null;
	protected Object cancelledItem=null;
	protected ProcessResult processResult;
	
	//
	private boolean applyAllProperties=false;
	
	protected SecureRequestTokenProvider secureRequestTokenProvider=new SecureRequestTokenProvider();
	
	protected boolean checkSecureRequestToken=false;
		
	public void setCheckSecureRequestToken(boolean checkSecureRequestToken) {
		this.checkSecureRequestToken = checkSecureRequestToken;
	}
	
	public FormConfiguration getFormConfiguration() {
		return null;
	}

	public static String RESOURCE_BUNDLE_NAME="ipsk.jsp.Messages";
	
	private static LocalizableMessage VALIDATION_MSG_FIELD_REQUIRED=new LocalizableMessage(RESOURCE_BUNDLE_NAME,"validation.field.required");

	// private LocalizableMessage errorMessage = null;
	public BasicPersistenceBeanController(String persistenceUnit, Class<T> queryType) {
		this(persistenceUnit, queryType, queryType.getName());
	}

	public BasicPersistenceBeanController(String persistenceUnit, Class<T> queryType,
			String jsfIdentifier) {
		super();
		this.queryType = queryType;
		queryTypeName = queryType.getName();
		if (!USE_FULL_QUALIFIED_CLASSNAMES_IN_QUERY) {
			qlQeryTypeName = queryTypeName.substring(queryTypeName
					.lastIndexOf(".") + 1);
		} else {
			qlQeryTypeName = queryTypeName;
		}
		
		// Name attribute of @Entity annotation might override JPQL entity name
		Entity entityAnnot=queryType.getAnnotation(Entity.class);
		if(entityAnnot!=null) {
			String entityNm=entityAnnot.name();
			if(entityNm!=null && ! entityNm.isBlank()) {
				qlQeryTypeName=entityNm;
			}
		}
		
		try {
//			beanInfo = PersistenceIntrospector
//					.getPersistenceBeanInfo(queryType);
			beanInfo=PersistenceIntrospector.getExtendedBeanInfo(queryType, true, false);
		} catch (IntrospectionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();

		for (PropertyDescriptor pd : pds) {

			// Class type = pd.getPropertyType();
			Method rm = pd.getReadMethod();
			// if (rm.getAnnotation(javax.persistence.Id.class) != null
			// || rm.getAnnotation(javax.persistence.EmbeddedId.class) != null)
			// {
			// idPropertyDescriptor = pd;
			// }
			if (rm.getAnnotation(javax.persistence.GeneratedValue.class) != null) {
				setIdGenerated(true);
			}
		}
		this.jsfIdentifier = jsfIdentifier;

		//emtl=new EntityManagerThreadLocal();
		//System.out.println(getClass().getName()+": Created EMTL:"+ObjectUtil.objIdentyStr(emtl));

	}
	
	
	
	public String getSecureRequestTokenName() {
		return SecureRequestTokenProvider.SECURE_REQUEST_TOKEN_NAME;
	}
	
	public String generateSecureRequestToken() {
		return SecureRequestTokenProvider.generateSecureRequestToken(currentRequest);
	}
	
	public void open(){
		EntityManager em= getThreadEntityManager();
		if(em!=null) {
			EntityTransaction tx=em.getTransaction();
			if(tx!=null && ! tx.isActive()){
				tx.begin();
			}
		}
	}

	public ExtBeanInfo getBeanInfo() {
		try {
			return PersistenceIntrospector.getPersistenceBeanInfo(queryType);
		} catch (IntrospectionException e1) {
			return null;
		}
	}

	public PropertyDescriptor[] getBeanProperties() {
		BeanInfo beanInfo;
		try {
			beanInfo = Introspector.getBeanInfo(queryType);
		} catch (IntrospectionException e1) {
			return null;
		}
		PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();

		return pds;
	}
	
	public T getById(Object id) {
		EntityManager em = getThreadEntityManager();
		T o = em.find(queryType, id);
		return o;
	}

//	protected void deleteRelatedObject(EntityManager em,Object relObj) {
//		em.remove(relObj);
//	}
	
	
	public void deleteRelated(HttpServletRequest req,Object o) throws ControllerException{
		EntityManager em=getThreadEntityManager();
		
		Map<String,String[]> queryMap=req.getParameterMap();
		Set<String> paramKeys=queryMap.keySet();
		for(String key:paramKeys){
			if(key.startsWith(KEY_PREFIX_DELETE_RELATED)){
				String relPropStr=key.substring(KEY_PREFIX_DELETE_RELATED.length());
					if(relPropStr.startsWith(".")){
						// cut leading dot
						relPropStr=relPropStr.substring(1);
						// split into property and id property 
						int dotIndex=relPropStr.indexOf(".");
						if(dotIndex>0){
							String propertyName=relPropStr.substring(0,dotIndex);
							String propertyIdName=relPropStr.substring(dotIndex+1);
							String[] relIdStrsToDelete=queryMap.get(key);
							PropertyDescriptor pd=beanInfo.getPersistencePropertyDescriptor(propertyName);
							if(pd!=null){
								Method readMethod=pd.getReadMethod();
								Class<?> getterType=readMethod.getReturnType();
								Class<?> relatedType=null;
								if (Collection.class.isAssignableFrom(getterType)) {
									// collection 
									// we need the parameterized type argument
									
									Type rt = readMethod.getGenericReturnType();
									if (rt instanceof ParameterizedType) {
										ParameterizedType prt = (ParameterizedType) rt;
										Type[] pts = prt.getActualTypeArguments();
										if (pts.length != 1) {
											throw new ControllerException(
													"Parameterized type has not exactly one type arguemnts\nCannot get bean info of property return type.");
										}
										relatedType=(Class<?>)pts[0];
									} else {
										throw new ControllerException(
												"Property is not prameterized.\nCannot create Id object for unknown type!");
									}
									// check property IDname
									try {
										ExtBeanInfo relBeanInfo=PersistenceIntrospector.getPersistenceBeanInfo(relatedType);
										PropertyDescriptor relIdPd=relBeanInfo.getIdPropertyDescriptor();
										if(relIdPd.getName().equals(propertyIdName)){
											// OK
											Collection<?> coll=(Collection<?>) readMethod.invoke(o,new Object[0]);
											
											for(String relIdStr:relIdStrsToDelete){
												Object relId=relBeanInfo.createIdValueByString(relIdStr);
												Object relObjToDelete=em.find(relatedType, relId);
												if(coll.contains(relObjToDelete)){
													securityManager.checkRemovePermission(req, relObjToDelete);
													//em.remove(relObjToDelete);
													removeById(req,relBeanInfo,relId,true);
												}
											}
										}
									} catch (Exception e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}
									
									
								}else{
									// simple class
									try {
										ExtBeanInfo relBeanInfo=PersistenceIntrospector.getPersistenceBeanInfo(relatedType);
										PropertyDescriptor relIdPd=relBeanInfo.getIdPropertyDescriptor();
										if(relIdPd.getName().equals(propertyIdName)){
											// OK
											Object relObj= readMethod.invoke(o,new Object[0]);
											
											if(relIdStrsToDelete.length==1){
												Object relId=relBeanInfo.createIdValueByString(relIdStrsToDelete[0]);
												Object relObjToDelete=em.find(relatedType, relId);
												if(relObj!=null && relObj.equals(relObjToDelete)){
													securityManager.checkRemovePermission(req, relObjToDelete);
													removeById(req,relBeanInfo,relId,true);
												}
											}
										}
									} catch (Exception e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}
								}
							}
						}
					}
				}
			
			
		}
	}
	
	
	private boolean hasCascadeType(CascadeType[] cascadeTypes,CascadeType cascadeType){
		if(cascadeTypes==null) return false;
		for(CascadeType ct:cascadeTypes){
			if(CascadeType.ALL.equals(ct) || cascadeType.equals(ct)){
				return true;
			}
		}
		return false;
	}
	
	public boolean hasRelationShips(Object bean) throws ControllerException{
		return hasRelationShips(bean, (CascadeType)null);
	}
	
	
	
	public boolean hasRelationShips(Object bean,PropertyDescriptor propertyDescriptor) throws ControllerException{
		Object o=bean;
		Method rm = propertyDescriptor.getReadMethod();
		OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
		ManyToMany manyToManyAnno = rm
				.getAnnotation(ManyToMany.class);
		OneToOne oneToOneAnno=rm.getAnnotation(OneToOne.class);
		try {
			if (oneToManyAnno != null){

				Collection<?> values;

				values = (Collection<?>)rm.invoke(o, new Object[0]);

				if(values!= null && values.size()>0){
					return true;
				}
			}else if(manyToManyAnno!=null) {

				Collection<?> values = (Collection<?>)rm.invoke(o, new Object[0]);
				if(values!= null && values.size()>0){
					return true;
				}
			}else if(oneToOneAnno!=null){

				Object relObj = rm.invoke(o, new Object[0]);
				if (relObj != null) {
					return true;
				}
			}
		} catch (IllegalArgumentException e) {
			throw new ControllerException(e);
		} catch (IllegalAccessException e) {
			throw new ControllerException(e);
		} catch (InvocationTargetException e) {
			throw new ControllerException(e);
		}
		return false;
	}
	
	public boolean hasRelationShips(Object bean,CascadeType ignoreRemoveCascadedWith) throws ControllerException{
//		EntityManager em = getThreadEntityManager();
		try {
			Object o=bean;
//			Object o = em.find(beanInfo.getBeanDescriptor().getBeanClass(), id);
//			if(o==null){
//				throw new NoSuchObjectException(id);
//			}
			// check each property for relationship annotations

			PropertyDescriptor[] ppds = beanInfo
					.getPersistencePropertyDescriptors();
			for (PropertyDescriptor ppd : ppds) {
				Method rm = ppd.getReadMethod();
				OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
				ManyToMany manyToManyAnno = rm
						.getAnnotation(ManyToMany.class);
				OneToOne oneToOneAnno=rm.getAnnotation(OneToOne.class);
				
				if (oneToManyAnno != null){
					CascadeType[] cascadeTypes=oneToManyAnno.cascade();
					boolean hasCt=hasCascadeType(cascadeTypes,ignoreRemoveCascadedWith);
					if(hasCt){
						continue;
					}
					Collection<?> values = (Collection<?>)rm.invoke(o, new Object[0]);
					if(values!= null && values.size()>0){
						return true;
					}
				}else if(manyToManyAnno!=null) {
					CascadeType[] cascadeTypes=manyToManyAnno.cascade();
					boolean hasCt=hasCascadeType(cascadeTypes,ignoreRemoveCascadedWith);
					if(hasCt){
						continue;
					}
					Collection<?> values = (Collection<?>)rm.invoke(o, new Object[0]);
					if(values!= null && values.size()>0){
						return true;
					}
				}else if(oneToOneAnno!=null){
					CascadeType[] cascadeTypes=oneToOneAnno.cascade();
					boolean hasCt=hasCascadeType(cascadeTypes,ignoreRemoveCascadedWith);
					if(hasCt){
						continue;
					}
					Object relObj = rm.invoke(o, new Object[0]);
					if (relObj != null) {
						return true;
					}
				}
			}
		return false;
	} catch (IllegalArgumentException e) {
		e.printStackTrace();
		throw new ControllerException(e);
	}catch (IllegalAccessException e) {
		e.printStackTrace();
		throw new ControllerException(e);
	} catch (InvocationTargetException e) {
		e.printStackTrace();
		throw new ControllerException(e);
	} 
}
	
	public boolean isObjectImmutable(Object bean) throws ControllerException{
		if(bean instanceof ImmutibilityProvider){
			ImmutibilityProvider ip=(ImmutibilityProvider)bean;
			boolean beanImmut=ip.isImmutable();
			if(beanImmut){
				return true;
			}
		}
		Set<PropertyDescriptor> oipds=beanInfo.getObjectImmutablePropertyDescriptors();
		for(PropertyDescriptor oipd:oipds){
			boolean hasRefs=hasRelationShips(bean, oipd);
			if(hasRefs){
				return true;
			}
		}
		return false;
	}
	
	public boolean isObjectRemovable(Object bean) throws ControllerException{
		if(bean instanceof ImmutibilityProvider){
			ImmutibilityProvider ip=(ImmutibilityProvider)bean;
			boolean beanRemovable=ip.isRemovable();
			return beanRemovable;
		}
		Set<PropertyDescriptor> oipds=beanInfo.getObjectImmutablePropertyDescriptors();
		for(PropertyDescriptor oipd:oipds){
			boolean hasRefs=hasRelationShips(bean, oipd);
			if(hasRefs){
				return false;
			}
		}
		return true;
	}
	
	public boolean itemSelectable(Object item) {
		return true;
	}
	
	public boolean modifyable(Object bean) throws ControllerException {
		if(currentRequest!=null) {
			boolean mergePerm=securityManager.getMergePermission(currentRequest, bean, null);
			if(mergePerm) {
				boolean immutable=isObjectImmutable(bean);
				return !immutable;
			}
		}
		return false;
	}
	
	public boolean removable(Object bean) throws ControllerException {
		if(currentRequest!=null) {
			boolean rmPerm=securityManager.getRemovePermission(currentRequest, bean);
			if(rmPerm) {
				return isObjectRemovable(bean);
			}
		}
		return false;
	}
	
	
	/**
	 * Removes object by ID.
	 * Throws controller exception if object has relationships (SQL foreign constraints) or remove not permitted by security manager.
	 * @param req HTTP servlet request
	 * @param id object ID
	 * @return the object
	 * @throws ControllerException
	 */
	public Object removeById(HttpServletRequest req,Object id) throws ControllerException {
		return removeById(req,id, false);
	}
	/**
	 * Removes object by ID.
	 * If removeRelationShips parameter is set the method tries to remove the relationships (not the related objects; no cascade remove) first.
	 * When the object is decoupled it will be removed.
	 * Throws controller exception if object has relationships (SQL foreign constraints) or remove not permitted by security manager.
	 * @param req HTTP servlet request
	 * @param id object ID
	 * @param removeRelationShips if true remove the relationships first
	 * @return the object
	 * @throws ControllerException
	 */
	public Object removeById(HttpServletRequest req,Object id,boolean removeRelationShips) throws ControllerException {
		return removeById(req,beanInfo,id,removeRelationShips);
	}
	
	public Object removeById(HttpServletRequest req,ExtBeanInfo typeInfo,Object id,boolean removeRelationShips) throws ControllerException {
		
		EntityManager em = getThreadEntityManager();
		try {
			BeanDescriptor bd=typeInfo.getBeanDescriptor();
			Class<?> beanClass=bd.getBeanClass();
			Object o = em.find(beanClass, id);
			if(o==null){
				throw new NoSuchObjectException(id);
			}
			securityManager.checkRemovePermission(req,o);
			if (removeRelationShips) {
				PropertyDescriptor[] ppds = typeInfo
						.getPersistencePropertyDescriptors();
				for (PropertyDescriptor ppd : ppds) {
					Method rm = ppd.getReadMethod();
					OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
					ManyToOne manyToOneAnno=rm.getAnnotation(ManyToOne.class);
					ManyToMany manyToManyAnno = rm
							.getAnnotation(ManyToMany.class);
					OneToOne oneToOneAnnotation=rm.getAnnotation(OneToOne.class);
					boolean cascadeRemove=false;
					if (oneToManyAnno != null) {
						CascadeType[] cascadeTypes=oneToManyAnno.cascade();
						for(CascadeType ct:cascadeTypes){
							if(ct.equals(CascadeType.ALL) || ct.equals(CascadeType.REMOVE)){
								cascadeRemove=true;
								break;
							}
						}
						if(cascadeRemove)continue;
						PropertyDescriptor relatedPropertyDescriptor = null;
						String mappedby = oneToManyAnno.mappedBy();
						if (mappedby == null || mappedby.equals("")) {
							// simply continue, will throw an error on remove
							// later
							continue;
						}
						Type rt = rm.getGenericReturnType();
						if (rt instanceof ParameterizedType) {
							ParameterizedType prt = (ParameterizedType) rt;
							Type[] pts = prt.getActualTypeArguments();
							if (pts.length == 1) {
								// we expect exactly one parameterized type
								// argument
								Class<?> relatedReturnType = (Class<?>) pts[0];
								ExtBeanInfo relatedbeanInfo = null;
									relatedbeanInfo = PersistenceIntrospector
											.getPersistenceBeanInfo(relatedReturnType);
								PropertyDescriptor[] relPpds = relatedbeanInfo
										.getPersistencePropertyDescriptors();
								for (PropertyDescriptor relPpd : relPpds) {
									if (relPpd.getName().equals(mappedby)) {
										relatedPropertyDescriptor = relPpd;
									}
								}

							} else {
								continue;
							}
						} else {
							continue;
						}
						Collection<?> values;
							values = (Collection<?>)rm.invoke(o, new Object[0]);
						Method relWriteMethod=relatedPropertyDescriptor.getWriteMethod();
						for(Object relObj:values){
							relWriteMethod.invoke(relObj, new Object[]{null});
							securityManager.checkMergePermission(req, relObj);
							em.merge(relObj);
						}
						values.clear();
					}else if (manyToOneAnno!=null) {
						CascadeType[] cascadeTypes=manyToOneAnno.cascade();
						for(CascadeType ct:cascadeTypes){
							if(ct.equals(CascadeType.ALL) || ct.equals(CascadeType.REMOVE)){
								cascadeRemove=true;
								break;
							}
						}
						if(cascadeRemove)continue;
						
						Class<?> returnType = rm.getReturnType();
						Object relObj = rm.invoke(o, new Object[0]);
						if (relObj == null) {
							// no relationship set
							continue;
						}

						ExtBeanInfo relBeanInfo = PersistenceIntrospector
								.getPersistenceBeanInfo(returnType);
						PropertyDescriptor[] relPPds = relBeanInfo
								.getPersistencePropertyDescriptors();
						PropertyDescriptor relCollPd=null;
						for(PropertyDescriptor relPPd:relPPds) {
							
							// find related collection property
							
							Class<?> relPropType=relPPd.getPropertyType();
							if(Collection.class.isAssignableFrom(relPropType)) {
								//relPropType.
								Method relRm=relPPd.getReadMethod();
								
								Type relRt = relRm.getGenericReturnType();
								if (relRt instanceof ParameterizedType) {
									ParameterizedType relPrt = (ParameterizedType) relRt;
									Type[] relPts = relPrt.getActualTypeArguments();
									if (relPts.length == 1) {
										// we expect exactly one parameterized type
										// argument
										Class<?> relatedReturnType = (Class<?>) relPts[0];
										if(relatedReturnType.isAssignableFrom(beanClass)) {
											
											// found matching candidate
											relCollPd=relPPd;
											
											OneToMany relOneToManyAnno=relRm.getAnnotation(OneToMany.class);
											if(relOneToManyAnno!=null) {
												String relOtMmappedBy=relOneToManyAnno.mappedBy();
												if(relOtMmappedBy!=null && relOtMmappedBy.equals(ppd.getName())) {
													// definitely found
													break;
												}
											}
										}
									}
								}
								
							}
						}
						if(relCollPd!=null) {
							// and remove bean from related collection
							Method relRm=relCollPd.getReadMethod();
							Collection<?> relValues= (Collection<?>)relRm.invoke(relObj, new Object[0]);
							relValues.remove(o);
							securityManager.checkMergePermission(req, relObj);
							em.merge(relObj);
						}
						
					}else if(manyToManyAnno != null){
						CascadeType[] cascadeTypes=manyToManyAnno.cascade();
						for(CascadeType ct:cascadeTypes){
							if(ct.equals(CascadeType.ALL) || ct.equals(CascadeType.REMOVE)){
								cascadeRemove=true;
								break;
							}
						}
						if(cascadeRemove)continue;
						PropertyDescriptor relatedPropertyDescriptor = null;
						String mappedby = manyToManyAnno.mappedBy();
//						if (mappedby == null || mappedby.equals("")) {
//							// Owning side, nothing to do
//							// continue;
//							// Update: But not if JPA caching is used.
//							
//						}
						Type rt = rm.getGenericReturnType();
						if (rt instanceof ParameterizedType) {
							ParameterizedType prt = (ParameterizedType) rt;
							Type[] pts = prt.getActualTypeArguments();
							if (pts.length == 1) {
								// we expect exactly one parameterized type
								// argument
								Class<?> relatedReturnType = (Class<?>) pts[0];
								ExtBeanInfo relatedbeanInfo = null;
									relatedbeanInfo = PersistenceIntrospector
											.getPersistenceBeanInfo(relatedReturnType);
								PropertyDescriptor[] relPpds = relatedbeanInfo
										.getPersistencePropertyDescriptors();
								for (PropertyDescriptor relPpd : relPpds) {
									if (mappedby == null || mappedby.equals("")) {
										Method relRm = relPpd.getReadMethod();
										ManyToMany relManyToManyAnno = relRm.getAnnotation(ManyToMany.class);
										if(relManyToManyAnno!=null) {
											String relMappedby=relManyToManyAnno.mappedBy();
											if(relMappedby!=null && relMappedby.equals(ppd.getName())){
												relatedPropertyDescriptor = relPpd;
												break;
											}
										}
									}else {
										if (relPpd.getName().equals(mappedby)) {
											relatedPropertyDescriptor = relPpd;
											break;
										}
									}
								}

							} else {
								continue;
							}
						} else {
							continue;
						}
						Collection<?> values;
							values = (Collection<?>)rm.invoke(o, new Object[0]);
						Method relReadMethod=relatedPropertyDescriptor.getReadMethod();
						for(Object relObj:values){
							Collection<?> relCollValues=(Collection<?>)relReadMethod.invoke(relObj, new Object[0]);
							securityManager.checkMergePermission(req,relObj);
							relCollValues.remove(o);
							em.merge(relObj);
						}
						values.clear();
					}else if(oneToOneAnnotation!=null){
						CascadeType[] cascadeTypes = oneToOneAnnotation
								.cascade();
						for (CascadeType ct : cascadeTypes) {
							if (ct.equals(CascadeType.ALL)
									|| ct.equals(CascadeType.REMOVE)) {
								cascadeRemove = true;
								break;
							}
						}
						if (cascadeRemove)
							continue;
						Class<?> returnType = rm.getReturnType();
						Object relObj = rm.invoke(o, new Object[0]);
						if (relObj == null) {
							// no relationship set
							continue;
						}

						ExtBeanInfo relBeanInfo = PersistenceIntrospector
								.getPersistenceBeanInfo(returnType);
						PropertyDescriptor[] relPPds = relBeanInfo
								.getPersistencePropertyDescriptors();
						String mappedBy = oneToOneAnnotation.mappedBy();
						if (mappedBy != null && !mappedBy.equals("")) {
							// not owning
							for (PropertyDescriptor relPpd : relPPds) {
								if (relPpd.getName().equals(mappedBy)) {
									Method relWm = relPpd.getWriteMethod();
									securityManager.checkMergePermission(req,
											relObj);
									relWm.invoke(relObj, new Object[] { null });

									em.merge(relObj);
									break;
								}
							}
						} else {
							// owning

							for (PropertyDescriptor relPpd : relPPds) {
								Method relRm = relPpd.getReadMethod();
								OneToOne relOneToOneAnno = relRm
										.getAnnotation(OneToOne.class);
								if (relOneToOneAnno != null) {
									String mappedby = relOneToOneAnno
											.mappedBy();
									if (mappedby != null
											&& mappedby.equals(ppd.getName())) {
										Method relWm = relPpd.getWriteMethod();
										securityManager.checkMergePermission(
												req, relObj);
										relWm.invoke(relObj,
												new Object[] { null });
										break;
									}

								}
							}

				}
						
					}
				}
			}
			em.remove(o);
			return o;
		//	beanModel=new BeanModel(o);
		//	processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
			throw new ControllerException(e);
		} catch (IntrospectionException e) {
			e.printStackTrace();
			throw new ControllerException(e);
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			throw new ControllerException(e);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
			throw new ControllerException(e);
		} 
	}
	
//	 To be overriden by custom controllers
	//protected abstract void checkReadPermission(HttpServletRequest req, Object o) throws PermissionDeniedException;
	//protected abstract void checkPersistPermission(HttpServletRequest req, Object o) throws PermissionDeniedException;
	//protected abstract void checkMergePermission(HttpServletRequest req, Object o) throws PermissionDeniedException;
	//protected abstract void checkRemovePermission(HttpServletRequest req, Object o) throws PermissionDeniedException;

	
	public BeanTableModel<?> getBeanTableModel(HttpServletRequest request) throws ControllerException {
		if(beanTableModel==null)createBeanTableModel(request);
		return beanTableModel;
	}

	public BeanTableModel<?> getBeanTableModel(){
		return beanTableModel;
	}
	public int getFirstItem() {
		return firstItem;
	}


	public int getBatchSize() {
		return batchSize;
	}

	public void processNamedQuery(HttpServletRequest req,String namedQuery, Object[] params) throws ControllerException {
		currentRequest=req;
		clear();
		namedQueryParam = null;
		namedQueryParams = params;
		this.namedQuery = namedQuery;
		this.parameterizedQuery=null;
		//processRequest(req);
		//createBeanTableModel(req.getParameter(KEY_CMD), new BeanTableModel(),req);
		processListRequest(req);
	}

//	public void processParameterizedQuery(HttpServletRequest req) throws ControllerException {
//		namedQueryParam = null;
//		namedQueryParams = null;
//		this.namedQuery = null;
//		processRequest(req);
//		//createBeanTableModel(req.getParameter(KEY_CMD), new BeanTableModel(),req);
//	}
	
	private List<PropertyDescriptor> getPropertyDescriptorByReturnType(PropertyDescriptor[] ppds,Class<?> returnType){
		List<PropertyDescriptor> resList=new ArrayList<PropertyDescriptor>();
		for (PropertyDescriptor pd : ppds) {
			Method rm = pd.getReadMethod();
			Class<?> relatedReturnType=null;
			Type rt = rm.getGenericReturnType();
			if (rt instanceof ParameterizedType) {
				ParameterizedType prt = (ParameterizedType) rt;
				Type[] pts = prt.getActualTypeArguments();
				if (pts.length == 1) {
					// we expect exactly one parameterized type argument
					Type pt=pts[0];
					if(pt instanceof Class){
						relatedReturnType = (Class<?>) pts[0];
					}else{
						continue;
					}
					
				}else{
					continue;
				}
			}else{
				relatedReturnType=(Class<?>)rt;
			}
			if(relatedReturnType!=null && relatedReturnType.isAssignableFrom(returnType)){
				resList.add(pd);
			}
		}
		return resList;
	}
	
	@Deprecated
	private PropertyDescriptor getPropertyDescriptorByMappedBy(PropertyDescriptor[] ppds,Class<?> returnType,String relatedProp){
		List<PropertyDescriptor> retTypeMatchPds=getPropertyDescriptorByReturnType(ppds, returnType);
		for (PropertyDescriptor pd : retTypeMatchPds) {
			Method rm = pd.getReadMethod();
			
			String mappedBy = null;
			ManyToMany mToMAnno = rm
					.getAnnotation(ManyToMany.class);
			OneToMany oToMAnno = rm
					.getAnnotation(OneToMany.class);
			OneToOne oToOAnno=rm.getAnnotation(OneToOne.class);
			if (mToMAnno != null) {
				mappedBy = mToMAnno.mappedBy();
			} else if(oToMAnno!=null){
				mappedBy = oToMAnno.mappedBy();
			}else if(oToOAnno!=null){
				mappedBy=oToOAnno.mappedBy();
			}
			if (mappedBy != null && mappedBy.equals(relatedProp)) {
				return pd;
			}
		}
		
		return null;
	}
	
	
	
	
	public void createBeanTableModel(HttpServletRequest request) throws ControllerException {
		createBeanTableModel(request.getParameter(KEY_CMD),request);
	}

	public void createBeanTableModel(String cmd,HttpServletRequest request) throws ControllerException {
		
		createBeanTableModel(cmd, new BeanTableModel<T>(),request);
	}
//	public void createBeanTableModel(String cmd) throws ControllerException {
//		
//		createBeanTableModel(cmd, new BeanTableModel(),null);
//	}
//	
	
	
	public void selectItem(HttpServletRequest request) throws ControllerException{
		Map<String,String[]> pMap=(Map<String, String[]>) request.getParameterMap();
		setSelectedItemId(request, createIdObject(pMap));
	}
	
	
	public void changeSelectedItemIds(HttpServletRequest request) throws ControllerException{
//		String deselectedInputName=KEY_PREFIX_DEFAULT_DESELECT+"."+beanInfo.getIdPropertyDescriptor().getName();
//		
//		Map<String, String[]> paramMap=request.getParameterMap();
//		String[] deselectIds=paramMap.get(deselectedInputName);
//		HashSet<Object> deselectSet=new HashSet<Object>(batchSize);
//		
//		for(String deselectId:deselectIds){
//			
//		}
		Map<String,String[]> pMap=request.getParameterMap();
		setSelectedItemId(request, createIdObject(pMap));
	}
	
	public void createEmptyBeanTableModel(HttpServletRequest request){
		beanTableModel=new BeanTableModel<T>();
		beanTableModel.setBatchSize(batchSize);
		beanTableModel.setExtBeanInfo(beanInfo);
		beanTableModel.setItems(new ArrayList<T>());
		beanTableModel.setItemCount(0);
	}

	@SuppressWarnings("unchecked")
	public void createBeanTableModel(String command, BeanTableModel<T> btm,
			HttpServletRequest request) throws ControllerException {

		btm.setBatchSize(batchSize);
//		if (mode != null && mode instanceof ListMode) {
//			btm.setSelectMode(((ListMode) mode).getSelectMode());
//		}
		btm.setExtBeanInfo(beanInfo);

		if (CMD_LIST_ALL.equals(command)) {
			setBoolCondition(null);
			mode=new ListMode();
		}else if (CMD_LIST_RELATED.equals(command)) {
			mode=new ListMode();
			processRelationShip(request.getParameterMap());
			//createBeanTableModel(CMD_LIST,request);
			command=CMD_LIST; // TODO necessary to change command here ?
		}else if (CMD_SELECT_TO_RESET.equals(command)) {
			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
			ListMode lm=new ListMode();
			lm.setSelectMode(new SelectMode(SelectMode.ActionType.RESET,request.getParameter(KEY_ACTION),selectTargetProperty));
			mode=lm;
			processRelationShip(request.getParameterMap());
			//createBeanTableModel(command,btm,request);
		}else if (CMD_LIST_APPLY_COND.equals(command)) {

			BoolExprQueryParser q = null;
			try {

				q = new BoolExprQueryParser(request, queryType);
			} catch (ParserException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
				setBoolCondition(null);
			}
			ExtBoolExpr be = null;
			try {
				be = q.parse();
				setBoolCondition(be);
			} catch (ParserException e) {
				setBoolCondition(null);
				e.printStackTrace();
			}
			// createBeanTableModel(command);
		} else if (CMD_LIST_ORDER_BY.equals(command)) {
			OrderByQueryParser obQueryParser = new OrderByQueryParser(request);
			try {
				orderByClause = obQueryParser.parse();
			} catch (ParserException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			// createBeanTableModel(command);
		}
		if (mode != null && mode instanceof ListMode) {
			btm.setSelectMode(((ListMode) mode).getSelectMode());
		}
		EntityManager em = getThreadEntityManager();
		Query q = null;

		String jpqlSelectExpression = "o";
		int itemCount = 0;

		if(query!=null) {
			q=query;
			itemCount = q.getResultList().size();
		}else if (namedQuery != null) {
			Object idObj = null;
			if (namedQueryParam != null) {

				try {

					idObj = em.find(namedQueryParam.getTargetClass(),
							namedQueryParam.getIdObject());
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				Query qc = em.createNamedQuery(namedQuery);
				qc.setParameter(1, idObj);
				itemCount = qc.getResultList().size();
				q = em.createNamedQuery(namedQuery);
				q.setParameter(1, idObj);
			} else {
				Query qc = em.createNamedQuery(namedQuery);
				if (namedQueryParams != null) {
					for (int pi = 0; pi < namedQueryParams.length; pi++) {
						qc.setParameter(pi + 1, namedQueryParams[pi]);
					}
				}
				itemCount = qc.getResultList().size();
				q = em.createNamedQuery(namedQuery);
				if (namedQueryParams != null) {
					for (int pi = 0; pi < namedQueryParams.length; pi++) {
						q.setParameter(pi + 1, namedQueryParams[pi]);
					}
				}
			}

		} else if (parameterizedQuery != null) {

			// if(boolCondition !=null){
			parameterizedQuery.setAdditionalCondition(boolCondition);
			// }
			
			parameterizedQuery.appendOrderByClause(orderByClause);

			q = parameterizedQuery.createQuery(em);

			itemCount = q.getResultList().size();

		} else {

			String baseQuery = "SELECT COUNT(" + jpqlSelectExpression
					+ ") FROM " + qlQeryTypeName + " AS "
					+ jpqlSelectExpression;
			String orderByClauseStr = "";
			String whereClauseStr = "";
			if (orderByClause != null) {
				orderByClauseStr = orderByClause
						.toJPQLString(jpqlSelectExpression);
			}

			PersistenceBoolExpr pqd = null;
			Query qc = null;
			if (boolCondition != null) {
				whereClauseStr = whereClauseStr.concat(" WHERE ");
			}

			if (boolCondition != null) {
				PersistenceBoolExprConverter pbec = new PersistenceBoolExprConverter(
						boolCondition, jpqlSelectExpression);
				pqd = pbec.createQueryData(em);
				whereClauseStr = whereClauseStr.concat(" ("
						+ pqd.getConditionalExpression() + " )");
			}

			qc = em.createQuery(baseQuery + whereClauseStr);
			if (boolCondition != null) {
				Object[] vars = pqd.getQueryVars();
				for (int i = 0; i < vars.length; i++) {
					//qc.setParameter(i + 1, vars[i]);
					qc.setParameter(PersistenceBoolExprConverter.JPQL_PARAM_NAME_PREFIX+"_"+(i+1), vars[i]);
				}
			}

			itemCount = (int) ((Long) qc.getSingleResult()).intValue();
			baseQuery = "SELECT " + jpqlSelectExpression + " FROM "
					+ qlQeryTypeName + " " + jpqlSelectExpression;
			q = em.createQuery(baseQuery + whereClauseStr + " "
					+ orderByClauseStr);
			if (boolCondition != null) {
				Object[] vars = pqd.getQueryVars();
				for (int i = 0; i < vars.length; i++) {
					//q.setParameter(i + 1, vars[i]);
					q.setParameter(PersistenceBoolExprConverter.JPQL_PARAM_NAME_PREFIX+"_"+(i+1), vars[i]);
				}
			}
		}
			// set pre selected item
			PersistenceObjectIdentifier relatedPoi = getRelatedObjectIdentifier();
			SelectMode sm = btm.getSelectMode();
			if (relatedPoi != null
					&& sm != null
					&& (ActionType.SET.equals(sm.getActionType()) || ActionType.RESET
							.equals(sm.getActionType()))) {
				Object relatedObject = em.find(relatedPoi.getTargetClass(),
						relatedPoi.getIdObject());
				securityManager.checkReadPermission(request, relatedObject);
				PropertyDescriptor relPd=getRelatedPropertyDescriptor();
				Method rm=relPd.getReadMethod();
				// check for ManyToMany and OneToMany (collections)
				ManyToMany mToMAnno=rm.getAnnotation(ManyToMany.class);
				OneToMany oToMAnno=rm.getAnnotation(OneToMany.class);
				String selQuery=null;
				if(mToMAnno !=null || oToMAnno!=null){
					selQuery = "SELECT " + jpqlSelectExpression + " FROM "
						+ qlQeryTypeName + " " + jpqlSelectExpression
						+ " WHERE :"+JPQL_PARAM_NAME_PREFIX+" MEMBER OF " + jpqlSelectExpression + "."
						+ relPd.getName();
				}else{
					selQuery="SELECT " + jpqlSelectExpression + " FROM "
					+ qlQeryTypeName + " " + jpqlSelectExpression
					+ " WHERE " + jpqlSelectExpression + "."
					+ relPd.getName()+" = :"+JPQL_PARAM_NAME_PREFIX;
				}
				Query selQ = em.createQuery(selQuery);
				selQ.setParameter(JPQL_PARAM_NAME_PREFIX, relatedObject);
				// Object selObject=selQ.getSingleResult();
				List<?> resultList = selQ.getResultList();
				int selSize = resultList.size();
				if (selSize > 1) {
					throw new ControllerException(
							"More than one result in many/one to one relationship !");
				} else if (selSize == 1) {
					Object selObject = resultList.get(0);
					if(securityManager!=null)securityManager.checkReadPermission(request, selObject);
					try {
						Object selId = beanInfo.getIdValue(selObject);
						btm.setSelectedIds(new Object[] { selId });
					} catch (Exception e) {
						throw new ControllerException(e);
					}
				}
			}
		

		if (CMD_LIST_ADD_COL.equals(command)) {
			// int i = 0;
			String p = null;
			ArrayList<String> newDisplayedProps = new ArrayList<String>();
			List<String> dpdsList =new ArrayList<String>(displayColumns);
			newDisplayedProps.addAll(dpdsList);
			
			List<String> hiddenProps=beanInfo.getHiddenProperties();
			if ((p = request.getParameter("_col")) != null) {
	
				if(hiddenProps.contains(p)) {
					throw new ControllerException("Access to property denied!");
				}
				
				for (PropertyDescriptor pd : beanInfo
						.getPersistencePropertyDescriptors()) {
					String pdName=pd.getName();
					if (pdName.equals(p) && !dpdsList.contains(pdName)) {
						newDisplayedProps.add(pdName);
					}
				}
				if(additionalColumns!=null){
					for (String additionalColName: additionalColumns) {

						if (additionalColName.equals(p) && !dpdsList.contains(additionalColName)) {
							newDisplayedProps.add(additionalColName);
						}
					}
				}
			}
			newDisplayedProps.removeAll(hiddenProps);
			setDisplayColumns(newDisplayedProps);
			// createBeanTableModel(command);
		} else if (CMD_LIST_REMOVE_COL.equals(command)) {
			// int i = 0;
			String p = null;
			List<String> newDisplayedProps = new ArrayList<String>();

			if ((p = request.getParameter("_col")) != null) {

				for (String colName : displayColumns) {
					if (!colName.equals(p)) {
						newDisplayedProps.add(colName);
					}
				}
			}
			setDisplayColumns(newDisplayedProps);
			// createBeanTableModel(command);
		} else if (CMD_LIST_COLS_RESET.equals(command)) {
			setDisplayColumns(null);
			// createBeanTableModel(command);
		} else if (CMD_LIST_SELECT_ITEM.equals(command)
				|| CMD_LIST_SELECT_MULTI.equals(command)) {

			selectItem(request);
			// BeanTableModel btm = new BeanTableModel();

			// createBeanTableModel(command, btm,request);

			// setPropertiesAfterSelect(request,getSelectedItem());
		} else if (CMD_LIST_FIRST.equals(command)) {
			firstItem = 0;
		} else if (CMD_LIST_NEXT.equals(command)) {
			if (firstItem + batchSize < itemCount) {
				firstItem += batchSize;
			}
		} else if (CMD_LIST_PREVIOUS.equals(command)) {
			firstItem -= batchSize;
			if (firstItem < 0) {
				firstItem = 0;
			}
		} else if (CMD_LIST_LAST.equals(command)) {
			int pages = itemCount / batchSize;
			if (itemCount % batchSize > 0) {
				pages += 1;
			}
			firstItem = ((pages - 1) * batchSize);
		} else if (CMD_LIST_ALL.equals(command)) {
			// namedQuery = null;
			// parameterizedQuery=null;
			boolCondition = null;
		}
		
		if (firstItem > itemCount - 1) {
			firstItem = 0;
		}
		q.setMaxResults(batchSize);
		q.setFirstResult(firstItem);
		
		List<T> unfilteredResultList = q.getResultList();
		List<T> resultList=unfilteredResultList;
		
		if(filterMethod!=null) {
			Object fResObj;
			try {
				fResObj = filterMethod.invoke(this,unfilteredResultList);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
				e.printStackTrace();
				throw new ControllerException("Error invoking filter method "+filterMethod+": ", e);
			}
			if(fResObj instanceof List) {
				resultList=(List<T>) fResObj;
			}
		}
		List<T> safeItems=new ArrayList<T>();
		for (T o : resultList) {
//			em.refresh(o);
			if(securityManager!=null){
				if(!dropInSecureItems){
					securityManager.checkReadPermission(request, o);
				}else{
					if(securityManager.getReadPermission(request, o)){
						safeItems.add(o);
					}	
				}
			}
			setPropertiesAfterQuery(request, em, o);
		}
		
		
		if(dropInSecureItems){
			itemCount=safeItems.size();
			btm.setItems(safeItems);
		}else{
			btm.setItems(resultList);
		}
		
		btm.setItemCount(itemCount);
		btm.setFirstItem(firstItem);
		btm.setLastItem(firstItem + batchSize >= itemCount ? itemCount - 1
				: firstItem + batchSize - 1);
		
		
		if (selectedItemId != null) {
			btm.setSelectedRowsIds(new Object[] { selectedItemId });
		}
		// btm.setBeanClass(queryType);
		btm.setExtBeanInfo(getBeanInfo());
		beanTableModel = btm;
	}

	protected void setPropertiesAfterSelect(HttpServletRequest request, Object selObject) {
		// Does nothing
		// To be overridden by controller subclasses
	}
	
	protected void setPropertiesAfterSelect(HttpServletRequest request, Set<Object> selObjects) {
		// Does nothing
		// To be overridden by controller subclasses
	}

	public void createBeanModel(HttpServletRequest request) throws ControllerException{	
		createBeanModel(request, false);
	}
	
	public void createBeanModel(HttpServletRequest request,boolean createIfNotExist) throws ControllerException{	
		Map<String,String[]> map = request.getParameterMap();
		Object idObj = createIdObject(map);
		EntityManager em = getThreadEntityManager();
		
		T editItem;
		try {
			boolean created=false;
			editItem = em.find(queryType, idObj);
			if(editItem==null){
				if(createIfNotExist) {
					try {
						editItem=queryType.getDeclaredConstructor().newInstance();
						created=true;
					} catch (InstantiationException | IllegalAccessException | IllegalArgumentException
							| InvocationTargetException | NoSuchMethodException | SecurityException e) {
						
						e.printStackTrace();
						throw new ControllerException(
								"Could not create instance: ", e);
					}
				}else {
				throw new NoSuchObjectException(idObj);
			}
			}
			PersistenceMapConverter mapConverter = new PersistenceMapConverter();
			try {
				mapConverter.setBeanProperties(editItem, map, em, false,request,securityManager);
				if(!created) {
				securityManager.checkReadPermission(request, editItem);
				}
				beanModel=new BeanModel<T>(editItem);
			} catch (MapConverterException e) {
				e.printStackTrace();
				throw new ControllerException(
						"Could not apply property values.", e);
			}
		} catch (PersistenceException e) {
			e.printStackTrace();
			close();
			throw e;
		}
	}
	
	@SuppressWarnings("unchecked")
	private void createSingleItemModel(HttpServletRequest req) throws ControllerException {
		if (namedQuery == null && id == null) {
			throw new ControllerException(
					"No named query or ID to load single object!");
		}
		T singleItem=null;
		EntityManager em = getThreadEntityManager();
	
		if (namedQuery != null) {
			Query q = null;
			Object idObj = null;
			q = em.createNamedQuery(namedQuery);
			if (namedQueryParam != null) {
				try {

					idObj = em.find(namedQueryParam.getTargetClass(),
							namedQueryParam.getIdObject());
				} catch (Exception e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}

				q.setParameter(1, idObj);

			} else {
				if (namedQueryParams != null) {
					for (int pi = 0; pi < namedQueryParams.length; pi++) {
						q.setParameter(pi + 1, namedQueryParams[pi]);
					}
				}
			}
			try {
				singleItem = (T) q.getSingleResult();
			} catch (NoResultException nre) {
				beanModel=null;
			}
		} else if (id != null) {
			singleItem = em.find(queryType, id);
		}
		
		
		// if permission check OK set the item
		if(singleItem!=null){
			securityManager.checkReadPermission(req, singleItem);
			em.refresh(singleItem);
			beanModel =new BeanModel<T>(singleItem);
		}
	}
	
	public T getItem() throws ControllerException {

		if (beanModel == null) createSingleItemModel(currentRequest);
		if(beanModel!=null){
			return beanModel.getBean();
		}else{
			return null;
		}
	}

	
	public List<String> getDisplayColumns() {
		return displayColumns;
	}

	protected void setPropertiesOnNew(Object bean) {
		// Does nothing
		// To be overwritten by special controllers
	}

	protected void setPropertiesOnCreate(HttpServletRequest request,EntityManager em,Object bean) {
		// Does nothing
		// To be overwritten by special controllers
	}
	
	protected void setPropertiesOnApply(HttpServletRequest request,EntityManager em,Object bean) {
		// Does nothing
		// To be overwritten by special controllers
	}
	
	protected void setPropertiesAfterQuery(HttpServletRequest request,EntityManager em,Object o) {
		// Does nothing
		// To be overwritten by special controllers
	}
	
//	protected void setPropertiesBeforeStore(HttpServletRequest request,EntityManager em,Object bean) {
//		// Does nothing
//		// To be overwritten by special controllers
//	}

	public ValidationResult validate(Object o,ValidationResult validationResult) throws ValidationException{
		FormConfiguration formConfiguration=getFormConfiguration();
		ValidationResult vr=validationResult;
		boolean defaultRequired=false;
		if(vr==null){
		vr=new ValidationResult();
		}
		if (queryType.isAssignableFrom(o.getClass())){
			
			
//			if(formConfiguration!=null){
//				boolean formRequired=formConfiguration.isDefaultRequired();
//				boolean formShow=formConfiguration.isDefaultShow();
//				defaultRequired=formRequired&&formShow;
//			}
			PropertyDescriptor[] pPds=beanInfo.getPersistencePropertyDescriptors();
			for (PropertyDescriptor pd:pPds){
				String pdName=pd.getName();
				PropertyValidationResult prVr=vr.getPropertyValidationResult(pdName);
				// Ignore already existing errors
				if(prVr==null || prVr.isValid()){
					boolean required=defaultRequired;
					if(formConfiguration!=null){
						boolean requiredByFormConfig=false;
						List<PropertyConfiguration> propCfgs=formConfiguration.getPropertyConfigurations();
						for(PropertyConfiguration pCfg:propCfgs){
							if(pd.equals(pCfg.getPropertyDescriptor())){
								requiredByFormConfig=pCfg.isRequired()&&pCfg.isShow();
								break;
							}
						}
						required=requiredByFormConfig;
					}
					Method rm=pd.getReadMethod();
					Object val;
					try {
						val = rm.invoke(o, new Object[]{});
					} catch (Exception e) {
						e.printStackTrace();
						throw new ValidationException(e);
					}
					Input inputA=rm.getAnnotation(Input.class);
					if(inputA!=null){
						required=required || inputA.required();
					}
					Column colAnno=rm.getAnnotation(Column.class);
					Delegate delegateAnno=rm.getAnnotation(Delegate.class);
					if(colAnno!=null || delegateAnno!=null){
						// check nullable
						if(colAnno!=null && !colAnno.nullable() && val==null){
							vr.setType(ValidationResult.Type.ERRORS);
							LocalizableMessage msg=new LocalizableMessage(beanInfo.getResourceBundleName(),"validation.field.must_be_set");
							vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR,msg));
						}

						if(required){
							if(val==null || (pd.getPropertyType().equals(String.class) && "".equals(val))){
								vr.setType(ValidationResult.Type.ERRORS);
								vr.putPropertyValidationResult(pd.getName(),new PropertyValidationResult(PropertyValidationResult.Type.ERROR,VALIDATION_MSG_FIELD_REQUIRED));
							}

						}
						// check length of string
						if(colAnno !=null && pd.getPropertyType().equals(String.class)){
							if(val!=null && ((String)val).length() > colAnno.length()){
								vr.setType(ValidationResult.Type.ERRORS);
								LocalizableMessage msg=new LocalizableMessage(beanInfo.getResourceBundleName(),"validation.field.too_long");
								vr.putPropertyValidationResult(pd.getName(),new PropertyValidationResult(PropertyValidationResult.Type.ERROR,msg));
							}
						}
					}
				}
			}
		}else{
			throw new ValidationException("Object has not type of controller !");
		}
		
		return vr;
	}
	
	protected void apply(HttpServletRequest request)
			throws ControllerException {
		// Merge properties if 
		T newItem=null;
		try {
			newItem = queryType.newInstance();
		} catch (InstantiationException e1) {

			e1.printStackTrace();
			throw new ControllerException(e1);
		} catch (IllegalAccessException e1) {
			e1.printStackTrace();
			throw new ControllerException(e1);
		}
		
		_apply(request, newItem);
	}
	protected void merge(HttpServletRequest request)
			throws ControllerException {
		// Merge properties if 
		T item= getItem();
		if(item==null){
			try {
				item = queryType.newInstance();
			} catch (InstantiationException e1) {

				e1.printStackTrace();
				throw new ControllerException(e1);
			} catch (IllegalAccessException e1) {
				e1.printStackTrace();
				throw new ControllerException(e1);
			}
		}
		MapConverter mc=new MapConverter();
		try {
			mc.validateAndSetBeanProperties(item, request.getParameterMap(), false);
			processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
			beanModel=new BeanModel<T>(item);
		} catch (MapConverterException e) {
			e.printStackTrace();
			processResult=new ProcessResult(ProcessResult.Type.ERROR);
			beanModel=null;
			
		}
		
	
	}
	protected void _apply(HttpServletRequest request,T item)
			throws ControllerException {
		Map<String,String[]> map = request.getParameterMap();

		BeanModel<?> newBeanModel=null;

		EntityManager em = getThreadEntityManager();
		//securityManager.checkPersistPermission(request, newItem);
//		boolean idGenerated=beanInfo.isIdGenerated();
		// pre persist the item
//		if(idGenerated){
//			em.persist(newItem);
//		}
			setPropertiesOnCreate(request,em,item);
			PersistenceMapConverter mapConverter = new PersistenceMapConverter();
			try {
				//mapConverter.setBeanProperties(newItem, map, em, true,request,securityManager);
				newBeanModel=mapConverter.createBeanModel(item, map, em, false, request, securityManager);
			} catch (MapConverterException e) {
				e.printStackTrace();
				//if(idGenerated)em.remove(newItem);
				rollback();
				Throwable cause=e.getCause();
				if(cause instanceof ControllerException){
					throw (ControllerException)cause;
				}
				throw new ControllerException("Could not apply properties.", e);
			}
			ExtBeanInfo bInfo = getBeanInfo();
			if (bInfo.getIdPropertyDescriptor() != null && !isIdGenerated()) {
				// check if id already exists
				Object idO;
				try {
					idO = bInfo.getIdValue(item);
				} catch (Exception e) {
					
					e.printStackTrace();
					em.remove(item);
					throw new ControllerException(e);
				}
				Object exO = em.find(bInfo.getBeanDescriptor().getBeanClass(),
						idO);
				if (exO != null) {
					throw new ObjectAlreadyExistsException(idO);
				}
			}
		
			ValidationResult validationResult=null;
			try {
				validationResult=validate(newBeanModel.getBean(),newBeanModel.getValidationResult());
			} catch (ValidationException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			}
			processResult=new ProcessResult(validationResult);
			
			//processResult=null;
			beanModel=new BeanModel<T>(item,validationResult);
	}
	
	protected ValidationResult validateAlreadyExisting(EntityManager em,PropertyDescriptor idPd,T mergeItem) throws ControllerException {
		ValidationResult validationResult=null;
		if (idPd != null && !isIdGenerated()) {
			// check if id already exists
			Object idO;
			try {
				idO = beanInfo.getIdValue(mergeItem);
			} catch (Exception e) {

				e.printStackTrace();
				em.remove(mergeItem);
				throw new ControllerException(e);
			}
			Object exO = em.find(beanInfo.getBeanDescriptor().getBeanClass(),
					idO);
			if (exO != null) {
				validationResult=new ValidationResult(ValidationResult.Type.ERRORS);
				
				Object classDescr=null;
				String bRbNm=beanInfo.getResourceBundleName();
				String bClResKey=beanInfo.getClassResourceKey();
				if(bRbNm!=null && bClResKey!=null){
					LocalizableMessage objClassNm=new LocalizableMessage(bRbNm,bClResKey);
					classDescr=objClassNm;
				}else{
					classDescr=beanInfo.getBeanDescriptor().getBeanClass().getName();
				}
				
				PropertyValidationResult idPvr=new PropertyValidationResult(PropertyValidationResult.Type.ERROR, new LocalizableMessage("ipsk.jsp.Messages", "object.already_exists",new Object[]{classDescr,idO}));
				validationResult.putPropertyValidationResult(idPd.getName(), idPvr);
				//throw new ObjectAlreadyExistsException(idO);
			}
		}
		return validationResult;
	}
	
	
	protected void add(HttpServletRequest request, String command)
			throws ControllerException {
		
		Map<String,String[]> map = (Map<String,String[]>)request.getParameterMap();
		T newItem= null;
		try {
			newItem = queryType.getDeclaredConstructor().newInstance();
		} catch (InstantiationException | IllegalAccessException | IllegalArgumentException
				| InvocationTargetException | NoSuchMethodException | SecurityException e1) {
			e1.printStackTrace();
			throw new ControllerException(e1);
		}

		EntityManager em = getThreadEntityManager();
		
		BeanModel<T> newBeanModel=new BeanModel<T>(newItem);
		boolean idGenerated=beanInfo.isIdGenerated();
		ValidationResult validationResult=null;
		ExtBeanInfo bInfo = getBeanInfo();
		PropertyDescriptor idPd=bInfo.getIdPropertyDescriptor();
		PersistenceMapConverter<T> mapConverter = new PersistenceMapConverter<T>();
		boolean prePersisted=false;
		try {
			boolean prePersistRequired=mapConverter.createPrepersistBeanModel(newItem, map,newBeanModel);
			if(idGenerated || prePersistRequired) {
				validationResult=validateAlreadyExisting(em, idPd, newItem);
				if(validationResult==null) {
					securityManager.checkPersistPermission(request, newItem);
					em.persist(newItem);
					em.flush();
					prePersisted=true;
				}
			}
		} catch (MapConverterException e) {
			throw new ControllerException(e);
		}
		BeanModel<T> mergeModel=newBeanModel;
		
		setPropertiesOnCreate(request,em,newItem);
		T mergeItem=mergeModel.getBean();
		if(validationResult==null || validationResult.isValid()){
			try {
				mapConverter.applyToBeanModel(mergeModel, map, em, true, request, securityManager);
				
			} catch (MapConverterException e) {
				e.printStackTrace();
				rollback();
				Throwable cause=e.getCause();
				if(cause instanceof ControllerException){
					throw (ControllerException)cause;
				}
				throw new ControllerException("Could not apply properties.", e);
			}
			setPropertiesOnApply(request, em, mergeItem);
			if(!prePersisted) {
				validationResult=validateAlreadyExisting(em, idPd, newItem);
			}
			try {
				validationResult=validate(mergeModel.getBean(),mergeModel.getValidationResult());
			} catch (ValidationException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			}
		}

		processResult=new ProcessResult(validationResult);
		if (validationResult.isValid()) {
			
			if(idGenerated || prePersisted){
				securityManager.checkMergePermission(request, mergeItem);
				em.merge(mergeItem);
			}else{
				// Adding ORGANISATION UserRole problem here:
				// UserRole mergeItem is not yet persisted here
				// EclipseLnk discovers this when fetching the case insensitive LDAP current user account and fails
				// Persist the entity without check and check permission afterwards. If not permitted the exception will rollback the insert. 
				//securityManager.checkPersistPermission(request, mergeItem);
				em.persist(mergeItem);
				securityManager.checkPersistPermission(request, mergeItem);
			}
			em.flush();
		}else{
			rollback();
		}
		beanModel=new BeanModel<T>(mergeItem,validationResult);
	}
	
	
	public boolean isApplyAllProperties() {
		return applyAllProperties;
	}

	public void setApplyAllProperties(boolean applyAllProperties) {
		this.applyAllProperties = applyAllProperties;
	}

	private void processRelationShip(Map<String, String[]> queryMap)
			throws ControllerException {
		ExtBoolExpr relatedCondition = null;

		// String qc=null;
		PersistenceObjectIdentifier poi;
		try {
			poi = PersistenceObjectIdentifier.parseQueryMap(queryMap);
		} catch (ParserException e1) {

			e1.printStackTrace();
			throw new ControllerException(
					"Could not parse object identifier from query map.", e1);
		} catch (IntrospectionException e1) {
			e1.printStackTrace();
			throw new ControllerException("Could not introspect class.", e1);
		}
		PropertyDescriptor[] ppds = beanInfo
				.getPersistencePropertyDescriptors();

		// String idStr = queryMap.get(KEY_RELATED_ID)[0];
		String propertyName = null;

		String[] mappedByArr = queryMap.get(KEY_MAPPEDBY);
		//boolean relIsToOne=false;
		if (mappedByArr != null) {
			// ManyToOne
			propertyName = mappedByArr[0];
			for (PropertyDescriptor pd : ppds) {
				if (pd.getName().equals(propertyName)) {
					relatedPropertyDescriptor = pd;
					//relIsToOne=true;
					break;
				}
			}
			if(relatedPropertyDescriptor==null){
				throw new ControllerException("Could not find related property descriptor for mapped by : '"+propertyName+"'");
			}
		} else {
			// OneToMany,ManyToMany,OneToOne
			String[] relatedPropArr=queryMap.get(KEY_RELATED_PROPERTY);
			if(relatedPropArr==null || relatedPropArr.length!=1){
				throw new ControllerException("Related property name missing in query (parameter '"+KEY_RELATED_PROPERTY+"'");
			}
			String relatedProp = relatedPropArr[0];
			
//			relatedPropertyDescriptor = getPropertyDescriptorByMappedBy(ppds,poi.getTargetClass(), relatedProp);
			List<PropertyDescriptor> retTypeMatchPds=getPropertyDescriptorByReturnType(ppds, poi.getTargetClass());
			relatedPropertyDescriptor=null;
			for (PropertyDescriptor pd : retTypeMatchPds) {
				Method rm = pd.getReadMethod();
				
				String mappedBy = null;
				ManyToMany mToMAnno = rm
						.getAnnotation(ManyToMany.class);
				OneToMany oToMAnno = rm
						.getAnnotation(OneToMany.class);
				OneToOne oToOAnno=rm.getAnnotation(OneToOne.class);
				if (mToMAnno != null) {
					mappedBy = mToMAnno.mappedBy();
				} else if(oToMAnno!=null){
					mappedBy = oToMAnno.mappedBy();
				}else if(oToOAnno!=null){
					mappedBy=oToOAnno.mappedBy();
					//relIsToOne=true;
				}
				if (mappedBy != null && mappedBy.equals(relatedProp)) {
					relatedPropertyDescriptor=pd;
					break;
				}else if(retTypeMatchPds.size()==1){
					relatedPropertyDescriptor=retTypeMatchPds.get(0);
					break; // redundant
				}
			}
			if(relatedPropertyDescriptor==null){
				throw new ControllerException("Could not find related property descriptor: '"+relatedProp+"'");
			}
			propertyName = relatedPropertyDescriptor.getName();
		}
		
		String relatedPropertyName = relatedPropertyDescriptor.getName();
		Class<?> relatedType = relatedPropertyDescriptor.getPropertyType();
		Method readMethod = relatedPropertyDescriptor.getReadMethod();
		
		if(mode !=null && mode instanceof ListMode){
			SelectMode selectMode=((ListMode) mode).getSelectMode();
			SelectMode.ActionType actionType = null;
			if(selectMode!=null){
				actionType=selectMode.getActionType();
			}
			if (Collection.class.isAssignableFrom(relatedType)) {
				// we need the parameterized type argument e.g. Person
				// for method: Set<Person> getPersons()
				Type rt = readMethod.getGenericReturnType();
				if (rt instanceof ParameterizedType) {
					ParameterizedType prt = (ParameterizedType) rt;
					Type[] pts = prt.getActualTypeArguments();
					if (pts.length != 1) {
						throw new ControllerException(
								"Parameterized type "
										+ prt
										+ " has not exactly one type argument\nCannot get bean info of property return type.");
					}
				} else {
					throw new ControllerException(
							"Property "
									+ relatedPropertyName
									+ " is not prameterized.\nCannot create Id object for unknown type!");
				}

				if(actionType==null){
					relatedCondition = new ExtBoolExpr();
					relatedCondition.setOperator(ExtBoolExpr.MEMBER);
				}else if (actionType.equals(ActionType.ADD)) {

					relatedCondition = new ExtBoolExpr();
					relatedCondition.setOperator(ExtBoolExpr.NOT_MEMBER);
				} else if (actionType.equals(ActionType.REMOVE) || ActionType.DELETE.equals(actionType)) {
					relatedCondition = new ExtBoolExpr();
					relatedCondition.setOperator(ExtBoolExpr.MEMBER);
				} else if (actionType.equals(ActionType.SET)) {
					// do not set a condition
				}else if (actionType.equals(ActionType.RESET)) {
					relatedCondition = new ExtBoolExpr();
					relatedCondition.setOperator(ExtBoolExpr.MEMBER);
				} 

			} else {
				// related type is the return type of the getter method
				// e.g. Person getPerson()
				//relatedReturnType = relatedPropertyDescriptor.getPropertyType();
				if (actionType==null || actionType.equals(ActionType.REMOVE) || ActionType.DELETE.equals(actionType)) {
					relatedCondition = new ExtBoolExpr();
					relatedCondition.setOperator(ExtBoolExpr.EQUALS);
				}else if (actionType.equals(ActionType.ADD)) {
					relatedCondition = new ExtBoolExpr();
					//relatedCondition.setOperator(ExtBoolExpr.EQUALS_NOT);
					// we need IS NULL here !!
					relatedCondition.setOperator(ExtBoolExpr.NOT_BOUND);
				}  

			}		
			if (relatedCondition != null) {
				relatedCondition.setOperand0(relatedPropertyDescriptor.getName());
				// TODO not necessary for ManyToOne (IS NULL has no operand)
				relatedCondition.setOperand1(poi);
			}
			setBoolCondition(relatedCondition);
		}
		setRelatedObjectIdentifier(poi);
	}


	
	
	public void processListRequest(HttpServletRequest req) throws ControllerException{
		currentRequest=req;
		clear();
		if(!(mode instanceof ListMode)){
			mode=new ListMode();
		}
		createBeanTableModel(req.getParameter(KEY_CMD),req);
	}
	
//	public void processListRequest(String command) throws ControllerException{
//		mode=new ListMode();
//		createBeanTableModel(command);
//	}
	
	public String processCommand(HttpServletRequest request,String[] possibleSubmitCommands){
		String command = request.getParameter(KEY_CMD);
		
		// find submit commands
		for (String possibleSubmitCmd :possibleSubmitCommands) {
			if (request.getParameter("_" + possibleSubmitCmd) != null) {
				command = possibleSubmitCmd;
				break;
			}
		}
		return command;
	}
	public String processCommand(HttpServletRequest request){
		return processCommand(request,SUBMIT_CMDS);
	}
	/**
	 * Compatibility method implementation only.
	 * @throws ControllerException 
	 */
	public ProcessResult process(HttpServletRequest request,HttpServletResponse response,Servlet servlet) throws ControllerException{
		processRequest(request);
		return getProcessResult();
	}
	/**
	 * Compatibility method implementation only.
	 * @throws ControllerException 
	 */
	public ProcessResult process(HttpServletRequest request,HttpServletResponse response) throws ControllerException{
		processRequest(request);
		return getProcessResult();
	}
	
	
	@SuppressWarnings("unchecked")
	public void processRequest(HttpServletRequest request)
			throws ControllerException {
		processRequest(request, null);
	}
	
	@SuppressWarnings("unchecked")
	public void processRequest(HttpServletRequest request,ParameterizedQuery parameterizedQuery)
			throws ControllerException {
		currentRequest=request;
		
		this.parameterizedQuery=parameterizedQuery;
		namedQuery=null;
		//clear();
		processResult=null;
		//beanModel=null;
		//beanTableModel=null;
		//validationResult=null;
		cancelledItem=null;
		actionCanceled=false;
		if (request.getCharacterEncoding() == null) {
			try {
				request.setCharacterEncoding("UTF-8");
			} catch (UnsupportedEncodingException e) {
				throw new ControllerException(e);
			}
		}
		Map<String,String[]> queryMap=request.getParameterMap();
		String command=processCommand(request);
		if(command!=null && command.equals(CMD_CANCEL)){
			cancelledItem=getItem();
			beanModel=new BeanModel<T>((T)null,new ValidationResult(ValidationResult.Type.CANCELLED));
			processResult=new ProcessResult(ProcessResult.Type.CANCELLED);
			actionCanceled=true;
			return;
		}
		if(command !=null && command.equals(CMD_CANCEL_STORE_RELATED)){
			//processResult=new ProcessResult(ProcessResult.Type.CANCELLED);
			actionCanceled=true;
			command=CMD_EDIT;
		}
		
		// set default command
		// and translate cancel commands
		if (command == null || command.equals(CMD_CANCEL))command = CMD_LIST;
		
	
		if (CMD_LIST_RELATED.equals(command)) {
			beanModel=null;
			beanTableModel=null;
			setNamedQuery(null, null);
			setBoolCondition(null);
			mode=new ListMode();
			processRelationShip(queryMap);
			createBeanTableModel(CMD_LIST,request);
		}else if (command.equals(CMD_SELECT_TO_ADD)) {
			beanModel=null;
			beanTableModel=null;
			setNamedQuery(null, null);
			setBoolCondition(null);
			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
			ListMode lm=new ListMode();
			lm.setSelectMode(new SelectMode(SelectMode.ActionType.ADD,request.getParameter(KEY_ACTION),selectTargetProperty));
			mode=lm;
			BeanTableModel<T> btm = new BeanTableModel<T>();
			processRelationShip(queryMap);
			
			createBeanTableModel(command,btm,request);
		}else if (command.equals(CMD_SELECT_TO_REMOVE)) {
			beanModel=null;
			beanTableModel=null;
			setNamedQuery(null, null);
			setBoolCondition(null);
			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
			ListMode lm=new ListMode();
			lm.setSelectMode(new SelectMode(SelectMode.ActionType.REMOVE,request.getParameter(KEY_ACTION),selectTargetProperty));
			mode=lm;
			BeanTableModel<T> btm = new BeanTableModel<T>();
			processRelationShip(queryMap);
			
			createBeanTableModel(command,btm,request);
		}else if (command.equals(CMD_SELECT_TO_DELETE)) {
			beanModel=null;
			beanTableModel=null;
			setNamedQuery(null, null);
			setBoolCondition(null);
			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
			ListMode lm=new ListMode();
			lm.setSelectMode(new SelectMode(SelectMode.ActionType.DELETE,request.getParameter(KEY_ACTION),selectTargetProperty));
			mode=lm;
			BeanTableModel<T> btm = new BeanTableModel<T>();
			processRelationShip(queryMap);
			
			createBeanTableModel(command,btm,request);
		}else if (command.equals(CMD_SELECT_TO_SET)) {
			beanModel=null;
			beanTableModel=null;
			setNamedQuery(null, null);
			setBoolCondition(null);
			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
			ListMode lm=new ListMode();
			lm.setSelectMode(new SelectMode(SelectMode.ActionType.SET,request.getParameter(KEY_ACTION),selectTargetProperty));
			mode=lm;
			BeanTableModel<T> btm = new BeanTableModel<T>();
			processRelationShip(queryMap);
			createBeanTableModel(command,btm,request);
		}else if (command.equals(CMD_SELECT_TO_RESET)) {
			beanModel=null;
			beanTableModel=null;
			setNamedQuery(null, null);
			setBoolCondition(null);
//			String selectTargetProperty=request.getParameter(KEY_RELATED_PROPERTY);
//			ListMode lm=new ListMode();
//			lm.setSelectMode(new SelectMode(SelectMode.ActionType.RESET,request.getParameter(KEY_ACTION),selectTargetProperty));
//			mode=lm;
			BeanTableModel<T> btm = new BeanTableModel<T>();
			//processRelationShip(queryMap);
			
			createBeanTableModel(command,btm,request);
		}else if (CMD_LIST_NUM_ROWS_PAGE.equals(command)) {
			beanModel=null;
			beanTableModel=null;
			String rowsParm=request.getParameter(KEY_ROWS);
			if(rowsParm!=null){
				int newRows=Integer.parseInt(rowsParm);
				if(newRows >0 ){
					if(newRows>MAX_BATCHSIZE){
						newRows=MAX_BATCHSIZE;
					}
					setBatchSize(newRows);
				}
			}
			processListRequest(request);
			// createBeanTableModel(command);
		}else if (command.equals(CMD_LIST) || command.equals(CMD_LIST_ALL)) {
			beanModel=null;
			beanTableModel=null;
			//relatedQuery=null;
			setBoolCondition(null);
			mode=new ListMode();
			//createBeanTableModel(command);
			processListRequest(request);
		}else if (command.startsWith(CMD_LIST)) {
			beanModel=null;
			beanTableModel=null;
			//relatedQuery=null;
			//createBeanTableModel(command);
			processListRequest(request);
		}  else if (command.equals(CMD_NAMED_QUERY)) {
			beanModel=null;
			beanTableModel=null;
			//relatedQuery=null;
			mode=new ListMode();
			PersistenceObjectIdentifier poi;
			try {
				poi = PersistenceObjectIdentifier.parseQueryMap(queryMap);
			} catch (ParserException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			} catch (IntrospectionException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			}
			setNamedQuery(request.getParameter("name"),poi);
			createBeanTableModel(command,request);
		} else if (command.equals(CMD_NAMED_QUERY_SINGLE)) {
			beanModel=null;
			beanTableModel=null;
			PersistenceObjectIdentifier poi;
			try {
				poi = PersistenceObjectIdentifier.parseQueryMap(queryMap);
			} catch (ParserException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			} catch (IntrospectionException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			}
			setNamedQuery(request.getParameter("name"), poi);
			
			//getItem();
			createSingleItemModel(request);
			mode=new ViewMode();
		} else if (command.equals(CMD_NEW)) {
			beanModel=null;
			beanTableModel=null;
			setNamedQuery(null, null);
			//relatedQuery=null;
			setId(null);
			mode=new EditMode();
			Object newItem;
			// new
			try {
				newItem = queryType.newInstance();

			} catch (Exception e) {
				e.printStackTrace();
				throw new ControllerException(
						"Could not instantiate new object.", e);
			}
			Map<String, String[]> map = request.getParameterMap();
			EntityManager em = getThreadEntityManager();
			try {
				PersistenceMapConverter<T> mapConverter = new PersistenceMapConverter<T>();
				try {
					mapConverter.setBeanProperties(newItem, map, em, false,request,securityManager);
				} catch (MapConverterException e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}
				setPropertiesOnNew(newItem);
				
			} catch (PersistenceException e) {
				e.printStackTrace();
				close();
				throw e;
			} 
			T newItemT=(T)newItem;
			beanModel=new BeanModel<T>(newItemT);
			
			
		}else if (command.equals(CMD_NEW_TO_ADD)) {
			beanModel=null;
			beanTableModel=null;
			setNamedQuery(null, null);
			//relatedQuery=null;
			setId(null);
			mode=new EditMode();
			Object newItem;
			// new
			try {
				newItem = queryType.newInstance();

			} catch (Exception e) {
				e.printStackTrace();
				throw new ControllerException(
						"Could not instantiate new object.", e);
			}
			Map<String, String[]> map = request.getParameterMap();
			EntityManager em = getThreadEntityManager();
			try {
				PersistenceMapConverter mapConverter = new PersistenceMapConverter();
				try {
					mapConverter.setBeanProperties(newItem, map, em, false,request,securityManager);
					//beanModel=mapConverter.createBeanModel(newItem, map, em, false, request, securityManager);
				} catch (MapConverterException e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}
				setPropertiesOnNew(newItem);
				
			} catch (PersistenceException e) {
				e.printStackTrace();
				close();
				throw e;
			} 
			processRelationShip(queryMap);
			if(relatedPropertyDescriptor!=null){
				// set parent 
				Method wm=relatedPropertyDescriptor.getWriteMethod();
				Method rm=relatedPropertyDescriptor.getReadMethod();
				PersistenceObjectIdentifier poi=getRelatedObjectIdentifier();
				Object poiIdObj=poi.getIdObject();
				Object relatedParentObj=em.find(poi.getTargetClass(), poiIdObj);
				ManyToMany mtom=rm.getAnnotation(ManyToMany.class);
				try {
					if(mtom!=null){
						
						Object collObj=rm.invoke(newItem,new Object[0]);
						
						if(collObj instanceof Collection<?>){
							// Note: coll should be empty here. It is called on a new bean.
							Collection<Object> coll=(Collection<Object>)collObj;
							coll.add(relatedParentObj);
						}
					}else{
						wm.invoke(newItem, relatedParentObj);
					}
				} catch (Exception e) {
					e.printStackTrace();
					throw new ControllerException(e);
				} 
			}
			T newItemT=(T)newItem;
			beanModel=new BeanModel<T>(newItemT);
			

		}else if (command.equals(CMD_REMOVE)) {
			beanModel=null;
			beanTableModel=null;
			if(checkSecureRequestToken) {
				secureRequestTokenProvider.checkSecureRequestToken(request);
			}
			String idStr = request.getParameter(beanInfo
					.getIdPropertyDescriptor().getName());
			try {
				setId(beanInfo.createIdValueByString(idStr));
			} catch (Exception e) {

				e.printStackTrace();
				throw new ControllerException(e);
			}
			
			Object o=removeById(request,id);
			T ot=(T)o;
			beanModel=new BeanModel<T>(ot);
			processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
			
		} else if (command.equals(CMD_DELETE)) {
			beanModel=null;
			beanTableModel=null;
			if(checkSecureRequestToken) {
				secureRequestTokenProvider.checkSecureRequestToken(request);
			}
			String idStr = request.getParameter(beanInfo
					.getIdPropertyDescriptor().getName());
			try {
				setId(beanInfo.createIdValueByString(idStr));
			} catch (Exception e) {

				e.printStackTrace();
				throw new ControllerException(e);
			}
			EntityManager em=getThreadEntityManager();
			Object objToDelete = em.find(queryType, id);
			if(objToDelete==null){
				throw new NoSuchObjectException(id);
			}
			beforeDelete(request,objToDelete);
			deleteRelated(request,objToDelete);
			Object o=removeById(request,id,true);
			afterDelete(request, o);
			T ot=(T)o;
			beanModel=new BeanModel<T>(ot);
			processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
			
		}else if (command.equals(CMD_EDIT) || command.equals(CMD_EDIT_OR_NEW) || command.equals(CMD_CORRECT) || command.equals(CMD_VIEW) || command.equals(CMD_EXPORT)) {
			beanModel=null;
			beanTableModel=null;
//			Map map = request.getParameterMap();
//			Object idObj = createIdObject(map);
//			EntityManager em = getThreadEntityManager();
//			Object editItem;
//			try {
//				editItem = em.find(queryType, idObj);
//				if(editItem==null){
//					throw new NoSuchObjectException(idObj);
//				}
//				PersistenceMapConverter mapConverter = new PersistenceMapConverter();
//				try {
//					mapConverter.setBeanProperties(editItem, map, em, false,request,securityManager);
//					// TODO check permissions here !!
//					beanModel=new BeanModel(editItem);
//				} catch (MapConverterException e) {
//					e.printStackTrace();
//					throw new ControllerException(
//							"Could not apply property values.", e);
//				}
//			} catch (PersistenceException e) {
//				e.printStackTrace();
//				close();
//				throw e;
//			}
			boolean createIfNotExists=CMD_EDIT_OR_NEW.equals(command);
			createBeanModel(request,createIfNotExists);
			
			if(command.equals(CMD_EDIT) || command.equals(CMD_EDIT_OR_NEW) ||  command.equals(CMD_CORRECT)){
				mode=new EditMode();
			}else{
				mode=new ViewMode();
			}
		}  else if (command.equals(CMD_APPLY)) {
			beanModel=null;
			beanTableModel=null;
			apply(request);

		} else if (command.equals(CMD_MERGE)) {
			if(checkSecureRequestToken) {
				secureRequestTokenProvider.checkSecureRequestToken(request);
			}
			merge(request);

		}else if (command.equals(CMD_STORE)) {
			beanModel=null;
			beanTableModel=null;
			if(checkSecureRequestToken) {
				secureRequestTokenProvider.checkSecureRequestToken(request);
			}
			Map<String, String[]> map = request.getParameterMap();
			Object idObj = createIdObject(map);
			EntityManager em = getThreadEntityManager();
			T mergeItem = em.find(queryType, idObj);
			if(mergeItem==null) throw new ControllerException("Item with ID '"+idObj+"' to update not found !");
//			createBeanModel(request);
			// Next does not work: 
			// mergeProperties is only suitable for add, it checks if the object already exists
//			mergeProperties(request,mergeItem);
			
			beanModel=new BeanModel<T>(mergeItem);
			PersistenceMapConverter<T> mapConverter = new PersistenceMapConverter<T>();
			try {
				
//				mapConverter.setBeanProperties(mergeItem, map, em, false,request,securityManager);
				mapConverter.applyToBeanModel(beanModel, map, em, false, request, securityManager);
			} catch (MapConverterException e) {
//				close();
				e.printStackTrace();
				throw new ControllerException(e);
			}
			setPropertiesOnApply(request, em, mergeItem);

			ValidationResult validationResult=null;
			try {
				validationResult=validate(beanModel.getBean(),beanModel.getValidationResult());
				beanModel.setValidationResult(validationResult);
			} catch (ValidationException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			}
			if(validationResult.isValid()){
				securityManager.checkMergePermission(request, mergeItem);
				em.merge(mergeItem);
				em.flush();
			}
//			beanModel=new BeanModel(mergeItem,validationResult);
			processResult=new ProcessResult(validationResult);

		} else if (command.equals(CMD_STORE_ADD_RELATED) || command.equals(CMD_STORE_REMOVE_RELATED) || command.equals(CMD_STORE_DELETE_RELATED) || command.equals(CMD_STORE_SET_RELATED) || command.equals(CMD_STORE_RESET_RELATED)) {
			beanModel=null;
			beanTableModel=null;
			if(checkSecureRequestToken) {
				secureRequestTokenProvider.checkSecureRequestToken(request);
			}
			Map<String, String[]> map = request.getParameterMap();
			Object idObj = createIdObject(map);
			EntityManager em = getThreadEntityManager();
			try {
				T o = em.find(queryType, idObj);
				if(o==null){
					throw new ControllerException("Could not find entity for class "+queryType+ " with ID: "+idObj);
				}
				
					
				
					
				securityManager.checkMergePermission(request, o);
				
				beanModel=new BeanModel<T>(o);
				// now find relationship query parameters
				PropertyDescriptor[] ppds=beanInfo.getPersistencePropertyDescriptors();
				PropertyDescriptor propertyDescriptor=null;
				Object enumValue=null;
				//String propertyIdProperty;
				String[] relatedIdValues=null;
				Set<String> queryKeySet=queryMap.keySet();
				for(String key:queryKeySet){
					int dotPosition=key.indexOf(".");
					if(dotPosition==-1){
						// looking for related property
						// means there must be a dot in the key
						continue;
					}
					// Ok try to lookup property name
					String pName=key.substring(0,dotPosition);
					
					for(PropertyDescriptor pd:ppds){
						if(pd.getName().equals(pName)){
							// found
							propertyDescriptor=pd;
							relatedIdValues=queryMap.get(key);
							//propertyIdProperty=key.substring(dotPosition);
							break;
						}
					}
					if(propertyDescriptor!=null){
						break;
					}
				}
				if (propertyDescriptor!=null){
				//
				Method readMethod=propertyDescriptor.getReadMethod();
				Method writeMethod=propertyDescriptor.getWriteMethod();
				Class<?> collType=null;
				
				
				// JPA 2 Metamodel experiments
				// Works, but how to get the mappedBy value of an OneToMany relationship/annotation ?
				// The JPA 2 meta model does not reflect the complete mapping
//		
//				Metamodel mm=em.getMetamodel();
//				EntityType<?> et=mm.entity(queryType);
//				Attribute<?, ?> attr=et.getAttribute(propertyDescriptor.getName());
//				boolean isAssociation=attr.isAssociation();
//				boolean isColl=attr.isCollection();
//				Attribute.PersistentAttributeType attrType=attr.getPersistentAttributeType();
//				String attrTypeStr=attrType.toString();
//				ManagedType<?> mt=attr.getDeclaringType();
//				String manClass=mt.getJavaType().toString();
//				Member jMember=attr.getJavaMember();
//				String jMemberName=jMember.getName();
//				if( attr instanceof Bindable<?>){
//					Bindable<?> bindable=(Bindable<?>)attr;
//					String bStr=bindable.toString();
//				}
				
				
				OneToMany oneToManyAnno=readMethod.getAnnotation(OneToMany.class);
				ManyToMany manyToManyAnno=readMethod.getAnnotation(ManyToMany.class);
				ManyToOne manyToOneAnno=readMethod.getAnnotation(ManyToOne.class);
				OneToOne oneToOneAnno=readMethod.getAnnotation(OneToOne.class);
				
				Enumerated enumerated=readMethod.getAnnotation(Enumerated.class);
				ElementCollection elementCollection=readMethod.getAnnotation(ElementCollection.class);
				
				if(oneToManyAnno!=null){
					// store at the owning (the inverse) side
					String mappedByPropertyName=oneToManyAnno.mappedBy();
					Type rt = readMethod.getGenericReturnType();
					if (rt instanceof ParameterizedType) {
						ParameterizedType prt = (ParameterizedType) rt;
						Type[] pts = prt.getActualTypeArguments();
						if (pts.length == 1) {
							// we expect exactly one parameterized type argument
							collType = (Class<?>) pts[0];
						} else {
							throw new ControllerException(
									"Parameterized type "
											+ prt
											+ " has more than one type arguemnts\nCannot get bean info of property return type.");
						}
					}else {
						throw new ControllerException(
								"Collection return type of property is not parametrized.\nCannot get bean info of property return type.");
					}
					ExtBeanInfo retTypeInfo=null;
					
						retTypeInfo=PersistenceIntrospector.getPersistenceBeanInfo(collType);
					Collection<Object> collVal=(Collection<Object>)readMethod.invoke(o, new Object[0]);
					for(String idStr:relatedIdValues){
						Object relIdObj=retTypeInfo.createIdValueByString(idStr);
						Object relObj=em.find(collType, relIdObj);
						
						PropertyDescriptor relPd=null;
						PropertyDescriptor[] relPpds=retTypeInfo.getPersistencePropertyDescriptors();
						for(PropertyDescriptor rPd:relPpds){
							if(rPd.getName().equals(mappedByPropertyName)){
								relPd=rPd;
								break;
							}
						}
						securityManager.checkMergePermission(request, relObj,relPd);
						Method relWriteMethod=relPd.getWriteMethod();
						if(command.equals(CMD_STORE_ADD_RELATED)){
							relWriteMethod.invoke(relObj, new Object[]{o});
							//store to non owning side (this side)
							collVal.add(relObj);
						}else if(command.equals(CMD_STORE_REMOVE_RELATED)){
							relWriteMethod.invoke(relObj, new Object[]{null});
							collVal.remove(relObj);
						}else if(command.equals(CMD_STORE_DELETE_RELATED)){
							// delete means remove the object itself
							securityManager.checkRemovePermission(request, relObj);
							relWriteMethod.invoke(relObj, new Object[]{null});
							collVal.remove(relObj);
							em.remove(relObj);
						}
					
						//em.merge(relObj);
					}
					//em.refresh(o);
					
					
				
				}else if(manyToManyAnno!=null){
					Type rt = readMethod.getGenericReturnType();
					if (rt instanceof ParameterizedType) {
						ParameterizedType prt = (ParameterizedType) rt;
						Type[] pts = prt.getActualTypeArguments();
						if (pts.length == 1) {
							// we expect exactly one parameterized type
							// argument
							collType = (Class<?>) pts[0];
						} else {
							throw new ControllerException(
									"Parameterized type "
											+ prt
											+ " has more than one type arguemnts\nCannot get bean info of property return type.");
						}
					}else {
						throw new ControllerException(
								"Collection return type of property is not parametrized.\nCannot get bean info of property return type.");
					}
					ExtBeanInfo retTypeInfo=null;
					
					retTypeInfo=PersistenceIntrospector.getPersistenceBeanInfo(collType);
					String relatedPropertyName=manyToManyAnno.mappedBy();
					if(relatedPropertyName==null || "".equals(relatedPropertyName)){
						// no mappedBy attribute
						// try to find single property with matching return type
						List<PropertyDescriptor> retTypeMatchPds=getPropertyDescriptorByReturnType(retTypeInfo.getPropertyDescriptors(),queryType);
						if(retTypeMatchPds!=null && retTypeMatchPds.size()==1){
							PropertyDescriptor retTypeMatchPd=retTypeMatchPds.get(0);
							relatedPropertyName=retTypeMatchPd.getName();
						}
					}
					if(relatedPropertyName!=null && ! relatedPropertyName.equals("")){
						
						for(String idStr:relatedIdValues){
							Object relIdObj=retTypeInfo.createIdValueByString(idStr);
							Object relObj=em.find(collType, relIdObj);
							securityManager.checkMergePermission(request, relObj);
							PropertyDescriptor relPd=null;
							PropertyDescriptor[] relPpds=retTypeInfo.getPersistencePropertyDescriptors();
							for(PropertyDescriptor rPd:relPpds){
								if(rPd.getName().equals(relatedPropertyName)){
									relPd=rPd;
									break;
								}
							}
							
							//Method relWriteMethod=relPd.getWriteMethod();
							Method relReadMethod=relPd.getReadMethod();
							// get collection
							Collection<Object> coll=(Collection<Object>)readMethod.invoke(o, new Object[0]);
							Collection<Object> relColl=(Collection<Object>)relReadMethod.invoke(relObj, new Object[0]);
							securityManager.checkMergePermission(request, relObj,relatedPropertyDescriptor);
							if (command.equals(CMD_STORE_ADD_RELATED)) {
								relColl.add(o);
								coll.add(relObj);
							} else if (command.equals(CMD_STORE_REMOVE_RELATED)) {
								relColl.remove(o);
								coll.remove(relObj);
							}else if(command.equals(CMD_STORE_DELETE_RELATED)){
								securityManager.checkRemovePermission(request, relObj);
								relColl.remove(o);
								coll.remove(relObj);
								// delete means remove the object itself
								em.remove(relObj);
								//deleteRelatedObject(em, relObj);
							}
							
							// TODO is it necessary to call merge here ?
							//em.merge(relObj);
						}
//						 Refresh on the inverse side to reflect change
						//em.refresh(o);
					
					}else{
						// no mappedby means this is owning side
						PropertyDescriptor relPd=null;
						PropertyDescriptor[] relPpds=retTypeInfo.getPersistencePropertyDescriptors();
						for(PropertyDescriptor rPd:relPpds){
							ManyToMany relMtoMAnno=rPd.getReadMethod().getAnnotation(ManyToMany.class);
							if(relMtoMAnno !=null && relMtoMAnno.mappedBy().equals(propertyDescriptor.getName())){
								relPd=rPd;
								break;
							}
						}
						Method relReadMethod=relPd.getReadMethod();
						Collection<Object> coll=(Collection<Object>)readMethod.invoke(o, new Object[0]);
						
						Object[] relatedObjects=new Object[relatedIdValues.length];
						for(int i=0;i<relatedIdValues.length;i++){
							Object relIdObj=retTypeInfo.createIdValueByString(relatedIdValues[i]);
							relatedObjects[i]=em.find(collType, relIdObj);
						}
						for(Object relObj:relatedObjects){
							securityManager.checkMergePermission(request, relObj,relPd);
							Collection<Object> relColl=(Collection<Object>)relReadMethod.invoke(relObj, new Object[0]);
							if (command.equals(CMD_STORE_ADD_RELATED)) {
								coll.add(relObj);
								relColl.add(o);
							} else if (command.equals(CMD_STORE_REMOVE_RELATED)) {
								coll.remove(relObj);
								relColl.remove(o);
							} else if (command.equals(CMD_STORE_DELETE_RELATED)) {
								securityManager.checkRemovePermission(request, relObj);
								coll.remove(relObj);
								relColl.remove(o);
								// delete means remove the object itself
								em.remove(relObj);
							}
						}
//						 TODO do we have to write the collection back ?
						//writeMethod.invoke(o, new Object[]{coll});
//						 TODO is it necessary to call merge here ?
						//em.merge(o);
//						for(Object relObj:relatedObjects){
//							em.refresh(relObj);
//						}
						
						//em.refresh(relObj);
					}
				}else if(manyToOneAnno!=null){
					// always owning side
					if(relatedIdValues.length >1){
						throw new ControllerException("More than one value for a many to one relationship.");
					}else if(relatedIdValues.length==1){
						
						String  idStr=relatedIdValues[0];
						Class<?> relatedType=readMethod.getReturnType();
						ExtBeanInfo relatedTypeInfo=PersistenceIntrospector.getPersistenceBeanInfo(relatedType);
						PropertyDescriptor relPd=null;
						PropertyDescriptor[] relPpds=relatedTypeInfo.getPersistencePropertyDescriptors();
						for(PropertyDescriptor rPd:relPpds){
							OneToMany relOtoMAnno=rPd.getReadMethod().getAnnotation(OneToMany.class);
							if(relOtoMAnno !=null && relOtoMAnno.mappedBy().equals(propertyDescriptor.getName())){
								relPd=rPd;
								break;
							}
						}
						Method relReadMethod=relPd.getReadMethod();
						Object relObj=null;
						
						if(command.equals(CMD_STORE_SET_RELATED)){
//							 set the value
							Object relIdObj=relatedTypeInfo.createIdValueByString(idStr);
							relObj=em.find(relatedType, relIdObj);
							securityManager.checkMergePermission(request, relObj,relPd);
							
							writeMethod.invoke(o, relObj);
							Collection<Object> relColl=(Collection<Object>)relReadMethod.invoke(relObj, new Object[0]);
							relColl.add(o);
						}else if(command.equals(CMD_STORE_RESET_RELATED)){
							relObj=readMethod.invoke(o,new Object[0]);
							securityManager.checkMergePermission(request, relObj,relPd);
							writeMethod.invoke(o, new Object[]{null});
							Collection<Object> relColl=(Collection<Object>)relReadMethod.invoke(relObj, new Object[0]);
							relColl.remove(o);
						}
//						em.merge(o);
//						if(relObj!=null)em.refresh(relObj);
					}
					
				}else if(oneToOneAnno!=null){
					
					if(relatedIdValues.length >1){
						throw new ControllerException("More than one value for a one to one relationship.");
					}else if(relatedIdValues.length==1){
						String  idStr=relatedIdValues[0];
						Class<?> relatedType=readMethod.getReturnType();
						String propertyName=propertyDescriptor.getName();
						PropertyDescriptor relPd=null;
						//Method relWriteMethod=null;
						ExtBeanInfo relatedTypeInfo=PersistenceIntrospector.getPersistenceBeanInfo(relatedType);
						Object relObj=null;
						String mappedByAnno=oneToOneAnno.mappedBy();
						String mappedBy=null;
						if(mappedByAnno != null && ! mappedByAnno.equals("")){
							mappedBy=mappedByAnno;
						}
						PropertyDescriptor[] relPpds=relatedTypeInfo.getPersistencePropertyDescriptors();
						for(PropertyDescriptor relPpd:relPpds){
							if(mappedBy!=null){
								if(mappedBy.equals(relPpd.getName())){
								relPd=relPpd;
								break;
								}
							}else{
								OneToOne relOnetToOneAnno=relPpd.getReadMethod().getAnnotation(OneToOne.class);
								if(relOnetToOneAnno != null){
									String relMappedby=relOnetToOneAnno.mappedBy();
									if(relMappedby != null && relMappedby.equals(propertyName)){
										relPd=relPpd;
										break;
									}
								}
							}
						}
						Method relWriteMethod=relPd.getWriteMethod();
						if(command.equals(CMD_STORE_SET_RELATED)){
//							 set the value
							Object relIdObj=relatedTypeInfo.createIdValueByString(idStr);
							relObj=em.find(relatedType, relIdObj);
							securityManager.checkMergePermission(request, relObj);
		
							Object oldRelObject=readMethod.invoke(o, new Object[0]);
							if(oldRelObject!=null){
								// reset old relationship first
								relWriteMethod.invoke(oldRelObject, new Object[]{null});
							}
							relWriteMethod.invoke(relObj,new Object[]{o});
							writeMethod.invoke(o, new Object[]{relObj});
							//em.merge(relObj);
							
						}else if(command.equals(CMD_STORE_RESET_RELATED)){
							relObj=readMethod.invoke(o,new Object[0]);
							securityManager.checkMergePermission(request, relObj);
							relWriteMethod.invoke(relObj, new Object[]{null});
							writeMethod.invoke(o, new Object[]{null});
							//em.merge(relObj);
							
						}
						//em.merge(o);
						//if(relObj!=null)em.refresh(relObj);
					}
					
				}else if(enumerated!=null){
					EnumType enumtype=enumerated.value();
					if(EnumType.STRING.equals(enumtype)){
						if(elementCollection!=null){

							Class<? extends Enum<?>> enumClass=elementCollection.targetClass();


							Type rt = readMethod.getGenericReturnType();
							if (rt instanceof ParameterizedType) {
								ParameterizedType prt = (ParameterizedType) rt;
								Type[] pts = prt.getActualTypeArguments();
								if (pts.length == 1) {
									// we expect exactly one parameterized type argument
									collType = (Class<?>) pts[0];
									if(!enumClass.equals(collType)){
										throw new ControllerException(
												"Parameterized type "
														+ prt
														+ " does not match type of annotated enumeration collection type "+enumClass.getName()+".");
									}
								} else {
									throw new ControllerException(
											"Parameterized type "
													+ prt
													+ " has more than one type arguemnts\nCannot get bean info of property return type.");
								}
							}else {
								throw new ControllerException(
										"Collection return type of property is not parameterized.\nCannot get bean info of property return type.");
							}

							Collection<Object> collVal=(Collection<Object>)readMethod.invoke(o, new Object[0]);
							for(String idStr:relatedIdValues){
								Method valueOfM=enumClass.getDeclaredMethod("valueOf", String.class);
								Object enumObj=valueOfM.invoke(null, idStr);
								securityManager.checkMergePermission(request,enumObj);

								if(command.equals(CMD_STORE_ADD_RELATED)){
									// add
									collVal.add(enumObj);
								}else if(command.equals(CMD_STORE_REMOVE_RELATED)){
									// remove
									collVal.remove(enumObj);
								}else if(command.equals(CMD_STORE_DELETE_RELATED)){
									// remove
									collVal.remove(enumObj);
									// enum  cannot be removed
								}
							}
						}
					}
				}

				}
			} catch (Exception e) {
				e.printStackTrace();
				ControllerException ce;
				if(e instanceof ControllerException){
					ce=(ControllerException)e;
				}else{
					ce=new ControllerException(e);
				}
				throw ce;
			}
			mode=new EditMode();
		}else if (command.equals(CMD_ADD)) {
			beanModel=null;
			beanTableModel=null;
			if(checkSecureRequestToken) {
				secureRequestTokenProvider.checkSecureRequestToken(request);
			}
			add(request, command);
		} 
	}
	
//	protected void beforeRemove(HttpServletRequest request, Object objToRemove) {
//		// Do nothing by default
//	}
//	
//	protected void afterRemove(HttpServletRequest request, Object removedObj) {
//		// Do nothing by default
//	}

	public Object getCancelledItem() {
		return cancelledItem;
	}

	protected void beforeDelete(HttpServletRequest request, Object objToDelete) {
		// Do nothing by default
	}
	
	protected void afterDelete(HttpServletRequest request, Object deletedObj) {
		// Do nothing by default
	}

	protected Object createIdObject(Map<String,String[]> map) throws ControllerException {
		Object idObj = null;
		if (beanInfo.isIdEmbedded()) {
			
			// embedded (compound) ID's are coded either with
			// keys for each attribute of the ID or as
			// as single string id (required for relationship operations
			// otherwise the query map gets topo complicated)
			
			PropertyDescriptor idPd = beanInfo.getIdPropertyDescriptor();
			// construct embedded id object

			try {
				idObj = idPd.getPropertyType().newInstance();
			} catch (Exception e) {

				e.printStackTrace();
				throw new ControllerException(e);
			}

			// construct "toplevel" property map
			// with key for each attribute of the coumpound key

			HashMap<String,String[]> embProps = new HashMap<String, String[]>();
			Set<Map.Entry<String,String[]>> entries2 = map.entrySet();
//			Iterator ei2 = entries2.iterator();
//			while (ei2.hasNext()) {
			for(Map.Entry<String,String[]> entry2:entries2){
//				Map.Entry<String,String[]> entry2 = ei2.next();
				String key2 =entry2.getKey();
				// Object value2 = entry2.getValue();

				int dotIndex2 = key2.indexOf('.');
				String keyName2 = null;
				String deepProperty2 = null;
				if (dotIndex2 > 0) {
					keyName2 = key2.substring(0, dotIndex2);
					deepProperty2 = key2.substring(dotIndex2 + 1);
					if (!keyName2.equals(idPd.getName())) {
						continue;
					}
					embProps.put(deepProperty2, entry2.getValue());
				}
			}
			
			if(embProps.size()>0){
			// apply map
			MapConverter embMc = new MapConverter();
			try {
				embMc.setBeanProperties(idObj, embProps);
				return idObj;
			} catch (MapConverterException e) {

				e.printStackTrace();
				throw new ControllerException(e);
			}
			}else{
				// TODO chack this code!
				// fall back to single String constructor below
				
			}
		} 
			String[] idStrs = map.get(beanInfo
					.getIdPropertyDescriptor().getName());
			if (idStrs != null && idStrs.length == 1 && idStrs[0] != null) {
				String idStr = idStrs[0];
				try {
					idObj = beanInfo.createIdValueByString(idStr);
					if (idObj == null)
						throw new ControllerException(
								"Could not get item with id=" + idStr);
					setId(idObj);
				} catch (Exception e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}
			} else {
				// try object identifier
				try {
					PersistenceObjectIdentifier poi = PersistenceObjectIdentifier.parseQueryMap(map);
					if(poi!=null){
						idObj=poi.getIdObject();
					}
				} catch (Exception e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}

			}
		
		return idObj;
	}
	
	
	public void rollback(){
		EntityManager em = getThreadEntityManager();
		if (em != null) {
			EntityTransaction tx = null;
				tx = em.getTransaction();
				if (tx!=null && tx.isActive()) {
					tx.rollback();
				}
		}
	}
	
	public void commit() throws ControllerException{
		EntityManager em = getThreadEntityManager();
		if (em != null) {
			EntityTransaction tx = null;
			try {
				tx = em.getTransaction();
				if (tx!=null && tx.isActive()) {
					tx.commit();
				}
			} catch (PersistenceException e) {
				e.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();

				setBoolCondition(null);
				throw new ControllerException(e);
			} catch (IllegalStateException ise) {
				ise.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();

				setBoolCondition(null);
				throw new ControllerException(ise);
			} catch (Exception e) {
				e.printStackTrace();
				if (tx != null && tx.isActive())
					tx.rollback();
				throw new ControllerException(e);
			} 
		}
	}
	
	protected void clear(){
		processResult=null;
		beanModel=null;
		beanTableModel=null;
		//validationResult=null;
		actionCanceled=false;
		
	}
	
	public synchronized void close()  {
		EntityManager em = getThreadEntityManager();
		if(em!=null) {
			// commit changes
			try {
				commit();
			} catch (ControllerException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			if (em != null) {
				em.close();
			}
		}
		removeEntityManagerThreadLocal();
	}

	public ExtBoolExpr getBoolCondition() {
		return boolCondition;
	}

	public void setBoolCondition(ExtBoolExpr boolCondition) {
		ExtBoolExpr oldCondition = this.boolCondition;
		this.boolCondition = boolCondition;
		if (this.boolCondition == null) {
			if (oldCondition != null)
				firstItem = 0;
		} else {
			//namedQuery = null;
			if (!this.boolCondition.equals(oldCondition))
				firstItem = 0;
		}
	}

	public OrderByClause getOrderByClause() {
		return orderByClause;
	}

	public void setOrderByClause(OrderByClause orderByClause) {
		this.orderByClause = orderByClause;
	}

	public String getNamedQuery() {
		return namedQuery;
	}

	public void setNamedQuery(String namedQuery,PersistenceObjectIdentifier namedQueryParam) {
		this.namedQuery = namedQuery;
		//this.namedQueryParamClassName = namedQueryParamClassName;
		this.namedQueryParam = namedQueryParam;
		namedQueryParams = null;
		if (namedQuery != null) {
			parameterizedQuery=null;
			query=null;
			boolCondition = null;
			orderByClause = null;
			
		}
		firstItem = 0;
	}

	public void setDisplayColumns(List<String> displayColumns) {
		this.displayColumns = displayColumns;
	}

	public boolean isIdGenerated() {
		return idGenerated;
	}

	public void setIdGenerated(boolean idGenerated) {
		this.idGenerated = idGenerated;
	}

	public Object getId() {
		return id;
	}

	public void setId(Object id) {
		this.id = id;
	}

	// reqired getters for JSTL access
	// Eclipse suggest static modifiers, but this does not work !
//	public String getKEY_SELECT_TARGET_CLASS() {
//		return KEY_SELECT_TARGET_CLASS;
//	}

	public String getKEY_SELECT_TARGET_PROPERTY() {
		return KEY_SELECT_TARGET_PROPERTY;
	}

	public String getKEY_SELECT_TARGET_ID() {
		return KEY_SELECT_TARGET_ID;
	}

	public String getKEY_SELECT_TARGET_ID_PROPERTY() {
		return KEY_SELECT_TARGET_ID_PROPERTY;
	}

	public String getKEY_SELECTED_ID() {
		return KEY_SELECTED_ID;
	}

	public String getKEY_ACTION() {
		return KEY_ACTION;
	}

	public void setBatchSize(int batchSize) {
		this.batchSize = batchSize;
	}
	
	public PersistenceObjectIdentifier getRelatedObjectIdentifier() {
		return relatedObjectIdentifier;
	}

	public void setRelatedObjectIdentifier(
			PersistenceObjectIdentifier relatedObjectIdentifier) {
		this.relatedObjectIdentifier = relatedObjectIdentifier;
	}

	public PropertyDescriptor getRelatedPropertyDescriptor() {
		return relatedPropertyDescriptor;
	}

	public void setRelatedPropertyDescriptor(
			PropertyDescriptor relatedPropertyDescriptor) {
		this.relatedPropertyDescriptor = relatedPropertyDescriptor;
	}

	public Object getSelectedItemId() {
		return selectedItemId;
	}
	
	public Object getSelectedItem() {
		if(selectedItemId==null)return null;
		EntityManager em=getThreadEntityManager();
		Object ret=em.find(queryType, selectedItemId);
		return ret;
	}

	public void setSelectedItemId(HttpServletRequest request,Object selectedItemId) {
		this.selectedItemId = selectedItemId;
		setPropertiesAfterSelect(request, selectedItemId);
	}

	public void setSelectedItemIds(HttpServletRequest request,Set<Object> selectedItemIds) {
		this.selectedItemIds = selectedItemIds;
		setPropertiesAfterSelect(request, selectedItemIds);
	}

	public Set<Object> getSelectedItemIds() {
		return selectedItemIds;
	}

	public boolean isActionCanceled() {
		return actionCanceled;
	}

	public ParameterizedQuery getParameterizedQuery() {
		return parameterizedQuery;
	}

	public void setParameterizedQuery(ParameterizedQuery parameterizedQuery) {
		this.parameterizedQuery = parameterizedQuery;
		namedQuery=null;
		query=null;
	}
	
	public void setQuery(Query query) {
		this.query=query;
		this.namedQuery=null;
		this.parameterizedQuery=null;
	}

//	public ValidationResult getValidationResult() {
//		return validationResult;
//	}

	public BeanModel<T> getBeanModel() {
		return beanModel;
	}

	public ProcessResult getProcessResult() {
		return processResult;
	}

	public static String getKEY_PREFIX_DELETE_RELATED() {
		return KEY_PREFIX_DELETE_RELATED;
	}

	public SecurityManager getSecurityManager() {
		return securityManager;
	}

	public void setSecurityManager(SecurityManager securityManager) {
		this.securityManager = securityManager;
	}

	public boolean isDropInSecureItems() {
		return dropInSecureItems;
	}

	public void setDropInSecureItems(boolean dropInSecureItems) {
		this.dropInSecureItems = dropInSecureItems;
	}

	
	

//	public RelatedQuery getRelatedQuery() {
//		return relatedQuery;
//	}

	// public LocalizableMessage getErrorMessage() {
	// return errorMessage;
	// }

}
