package ipsk.webapps;

import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration.Dynamic;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

import ips.servlet.http.URLEncoder;
import ipsk.jsp.Controller;
import ipsk.text.StringTokenizer;
import ipsk.webapps.actionmap.ActionLink;
import ipsk.webapps.actionmap.ActionMap;
import ipsk.webapps.actionmap.Controller.Scope;
import ipsk.webapps.actionmap.Forward;
import ipsk.webapps.actionmap.Param;


public class ControllerDispatcherServlet extends HttpServlet implements ServletContainerInitializer{
	
	public final static boolean DEBUG=false;
	public final static String SERVLET_NAME="ActionDispatcher";
	public final static String DEFAULT_MAP_NAME="/WEB-INF/classes/META-INF/ips_webutils_action_map.xml";
	public final static String DYNAMIC_SERVLET_MAPPING_PARAM_NAME="dynamic_servlet_mapping";
	
	private HashMap<String,ipsk.webapps.actionmap.ActionLink> map=new HashMap<String, ipsk.webapps.actionmap.ActionLink>();

	public static class ForwardRequest{
		private String forwardPath;
		private boolean redirect;
		

		/**
		 * @param forwardPath
		 * @param request
		 */
		public ForwardRequest(String forwardPath, boolean redirect,HttpServletRequest request) {
			super();
			this.forwardPath = forwardPath;
			this.redirect=redirect;
			this.request = request;
		}

		public String getForwardPath() {
			return forwardPath;
		}
		
		public boolean getRedirect() {
			return redirect;
		}
		
		public HttpServletRequest getRequest() {
			return request;
		}
		private HttpServletRequest request;
	}
	
	
	
	private ForwardRequest checkForwardRequest(Controller ctrl,Forward fw,HttpServletRequest httpReq) throws ServletException{
		ForwardRequest forwardRequest=null;
		String forwardPath=null;
		HttpServletRequest modifiedRequest=null;
		
		String onSuccessUrl=fw.getUrl();
		List<Param> params=fw.getParams();
		Map<String,String[]> newParamMap=new HashMap<String, String[]>();
		if(params!=null){

			int paramsCount=params.size();

			if(paramsCount>0){	
				onSuccessUrl=onSuccessUrl.concat("?");

				for(int i=0;i<paramsCount;i++){
					Param p=params.get(i);
					String name=p.getName();
					String value=p.getValue();
					if(value==null){
						String ctrlVal=p.getControllerValue();
						String[] valPnames=StringTokenizer.split(ctrlVal,'.');
						Object pVal="";
						if(valPnames.length>0){

							pVal=ctrl;
							for(String valPname:valPnames){
								StringBuffer getterNameSb=new StringBuffer("get");
								String firstCharUpper=valPname.substring(0, 1).toUpperCase();
								getterNameSb.append(firstCharUpper);
								getterNameSb.append(valPname.substring(1));
								String getterName=getterNameSb.toString();
								if(pVal==null) {
									throw new ServletException("Error resolving values. Try to call method "+getterName+ " on a null value.");
								}
								Class<?> pValClass=pVal.getClass();
								try{
									java.lang.reflect.Method getterMethod=pValClass.getMethod(getterName);
									Object newPVal=getterMethod.invoke(pVal);
									pVal=newPVal;
								}catch(Exception e){
									throw new ServletException("Error resolving values. Could not find method "+getterName+ " in class "+pValClass.getName(), e);
								}
							}
						}
						if(pVal!=null) {
						 value=pVal.toString();
						}
					}
					if(value!=null) {
					 newParamMap.put(name, new String[]{value});
					}
				}
			}
		}
		if(onSuccessUrl!=null && ! "".equals(onSuccessUrl)){
			forwardPath=onSuccessUrl;
			// substitute parameter map
			modifiedRequest=new HttpRequestParameterMapWrapper(httpReq, newParamMap);
		}
		if(forwardPath!=null){
			forwardRequest=new ForwardRequest(forwardPath,fw.getRedirect(),modifiedRequest);
			
		}
		return forwardRequest;
	}

	public void service(HttpServletRequest httpReq, HttpServletResponse res)
			throws ServletException, IOException {

		String pathInfo = httpReq.getPathInfo();
		if (pathInfo != null) {
			if(DEBUG)System.out.println("Path info " + pathInfo);
		}
		String servletPath = httpReq.getServletPath();
		if (servletPath != null) {
			ActionLink al=map.get(servletPath);
			if(al==null){
				throw new ServletException("Action link for path "+servletPath+" not found!");
			}
			ipsk.webapps.actionmap.Controller ct=al.getController();
			if(ct!=null){

				String ctrlClassName=ct.getClassname();
				if (ctrlClassName != null) {
					Object ctrlO=null;
					HttpSession httpSession=null;
					String ctVar=ct.getVar();
					if(ctVar!=null){
						// controller is bound to JSP variable

						Scope ctScope=ct.getScope();
						if(ctScope.equals(Scope.SESSION)){
							httpSession=httpReq.getSession(true);
							if(httpSession!=null){	
								ctrlO=httpSession.getAttribute(ctVar);

							}
						}else if(ctScope.equals(Scope.REQUEST)){
							ctrlO=httpReq.getAttribute(ctVar);
						}else if(ctScope.equals(Scope.APPLICATION)){
							// TODO

							// is this the JSP application scope?
							ctrlO=getServletContext().getAttribute(ctVar);
						}
					}
					if (ctrlO == null) {

						try {
							ctrlO = Beans.instantiate(this.getClass()
									.getClassLoader(), ctrlClassName);
							// Class<?> cClass=Class.forName(ctrlClassName);
							// ctrlO=cClass.newInstance();
						} catch (ClassNotFoundException e) {
							throw new ServletException(e);
						}
						if(ctVar!=null){
							// controller is bound to JSP variable

							Scope ctScope=ct.getScope();
							if(ctScope.equals(Scope.SESSION)){
								if(httpSession!=null){	
									httpSession.setAttribute(ctVar,ctrlO);
								}
							}else if(ctScope.equals(Scope.REQUEST)){
								httpReq.setAttribute(ctVar,ctrlO);
							}else if(ctScope.equals(Scope.APPLICATION)){
								// TODO

								// is this the JSP application scope?
								getServletContext().setAttribute(ctVar,ctrlO);
							}
						}
					}
					//System.out.println("Controller found");
					if (ctrlO instanceof Controller) {
						ProcessResult pr=null;
						Controller ctrl = (Controller) ctrlO;
						ipsk.persistence.Controller pctrl=null;
						
						if(ctrlO instanceof ipsk.persistence.Controller) {
							pctrl=(ipsk.persistence.Controller)ctrlO;
						}
						if(pctrl!=null) {
							pctrl.open();
						}
						String processMethodName=ct.getProcessMethod();
						
						if(processMethodName==null) {
							try {
								pr=ctrl.process(httpReq,res,this);
							} catch (ControllerException e) {
								if(pctrl!=null) {
									pctrl.rollback();
								}
								e.printStackTrace();
								throw new ServletException(e);
							}
						}else {
							// Invoke custom controller method
							Class<? extends Controller> ctrlCls=ctrl.getClass();
							Method processMethod;
							try {
								processMethod = ctrlCls.getMethod(processMethodName, HttpServletRequest.class);
								processMethod.invoke(ctrl, httpReq);
								pr=ctrl.getProcessResult();
							} catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
								if(pctrl!=null) {
									pctrl.rollback();
								}
								e.printStackTrace();
								throw new ServletException(e);
							}
						}
						// default: "underlying" JSP file
						String forwardPath=servletPath+".jsp";
						ForwardRequest forwardRequest=null;
						try {

							
							if(pr==null){
								// default: current JSP file
							}else if(ProcessResult.Type.DONE.equals(pr.getType())){
								// OK
								// do NOT forward to any page
								forwardPath=null;
							}else{
								List<Forward> fws=al.getForwards();
								if(fws!=null && fws.size()>0){
									
									// find matching result status forward
									for(Forward fw:fws){
										String fwst=fw.getStatus();
										
										if(pr.getType().toString().equalsIgnoreCase(fwst)){
											forwardRequest=checkForwardRequest(ctrl, fw, httpReq);
											break;
										}
									}
									
									if(forwardRequest==null){
										// find catch all forward
										for(Forward fw:fws){
											String fwst=fw.getStatus();
											if(fwst==null){
												forwardRequest=checkForwardRequest(ctrl, fw, httpReq);
												break;
											}
										}
									}
									
								}
							}
							if(pctrl!=null) {
								pctrl.close();
							}
							boolean redirect=false;
							if(forwardRequest!=null){
								forwardPath=forwardRequest.getForwardPath();
								redirect=forwardRequest.getRedirect();
							}
							if(forwardPath!=null ){
								HttpServletRequest modifiedRequest=null;
								if(forwardRequest!=null){
									modifiedRequest=forwardRequest.getRequest();
								}
								RequestDispatcher requestDispatcher=httpReq.getRequestDispatcher(forwardPath);
								
								if(redirect) {
									// For POST/Redirect/GET pattern to prevent back-button re-submissions
									
									Map<String,String[]> pMap;
									if(modifiedRequest!=null) {
										pMap=modifiedRequest.getParameterMap();
									}else {
										pMap=httpReq.getParameterMap();
									}
									String qStr=URLEncoder.parameterMapToQueryString(pMap);
									String redirectLoc=httpReq.getContextPath()+forwardPath+qStr;
									String encRedirectURL=res.encodeRedirectURL(redirectLoc);
									res.setStatus(HttpServletResponse.SC_SEE_OTHER);
									res.setHeader("Location",encRedirectURL);
								}else {
									if(modifiedRequest!=null){
										requestDispatcher.forward(modifiedRequest, res);
									}else{
										
										requestDispatcher.forward(httpReq, res);
									}
								}
							}


						} catch (Exception e) {
							throw new ServletException(e);
						} 
						
					}
				}

			}
		}

	}

	
	public void init() throws ServletException {
		ServletContext ctx=getServletContext();
		
		// The servlet might be different object instance, we need to read the map again
		InputStream is=ctx.getResourceAsStream(DEFAULT_MAP_NAME);
		
		if(is!=null){
			Reader mr=new InputStreamReader(is);
			try{
				ActionMap actionMap=JAXB.unmarshal(mr,ActionMap.class);
				ActionLink[] als=actionMap.getActionLink();
				if(als!=null){
					for(ActionLink al:als){
						String alUrl=al.getUrl();
						map.put(alUrl, al);
					}
				}
			}catch(DataBindingException dbe){
				log(dbe.getMessage(),dbe);
				dbe.printStackTrace();
				throw new ServletException(dbe.getMessage(), dbe);
			}
		}
	}

	@Override
	public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
	
		InputStream is=ctx.getResourceAsStream(DEFAULT_MAP_NAME);
		
		if(is==null){
			// New behavior since ips.webapp.lib 2.0.0:
			// If the action map does not exists, the servlet is not registered
			//throw new ServletException("Controller dispatcher: Map resource file "+DEFAULT_MAP_NAME+" not found!");
			ctx.log("Note: "+SERVLET_NAME+ " servlet: Action map "+DEFAULT_MAP_NAME+" not found. Servlet will not be registered.");
		}else {
			ctx.log("Registering "+SERVLET_NAME+" servlet dynamically...");
			Reader mr=new InputStreamReader(is);
			List<String> mappingUrls=new ArrayList<>();
			try{
				ActionMap actionMap=JAXB.unmarshal(mr,ActionMap.class);

				ActionLink[] als=actionMap.getActionLink();
				if(als!=null){
					for(ActionLink al:als){
						String alUrl=al.getUrl();
						mappingUrls.add(alUrl);
						//map.put(alUrl, al);
					}
				}
			}catch(DataBindingException dbe){
				log(dbe.getMessage(),dbe);
				dbe.printStackTrace();
				throw new ServletException(dbe.getMessage(), dbe);
			}

			Dynamic dynReg=ctx.addServlet(SERVLET_NAME,this.getClass());
			if(dynReg==null) {
				ctx.log(SERVLET_NAME+" already registered!");
			}else {
				dynReg.addMapping(mappingUrls.toArray(new String[mappingUrls.size()]));
				ctx.log("Registered Servlet "+SERVLET_NAME+" (class: "+this.getClass()+") with "+mappingUrls.size()+" mappings.");
			}
		}
		
	}
}
