package ipsk.webapps.ajax;

import java.util.Hashtable;

/**
 * Simplified state of an updatable (DOM) Element
 * @author klausj
 *
 */
public class ElementState {
	private String textContent=null;
	private Hashtable<String,String> attributes=new Hashtable<String, String>();
	
	public ElementState(){
		super();
	}
	public ElementState(String textContent){
		super();
		this.textContent=textContent;
	}

	public String getTextContent() {
		return textContent;
	}

	public void setTextContent(String textContent) {
		this.textContent = textContent;
	}
	
	public void putAttribute(String name,String value){
		attributes.put(name, value);
	}
	
	public String getAttribute(String name){
		return attributes.get(name);
	}
	
	public Hashtable<String, String> getAttributes() {
		return attributes;
	}
	
	public void setAttributes(Hashtable<String, String> attributes) {
		this.attributes = attributes;
	}
	
	public boolean equals(Object o){
		if (! (o instanceof ElementState)){
			return false;
		}
		ElementState oo=(ElementState)o;
		if(textContent==null){
			if(oo.getTextContent()!=null){
				return false;
			}
		}else{
			if(! textContent.equals(oo.getTextContent())){
				return false;
			}
		}
	
//		oo.get
//		for(String attrKey:attributes.keySet()){
//			
//		}
		return true;
	}
	
}
