package ipsk.webapps.filter;

import ipsk.jsp.fmt.LocaleSupport;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;


/**
 * Looks up localized pgae alternatives.
 * 
 * @klausj
 * 
 */

public class PageLocalizer implements Filter {

	private static boolean DEBUG = false;

	private ServletContext servletContext;

	public PageLocalizer() {
		super();

	}

	public void init(FilterConfig arg0) throws ServletException {

		servletContext = arg0.getServletContext();
	}

	public void doFilter(ServletRequest req, ServletResponse res,
			FilterChain arg2) throws IOException, ServletException {
		Locale reqLocale = LocaleSupport.getLocale(req);
		if (reqLocale != null && req instanceof HttpServletRequest
				&& res instanceof HttpServletResponse) {
			HttpServletRequest httpReq = (HttpServletRequest) req;
			// httpReq.getSession();
			HttpServletResponse httpRes = (HttpServletResponse) res;
			String jspFileExtension = "_" + reqLocale.getLanguage();
			String contextPath = httpReq.getContextPath();
			String servletPath = httpReq.getServletPath();
			String pathInfo = httpReq.getPathInfo();
			String queryString = httpReq.getQueryString();
			if (DEBUG) {
				System.out.println("Context path: " + contextPath);
				System.out.println("Servlet path: " + servletPath);
				System.out.println("Pathinfo: " + pathInfo);
				System.out.println("Query string: " + queryString);
			}
			URL localizedUrl = null;
			String localizedPath = null;
			int dotPos=servletPath.lastIndexOf(".");
			if(dotPos>0){
				String extension = servletPath.substring(dotPos);
				String servletPathWoExtension = servletPath.substring(0,dotPos);
				String localizedServletpath = servletPathWoExtension
						+ jspFileExtension + extension;
				localizedPath = contextPath + localizedServletpath;
				localizedUrl = servletContext.getResource(localizedServletpath);
				if (DEBUG) {
					System.out.println("Check resource: " + localizedPath);
				}
			}
			if (localizedUrl != null) {
				if (DEBUG) {
					System.out.println("Localized URL: " + localizedUrl);
				}
				httpRes.setStatus(HttpServletResponse.SC_MULTIPLE_CHOICES);
				httpRes.sendRedirect(httpRes.encodeRedirectURL(localizedPath));
				return;
			}

		}
		if (arg2 != null)
			arg2.doFilter(req, res);

	}

	public void destroy() {
		// nothing to do

	}

}
