package ipsk.webapps.filter;
import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
/**
 * 
 * Stores username to a web session.
 * @klausj
 *
 */

public class UsernameObserver implements Filter {

    public UsernameObserver() {
        super();
       
    }

    public void init(FilterConfig arg0) throws ServletException {
//      nothing to do

    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1,
            FilterChain arg2) throws IOException, ServletException {
       if (arg0 instanceof HttpServletRequest){
           HttpServletRequest httpReq=(HttpServletRequest)arg0;
           String user=httpReq.getRemoteUser();
           HttpSession sess=httpReq.getSession(false);
           if(sess!=null && user !=null){
               sess.setAttribute("remote_user",user);
           }
       }
       if (arg2!=null)arg2.doFilter(arg0,arg1);

    }

    public void destroy() {
        // nothing to do

    }

}
