package ipsk.webapps.security;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class AccountRequestsManager {
	private List<AccountRequest> accountRequests;
	
	
	public AccountRequestsManager(){
		super();
		accountRequests=new ArrayList<AccountRequest>();
	}
	
	public void add(AccountRequest pwrr){
		synchronized(this){
			accountRequests.add(pwrr);
		}
	}
	
	public AccountRequest getRequest(UUID uuid){
		synchronized (this) {
			for(AccountRequest pwrr:accountRequests){
				if(pwrr.getUuid().equals(uuid)){
					return pwrr;
				}
			}
		}
		return null;
	}
	
	public synchronized void expireInvalidRequests(){
		synchronized(this){
			
			ArrayList<AccountRequest> newPasswordResetRequests=new ArrayList<AccountRequest>();
			for(AccountRequest pwrr:accountRequests){
				if(pwrr.isValid()){
					newPasswordResetRequests.add(pwrr);
				}
			}
			accountRequests=newPasswordResetRequests;
		}
	}
	
	public List<AccountRequest> getAccountRequests() {
		return accountRequests;
	}

	public void remove(AccountRequest pwrr) {
		synchronized(this){
			accountRequests.remove(pwrr);
		}
		
	}
}
