package ipsk.webapps;

import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.jsp.Controller;

import ipsk.webapps.actionmap.ActionLink;
import ipsk.webapps.actionmap.ActionMap;
import ipsk.webapps.actionmap.Controller.Scope;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;

import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.w3c.dom.Document;

// TODO in development state
public class ControllerMapper  implements Filter{

	public final static String DEFAULT_MAP_NAME="ips_webutils_action_map.xml";
	
	private ActionMap actionMap;
	private HashMap<String,ipsk.webapps.actionmap.Controller> map=new HashMap<String, ipsk.webapps.actionmap.Controller>();
	private FilterConfig filterConfig=null;
	
	public void destroy() {
		// Nothing 
		
	}

	public void doFilter(ServletRequest arg0, ServletResponse arg1,
			FilterChain arg2) throws IOException, ServletException {
		
		if(arg0 instanceof HttpServletRequest){
			HttpServletRequest httpReq=(HttpServletRequest)arg0;
			String pathInfo=httpReq.getPathInfo();
			if (pathInfo!=null){
				System.out.println("Path info "+pathInfo);
			}
			String servletPath=httpReq.getServletPath();
			if(servletPath!=null){
				System.out.println(servletPath);
				ipsk.webapps.actionmap.Controller ct=map.get(servletPath);
				if(ct!=null){
				String ctrlClassName=ct.getClassname();
				if(ctrlClassName!=null){
					Object ctrlO=null;
					HttpSession httpSession=null;
					String ctVar=ct.getVar();
					if(ctVar!=null){
						// controller is bound to JSP variable

						Scope ctScope=ct.getScope();
						if(ctScope.equals(Scope.SESSION)){
							httpSession=httpReq.getSession(true);
							if(httpSession!=null){	
								ctrlO=httpSession.getAttribute(ctVar);

							}
						}else if(ctScope.equals(Scope.REQUEST)){
							ctrlO=arg0.getAttribute(ctVar);
						}else if(ctScope.equals(Scope.APPLICATION)){
							// TODO
					
							// is this the JSP application scope?
							ctrlO=filterConfig.getServletContext().getAttribute(ctVar);
						}
					}
					if(ctrlO==null){
						
						try {
							ctrlO=Beans.instantiate(this.getClass().getClassLoader(),ctrlClassName);
//							Class<?> cClass=Class.forName(ctrlClassName);
//							ctrlO=cClass.newInstance();
						} catch (ClassNotFoundException e) {
							throw new ServletException(e);
						}
						if(ctVar!=null){
							// controller is bound to JSP variable

							Scope ctScope=ct.getScope();
							if(ctScope.equals(Scope.SESSION)){
								if(httpSession!=null){	
									httpSession.setAttribute(ctVar,ctrlO);
								}
							}else if(ctScope.equals(Scope.REQUEST)){
								arg0.setAttribute(ctVar,ctrlO);
							}else if(ctScope.equals(Scope.APPLICATION)){
								// TODO
						
								// is this the JSP application scope?
								filterConfig.getServletContext().setAttribute(ctVar,ctrlO);
							}
						}
					}
					ipsk.persistence.Controller pctrl=null;
					if(ctrlO instanceof ipsk.persistence.Controller){
						pctrl=(ipsk.persistence.Controller)ctrlO;
					}
				
					if(ctrlO instanceof ipsk.jsp.Controller) {
						ipsk.jsp.Controller ctrl=(ipsk.jsp.Controller)ctrlO;
						if(pctrl!=null) {							
							pctrl.open();
						}
						try {
							ctrl.processRequest(httpReq);
						} catch (ControllerException e) {
							if(pctrl!=null) {
								pctrl.rollback();
							}
							e.printStackTrace();
							throw new ServletException(e);
						}
						RequestDispatcher rd = httpReq.getRequestDispatcher(servletPath);
						try{
							rd.forward(arg0, arg1);
						}catch(ServletException se){
							throw se;
						}catch (IOException ioe){
							throw ioe;
						}finally{
							if(pctrl!=null) {
								pctrl.close();
							}
						}
					}
				}
				}
			}
			
		}
		if (arg2!=null)arg2.doFilter(arg0,arg1);
		
	}

	public void init(FilterConfig arg0) throws ServletException {
		this.filterConfig=arg0;
		InputStream is=arg0.getServletContext().getResourceAsStream(DEFAULT_MAP_NAME);
		
		Reader mr=new InputStreamReader(is);
		try {
			DOMConverter dc=new DOMConverter();
			Document md=dc.readXML(mr);
			DOMCodec cod=new DOMCodec(ActionLink.class.getPackage());
			actionMap=(ActionMap)cod.readDocument(md);
		} catch (DOMConverterException e) {
			e.printStackTrace();
			throw new ServletException(e);
		} catch (DOMCodecException e) {
			e.printStackTrace();
			throw new ServletException(e);
		}
		ActionLink[] als=actionMap.getActionLink();
		if(als!=null){
			for(ActionLink al:als){
				map.put(al.getUrl(), al.getController());
			}
		}
		
		// load map
		// TEST
		//map.put("/db/project/ProjectExport.jsp","ipsk.webapps.db.speech.ProjectExportController");
	
		
	}

	
	
}
