package ipsk.jsp.taglib;

import ipsk.util.LocalizableMessage;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class LocalizableMessageTag extends ExtBodyTagSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4593551856001576024L;
	private LocalizableMessage message;

	public LocalizableMessage getMessage() {
		return message;
	}

	public void setMessage(LocalizableMessage message) {
		this.message = message;
	}

	public int doStartTag() throws JspException {

		return SKIP_BODY;
	}

	public int doEndTag() throws JspException {

		JspWriter out = pageContext.getOut();
		if(message!=null){
			String localizedMsg = getLocalizedMessage(message);
			try {
				out.print(localizedMsg);
			} catch (IOException e) {
				throw new JspException(e);
			}
		}
		return EVAL_PAGE;
	}
}
