package ipsk.net;

import java.util.Properties;

import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SendMail {

	private Properties props = new Properties();
	private String user;
	private String password;

	public SendMail(Properties props, String user, String password) {
		this();
		this.props = props;
		this.user = user;
		this.password = password;
	}

	public SendMail() {
		props.put("mail.smtp.host", "localhost");
		//props.put("mail.mime.charset","UTF-8");
		System.setProperty("mail.mime.charset","UTF-8");
	}

	public boolean isAddressValid(String address) {
		try {
			InternetAddress ia=new InternetAddress(address);
			ia.validate();
		} catch (AddressException e) {
			return false;
		}
		return true;
	}
	
	public void send(InternetAddress from, String to, String subject,
			String content) throws SendMailException {
		if (to == null) {
			throw new SendMailException("No recipient specified.");
		}
		String[] recipients=new String[] {to};
		send(from, recipients, subject, content);
	}
	
	public void send(InternetAddress from, String[] recipients, String subject,
			String content) throws SendMailException {
		if (recipients == null || recipients.length==0) {
			throw new SendMailException("No recipient(s) specified.");
		}
		try {
			
			InternetAddress dests[] = new InternetAddress[recipients.length];
			for(int ri=0;ri<recipients.length;ri++){
				dests[ri]=new InternetAddress(recipients[ri]);
			}
			send(from,dests,subject,content);
		} catch (AddressException e) {
			throw new SendMailException(e);
		}
	}
	
	public void send(InternetAddress from, InternetAddress[] dests, String subject,
			String content) throws SendMailException {

		if (dests == null) {
			throw new SendMailException("No recipient specified.");
		}
		if (from == null) {
			throw new SendMailException("No sender specified.");
		}
		if (subject == null)
			subject = "";
		if (content == null)
			content = "";

		try {
			Session session = Session.getDefaultInstance(props);
			// Prepare our mail message
			Message message = new MimeMessage(session);
			message.setFrom(from);

			
			message.setRecipients(Message.RecipientType.TO, dests);
			message.setSubject(subject);
			message.setContent(content, "text/plain; charset=UTF-8");
			

			// Send our mail message
			if (this.user == null || this.password == null) {
				Transport.send(message);
			} else {
				Transport.send(message, this.user, this.password);
			}


		} catch (Throwable t) {
			throw new SendMailException(t);

		}

	}

	public void send(String fromStr, String to, String subject, String content)
			throws SendMailException {
		InternetAddress from = null;
		try {
			from = new InternetAddress(fromStr);
		} catch (Exception e) {
			throw new SendMailException("Sender address invalid.");
		}
		send(from, to, subject, content);

	}
	
	public static void main(String[] args){
		String adr1="bla_fasel_falsch";
		String adr2="korrekt@bla.de";
		InternetAddress ia1=null;
		try {
			
			ia1 = new InternetAddress(adr1);
		} catch (AddressException e) {
			System.out.println(adr1+" failed");
			e.printStackTrace();
		}
		if(ia1!=null){
		try {
			ia1.validate();
		} catch (AddressException e) {
			System.out.println(adr1+" validate failed");
			e.printStackTrace();
		}
		}
		InternetAddress ia2=null;
		try {
			ia2 = new InternetAddress(adr2);
		} catch (AddressException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if(ia2!=null){
		try {
			ia2.validate();
		} catch (AddressException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		}
	}

}
