package ipsk.db.speech.utils;

import ipsk.awt.WorkerException;
import ipsk.audio.capture.session.info.RecordingSegment;
import ipsk.audio.capture.session.info.RecordingSequence;
import ipsk.audio.capture.session.info.RecordingSession;
import ipsk.awt.Worker.State;
import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.db.speech.Project;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.Session;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;
import ipsk.db.speech.speaker.Speakers;
import ipsk.persistence.EntityManagerWorker;
import ipsk.util.LocalizableMessage;
import ipsk.util.zip.ZipPackerWorker;
import ipsk.webapps.audio.RecordingFileHelper.RecordingFileEdit;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

import org.w3c.dom.Document;

import ips.annot.model.emu.EmuDB;


public class SessionEmuExporter extends EntityManagerWorker{
	
	public static class RecordingFileList{
		private Set<RecordingFile> recordingFileList=new HashSet<RecordingFile>();

		public Set<RecordingFile> getRecordingFileList() {
			return recordingFileList;
		}

		public void setRecordingFileList(Set<RecordingFile> recordingFileList) {
			this.recordingFileList = recordingFileList;
		}
	}
	public static String PERSISTENCE_UNIT_NAME="WebSpeechDBPU";
	public static final String SESSION_FILE_PREFIX="session_";
	public static final String SCRIPT_FILE_PREFIX="script_";
	public static final String XML_FILE_EXTENSION="xml";
	private final static String RESOURCE_BUNDLE_NAME="Messages";
	
	private SessionExportConfiguration configuration;
	private int sessionId;

	private Path outputBaseDir;
	
	private EmuDB dbConfig;
	public EmuDB getDbConfig() {
		return dbConfig;
	}
	public void setDbConfig(EmuDB dbConfig) {
		this.dbConfig = dbConfig;
		if(bundleExporter!=null) {
			bundleExporter.setDbConfig(dbConfig);
		}
	}

	private EmuBundleExporter bundleExporter=null;
	private File exportArchiveFile;
	private ZipPackerWorker zipPacker;
	
	public SessionEmuExporter(EntityManagerFactory entityManagerFactory,SessionExportConfiguration configuration){
		super(entityManagerFactory);
		this.configuration=configuration;
	}
	public SessionEmuExporter(EntityManager entityManager,SessionExportConfiguration configuration){
		super(entityManager);
		this.configuration=configuration;
	}
	public void doWork() throws WorkerException{
		if(bundleExporter==null){
			bundleExporter=new EmuBundleExporter(entityManager,configuration);
			bundleExporter.setDbConfig(dbConfig);
		}
		bundleExporter.setEntityManager(entityManager);
		Session session=entityManager.find(Session.class, sessionId);
		
		
		Project prj=session.getProject();
		
		// create dir if necessary
		if (outputBaseDir==null){
			throw new ExportException("No output directory given!");
		}
		Path outputSessionDir=outputBaseDir.resolve(Integer.toString(session.getSessionId())+"_ses");
		if(Files.exists(outputSessionDir)){
			throw new ExportException("Output directory already exists!");
		}	
		
		int recFilesProgressLength=98;
		int zipPackLength=0;
		if(configuration.isCreateSessionZIPArchive()){
			recFilesProgressLength=32;
			zipPackLength=66;
		}
		try {
		Files.createDirectories(outputSessionDir);
		}catch(IOException e){
			throw new ExportException("Could not create session export dir "+outputSessionDir);
		}
		progressStatus.setProgress(1);
		
		bundleExporter.setOutputDir(outputSessionDir);
		bundleExporter.setRunningWithParentWorker();
		
		progressStatus.setProgress(2);
		
		// export recordings
		Set<RecordingFile> recFiles=RecordingFileUtils.latestSprRecordingFiles(session);
		int recFilesSize=recFiles.size();
		int recFilesCount=0;
		
		for(RecordingFile rf:recFiles){
			if(hasCancelRequest()) {
				progressStatus.setMessage(new LocalizableMessage(RESOURCE_BUNDLE_NAME, "session.export.canceled", new Object[]{session}));
				return;
			}
			int rfId=rf.getRecordingFileId();
			bundleExporter.setRecordingFileId(rfId);
			bundleExporter.setRunningWithParentWorker();
			bundleExporter.doWork();
			recFilesCount++;
			
			
			progressStatus.setProgress(2+((recFilesProgressLength*recFilesCount)/recFilesSize));
		}
		
		progressStatus.setProgress(2+recFilesProgressLength);
		if(configuration.isCreateSessionZIPArchive()){
			progressStatus.setMessage(new LocalizableMessage(RESOURCE_BUNDLE_NAME, "zip.creating"));
			FileOutputStream exportArchivestream;
			try {
				exportArchivestream = new FileOutputStream(exportArchiveFile);
			} catch (FileNotFoundException e) {
				throw new ExportException(e);
			}
			zipPacker = new ZipPackerWorker();
			zipPacker.setSrcDir(outputSessionDir.toFile());
			zipPacker.setPackRecusive(true);
			zipPacker.setOutputStream(exportArchivestream);
			
			progressStatus.setSubStatus(zipPacker.getProgressStatus(),zipPackLength);
			zipPacker.open();
			zipPacker.setRunningWithParentWorker();
			zipPacker.doWork();
			zipPacker.close();
			
			if(hasCancelRequest()) {
				progressStatus.setMessage(new LocalizableMessage(RESOURCE_BUNDLE_NAME, "session.export.canceled", new Object[]{session}));
				return;
			}
			
		}
		progressStatus.setSubStatus(null, 0);
		//progressStatus.setProgress(100);
		progressStatus.setMessage(new LocalizableMessage(RESOURCE_BUNDLE_NAME, "session.export.done", new Object[]{session}));
	}

	public void cancel(){
		if(bundleExporter!=null){
			bundleExporter.cancel();
		}
		if(zipPacker!=null){
			zipPacker.cancel();
		}
		super.cancel();
	}
	
	public void close() throws WorkerException{
		if(bundleExporter!=null){
			bundleExporter.close();
		}
		super.close();
	}
	public Path getOutputBaseDir() {
		return outputBaseDir;
	}

	public void setOutputBaseDir(Path emuDBDir) {
		this.outputBaseDir = emuDBDir;
	}

	public int getSessionId() {
		return sessionId;
	}

	public void setSessionId(int sessionId) {
		this.sessionId = sessionId;
	}
	
	public File getExportArchiveFile() {
		return exportArchiveFile;
	}

	public void setExportArchiveFile(File exportArchiveFile) {
		this.exportArchiveFile = exportArchiveFile;
	}
	
}
