package ipsk.webapps.db.speech;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ipsk.db.speech.Account;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.webapps.ControllerException;

public class BasicProjectAdminController<T> extends BasicWikiSpeechController<T> {
	
	public BasicProjectAdminController(String persistenceUnit, Class<T> queryType) {
		super(persistenceUnit, queryType);
		securityManager=new WikiSpeechSecurityManager(this);
	}

	public BasicProjectAdminController(String persistenceUnit, Class<T> queryType, String jsfIdentifier) {
		super(persistenceUnit, queryType,jsfIdentifier);
		securityManager=new WikiSpeechSecurityManager(this);
	}

	protected Project owningProject=null;
	
	public Project getOwningProject() {
		return owningProject;
	}
	
	protected void applyOwningProject(HttpServletRequest req) {
		String trgClParam=req.getParameter(PersistenceObjectIdentifier.KEY_TARGET_CLASS);
		String prjNm=req.getParameter(PersistenceObjectIdentifier.KEY_ID);
		if(Project.class.getName().equals(trgClParam) && prjNm!=null) {
			EntityManager em=getThreadEntityManager();
			owningProject=em.find(Project.class,prjNm);
		}
	}
	
	protected void applyOwningProjectForProjectAdmin(HttpServletRequest req) {
		// try to intercept owning project
				Account acc = getAccountByRequest(req);
				if (acc != null && req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
					String trgClParam=req.getParameter(PersistenceObjectIdentifier.KEY_TARGET_CLASS);
					String prjNm=req.getParameter(PersistenceObjectIdentifier.KEY_ID);
					if(Project.class.getName().equals(trgClParam) && prjNm!=null) {
						EntityManager em=getThreadEntityManager();
						owningProject=em.find(Project.class,prjNm);
					}
				}
	}
	
	public void processRequest(HttpServletRequest req) throws ControllerException {
		applyOwningProjectForProjectAdmin(req);
		super.processRequest(req);
	}
	
}
