package ipsk.webapps.db.speech;

import ipsk.db.speech.Account;
import ipsk.db.speech.AudioFormat;
import ipsk.db.speech.Distribution;
import ipsk.db.speech.InformedConsent;
import ipsk.db.speech.Person;
import ipsk.db.speech.Project;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.Session;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.SpeechDBInfo;
import ipsk.db.speech.project.MediaCaptureFormat;
import ipsk.db.speech.script.Recording;
import ipsk.text.ParserException;
import ipsk.text.Version;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;
import ipsk.webapps.db.speech.ws.BasicRecordingfileResource;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.servlet.ServletContext;

public class SpeechDBInfoController extends BasicPersistenceBeanController<SpeechDBInfo> {
	
	public SpeechDBInfoController() {
		super("WebSpeechDBPU", SpeechDBInfo.class, "info");
		securityManager=new WikiSpeechSecurityManager(this);
	}
	
	private Version currVersion() throws ControllerException {
		EntityManager em=getThreadEntityManager();
		
		/// Only major version ordering!  Needs version compare !!
		Query q = em.createQuery("SELECT object(o) FROM SpeechDBInfo o ORDER BY o.version DESC");
		
		
		@SuppressWarnings("unchecked")
		List<ipsk.db.speech.SpeechDBInfo> list = q.getResultList();
		if(list.size()==0){
			return null;
		}else if(list.size()>0){
			
				Version latestVers=null;
				
				for(int i=0;i<list.size();i++) {
					SpeechDBInfo dbInfo=list.get(i);

					String dbVersStr=dbInfo.getVersion();

					if(dbVersStr!=null) {
						Version dbVers;
						try {
							dbVers = Version.parseString(dbVersStr);
						} catch (ParserException e) {
							
							e.printStackTrace();
							throw new ControllerException("Could not parse speech db info version:",e);
						}
						if(latestVers==null) {
							latestVers=dbVers;
						}else {
							if(latestVers.compareTo(dbVers)<0) {
								latestVers=dbVers;
							}
						}
					}
				}
				return latestVers;
			
		}
		return null;
	}
	
	

	
	public Version packageVersion() throws ControllerException {
		Package speechDbPackage=SpeechDBInfo.class.getPackage();
		String speechDBpackageVersionStr=speechDbPackage.getSpecificationVersion();
		try {
		Version pVers=Version.parseString(speechDBpackageVersionStr);
		return pVers;
		} catch (ParserException e) {
			e.printStackTrace();
			throw new ControllerException("Could not parse speech db info version:",e);
		}
		
	}
	
	public void databaseChecks() {
		
//		EntityManager em=getThreadEntityManager();
//		
//		int resSize=0;
//		//int pageSize=10000;
//		int invalidCnt=0;
//		//do{
//			Query sq=em.createQuery("SELECT object(s) FROM Speaker s");
//			
//			//sq.setMaxResults(pageSize);
//			List<Speaker> spks=sq.getResultList();
//			resSize=spks.size();
//			System.out.println("Checking "+resSize+" speaker codes ...");
//			for(Speaker spk:spks) {
//				String sc=spk.getCode();
//				if(sc!=null) {
//					if(!BasicRecordingfileResource.speakerCodeValid(sc)) {
//						invalidCnt++;
//						System.out.println("Invalid speaker code "+sc+" of speaker/person ID "+spk.getPersonId());
//					}
//				}
//			}
//			
//		//}while(resSize>0);
//		
//		System.out.println("Found "+invalidCnt+" invalid speaker codes.");
//		
//		resSize=0;
//		
//		invalidCnt=0;
//		//do{
//			Query rsq=em.createQuery("SELECT object(r) FROM Recording r");
//			
//			//rsq.setMaxResults(pageSize);
//			List<Recording> rs=rsq.getResultList();
//			
//			resSize=rs.size();
//			System.out.println("Checking "+resSize+" recording itemcodes ...");
//			for(Recording r:rs) {
//				String ic=r.getItemcode();
//				if(ic==null) {
//					invalidCnt++;
//					System.out.println("Itemcode is null of recording/recprompt ID "+r.getRecpromptId());
//				}else {
//					if(!BasicRecordingfileResource.itemCodeValid(ic)) {
//						invalidCnt++;
//						System.out.println("Invalid itemcode "+ic+" of recording/recprompt ID "+r.getRecpromptId());
//					}
//				}
//			}
//			
//		//}while(resSize>0);
//		
//		System.out.println("Found "+invalidCnt+" invalid itemcodes.");
		
	}
	
	
	/**
	 * Upgrade the speech database.
	 * The SQL schema is updated by EclipseLink JPA, this upgrade progress upgrades the database contents only.
	 * @throws ControllerException
	 */
	@SuppressWarnings("unchecked")
	public void upgrade() throws ControllerException {

			Version currVersion=currVersion();
			//System.out.println("Current speechdb version: "+currVersion);
			EntityManager em=getThreadEntityManager();
//			Version upgrVers1=new Version(new int[] {1,36,0});
//			
//			if(upgrVers1.compareTo(currVersion)>0) {	
//				System.out.println("Upgrading speechdb to "+upgrVers1);
//				Query qp = em.createQuery("SELECT object(p) FROM Project p WHERE p.uuid IS NULL");
//				List<ipsk.db.speech.Project> prjList = qp.getResultList();
//				System.out.println("Applying UUIDs to "+prjList.size()+" projects...");
//				for(Project p:prjList) {
//					if(p.getUuid()==null) {
//						p.setUuid(UUID.randomUUID().toString());
//						em.merge(p);
//					}
//				}
//				
//				Query qd = em.createQuery("SELECT object(d) FROM Distribution d WHERE d.uuid IS NULL");	
//				List<ipsk.db.speech.Distribution> distList = qd.getResultList();
//				System.out.println("Applying UUIDs to "+distList.size()+" distributions...");
//				for(Distribution d:distList) {
//					if(d.getUuid()==null) {
//						d.setUuid(UUID.randomUUID().toString());
//						em.merge(d);
//					}
//				}
//			
//				int resSize=0;
//				int pageSize=400;
//				do{
//					Query pqs=em.createQuery("SELECT object(s) FROM Session s WHERE s.uuid IS NULL");
//					
//					pqs.setMaxResults(pageSize);
//					List<Session> sessP=pqs.getResultList();
//					resSize=sessP.size();
//					System.out.println("Applying UUIDs to "+resSize+" sessions...");
//					for(Session s:sessP) {
//						if(s.getUuid()==null) {
//							s.setUuid(UUID.randomUUID().toString());
//							em.merge(s);
//						}
//					}
//					
//				}while(resSize>0);
//				
//				resSize=0;
//				
//				do{
//					Query pqp=em.createQuery("SELECT object(p) FROM Person p WHERE p.uuid IS NULL");
//					
//					pqp.setMaxResults(pageSize);
//					List<Person> pP=pqp.getResultList();
//					resSize=pP.size();
//					System.out.println("Applying UUIDs to "+resSize+" persons ...");
//					for(Person p:pP) {
//						if(p.getUuid()==null) {
//							p.setUuid(UUID.randomUUID().toString());
//							em.merge(p);
//						}
//					}
//					
//				}while(resSize>0);
//				
//				
//				resSize=0;
//				do{
//					Query pqrf=em.createQuery("SELECT object(rf) FROM RecordingFile rf WHERE rf.uuid IS NULL");
//					
//					pqrf.setMaxResults(pageSize);
//					List<RecordingFile> rfP=pqrf.getResultList();
//					resSize=rfP.size();
//					System.out.println("Applying UUIDs to "+resSize+" recording file entities...");
//					for(RecordingFile rf:rfP) {
//						if(rf.getUuid()==null) {
//							rf.setUuid(UUID.randomUUID().toString());
//							em.merge(rf);
//						}
//					}
//		
//				}while(resSize>0);
//			}
			
//			Version upgrVers2=new Version(new int[] {1,51,0});
//			if(currVersion !=null && upgrVers2.compareTo(currVersion)>0) {	
//				System.out.println("Upgrading speechdb to "+upgrVers2);
//				Query spksIcQ=em.createQuery("SELECT object(spk) FROM Speaker spk WHERE spk.informedConsent IS NOT NULL OR spk.informedConsentInPaperFormSigned = TRUE");
//				List<Speaker> spksIc=spksIcQ.getResultList();
//
//
//
//				for(Speaker spk:spksIc) {
//					
//					Set<InformedConsent> spkIcs=spk.getInformedConsents();
//					if(spkIcs.size()>0) {
//						System.out.println("Warning: Speaker "+spk+" alreday has "+spkIcs.size()+" informed consents. Ignoring.");
//					}else {
//
//						// Build project set
//
//						Set<Project> prjs=new HashSet<Project>();
//						Set<Session> spkSesss=spk.getSessions();
//						for(Session sess:spkSesss) {
//							Project sessPrj=sess.getProject();
//							if(sessPrj!=null) {
//								prjs.add(sessPrj);
//							}
//						}
//						int prjsSize=prjs.size();
//						if(prjsSize>0) {
//
//							if(prjsSize>1) {
//								System.out.println("Warning: Adding speaker "+spk+" informed consent to "+prjsSize+"  projects");
//							}
//							for(Project prj: prjs) {
//								// check existing
//
//
//								InformedConsent ic=new InformedConsent();
//								ic.setSpeaker(spk);
//								ic.setProject(prj);
//								ic.setInformedConsentInPaperFormSigned(spk.isInformedConsentInPaperFormSigned());
//								ic.setInformedConsent(spk.getInformedConsent());
//								ic.setInformedBroadConsent(spk.getInformedBroadConsent());
//								em.persist(ic);
//								em.merge(spk);
//								em.merge(prj);
//								System.out.println("Adding informed consent for speaker "+spk+" and project "+prj+".");
//							}
//
//							
//						}else {
//							System.out.println("Note: Speaker "+spk+" has informed consent but no sessions. Ignoring.");
//						}
//					}
//				}
//			}
			
//			Version upgrVers2=new Version(new int[] {2,36,1});
//			if(currVersion !=null && upgrVers2.compareTo(currVersion)>0) {	
//				System.out.println("Upgrading speechdb to "+upgrVers2);
//				List<Project> allPrjs = em.createQuery("SELECT p from Project p").getResultList();
//				for(Project prj:allPrjs) {
//					
//						MediaCaptureFormat mcf=new MediaCaptureFormat();
//						AudioFormat af=prj.getAudioFormat();
//						if(af!=null) {
//							mcf.setAudioChannelCount(af.getChannels());
//							mcf.setAudioSampleRate(af.getSampleRate());
//							mcf.setAudioQuantisationBits(af.getQuantisation());
//						}
//						mcf.setProject(prj);
//						prj.setMediaCaptureFormat(mcf);
//						em.persist(mcf);
//						em.merge(prj);
//					
//				}
//			}
			
			
			Version upgrVersion=new Version(new int[] {2,37,0});
			if(currVersion !=null && upgrVersion.compareTo(currVersion)>0) {	
				System.out.println("Upgrading speechdb to "+upgrVersion);
				List<Account> allAccs=em.createQuery("SELECT a FROM Account a").getResultList();
				System.out.print("Set account logins case for "+allAccs.size()+" accounts...");
				for(Account a:allAccs) {
					String login=a.getLogin();
					String email=a.getEmail();
					boolean ci=false;
					if(email!=null && !email.isBlank()) {
						ci=(login.equalsIgnoreCase(email));
					}else {
						ServletContext servletContext=getServletContext();
						if(servletContext==null) {
							System.err.println("Servlet context not available!");
						}else {
							String dirPtn=servletContext.getInitParameter("directoryServiceUserDnPattern");
							if(dirPtn!=null) {
								String dirPtnRegex=dirPtn.replace("{0}",".*");
								Pattern dirPtnCi = Pattern.compile(dirPtnRegex, Pattern.CASE_INSENSITIVE);
								Matcher dirPtnMtch= dirPtnCi.matcher(login);
								ci=(dirPtnMtch.matches());
							}
						}
					}
					a.setLoginCaseInsensitiv(ci);
					em.merge(a);
					
//					System.out.print("Set account login "+login+" case ");
//					if(ci) {
//						System.out.print("in");
//					}
//					System.out.println("sensitive");
				}
				System.out.print("Set account logins case for "+allAccs.size()+" accounts finished.");
			}
	}


	public SpeechDBInfo addDeploymentInfo() throws ParserException, ControllerException{
		SpeechDBInfo newInfo=new SpeechDBInfo();
		
		Version pkgVers=packageVersion();
		if(pkgVers!=null) {
			newInfo.setVersion(pkgVers.toString());
			newInfo.setDeploymentDate(new Date());
			EntityManager em=getThreadEntityManager();


			Version latestVers=currVersion();
			if(latestVers==null){
				em.persist(newInfo);
			}else if(pkgVers!=null){
				int cmp=pkgVers.compareTo(latestVers);
				if(cmp>0){
					newInfo.setUpdateFrom(latestVers.toString());
					em.persist(newInfo);
					System.out.println("Commit new speechdb version: "+newInfo.getVersion());
				}
				
			}
		}
		return newInfo;
	}



	
		

}
